/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import org.ckkloverdos.collection.IL;
import org.ckkloverdos.java.JavaPlatform;
import org.ckkloverdos.log.StdLog;

public final class Util {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Random RANDOM = Util.getRandom();
    public static final SimpleDateFormat STD_DATE_FMT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    private Util() {
    }

    public static String getFormattedDate(SimpleDateFormat sdf) {
        return sdf.format(new Date());
    }

    public static String getFormattedDate() {
        return STD_DATE_FMT.format(new Date());
    }

    public static Random getRandom() {
        return Util.getRandom("SHA1PRNG");
    }

    public static Random getRandom(String algorithm) {
        try {
            SecureRandom r = SecureRandom.getInstance(algorithm);
            return r;
        }
        catch (NoSuchAlgorithmException e) {
            StdLog.error(e);
            Random r = new Random();
            r.setSeed(System.currentTimeMillis() ^ (long)new Object().hashCode());
            return r;
        }
    }

    public static boolean trimmedEmpty(String s) {
        return 0 == s.trim().length();
    }

    public static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (Throwable e) {
            return "localhost";
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        throwable.printStackTrace(pw);
        return w.toString();
    }

    public static URL toURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            StdLog.error(e);
            return null;
        }
    }

    public static String getPropertyOrEnv(String name) {
        String p = System.getProperty(name);
        if (null == p && JavaPlatform.version().compare(1, 5) >= 0) {
            p = System.getenv(name);
        }
        return p;
    }

    public static String getEnvOrProperty(String name) {
        if (JavaPlatform.version().compare(1, 5) < 0) {
            return System.getProperty(name);
        }
        String p = System.getenv(name);
        if (null == p) {
            p = System.getProperty(name);
        }
        return p;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getenv(String name) {
        if (JavaPlatform.version().compare(1, 5) < 0) {
            return System.getProperty(name);
        }
        return System.getenv(name);
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static boolean equalSafe(Object a, Object b) {
        if (null == a) {
            return null == b;
        }
        return a.equals(b);
    }

    public static boolean emptySafe(String s) {
        return s == null || 0 == s.length();
    }

    public static boolean trimmedEmptySafe(String s) {
        return s == null || 0 == s.trim().length();
    }

    public static String safe(String s) {
        return s == null ? "" : s;
    }

    public static Object[] safe(Object[] array, Class componentType) {
        return null != array ? array : Util.arrayFromItem(null, componentType);
    }

    public static Set safe(Set set) {
        return null == set ? Collections.EMPTY_SET : set;
    }

    public static Object[] arrayFromItem(Object object) {
        if (null == object) {
            return new Object[0];
        }
        return Util.arrayFromItem(object, object.getClass());
    }

    public static Object[] arrayFromItem(Object component, Class componentType) {
        int size = null == component ? 0 : 1;
        Object[] array = (Object[])Array.newInstance(componentType, size);
        if (1 == size) {
            array[0] = component;
        }
        return array;
    }

    public static boolean emptySafe(Object[] array) {
        return null == array ? true : 0 == array.length;
    }

    public static String[] safe(String[] array) {
        return null == array ? new String[]{} : array;
    }

    public static File[] safe(File[] array) {
        return null == array ? new File[]{} : array;
    }

    public static ClassLoader[] safe(ClassLoader[] array) {
        return null == array ? new ClassLoader[]{} : array;
    }

    public static boolean emptySafe(Collection collection) {
        return null == collection ? true : 0 == collection.size();
    }

    public static boolean emptySafe(IL list) {
        return null == list ? true : 0 == list.size();
    }

    public static int safe(String s, int safe) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return safe;
        }
    }

    public static long safe(String s, long safe) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return safe;
        }
    }

    public static double safe(String s, double safe) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return safe;
        }
    }
}

