/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.time;

import java.util.Date;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static String timeInfo(long millis) {
        long seconds = millis / 1000L;
        millis -= seconds * 1000L;
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        StringBuffer sb = new StringBuffer();
        if (days > 0L) {
            sb.append(days);
            sb.append(' ');
            sb.append("day");
            if (days > 1L) {
                sb.append('s');
            }
            sb.append(", ");
        }
        if (hours < 10L) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
        sb.append('.');
        if (millis < 100L) {
            sb.append('0');
            if (millis < 10L) {
                sb.append('0');
            }
        }
        sb.append(millis);
        return sb.toString();
    }

    public static long datePlusDays(long millis, long days) {
        return millis + 86400000L * days;
    }

    public static long datePlusHours(long millis, long hours) {
        return millis + 3600000L * hours;
    }

    public static long datePlusMinutes(long millis, long minutes) {
        return millis + 60000L * minutes;
    }

    public static long dateMinusDays(long millis, long days) {
        return millis - 86400000L * days;
    }

    public static long dateMinusHours(long millis, long hours) {
        return millis - 3600000L * hours;
    }

    public static long dateMinusMinutes(long millis, long minutes) {
        return millis - 60000L * minutes;
    }

    public static long nowPlusDays(long days) {
        return System.currentTimeMillis() + 86400000L * days;
    }

    public static long nowPlusHours(long hours) {
        return System.currentTimeMillis() + 3600000L * hours;
    }

    public static long nowPlusMinutes(long minutes) {
        return System.currentTimeMillis() + 60000L * minutes;
    }

    public static long nowMinusDays(long days) {
        return System.currentTimeMillis() - 86400000L * days;
    }

    public static long nowMinusHours(long hours) {
        return System.currentTimeMillis() - 3600000L * hours;
    }

    public static long nowMinusMinutes(long minutes) {
        return System.currentTimeMillis() - 60000L * minutes;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static Date nowDate() {
        return new Date();
    }

    public static Date nowSqlDate() {
        return new java.sql.Date(TimeUtil.now());
    }

    public static long today() {
        return System.currentTimeMillis();
    }

    public static Date todayDate() {
        return new Date();
    }

    public static Date todaySqlDate() {
        return new java.sql.Date(TimeUtil.now());
    }

    public static long yesterday() {
        return TimeUtil.nowMinusDays(1L);
    }

    public static Date yesterdayDate() {
        return new Date(TimeUtil.yesterday());
    }

    public static java.sql.Date yesterdaySqlDate() {
        return new java.sql.Date(TimeUtil.yesterday());
    }

    public static long tomorrow() {
        return TimeUtil.nowPlusDays(1L);
    }

    public static Date tomorrowDate() {
        return new Date(TimeUtil.tomorrow());
    }

    public static Date tomorrowSqlDate() {
        return new java.sql.Date(TimeUtil.tomorrow());
    }
}

