/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.ckkloverdos.source.SourceSkeleton;
import org.ckkloverdos.source.SourceType;

public class StringSource
extends SourceSkeleton {
    private String theString;

    public StringSource(String name, SourceType type, String theString) {
        super(name, type, null);
        this.theString = theString;
        this.setValid(null != theString);
    }

    public StringSource(String name, SourceType type, StringBuffer theString) {
        this(name, type, theString.toString());
    }

    public Reader getReader() throws UnsupportedEncodingException {
        return new StringReader(this.theString);
    }

    public Reader getReader(String encoding) throws IOException {
        return new StringReader(this.getString(encoding));
    }

    public String getString() throws IOException {
        return this.theString;
    }

    public String getString(String encoding) throws IOException {
        return new String(this.theString.getBytes(), encoding);
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getString("UTF-8").getBytes());
    }
}

