/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.java;

import org.ckkloverdos.java.JavaVersion;
import org.ckkloverdos.util.Util;

public final class JavaPlatform {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EOL = JavaPlatform.getProperty("line.separator");
    public static final String FILE_SEP = JavaPlatform.getProperty("file.separator");
    public static final String PATH_SEP = JavaPlatform.getProperty("path.separator");
    public static final JavaVersion JAVA_VERSION = JavaVersion.JAVA_VERSION;
    public static final String OS_NAME = JavaPlatform.getProperty("os.name");
    public static final String OS_VERSION = JavaPlatform.getProperty("os.version");
    private static final String OS_NAME_LOWER = OS_NAME.toLowerCase();

    private JavaPlatform() {
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("Windows") != -1;
    }

    public static boolean isSolaris() {
        return OS_NAME.indexOf("Solaris") != -1 || OS_NAME.indexOf("SunOS") != -1;
    }

    public static boolean isLinux() {
        return OS_NAME.indexOf("Linux") != -1;
    }

    public static boolean isUnix() {
        return !JavaPlatform.isWindows() && !JavaPlatform.isMac();
    }

    public static boolean isMac() {
        return OS_NAME.startsWith("Mac OS");
    }

    public static boolean isMacOSX() {
        return JavaPlatform.isMac() && OS_NAME.endsWith("X");
    }

    public static JavaVersion version() {
        return JAVA_VERSION;
    }

    public static boolean isAtLeastJdk14() {
        return JAVA_VERSION.compare(1, 4) >= 0;
    }

    public static boolean isAtLeastJdk15() {
        return JAVA_VERSION.compare(1, 5) >= 0;
    }

    public static boolean isAtLeastJdk16() {
        return JAVA_VERSION.compare(1, 6) >= 0;
    }

    public static String path() {
        String path = Util.getEnvOrProperty("PATH");
        if (null == path && JavaPlatform.isWindows()) {
            path = JavaPlatform.getProperty("java.library.path");
        } else if (null == path) {
            path = "";
        }
        return path;
    }

    public static String[] splitpath() {
        return JavaPlatform.path().split(PATH_SEP);
    }
}

