/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.collection;

import [Ljava.lang.String;;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ckkloverdos.collection.ArrayIterator;
import org.ckkloverdos.collection.CollectionProxy;
import org.ckkloverdos.collection.IL;
import org.ckkloverdos.filter.IFilter;
import org.ckkloverdos.function.IFilterFunction;
import org.ckkloverdos.function.IFilterProcedure;
import org.ckkloverdos.function.IFunction;
import org.ckkloverdos.function.IProcedure;
import org.ckkloverdos.hint.BinaryHint;
import org.ckkloverdos.reflect.IReflectiveAccessor;
import org.ckkloverdos.reflect.ReflectUtil;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.tuple.Pair;
import org.ckkloverdos.util.Util;

public class L
implements IL {
    protected Collection col;
    protected Object[] array;
    private static final IFunction FUNCTION_chopPrefixRE = new IFunction(){

        public Object evaluate(Object o, Object hints) {
            if (null == o) {
                return o;
            }
            Pattern p = (Pattern)hints;
            String so = (String)o;
            Matcher matcher = p.matcher(so);
            if (matcher.find()) {
                String prefix = matcher.group(1);
                return so.substring(prefix.length());
            }
            return o;
        }
    };
    private static final IFunction FUNCTION_chopSuffixRE = new IFunction(){

        public Object evaluate(Object o, Object hints) {
            if (null == o) {
                return o;
            }
            Pattern p = (Pattern)hints;
            String so = (String)o;
            Matcher matcher = p.matcher(so);
            if (matcher.find()) {
                String suffix = matcher.group(1);
                return so.substring(0, so.lastIndexOf(suffix));
            }
            return o;
        }
    };
    private static final IFilter FILTER_filterStartsWith = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o || null == hints) {
                return false;
            }
            String so = (String)o;
            String s = (String)hints;
            return so.startsWith(s);
        }
    };
    private static final IFilter FILTER_filterNotStartsWith = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o || null == hints) {
                return true;
            }
            String so = (String)o;
            String s = (String)hints;
            return !so.startsWith(s);
        }
    };
    private static final IFilter FILTER_filterEndsWith = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o || null == hints) {
                return false;
            }
            String so = (String)o;
            String s = (String)hints;
            return so.endsWith(s);
        }
    };
    private static final IFilter FILTER_filterNotEndsWith = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o || null == hints) {
                return true;
            }
            String so = (String)o;
            String s = (String)hints;
            return !so.endsWith(s);
        }
    };
    private static final IFilter FILTER_filterFindRE = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return false;
            }
            String so = (String)o;
            Pattern p = (Pattern)hints;
            return p.matcher(so).find();
        }
    };
    private static final IFilter FILTER_filterNotFindRE = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return true;
            }
            Pattern p = (Pattern)hints;
            String so = (String)o;
            return !p.matcher(so).find();
        }
    };
    private static final IFilter FILTER_filterFindRE_m = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return false;
            }
            String so = (String)o;
            Pattern p = (Pattern)hints;
            return p.matcher(so).find();
        }
    };
    private static final IFilter FILTER_filterNotFindRE_m = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return true;
            }
            Pattern p = (Pattern)hints;
            String so = (String)o;
            return !p.matcher(so).find();
        }
    };
    private static final IFilter FILTER_filterMatchesRE = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return false;
            }
            String so = (String)o;
            Pattern p = (Pattern)hints;
            return p.matcher(so).matches();
        }
    };
    private static final IFilter FILTER_filterNotMatchesRE = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return true;
            }
            Pattern p = (Pattern)hints;
            String so = (String)o;
            return !p.matcher(so).matches();
        }
    };
    private static final IFilter FILTER_filterMatchesRE_m = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return false;
            }
            String so = (String)o;
            Pattern p = (Pattern)hints;
            return p.matcher(so).matches();
        }
    };
    private static final IFilter FILTER_filterNotMatchesRE_m = new IFilter(){

        public boolean accept(Object o, Object hints) {
            if (null == o) {
                return true;
            }
            Pattern p = (Pattern)hints;
            String so = (String)o;
            return !p.matcher(so).matches();
        }
    };

    public L() {
        this.col = new ArrayList();
    }

    public L(Object o) {
        if (null == o) {
            this.col = Collections.EMPTY_LIST;
        } else if (o instanceof Collection) {
            this.col = (Collection)o;
        } else if (o.getClass().isArray()) {
            this.array = (Object[])o;
        } else {
            this.col = Collections.singletonList(o);
        }
    }

    public L(Object a, Object b) {
        this(new Object[]{a, b});
    }

    public L(Object a, Object b, Object c) {
        this(new Object[]{a, b, c});
    }

    public L(Object a, Object b, Object c, Object d) {
        this(new Object[]{a, b, c, d});
    }

    public L(Object a, Object b, Object c, Object d, Object e) {
        this(new Object[]{a, b, c, d, e});
    }

    public L(Collection collection) {
        this.col = null == collection ? this.newList() : collection;
    }

    public L(Set set) {
        this.col = null == set ? this.newSet() : set;
    }

    public L(Iterator iterator) {
        this.col = null == iterator ? this.newList() : this.newCollection(iterator);
    }

    public L(Object[] array) {
        this.array = null == array ? new Object[]{} : array;
    }

    protected SortedSet newSortedSet() {
        return new TreeSet();
    }

    protected SortedSet newSortedSet(Comparator c) {
        return new TreeSet(c);
    }

    protected Set newSet() {
        if (this.isSortedSet()) {
            return this.newSortedSet();
        }
        return new HashSet();
    }

    protected Set newSet(Collection withElements) {
        Set s = this.newSet();
        s.addAll(withElements);
        return s;
    }

    protected Set newSet(Iterator withElements) {
        Set s = this.newSet();
        this.addAll((Collection)s, withElements);
        return s;
    }

    protected SortedSet newSortedSet(Collection withElements) {
        SortedSet s = this.newSortedSet();
        s.addAll(withElements);
        return s;
    }

    protected SortedSet newSortedSet(Collection withElements, Comparator c) {
        SortedSet s = this.newSortedSet(c);
        s.addAll(withElements);
        return s;
    }

    protected Set newSet(Object[] withElements) {
        Set s = this.newSet();
        this.addAll((Collection)s, withElements);
        return s;
    }

    protected SortedSet newSortedSet(Object[] withElements) {
        SortedSet s = this.newSortedSet();
        this.addAll((Collection)s, withElements);
        return s;
    }

    private Collection addAll(Collection c, Iterator other) {
        while (other.hasNext()) {
            c.add(other.next());
        }
        return c;
    }

    private Collection addAll(Collection c, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            c.add(array[i]);
        }
        return c;
    }

    protected Collection newCollection() {
        if (this.isSet()) {
            return this.newSet();
        }
        return this.newList();
    }

    protected Collection newCollection(Collection withItems) {
        Collection c = this.newCollection();
        c.addAll(withItems);
        return c;
    }

    protected Collection newCollection(Iterator withItems) {
        Collection c = this.newCollection();
        this.addAll(c, withItems);
        return c;
    }

    protected Collection newCollection(Object[] withItems) {
        Collection c = this.newCollection();
        this.addAll(c, withItems);
        return c;
    }

    protected List newList() {
        if (null != this.col && this.col instanceof LinkedList) {
            return new LinkedList();
        }
        return new ArrayList();
    }

    protected List newList(Collection withElements) {
        List r = this.newList();
        r.addAll(withElements);
        return r;
    }

    protected List newList(Iterator withElements) {
        List r = this.newList();
        this.addAll((Collection)r, withElements);
        return r;
    }

    protected List newList(Object[] withElements) {
        List r = this.newList();
        this.addAll((Collection)r, withElements);
        return r;
    }

    public Iterator iterator() {
        if (null != this.col) {
            return this.col.iterator();
        }
        return new ArrayIterator(this.array);
    }

    public Iterator iterator(IFilter filter) {
        return this.iterator(filter, null);
    }

    public Iterator iterator(IFilter filter, Object hints) {
        return this.filter(filter, hints).iterator();
    }

    public int size() {
        if (null != this.col) {
            return this.col.size();
        }
        if (null != this.array) {
            return this.array.length;
        }
        return 0;
    }

    public boolean contains(Object o) {
        if (this.isCollection()) {
            return this.col.contains(o);
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (!Util.equalSafe(o, this.array[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isArray() {
        return null != this.array;
    }

    public boolean isCollection() {
        return null != this.col;
    }

    public boolean isSet() {
        return null != this.col && this.col instanceof Set;
    }

    private boolean isSortedSet() {
        return null != this.col && this.col instanceof SortedSet;
    }

    public boolean isList() {
        return null != this.col && this.col instanceof List;
    }

    public Object[] toArray() {
        if (this.isCollection()) {
            return this.col.toArray();
        }
        return this.array;
    }

    public Object[] toArray(Class arrayClass) {
        Object newArray;
        if (this.isCollection()) {
            return this.col.toArray((Object[])Array.newInstance(arrayClass.getComponentType(), 0));
        }
        if (this.array.getClass().equals(arrayClass)) {
            newArray = this.array;
        } else {
            Class<?> componentType = arrayClass.getComponentType();
            newArray = Array.newInstance(componentType, this.array.length);
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        }
        return newArray;
    }

    public String[] toStringArray() {
        return (String[])this.toArray(String;.class);
    }

    public List toList() {
        if (this.isCollection()) {
            if (this.isList()) {
                return (List)this.col;
            }
            return this.newList(this.col);
        }
        return this.newList(this.array);
    }

    public Set toSet() {
        if (this.isSet()) {
            return (Set)this.col;
        }
        if (this.isCollection()) {
            return this.newSet(this.col);
        }
        return this.newSet(this.array);
    }

    public SortedSet toSortedSet() {
        if (this.isCollection()) {
            if (this.isSortedSet()) {
                return (SortedSet)this.col;
            }
            return this.newSortedSet(this.col);
        }
        return this.newSortedSet(this.array);
    }

    public Collection toCollection() {
        if (this.isCollection()) {
            return this.col;
        }
        return this.newList(this.array);
    }

    public Object get(int i) {
        if (this.isList()) {
            return ((List)this.col).get(i);
        }
        if (this.isArray()) {
            return this.array[i];
        }
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Bad index " + i);
        }
        Iterator iter = this.iterator();
        for (int index = 0; index != i; ++index) {
            iter.next();
        }
        return iter.next();
    }

    public String getString(int i) {
        return (String)this.get(i);
    }

    public Object head() {
        if (0 == this.size()) {
            throw new IndexOutOfBoundsException("No elements in the list");
        }
        return this.iterator().next();
    }

    public IL tail() {
        return this.takeAfter(0);
    }

    private IL takeAfter(int n) {
        if (n < 0 || n > this.size() - 1) {
            return CollectionProxy.newLike(this).toL();
        }
        ++n;
        Iterator iter = this.iterator();
        while (n > 0) {
            iter.next();
            --n;
        }
        CollectionProxy proxy = CollectionProxy.newLike(this);
        if (iter.hasNext()) {
            proxy.beginMassiveAdd();
            while (iter.hasNext()) {
                proxy.add(iter.next());
            }
            proxy.endMassiveAdd();
        }
        return proxy.toL();
    }

    public IL take(int n) {
        if (n < 1) {
            return CollectionProxy.newLike(this).toL();
        }
        Iterator iter = this.iterator();
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        while (n > 0 && iter.hasNext()) {
            proxy.add(iter.next());
            --n;
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public Object head(IFilter filter) {
        return this.head(filter, null);
    }

    public Object head(IFilter filter, Object hints) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!filter.accept(o, hints)) continue;
            return o;
        }
        throw new IndexOutOfBoundsException("No element accepted by " + filter);
    }

    public IL filter(IFilter filter) {
        return this.filter(filter, null);
    }

    public IL filter(IFilter filter, Object hints) {
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!filter.accept(o, hints)) continue;
            proxy.add(o);
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public IL map(IFunction function) {
        return this.map(function, null);
    }

    public IL map(IFunction function, Object hints) {
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            proxy.add(function.evaluate(o, hints));
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public IL filterMap(IFilterFunction ff) {
        return this.filterMap(ff, null);
    }

    public IL filterMap(IFilterFunction ff, Object hints) {
        BinaryHint bh = BinaryHint.fromHint(hints);
        Object hintA = bh.getHintA();
        Object hintB = bh.getHintB();
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!ff.accept(o, hintA)) continue;
            proxy.add(ff.evaluate(o, hintB));
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public IL selectProperty(String propertyName) {
        boolean isMethodCall = propertyName.endsWith("()");
        if (isMethodCall) {
            propertyName = propertyName.substring(0, propertyName.length() - "()".length());
        }
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (null == o) continue;
            Class<?> c = o.getClass();
            IReflectiveAccessor reflectiveAccessor = ReflectUtil.getAccesorForSelect(c, propertyName, isMethodCall);
            proxy.add(reflectiveAccessor.get(o));
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public void forEach(IProcedure function) {
        this.forEach(function, null);
    }

    public void forEach(IProcedure function, Object hints) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            function.process(o, hints);
        }
    }

    public void filterForEach(IFilterProcedure function) {
        this.filterForEach(function, null);
    }

    public void filterForEach(IFilterProcedure function, Object hints) {
        BinaryHint bh = BinaryHint.fromHint(hints);
        Object hintA = bh.getHintA();
        Object hintB = bh.getHintB();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!function.accept(o, hintA)) continue;
            function.process(o, hintB);
        }
    }

    public IL copy() {
        return CollectionProxy.newLike(this).addAll(this).toL();
    }

    public IL add(Object o) {
        this.setFrom(new CollectionProxy(this).add(o));
        return this;
    }

    public IL addAll(Collection c) {
        return this.setFrom(new CollectionProxy(this).addAll(c));
    }

    public IL addAll(Object[] array) {
        return this.setFrom(new CollectionProxy(this).addAll(array));
    }

    public IL addAll(IL l) {
        return this.setFrom(new CollectionProxy(this).addAll(l));
    }

    public IL remove(Object o) {
        return this.setFrom(new CollectionProxy(this).remove(o));
    }

    public IL clear(Object o) {
        return this.setFrom(new CollectionProxy(this).clear(o));
    }

    public IL setFrom(CollectionProxy proxy) {
        if (proxy.isCollection()) {
            this.col = proxy.getCollection();
        } else {
            this.array = proxy.getArray();
        }
        return this;
    }

    public void toStringAware(ToString ts) {
        ToString ts2 = new ToString().setUsingTypeNames(false);
        if (null != this.col) {
            ts2.add(this.col);
        } else {
            ts2.add(this.array);
        }
        ts.add(ts2);
    }

    public boolean all(IFilter filter) {
        return this.all(filter, null);
    }

    public boolean all(IFilter filter, Object hints) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (filter.accept(o, hints)) continue;
            return false;
        }
        return this.size() > 0;
    }

    public boolean any(IFilter filter) {
        return this.any(filter, null);
    }

    public boolean any(IFilter filter, Object hints) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!filter.accept(o, hints)) continue;
            return true;
        }
        return 0 == this.size();
    }

    public IL unique() {
        if (this.isSet()) {
            return this;
        }
        Set unique = this.newSet();
        this.addAll((Collection)unique, this.iterator());
        return new L(unique);
    }

    public IL zip(IL other) {
        List r = this.newList();
        Iterator iThis = this.iterator();
        Iterator iOther = other.iterator();
        while (iThis.hasNext() && iOther.hasNext()) {
            r.add(new Pair(iThis.next(), iOther.next()));
        }
        return new L(r);
    }

    public IL sort() {
        if (this.isSortedSet()) {
            return this;
        }
        if (this.isSet()) {
            SortedSet ss = this.newSortedSet(this.col);
            return new L(ss);
        }
        if (this.isCollection()) {
            List l = this.toList();
            Collections.sort(l);
            return new L(l);
        }
        Object[] o = this.toArray();
        Arrays.sort(o);
        return new L(o);
    }

    public IL sort(Comparator c) {
        if (this.isSet()) {
            SortedSet ss = this.newSortedSet(this.col, c);
            return new L(ss);
        }
        if (this.isCollection()) {
            List l = this.toList();
            Collections.sort(l, c);
            return new L(l);
        }
        Object[] o = this.toArray();
        Arrays.sort(o, c);
        return new L(o);
    }

    private Collection newCombinedCollection(IL other) {
        if (this.isSet() && other.isSet()) {
            return this.newSet();
        }
        return this.newList();
    }

    public IL union(IL other) {
        Collection a;
        if (this.isSet() && other.isSet()) {
            a = this.newSet();
            a.addAll(this.col);
        } else {
            a = this.newList();
            this.addAll(a, this.array);
        }
        this.addAll(a, other.iterator());
        return new L(a);
    }

    public IL intersect(IL other) {
        Collection r = this.newCombinedCollection(other);
        int thisSize = this.size();
        int otherSize = other.size();
        IL small = this;
        IL big = other;
        if (thisSize > otherSize) {
            small = other;
            big = this;
        }
        Iterator iterator = small.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!big.contains(o)) continue;
            r.add(o);
        }
        return new L(r);
    }

    public IL minus(IL other) {
        Collection r = this.newCombinedCollection(other);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (other.contains(o)) continue;
            r.add(o);
        }
        return new L(r);
    }

    public String toString() {
        ToString ts = new ToString();
        this.toStringAware(ts);
        return ts.toString();
    }

    public IL chopPrefix(String prefix) {
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (null != item && item.startsWith(prefix)) {
                item = item.substring(prefix.length());
            }
            proxy.add(item);
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public IL chopPrefixRE(String prefix) {
        Pattern p = Pattern.compile("^(" + prefix + ")");
        return this.map(FUNCTION_chopPrefixRE, p);
    }

    public IL chopSuffix(String suffix) {
        CollectionProxy proxy = CollectionProxy.newLike(this);
        proxy.beginMassiveAdd();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (null != item && item.endsWith(suffix)) {
                item = item.substring(item.lastIndexOf(suffix));
            }
            proxy.add(item);
        }
        proxy.endMassiveAdd();
        return proxy.toL();
    }

    public IL chopSuffixRE(String suffix) {
        Pattern p = Pattern.compile("(" + suffix + ")$");
        return this.map(FUNCTION_chopSuffixRE, p);
    }

    public IL filterStartsWith(String s) {
        return this.filter(FILTER_filterStartsWith, s);
    }

    public IL filterNotStartsWith(String s) {
        return this.filter(FILTER_filterNotStartsWith, s);
    }

    public IL filterEndsWith(String s) {
        return this.filter(FILTER_filterEndsWith, s);
    }

    public IL filterNotEndsWith(String s) {
        return this.filter(FILTER_filterNotEndsWith, s);
    }

    public IL filterFindRE(String re) {
        Pattern p = Pattern.compile(re);
        return this.filter(FILTER_filterFindRE, p);
    }

    public IL filterNotFindRE(String re) {
        Pattern p = Pattern.compile(re);
        return this.filter(FILTER_filterNotFindRE, p);
    }

    public IL filterFindRE(String re, int modifiers) {
        Pattern p = Pattern.compile(re, modifiers);
        return this.filter(FILTER_filterFindRE_m, p);
    }

    public IL filterNotFindRE(String re, int modifiers) {
        Pattern p = Pattern.compile(re, modifiers);
        return this.filter(FILTER_filterNotFindRE_m, p);
    }

    public IL filterMatchesRE(String re) {
        Pattern p = Pattern.compile(re);
        return this.filter(FILTER_filterMatchesRE, p);
    }

    public IL filterNotMatchesRE(String re) {
        Pattern p = Pattern.compile(re);
        return this.filter(FILTER_filterNotMatchesRE, p);
    }

    public IL filterMatchesRE(String re, int modifiers) {
        Pattern p = Pattern.compile(re, modifiers);
        return this.filter(FILTER_filterMatchesRE_m, p);
    }

    public IL filterNotMatchesRE(String re, int modifiers) {
        Pattern p = Pattern.compile(re, modifiers);
        return this.filter(FILTER_filterNotMatchesRE_m, p);
    }

    public IL filterStartsWithRE(String re) {
        return this.filterFindRE("^" + re);
    }

    public IL filterNotStartsWithRE(String re) {
        return this.filterNotFindRE("^" + re);
    }

    public IL filterStartsWithRE(String re, int modifiers) {
        return this.filterFindRE("^" + re, modifiers);
    }

    public IL filterNotStartsWithRE(String re, int modifiers) {
        return this.filterNotFindRE("^" + re, modifiers);
    }

    public IL filterEndsWithRE(String re) {
        return this.filterFindRE(re + "$");
    }

    public IL filterNotEndsWithRE(String re) {
        return this.filterNotFindRE(re + "$");
    }

    public IL filterEndsWithRE(String re, int modifiers) {
        return this.filterFindRE(re + "$", modifiers);
    }

    public IL filterNotEndsWithRE(String re, int modifiers) {
        return this.filterNotFindRE(re + "$", modifiers);
    }

    public int hashCode() {
        int hash = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            hash += hash ^ o.hashCode();
        }
        return hash;
    }

    public void print() {
        System.out.println(this);
    }

    public void print(PrintStream ps) {
        ps.println(this);
    }

    public void print(PrintWriter pw) {
        pw.println(this);
    }
}

