/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ckkloverdos.collection.ArrayIterator;
import org.ckkloverdos.collection.CollectionUtil;
import org.ckkloverdos.collection.IL;
import org.ckkloverdos.collection.IntArray;
import org.ckkloverdos.collection.L;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.util.Util;

public final class CollectionProxy
implements IToStringAware {
    private ICollectionProxyImpl impl;

    public CollectionProxy(Collection col) {
        this.impl = new CProxy(col);
    }

    public CollectionProxy(Object[] array) {
        this.impl = new AProxy(array);
    }

    public CollectionProxy(L l) {
        this.impl = l.isCollection() ? new CProxy(l.toCollection()) : new AProxy(l.toArray());
    }

    public Iterator iterator() {
        return this.impl.iterator();
    }

    public CollectionProxy addAll(IL l) {
        this.impl.addAll(l);
        return this;
    }

    public CollectionProxy addAll(Collection c) {
        this.impl.addAll(c);
        return this;
    }

    public CollectionProxy addAll(Object[] array) {
        this.impl.addAll(array);
        return this;
    }

    public CollectionProxy add(Object o) {
        this.impl.add(o);
        return this;
    }

    public CollectionProxy remove(Object o) {
        this.impl.remove(o);
        return this;
    }

    public CollectionProxy clear(Object o) {
        this.impl.clear(o);
        return this;
    }

    public boolean isCollection() {
        return this.impl.isCollection();
    }

    public Collection getCollection() {
        return this.impl.getCollection();
    }

    public Object[] getArray() {
        return this.impl.getArray();
    }

    public L toL() {
        return this.impl.toL();
    }

    public static CollectionProxy newLike(IL l) {
        if (l.isCollection()) {
            return new CollectionProxy(CollectionUtil.newCollectionLike(l));
        }
        return new CollectionProxy(new Object[0]);
    }

    public void toStringAware(ToString ts) {
        this.impl.toStringAware(ts);
    }

    public String toString() {
        return this.impl.toString();
    }

    public void beginMassiveAdd() {
    }

    public void endMassiveAdd() {
    }

    private static final class AProxy
    implements ICollectionProxyImpl {
        private Object[] array;
        private ArrayList massiveAddHelper;

        private AProxy(Object[] array) {
            this.array = array;
        }

        public Iterator iterator() {
            return new ArrayIterator(this.array);
        }

        public void addAll(IL l) {
            Iterator iter = l.iterator();
            this.beginMassiveAdd();
            while (iter.hasNext()) {
                this.massiveAddHelper.add(iter.next());
            }
            this.endMassiveAdd();
        }

        public void addAll(Collection c) {
            this.beginMassiveAdd();
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                this.massiveAddHelper.add(iterator.next());
            }
            this.endMassiveAdd();
        }

        public void addAll(Object[] array) {
            this.beginMassiveAdd();
            for (int i = 0; i < array.length; ++i) {
                this.massiveAddHelper.add(array[i]);
            }
            this.endMassiveAdd();
        }

        private boolean inMassiveAdd() {
            return null != this.massiveAddHelper;
        }

        private Object newArray(int length) {
            Class<?> componentType = this.array.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, length);
            return newArray;
        }

        public void add(Object o) {
            if (this.inMassiveAdd()) {
                this.massiveAddHelper.add(o);
            } else {
                Object newArray = this.newArray(this.array.length + 1);
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                Array.set(newArray, this.array.length, o);
                this.array = (Object[])newArray;
            }
        }

        public void remove(Object o) {
            if (this.array.length > 0) {
                int delIndex = -1;
                for (int i = 0; i < this.array.length; ++i) {
                    if (!Util.equalSafe(this.array[i], o)) continue;
                    delIndex = i;
                    break;
                }
                if (delIndex >= 0) {
                    Object newArray = this.newArray(this.array.length - 1);
                    System.arraycopy(this.array, 0, newArray, 0, delIndex);
                    System.arraycopy(this.array, delIndex + 1, newArray, delIndex, this.array.length - delIndex - 1);
                    this.array = (Object[])newArray;
                }
            }
        }

        public void clear(Object o) {
            if (this.array.length > 0) {
                IntArray delPositions = new IntArray();
                for (int i = 0; i < this.array.length; ++i) {
                    if (!Util.equalSafe(this.array[i], o)) continue;
                    delPositions.add(i);
                }
                int howmanyToDelete = delPositions.length();
                if (howmanyToDelete > 0) {
                    int iToRead;
                    int newLength = this.array.length - howmanyToDelete;
                    Object newArray = this.newArray(newLength);
                    int[] dpArray = delPositions.array();
                    int dpIndex = 0;
                    int iToWrite = 0;
                    int wrote = 0;
                    for (iToRead = 0; iToRead < this.array.length && dpIndex < howmanyToDelete; ++iToRead) {
                        int dPos = dpArray[dpIndex];
                        if (iToRead < dPos) {
                            Array.set(newArray, iToWrite++, this.array[iToRead]);
                            ++wrote;
                            continue;
                        }
                        if (iToRead != dPos) continue;
                        ++dpIndex;
                    }
                    if (iToRead < this.array.length) {
                        int remainingToWrite = newLength - wrote;
                        System.arraycopy(this.array, iToRead, newArray, iToWrite, remainingToWrite);
                    }
                    this.array = (Object[])newArray;
                }
            }
        }

        public boolean isCollection() {
            return false;
        }

        public Collection getCollection() {
            return null;
        }

        public Object[] getArray() {
            return this.array;
        }

        public L toL() {
            return new L(this.array);
        }

        public void beginMassiveAdd() {
            this.massiveAddHelper = new ArrayList();
        }

        public void endMassiveAdd() {
            if (null != this.massiveAddHelper) {
                int total = this.array.length + this.massiveAddHelper.size();
                Object[] massive = this.massiveAddHelper.toArray();
                Object newArray = this.newArray(total);
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                System.arraycopy(massive, 0, newArray, this.array.length, massive.length);
                this.array = (Object[])newArray;
                this.massiveAddHelper = null;
            }
        }

        public void toStringAware(ToString ts) {
            ts.add(this.array);
        }

        public String toString() {
            ToString ts = new ToString();
            this.toStringAware(ts);
            return ts.toString();
        }
    }

    private static final class CProxy
    implements ICollectionProxyImpl {
        private Collection col;

        private CProxy(Collection col) {
            this.col = col;
        }

        public Iterator iterator() {
            return this.col.iterator();
        }

        public void addAll(IL l) {
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                this.col.add(iter.next());
            }
        }

        public void addAll(Collection c) {
            this.col.addAll(c);
        }

        public void addAll(Object[] array) {
            if (null != array) {
                for (int i = 0; i < array.length; ++i) {
                    this.col.add(array[i]);
                }
            }
        }

        public void add(Object o) {
            this.col.add(o);
        }

        public void remove(Object o) {
            this.col.remove(o);
        }

        public void clear(Object o) {
            while (this.col.remove(o)) {
            }
        }

        public boolean isCollection() {
            return true;
        }

        public Collection getCollection() {
            return this.col;
        }

        public Object[] getArray() {
            return null;
        }

        public L toL() {
            return new L(this.col);
        }

        public void beginMassiveAdd() {
        }

        public void endMassiveAdd() {
        }

        public void toStringAware(ToString ts) {
            ts.add(this.col);
        }

        public String toString() {
            ToString ts = new ToString();
            this.toStringAware(ts);
            return ts.toString();
        }
    }

    private static interface ICollectionProxyImpl
    extends IToStringAware {
        public Iterator iterator();

        public void addAll(IL var1);

        public void addAll(Collection var1);

        public void addAll(Object[] var1);

        public void add(Object var1);

        public void remove(Object var1);

        public void clear(Object var1);

        public boolean isCollection();

        public Collection getCollection();

        public Object[] getArray();

        public L toL();

        public void beginMassiveAdd();

        public void endMassiveAdd();
    }
}

