/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini: 
    window = VRWindow()
    call VRSet window, "Visible", 0
    if( Label = "" ) then do
        call ETKSetFileField "Line", CurrLine
    end
    else do
        "top"
        "locate /" || Label || ":/"
    end

    call VRSet window, "FrameOwner", ""
    call VRSet epmWindow, "Enabled", 1
    drop window

return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: 
    window = VRWindow()
    if( Address() <> "EPM" ) then do
        call VRMessage window, "You must run this macro from EPM.", "E"
        call Quit
        signal InitDone
    end

    /* Set the window owner to the EPM window
    */
    epmWindow = VRMethod( "Screen", "GetActiveWindow" )
    call VRSet window, "FrameOwner", epmWindow

    /* Disable the EPM window
    */
    call VRSet epmWindow, "Enabled", 0

    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    "extract /line"
    CurrLine = line.1
    "sayerror Found" ListLabels() "labels"   
    Label = ""
    
InitDone:
return

ListLabels: procedure
    "sayerror Locating labels"
    "all /^[abcdefghijklmnopqrstuvwxyz0123456789_]+:/g c"
    if( rc = 0 ) then do
        count = 0
        signal ListDone
    end
 
    "sayerror Extracting labels"
    call VRSet "LB_Labels", "Painting", 0
    "extract /last"
    count = last.1
    "top"
    do i = 1 to count
        "extract /getline"
        parse var getline.1 lineNum name ":" .
        call VRMethod "LB_Labels", "AddString", name
        "+1"
    end
    call VRSet "LB_Labels", "Painting", 1
    "quit"

ListDone:
return count

/*:VRX         LB_Labels_Click
*/
LB_Labels_Click:
    call VRMethod "LB_Labels", "GetSelectedStringList", "list."
    if( list.0 = 1 ) then do
        Label = list.1
    end
return

/*:VRX         LB_Labels_DoubleClick
*/
LB_Labels_DoubleClick:
    call Quit
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    Label = ""
    call Quit
return

/*:VRX         PB_OK_Click
*/
PB_OK_Click:
    call Quit
return

/*:VRX         Quit
*/
Quit: 
    window = VRWindow()
    call VRSet window, 'shutdown', 'true'
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

