/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         EnableButtons
*/
EnableButtons:
    /* Only enable the buttons if there is an available printer.
    */
    filename = VRGet( "Filename", "Value" )
    selected = VRGet( "Printers", "Selected" )
    enabled = ( filename \= "" ) & ( selected \= 0 )
    call VRSet "PB_Print", "Enabled", enabled
return

/*:VRX         Filename_Change
*/
Filename_Change:
    call EnableButtons
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /*  Build the list of printers
    */
    call VRMethod "Application", "ListPrinters", "printer."
    do i = 1 to printer.0
        parse var printer.i queue ";" printer ";" driver
        call VRMethod "Printers", "AddString", queue,,printer
    end
    
    /*  Select the first printer
    */
    call VRSet "Printers", "Selected", 1

    /* Create the window
    */   
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    call Quit
return

/*:VRX         PB_CancelPrint_Click
*/
PB_CancelPrint_Click:   
    call VRMethod "Application", "HaltThread", WorkerTID
    call Progress_Close
    call VRMessage "Window1", "Print job cancelled.", "Note", "Information"
return

/*:VRX         PB_Find_Click
*/
PB_Find_Click:
    /* Find the file to print.
    */

    fileName = VRFileDialog( VRWindow(), "File to print", "Open" )
    if fileName \= "" then do
        call VRSet "FileName", "Value", fileName
    end
return

/*:VRX         PB_Print_Click
*/
PB_Print_Click:
    /*  Get the printer name from the item data stored in the list
    */
    selection = VRGet( "Printers", "Selected" )
    printer = VRMethod( "Printers", "GetItemData", selection )

    /*  Get the name of the file to print, then print it from
        another thread.
    */
    filename = VRGet( "Filename", "Value" )
    cancelled = 0
    workerTID = VRMethod( "Application", "StartThread",,
                  "Worker", printer, filename )

    /*  Disable the main window while the "progress" window is open
    */
    call VRSet "Window1", "Enabled", 0
    call VRLoadSecondary "Progress"
return

/*:VRX         PrintDone
*/
PrintDone: procedure
    parse arg ok

    call Progress_Close

    if ok = 1 then do 
        call VRMessage "Window1", "File printed OK.",,
                       "Note", "Information"
    end
    else do
        call VRMessage "Window1", "Could not print the file.",,
                       "Error", "Error"
    end
return
/*:VRX         Printers_Click
*/
Printers_Click:
    call EnableButtons
return

/*:VRX         Progress_Close
*/
Progress_Close:
    call VRDestroy "Progress"
    call VRSet "Window1", "Enabled", 1
    call VRMethod "Window1", "Activate"
return
/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

