/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_BackColor_Click
*/
MI_BackColor_Click:
    call SetBackColor
return

/*:VRX         MI_BackDefault_Click
*/
MI_BackDefault_Click:
    call SetColor "<Default>"
return

/*:VRX         MI_BackGreen_Click
*/
MI_BackGreen_Click:
    call SetColor "Green"
return

/*:VRX         MI_BackRed_Click
*/
MI_BackRed_Click:
    call SetColor "Red"
return

/*:VRX         MI_Caption_Click
*/
MI_Caption_Click:
    call SetCaption
return

/*:VRX         MI_Help_Click
*/
MI_Help_Click:
    call About VRWindow()
return

/*:VRX         MI_PRODINFO_Click
*/
MI_PRODINFO_Click:
    call About VRWindow()
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SetCaption
*/
SetCaption:
    /* Get the button handle, and the caption
    */

    button = VRInfo( "Source" )
    caption = VRGet( button, "Caption" )

    /* Prompt for a new caption 
    */

    id = VRPrompt( VRWindow(), "Enter the new caption:", "caption",,
                   "Change button caption" )

    /* Change the caption
    */

    call VRSet button, "Caption", caption
return

/*:VRX         SetColor
*/
SetColor: procedure expose Button
    parse arg color

    /* Change the button color according to the 'color' parameter
    */

    source = VRInfo( "Source" )
    call VRSet source, "BackColor", color    
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_ContextMenu
*/
Window1_ContextMenu:
    /*  Display the popup menu if the user clicked on
        a button. Note that the buttons inherit the
        ContextMenu event from the window.
    */

    button = VRInfo( "Source" )
    if button \= VRWindow() then do
        call VRMethod "PopupMenu", "Popup"
    end
return

