/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__: 

return

/*:VRX         CNCT_Database_Fini
*/
CNCT_Database_Fini: 
    /*  Disconnect from the database
    */

    if( VRMethod( "CNCT_Database", "Disconnect" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close connection:",
            VRGet( "CNCT_Database", "Status" )
    end
return
/*:VRX         CNCT_Database_Init
*/
CNCT_Database_Init: 
    procedure expose Globals. database_type
 
    /*  Connect to the database
    */
    ok = VRMethod( "CNCT_Database", "Connect" )
    if( ok = 0 ) then do
        message = "Could not open connection: " || VRGet("CNCT_Database","Status") || "0A"x || "0A"x ||,
                  "Please ensure that your database engine is running." 
        if (database_type = "DB2") then do
           message = message || "0A"x || "0A"x || "Make sure you have run BINDDBI.EXE on the database you intend to use." || "0A"x
        end
        call VRMessage VRWindow(), message
        call Halt
    end
return

/*:VRX         DDCB_Max_Section_Change
*/
DDCB_Max_Section_Change: 
    /* Refresh the query
    */

    call VRSet "Window1", "Pointer", "Wait"

    call VRMethod "QRY_Chart_Section", "Close"
    call QRY_Chart_Section_Init

    call VRSet "Window1", "Pointer", "<default>"
return

/*:VRX         FindSampleDB
*/
FindSampleDB: procedure
    /* Finds the location of the WATCOM SQL VX-Rexx database
    */

    vxdir = VALUE( 'vxrexx', , 'os2environment' )

    if( RIGHT(vxdir, 1) = '\' ) then do 
        vxdir = LEFT( vxdir, LENGTH(vxdir) - 1 )
    end
    
    vxdir = vxdir || "\wsample.db"
    
return vxdir

/*:VRX         Fini
*/
Fini:
    /* Close the query
    */

    if( Globals.!Status = "OK" ) then do
        call QRY_Sections_Fini
        call QRY_Chart_Section_Fini
        call CNCT_Database_Fini
    end
    
    /* Globals.!Status = "Abort" if the cancel button
       was pushed in DBCNCT.  See the Init section.
    */

    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

    call Quit
return 0







/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Get the database type.
    */

    database_type = dbcnct( VRWindow() )

    if( database_type = "Abort" ) then do
        Globals.!Status = "Abort"
        call Halt 
    end

    /* Multiple database types are supported by changing the 
       connection object properties.
    */

    if( database_type = "WSQL" ) then do
        call VRSet "CNCT_Database", "DataSource", "WATCOM SQL" 
        call VRSet "CNCT_Database", "userid", "dba" 
        call VRSet "CNCT_Database", "password", "sql" 

        /* Find wsample.db on your HD
        */
        fspec = FindSampleDB( )
        call VRSet "CNCT_Database", "database", fspec         

        /* The SQL statment is changed to produce a nicer graph
           in WATCOM SQL mode.  This statement was added because
           DB2/2 did not have similary capabilities.
        */

        call VRSet "QRY_Chart_Section", "SQLStatement", "select string( 'Section ', s.section ), c.course, count(*) count from register r==section s==course c where s.section <= :max_section group by s.section, c.course " 
    end
    else do
        /* Set the DB2/2 options appropriately
        */
    
        call VRSet "CNCT_Database", "DataSource", "IBM DB2/2"    
        call VRSet "CNCT_Database", "userid", "" 
        call VRSet "CNCT_Database", "password", "" 
        call VRSet "CNCT_Database", "database", "wsample" 
    end

    /* Initialize the queries
    */

    call CNCT_Database_Init
    call QRY_Sections_Init

    /* Set the default value of the bound DDCB to the first element.*/

    call VRMethod "DDCB_Max_Section", "GetStringList", "section_list." 
    top_section = section_list.0
    call VRSet "DDCB_Max_Section", "Value", section_list.top_section

    call QRY_Chart_Section_Init

    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return







/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* Display all the product information in a multiline
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 4
    message.1 = "Chart Bound Data Sample #1"
    message.2 = ""
    message.3 = "This sample application shows how a"
    message.4 = "chart can be bound to a database."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1    
return

/*:VRX         QRY_Chart_Section_Fini
*/
QRY_Chart_Section_Fini:
    /*  Close a query
    */

    if( VRMethod( "QRY_Chart_Section", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Chart_Section", "Status" ),,"I"
    end
return
/*:VRX         QRY_Chart_Section_Init
*/
QRY_Chart_Section_Init:
    /* Get the maximum section number from the DDCB
    */

    max_section = VRGet( "DDCB_Max_Section", "Value" )
 
    /*  Open the query
    */

    if( VRMethod( "QRY_Chart_Section", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Chart_Section", "Status" )
    end
return
/*:VRX         QRY_Sections_Fini
*/
QRY_Sections_Fini:
     /*  Close a query
    */
 
    if( VRMethod( "QRY_Sections", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Sections", "Status" ),,"I"
    end
return
/*:VRX         QRY_Sections_Init
*/
QRY_Sections_Init:
    /* Get the maximum section value
    */ 

    max_section = VRGet( "DDCB_Max_Section", "Value" )

    /*  Open the query
    */

    if( VRMethod( "QRY_Sections", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Sections", "Status" )
    end
return
/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    /* Close the application when the "Close" event is triggered.
    */

    call Quit
return

