/* update installation script */
/* Created: 05.11.2005        */

/* env */
product_log       = value("PRODUCT_LOG", ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"   , ,"OS2ENVIRONMENT")
target            = value("PRODUCT_DRV", ,"OS2ENVIRONMENT")

/* start */
Say
Say 'Starting update installation...'
cdir = directory()
call directory inst_dir

/* unpack diskettes */
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call SysFileTree '*.?dk', 'dsk1.', 'FO'
if dsk1.0 > 0 then do
	Say
	Say 'Unpacking DSK files...'
	'@dskxtrct /s:*.?dk /t:. /ra /lr >> 'product_log' 2>>&1'
end
call SysFileTree '*.dsk', 'dsk2.', 'FO'
if dsk2.0 > 0 then do
	Say
	Say 'Unpacking DSK files...'
	'@dskxtrct /s:*.dsk /t:. /ra /lr >> 'product_log' 2>>&1'
end

/* find out os major version */
tempfile = '$tmp$.txt'
'@ver > 'tempfile' 2>>&1'
call linein(tempfile)
parse value linein(tempfile) with . . . . . os_version
call lineout tempfile
'@del 'tempfile' >nul 2>>&1'

/* replace syslevel if warp 3 */
if os_version = '3.00' then do
	'@attrib -r -s -h 'target'\os2\install\syslevel.os2 >nul 2>>&1'
	'@copy 'target'\os2\install\syslevel.os2 'target'\os2\install\syslevel._os >> 'product_log' 2>>&1'
	'@del 'target'\os2\install\syslevel.os2 >nul 2>>&1'
	l1 = 'FFFF5359534C4556454C00000000000100000000000000000000000000000000002500000000100F400000005852304D3030355F585230343030305F49424D204F532F322042617365204F7065726174696E672053797374656D0000000000000000000'
	l2 = '00000000000000000000000000000000000000000000000000000000000000000000000000000000035363339413631303000304300000000000000000000000000'
	l = x2c(l1||l2)
	do while length(l) > 0
		c = substr(l,1,1)
		l=substr(l,2)
		call charout target'\os2\install\syslevel.os2', c
	end
	call charout target'\os2\install\syslevel.os2'
end

/* create syslevel.jav */
l1 = 'FFFF5359534C4556454C00000000000000000000000000000000000000000000002500000080C00F11080000585230343030395F585230343030385F4A6176612052756E74696D650000000000000000000000000000000000000000000000000000000'
l2 = '000000000000000000000000000000000000000000000000000000000000000000000000000000000353633394233333030000000000000000000000000000000000000'
l = x2c(l1||l2)
do while length(l) > 0
	c = substr(l,1,1)
	l=substr(l,2)
	call charout target'\os2\install\syslevel.jav', c
end
call charout target'\os2\install\syslevel.jav'

/* install MPTS*/
return_code = 0
call run_install_file 'mpts.exe'
return_code = result

/* install TCP/IP */
if stream('CID.flg', 'C', 'Query Exists') = '' then do
	call run_install_file 'tcpinst.exe'
	return_code = result
end

/* restore syslevel files */
if os_version = '3.00' then do
	'@attrib -r -s -h 'target'\os2\install\syslevel.os2 >nul 2>>&1'
	'@copy 'target'\os2\install\syslevel._os 'target'\os2\install\syslevel.os2 >> 'product_log' 2>>&1'
	'@del 'target'\os2\install\syslevel._os >nul 2>>&1'
end

/* delete syslevel.jav */
'@del 'target'\os2\install\syslevel.jav >nul 2>>&1'

/* restore dir */
call directory cdir

exit return_code

/* run install */
run_install_file: procedure expose product_log target

	parse arg inst_file
	return_code = 0

	call SysFileTree inst_file, 'inst.', 'FSO'
	if inst.0 > 1 then do
		Say
		Say 'Error: More than 1 install file found. Exiting...'
		'@echo Error: More than 1 install file found. Exiting... >> 'product_log
	end
	else if inst.0 = 1 then do
		if stream('CID.flg', 'C', 'Query Exists') = '' then do
			'@'inst.1' >> 'product_log' 2>>&1'
			return_code = rc
		end
		else do

			/* create mpts rsp file */
			mptssdir = strip(filespec('drive', inst1.1)||filespec('path', inst.1),'T','\')
			'@echo INST_SECTION = (         > 'mptssdir'\mpts.rsp'
			'@echo   UPGRADE_LEVEL = SAME  >> 'mptssdir'\mpts.rsp'
			'@echo   INSTALL = PRODUCT     >> 'mptssdir'\mpts.rsp'
			'@echo )                       >> 'mptssdir'\mpts.rsp'
			'@echo MPTS = (                >> 'mptssdir'\mpts.rsp'
			'@echo   [CONTROL]             >> 'mptssdir'\mpts.rsp'
			'@echo     Local_IPC = YES     >> 'mptssdir'\mpts.rsp'
			'@echo     INET_Access = YES   >> 'mptssdir'\mpts.rsp'
			'@echo     NETBIOS_Access = NO >> 'mptssdir'\mpts.rsp'
			'@echo )                       >> 'mptssdir'\mpts.rsp'

			/* create tcpip rsp file */
			call SysFileTree 'tcpinst.exe', 'inst.', 'FSO'
			tcpsdir = strip(filespec('drive', inst1.1)||filespec('path', inst.1),'T','\')
			'@echo TARGET_DRIVE='target'               > 'tcpsdir'\tcpip.rsp'
			'@echo LOG_PATH1='target'\TCPINST.LOG     >> 'tcpsdir'\tcpip.rsp'
			'@echo LOG_PATH2='target'\TCPINST2.LOG    >> 'tcpsdir'\tcpip.rsp'
			'@echo INSTALL_MODE=UNATTENDED            >> 'tcpsdir'\tcpip.rsp'
			'@echo BOOT_DRIVE='substr(target,1,1)'    >> 'tcpsdir'\tcpip.rsp'
			'@echo MPTS_PATH='mptssdir'               >> 'tcpsdir'\tcpip.rsp'
			'@echo MPTS_RSP_FILE='mptssdir'\mpts.RSP  >> 'tcpsdir'\tcpip.rsp'
			'@echo CONFIG_NO_INSTALL=N                >> 'tcpsdir'\tcpip.rsp'
			'@echo LANG=ENUS                          >> 'tcpsdir'\tcpip.rsp'
			'@echo CODEPAGE=850                       >> 'tcpsdir'\tcpip.rsp'
			'@echo PACKAGES = (                       >> 'tcpsdir'\tcpip.rsp'
			'@echo         BASE_APPS = Y              >> 'tcpsdir'\tcpip.rsp'
			'@echo )                                  >> 'tcpsdir'\tcpip.rsp'

			/* install */
			'@call 'tcpsdir'\install.cmd /r:'tcpsdir'\tcpip.rsp'
			return_code = rc

			/* clean up */
			'@copy 'target'\tcpinst.log+'target'\tcpinst2.log 'product_log' >nul 2>>&1'
			'@del 'target'\tcpinst.log  >nul 2>>&1'
			'@del 'target'\tcpinst2.log >nul 2>>&1'

		end
	end

return return_code
