/* KOERSEN.CMD */

nu=Time('M')
vandaag=Date('S')

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

PARSE ARG datum
SAY
IF datum='' THEN DO
   SAY 'Welke datum (formaat: <EEJJMMDD>)? Voer een laag getal in om te stoppen,'
   CALL CharOut '','of druk op <ENTER> voor vandaag,' vandaag||': '
   PARSE PULL datum
   SAY
END
datum=Strip(datum)
IF datum='' THEN datum=vandaag
IF datum<vandaag-10000 THEN DO
   SAY
   SAY 'Fout: de ingevoerde datum' datum 'ligt voor' vandaag-10000
   SAY
   SAY 'Het aan te maken bestand is slechts bestemd voor controledoeleinden. De'
   SAY 'gegevens van donderdag 10 juli 2008 kunnen nabeurs worden opgehaald tot'
   SAY 'vrijdagochtend 11 juli 2008, of totdat deze de eindedagsgegevens van 10'
   SAY 'juli niet meer beschikbaar zijn. De te gebruiken datum is 20080710, met'
   SAY 'daarin de eindedagsgegevens van 10 juli 2008. Deze datum hoeft niet met'
   SAY 'de datum van de werkelijke gegevens overeen te stemmen, maar het is aan'
   SAY 'te raden om de datum wel gelijk te houden aan de datum van de gegevens.'
   SAY
   EXIT
END
IF datum>vandaag THEN DO
   SAY
   SAY 'Fout: de ingevoerde datum' datum 'ligt na vandaag,' vandaag
   SAY
   SAY 'Het aan te maken bestand is slechts bestemd voor controledoeleinden. De'
   SAY 'gegevens van donderdag 10 juli 2008 kunnen nabeurs worden opgehaald tot'
   SAY 'vrijdagochtend 11 juli 2008, of totdat deze de eindedagsgegevens van 10'
   SAY 'juli niet meer beschikbaar zijn. De te gebruiken datum is 20080710, met'
   SAY 'daarin de eindedagsgegevens van 10 juli 2008. Deze datum hoeft niet met'
   SAY 'de datum van de werkelijke gegevens overeen te stemmen, maar het is aan'
   SAY 'te raden om de datum wel gelijk te houden aan de datum van de gegevens.'
   SAY
   EXIT
END

begindatum=0
SAY
SAY 'De vanaf-datum wordt bepaald...'
beginjaar=Left(vandaag,4)
IF Stream(beginjaar||'.PRN','C','QUERY EXISTS')='' THEN DO
   beginjaar=beginjaar-1
   IF Stream(beginjaar||'.PRN','C','QUERY EXISTS')='' THEN DO
      beginjaar=beginjaar-1
      IF Stream(beginjaar||'.PRN','C','QUERY EXISTS')='' THEN DO
         beginjaar=beginjaar-1
         begindatum=beginjaar||'1227'
      END
   END
END
IF begindatum=0 THEN DO
   bron=beginjaar||'.PRN'
   DO WHILE Lines(bron)>0
      PARSE VALUE LineIn(bron) WITH tickertje ',' . ',' datumpje ',' .
      IF tickertje=='AEX' THEN DO
         IF datumpje>begindatum THEN begindatum=datumpje
      END
   END
   CALL LineOut bron
END
begindatum=Date('B',begindatum,'S')
begindatum=begindatum+1
IF Date('B',begindatum,'B')//7>4 THEN begindatum=begindatum+1
IF Date('B',begindatum,'B')//7>5 THEN begindatum=begindatum+1
begindatum=Date('S',begindatum,'B')
IF begindatum>vandaag THEN DO
   SAY
   SAY 'Fout: vanaf-datum' begindatum 'ligt na vandaag,' vandaag
   SAY
   EXIT
END
eindedatum=Date('B',vandaag,'S')
IF Date('B',eindedatum,'B')//7=5 THEN eindedatum=eindedatum-1
IF Date('B',eindedatum,'B')//7=6 THEN eindedatum=eindedatum-2
eindedatum=Date('S',eindedatum,'B')
IF eindedatum<begindatum THEN DO
   SAY
   SAY 'Fout: vanaf-datum' begindatum 'ligt voor tot en met-datum' eindedatum
   SAY
   EXIT
END
IF datum=vandaag THEN DO
   IF nu<1110 THEN DO
      SAY
      SAY 'Fout: de gegevens van' datum 'moeten nabeurs, vanaf 18:30 uur, worden'
      SAY '      opgehaald, en kunnen vanaf dat moment worden opgehaald tot deze'
      SAY '      voorbeurs op de volgende handelsdag niet meer beschikbaar zijn;'
      SAY '      aantal minuten wachttijd:' 1110-nu
      SAY
      IF 1110-nu>=5 THEN EXIT
      IF 1110-nu<5 THEN DO
         SAY '      De wachttijd duurt korter dan 5 minuten, er wordt nu gepauzeerd'
         SAY '      gedurende deze wachttijd, waarna de verwerking doorgaat...'
         SAY
         CALL SysSleep ((1100-nu)*60)
      END
   END
END
SAY 'Periode:' begindatum 'tot en met' eindedatum
SAY

browser='--user-agent="Mozilla/5.0 (OS/2; U; OS/2 4.50; nl-NL; rv:14.093)"'
url='"http://www.euronext.com/search/download/trapridownloadpopup.jcsv?'
url=url||'pricesearchresults=actif&filter=1&lan=NL&mep=8626&belongsToList='
url=url||'market_EURLS&resultsTitle=Amsterdam+-+Euronext&pageIndex=1&'
url=url||'cha=7213&format=txt&formatDecimal=.&formatDate=dd/MM/yy"'

IF Stream(datum,'C','QUERY EXISTS')='' THEN '@WGET' browser '-q -O'||datum url
IF stream(datum,'C','QUERY EXISTS')='' THEN DO
   SAY
   SAY 'Fout: bestand' datum 'niet opgehaald.'
   SAY
   EXIT
END
SAY 'Bestand' datum 'is opgehaald.'

extra=datum||'.ALT'
url='"http://www.euronext.com/search/download/trapridownloadpopup.jcsv?'
url=url||'pricesearchresults=actif&filter=1&mep=8626&lan=NL&belongsToList='
url=url||'market_ALTX&resultsTitle=Amsterdam+-+Alternext&cha=7213&format='
url=url||'txt&formatDecimal=.&formatDate=dd/MM/yy"'

opgehaald=0
IF Stream(extra,'C','QUERY EXISTS')='' THEN DO
   '@WGET' browser '-q -O'||extra url
   IF Stream(extra,'C','QUERY EXISTS')<>'' THEN opgehaald=1
END
IF Stream(extra,'C','QUERY EXISTS')='' THEN DO
   SAY
   SAY 'Fout: aanvullend bestand' extra 'niet opgehaald'
   SAY
   EXIT
END
SAY 'Bestand' extra 'is opgehaald.'
SAY

IF opgehaald=1 THEN DO
   teller=0
   DO 4
      CALL LineIn extra
   END
   DO WHILE Lines(extra)>0
      regel=Strip(LineIn(extra))
      IF regel<>'' THEN DO
         teller=teller+1
         PARSE VAR regel deel1 ';' deel2 ';' deel3 ';' deel4 ';' deel5 ';' . ';' deel6
         CALL LineOut datum,deel1||';'||deel2||';'||deel3||';'||deel4||';'||deel5||';'||deel6
      END
   END
   IF teller>0 THEN CALL LineOut datum
   CALL LineOut extra
   SAY Format(teller,5) 'regels uit bestand' extra 'toegevoegd aan bestand' datum||'.'
   SAY
END

bron='AANDELEN.LST'
IF Stream(bron,'C','QUERY EXISTS')='' THEN DO
   SAY
   SAY 'Fout: bestand' bron 'niet gevonden.'
   SAY
   EXIT
END

teller=0
DO WHILE Lines(bron)>0
   regel=Strip(LineIn(bron))
   IF regel<>'' THEN DO
      teller=teller+1
      PARSE VAR regel 1 symbool 11 . 31 isincode 46 .
      isincode.teller=Strip(isincode)
      symbool.teller=Strip(symbool)
   END
END
CALL LineOut bron
isincode.0=teller
symbool.0=teller
SAY Format(symbool.0,5) 'symbolen in' bron 'gevonden.'

DO 4
   CALL LineIn datum
END
overgeslagen=''
teller=0
DO WHILE Lines(datum)>0
   regel=LineIn(datum)
   IF Strip(regel)<>'' THEN DO
      teller=teller+1
      PARSE VAR regel . ';' isin ';' . ';' . ';' symbol ';' . ';' . ';' laatste ';' .
      isin.teller=Strip(isin)
      symbol.teller=Strip(symbol)
      IF laatste=0 THEN DO
         overgeslagen=Strip(overgeslagen||' '||symbol.teller)
         teller=teller-1
      END
   END
END
CALL LineOut datum
isin.0=teller
symbol.0=teller
SAY Format(symbol.0,5) 'symbolen in' datum 'gevonden.'
SAY

DO i=1 TO symbool.0
   gevonden=0
   DO j=1 TO symbol.0
      IF symbool.i==symbol.j THEN DO
         gevonden=gevonden+1
         IF isincode.i==isin.j THEN gevonden=gevonden+2
         j=symbol.0
      END
   END j
   IF symbool.i='AEX' THEN gevonden=9999
   IF symbool.i='AMX' THEN gevonden=9999
   IF symbool.i='ASCX' THEN gevonden=9999
   IF gevonden=0 THEN SAY 'Wel in' bron 'maar niet in' datum||':' symbool.i
   IF gevonden=1 THEN SAY 'ISIN-code van' symbool.i 'wijkt af:' isincode.i
END i

DO i=1 TO symbol.0
   gevonden=0
   DO j=1 TO symbool.0
      IF symbol.i==symbool.j THEN DO
         gevonden=gevonden+1
         IF isin.i==isincode.j THEN gevonden=gevonden+2
         j=symbool.0
      END
   END j
   IF gevonden=0 THEN SAY 'Wel in' datum 'maar niet in' bron||':' symbol.i isin.i
   IF gevonden=1 THEN SAY 'ISIN-code van' symbol.i 'wijkt af:' isin.i
END i

IF Words(overgeslagen)>0 THEN DO
   SAY
   SAY Format(Words(overgeslagen),5) 'symbolen overgeslagen:' overgeslagen
   SAY
END

IF begindatum=vandaag THEN DO
   IF nu<1420 THEN DO
      SAY
      SAY 'Fout: de gegevens van' datum 'moeten nabeurs, vanaf 23:40 uur, worden'
      SAY '      opgehaald, en kunnen vanaf dat moment worden opgehaald tot deze'
      SAY '      voorbeurs op de volgende handelsdag niet meer beschikbaar zijn;'
      SAY '      aantal minuten wachttijd:' 1420-nu
      SAY
      IF 1420-nu>=5 THEN EXIT
      IF 1420-nu<5 THEN DO
         SAY '      De wachttijd duurt korter dan 5 minuten, er wordt nu gepauzeerd'
         SAY '      gedurende deze wachttijd, waarna de verwerking doorgaat...'
         SAY
         CALL SysSleep ((1420-nu)*60)
      END
   END
END

PARSE VAR begindatum 1 beginjaar 5 beginmaand 7 begindag 9 .
PARSE VAR eindedatum 1 eindejaar 5 eindemaand 7 eindedag 9 .
begindatum=begindag||'/'||beginmaand||'/'||beginjaar
eindedatum=eindedag||'/'||eindemaand||'/'||eindejaar
teller=0
DO i=1 TO isincode.0
   CALL SysFileDelete symbool.i
   url='"http://www.euronext.com/tools/datacentre/dataCentreDownloadExcell.'
   url=url||'jcsv?cha=2634&lan=NL&fileFormat=txt&separator=.&dateFormat=dd/'
   url=url||'MM/yy&isinCode='||isincode.i||'&selectedMep=2&indexCompo=&'
   url=url||'opening=on&high=on&low=on&closing=on&volume=on&dateFrom='
   url=url||begindatum||'&dateTo='||eindedatum||'&typeDownload=2"'
   IF Stream(symbool.i,'C','QUERY EXISTS')='' THEN DO
      '@WGET' browser '--timeout=5 --tries=10 --waitretry=12 -q -O'||symbool.i url
      IF Stream(symbool.i,'C','QUERY EXISTS')<>'' THEN teller=teller+1
      IF teller//25=0 THEN DO
         IF teller<>isincode.0 THEN SAY Format(teller,5) 'van de' Format(isincode.0,5) 'bestanden opgehaald.'
      END
   END
END i
SAY Format(teller,5) 'van de' Format(isincode.0,5) 'bestanden opgehaald.'
IF teller<>isincode.0 THEN DO
   SAY
   SAY 'Fout: niet alle bestanden opgehaald, opgehaalde bestanden worden verwijderd'
   DO i=1 TO isincode.0
      IF Stream(symbool.i,'C','QUERY EXISTS')<>'' THEN CALL SysFileDelete symbool.i
   END i
   SAY
   EXIT
END

EXIT
