/* Controle of JJJJMMDD-bestand klopt met JJJJ.PRN */

NUMERIC DIGITS 19

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

PARSE ARG bestand

bestand=Strip(bestand)
IF bestand='' THEN DO
   SAY 'Fout: geen JJJJMMDD-bestand opgegeven'
   EXIT
END

IF Stream(bestand,'C','QUERY EXISTS')='' THEN DO
   SAY 'Fout: geen bestand opgegeven, of "'||bestand||'" bestaat niet'
   EXIT
END

bron=Left(bestand,4)||'.PRN'
IF Stream(bron,'C','QUERY EXISTS')='' THEN DO
   SAY 'Fout, bestand bestaat niet:' bron
   EXIT
END
teller1=0
teller2=0
kopregel=LineIn(bron)
DO WHILE Lines(bron)>0
   regel=LineIn(bron)
   teller2=teller2+1
   regel.teller2=regel
   PARSE VAR regel . ',' . ',' datum ',' .
   IF datum==bestand THEN DO
      teller1=teller1+1
      origineel.teller1=teller2
      PARSE VAR regel symbool.teller1 ',' . ',' datum.teller1 ',' open.teller1 ',' hoog.teller1 ',' laag.teller1 ',' slot.teller1 ',' omzet.teller1
   END
END
CALL LineOut bron
symbool.0=teller1
symbool2.0=teller2
SAY 'Bestand' bron 'ingelezen, aantal regels:' symbool2.0

patched=0
patches=0
teller=0
DO 4
   CALL LineIn bestand
END
DO WHILE Lines(bestand)>0
   regel=Strip(LineIn(bestand))
   IF regel<>'' THEN DO
      PARSE VAR regel . ';' . ';' . ';' . ';' symbool ';' . ';' . ';' slot ';' omzet ';' . ';' datum ';' effomzet ';' oi ';' oigeld ';' veiling ';' open ';' hoog ';' . ';' laag ';' .
      datum=Strip(datum)
      effomzet=Strip(effomzet)
      hoog=Strip(hoog)
      laag=Strip(laag)
      oi=Strip(oi)
      oigeld=Strip(oigeld)
      omzet=Strip(omzet)
      open=Strip(open)
      slot=Strip(slot)
      symbool=Strip(symbool)
      veiling=Strip(veiling)
      IF Pos('/',datum,1)=0 THEN datum='00/00/00 00:00'
      PARSE VAR datum dag tijd
      PARSE VAR dag dagnummer '/' maandnummer '/' jaarnummer
      datum=Right(jaarnummer+2000,4)||Right(maandnummer+100,2)||Right(dagnummer+100,2)
      IF omzet='-' THEN omzet=0
      gevonden=0
      DO i=1 TO symbool.0
         IF symbool.i==symbool THEN DO
            gevonden=i
            IF datum==bestand THEN DO
               IF open<>open.i THEN DO
                  patch=-1
                  patchlengte=Length(open)-Length(open.i)
                  PARSE VAR open . '.' decdag
                  PARSE VAR open.i . '.' decprn
                  decdaglen=Length(decdag)
                  decprnlen=Length(decprn)
                  IF Format(open,,decprnlen)=open.i THEN patch=open
                  IF patch=-1 THEN DO
                     verschil=5
                     DO decdaglen
                        verschil=Format(verschil/10,,decdaglen)
                     END
                     IF open-verschil=open.i THEN patch=open
                  END
                  IF patch>-1 THEN DO
                     SAY 'Patch open:' Left(symbool.i,10) '-' open.i '->' open 'in' bestand '->' patch
                     open.i=patch
                     regelnummer=origineel.i
                     PARSE VAR regel.regelnummer oudt ',' oudp ',' oudd ',' . ',' oudh ',' oudl ',' ouds ',' oudv
                     regel.regelnummer=oudt||','||oudp||','||oudd||','||open.i||','||oudh||','||oudl||','||ouds||','||oudv
                     patched=1
                     patches=patches+patchlengte
                  END
               END
               IF hoog<>hoog.i THEN DO
                  patch=-1
                  patchlengte=Length(hoog)-Length(hoog.i)
                  PARSE VAR hoog . '.' decdag
                  PARSE VAR hoog.i . '.' decprn
                  decdaglen=Length(decdag)
                  decprnlen=Length(decprn)
                  IF Format(hoog,,decprnlen)=hoog.i THEN patch=hoog
                  IF patch=-1 THEN DO
                     verschil=5
                     DO decdaglen
                        verschil=Format(verschil/10,,decdaglen)
                     END
                     IF hoog-verschil=hoog.i THEN patch=hoog
                  END
                  IF patch>-1 THEN DO
                     SAY 'Patch hoog:' Left(symbool.i,10) '-' hoog.i '->' hoog 'in' bestand '->' patch
                     hoog.i=patch
                     regelnummer=origineel.i
                     PARSE VAR regel.regelnummer oudt ',' oudp ',' oudd ',' oudo ',' . ',' oudl ',' ouds ',' oudv
                     regel.regelnummer=oudt||','||oudp||','||oudd||','||oudo||','||hoog.i||','||oudl||','||ouds||','||oudv
                     patched=1
                     patches=patches+patchlengte
                  END
               END
               IF laag<>laag.i THEN DO
                  patch=-1
                  patchlengte=Length(laag)-Length(laag.i)
                  PARSE VAR laag . '.' decdag
                  PARSE VAR laag.i . '.' decprn
                  decdaglen=Length(decdag)
                  decprnlen=Length(decprn)
                  IF Format(laag,,decprnlen)=laag.i THEN patch=laag
                  IF patch=-1 THEN DO
                     verschil=5
                     DO decdaglen
                        verschil=Format(verschil/10,,decdaglen)
                     END
                     IF laag-verschil=laag.i THEN patch=laag
                  END
                  IF patch>-1 THEN DO
                     SAY 'Patch laag:' Left(symbool.i,10) '-' laag.i '->' laag 'in' bestand '->' patch
                     laag.i=patch
                     regelnummer=origineel.i
                     PARSE VAR regel.regelnummer oudt ',' oudp ',' oudd ',' oudo ',' oudh ',' . ',' ouds ',' oudv
                     regel.regelnummer=oudt||','||oudp||','||oudd||','||oudo||','||oudh||','||laag.i||','||ouds||','||oudv
                     patched=1
                     patches=patches+patchlengte
                  END
               END
               IF slot<>slot.i THEN DO
                  patch=-1
                  patchlengte=Length(slot)-Length(slot.i)
                  PARSE VAR slot . '.' decdag
                  PARSE VAR slot.i . '.' decprn
                  decdaglen=Length(decdag)
                  decprnlen=Length(decprn)
                  IF Format(slot,,decprnlen)=slot.i THEN patch=slot
                  IF patch=-1 THEN DO
                     verschil=5
                     DO decdaglen
                        verschil=Format(verschil/10,,decdaglen)
                     END
                     IF slot-verschil=slot.i THEN patch=slot
                  END
                  IF patch>-1 THEN DO
                     SAY 'Patch slot:' Left(symbool.i,10) '-' slot.i '->' slot 'in' bestand '->' patch
                     slot.i=patch
                     regelnummer=origineel.i
                     PARSE VAR regel.regelnummer oudt ',' oudp ',' oudd ',' oudo ',' oudh ',' oudl ',' . ',' oudv
                     regel.regelnummer=oudt||','||oudp||','||oudd||','||oudo||','||oudh||','||oudl||','||slot.i||','||oudv
                     patched=1
                     patches=patches+patchlengte
                  END
               END
               IF datum==bestand THEN DO
                  IF omzet<>omzet.i THEN SAY 'Fout omz.:' Left(symbool.i,10) '-' omzet.i '->' omzet 'in' bestand
               END
            END
         END
      END i
      IF gevonden=0 THEN DO
         IF datum<>'20000000' THEN SAY 'Niet gevonden:' symbool
      END
   END
END
CALL LineOut bestand

IF patched>0 THEN DO
   temp=Left(bestand,4)||'.TMP'
   CALL LineOut temp,kopregel
   DO i=1 TO symbool2.0
      CALL LineOut temp,regel.i
   END i
   CALL LineOut temp
   SAY 'Bestand' temp 'aangemaakt.'

   bron=Left(bestand,4)||'.PRN'
   IF Stream(bron,'C','QUERY SIZE')+patches<>Stream(temp,'C','QUERY SIZE') THEN DO
      SAY
      SAY 'Fout: omvang bestand' bron 'past niet bij bestand' temp
      SAY '      met' patches 'bytes verschil'
      SAY
      EXIT
   END
   SAY 'Bestand' bron 'wordt verwijderd...'
   CALL SysFileDelete bron
   CALL CharOut bron,CharIn(temp,,Stream(temp,'C','QUERY SIZE'))
   CALL CharOut bron
   CALL CharOut temp
   IF Stream(bron,'C','QUERY SIZE')<>Stream(temp,'C','QUERY SIZE') THEN DO
      SAY
      SAY 'Fout:' temp 'niet gekopieerd naar' bron
      SAY
      EXIT
   END   
   SAY 'Bestand' bron 'aangemaakt.'
   SAY 'Bestand' temp 'wordt verwijderd...'
   CALL SysFileDelete temp
   SAY
END

EXIT
