; TURBO 4.0 - 7.0 CRT Delay replacement for RDELAY.PAS   97/01/18 red }
; ------------------------------------------------------------------- }
; Roger E. Donais                             <rdonais@southeast.net> }
; Freeware - Use at your own risk!                                    }
; =================================================================== }

        MODEL  Tpascal

        .DATA
        EXTRN  DelayCnt:DWORD


        .CODE

        PUBLIC  Delay,Init

TimerOffset  = 6Ch;
TimerSegment = 40h;

MSW equ WORD PTR 2
LSW equ WORD PTR 0

DELAY     LABEL FAR
          mov   BX,SP
          mov   CX,[SS:BX+4]
          jcxz  @Exit

          xor   DI,DI

          db    0Ch    ; Clear carry   (or AL,imm8)

INIT      LABEL NEAR
          stc          ; Set carry     (1-Byte opcode)

          mov   AX,TimerSegment
          mov   ES,AX
          lea   SI,[DelayCnt]
          jc    @2

@1:       call  @Delay
          loop  @1

; following was used to insure the "patch" had been applied
; and CRT.Delay was being vectored here!             ...red
;         mov   DL,'>'
;         mov   AH,02
;         int   21h

@Exit:    retf  2

@Delay:   mov  DX,DS:[SI.LSW]
          mov  AX,DS:[SI.MSW]
          mov  BL,ES:[DI]
@Count:   sub  DX,1
          sbb  AX,0
          jc   @Return
          cmp  BL,ES:[DI]
          jz   @Count
@Return:  retn

@2:       mov   DI,TimerOffset

          mov   BL,ES:[DI]
@3:       cmp   BL,ES:[DI]
          je    @3

          call  @Delay
          not   AX
          not   DX
          push  DX
          xor   DX,DX
          mov   DI,55
          div   DI
          mov   DS:[SI.MSW],AX
          pop   AX
          div   DI
          mov   DS:[SI.LSW],AX
          retn  ; --- init has no parameters
END

