{
 $Id$
}
{*****************************************************************************
 *
 * shareware registration key gen / check
 *           Removed from filemgr
 * Do not supply with filemgr package
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}
Unit  fm_key;

  {$A+} { everything is work aligned!! }
  {$X+} { extended syntax!  }
  {$V-} { no var string checks }
  {$F+} { FAR calls only }
  {$G-} { Don't generate 80286 code }
  {$O+}

  {.$define debug    - include debug output }
  {.$define develop  - include all routines in unit initialisation so the
                      smart linker doesn't throw everything out and we
                      can dump everything }

Interface
{ Uses  SYSTEM { checksum = 9373}
type
  REGSTATTYPE=  (
    NOTREGISTERED,     {0}
    REGISTERED,        {1}
    EXPIREDKEY,        {2}
    INVALIDKEY,        {3}
    FILEERROR,         {4}
    NULLOWNERCODE,     {5}
    NULLPROGRAMCODE,   {6}
    INVALIDFILE,       {7}
    BADTPU);           {8}
type
  RKPREC=  Record
    STATUS:  REGSTATTYPE; {ofs    0}
    KEYPATH:  string[79]; {ofs    1}
    ID:       string[36]; {ofs   51}
    NAME1:    string[36]; {ofs   76}
    NAME2:    string[36]; {ofs   9B}
    NAME3:    string[36]; {ofs   C0}
    MESSAGE:  string[36]; {ofs   E5}
    LEVEL:    BYTE;       {ofs  10A}
    EXPYEAR:  WORD;       {ofs  10B}
    EXPMONTH: WORD;       {ofs  10D}
    KEY:      string[12]; {ofs  10F}
  end;                    { ofs 11C }

Const
  RKPLUSVER=  '2.4';
  OWNERCODE:  string[20]=  ''; {ofs    0 in block    0}
  PROGRAMCODE:string[16]=  ''; {ofs   16 in block    0}
  KEYFILE:    string[12]=  ''; {ofs   28 in block    0}
  KEYFILESIZE:INTEGER=     0;  {ofs   36 in block    0}
  RKP:        RKPREC=
    (Status:  NotRegistered;
     KeyPath: '';
     Id:      '';
     Name1:   '';
     Name2:   '';
     Name3:   '';
     Message: '';
     Level:   0;
     ExpYear: 0;
     ExpMonth:0;
     Key:     '000000000000'
    );                         {ofs   38 in block    0}

function  BADSYSTEMDATE:   BOOLEAN; { Proc    8 Entry    0:0000}
function  GETKEYFILESIZE:  INTEGER; { Proc   10 Entry  120:0000}
  function MakeKey(
    Name1:  String;
    Name2:  String;
    Name3:  String;
    Level:  Byte;
    Year:   Word;
    Month:  Word
    ):      String;
  function ValidKey(
    Name1: String;
    Name2: String;
    Name3: String;
    Level: Byte;
    Key:   String
    ):     Boolean;
procedure  SETREGINFO(
      arg1:  string;
      arg2:  string;
      arg3:  string;
      arg4:  string;
      arg5:  string;
      arg6:  BYTE;
      arg7:  WORD;
      arg8:  WORD;
      arg9:  string
  ); { Proc   28 Entry   D0:0000}
procedure  CREATEKEY; { Proc   30 Entry   E0:0000}
procedure  VERIFYKEY; { Proc   38 Entry  108:0000}
procedure  GETREGINFO; { Proc   40 Entry  128:0000}
procedure  SAVEREGINFO; { Proc   48 Entry  150:0000}

{$ifdef debug}
procedure DumpStatus;
{$endif debug}


Implementation

  Uses Dos;


  type
    tByte0_3  = array[0.. 3] of Byte;
    tByte4_7  = array[4.. 7] of Byte;
    tByte0_7  = array[0.. 7] of Byte;
    tByte8_11 = array[8..11] of Byte;
    tByte0_11 = array[0..11] of Byte;
    tByte0_15 = array[0..15] of Byte;
    tByte0_53 = array[0..53] of Byte;

    tRkpTables = record
      Table0: tByte0_15;
      Table1: tByte0_3;
      Table2: tByte0_15;
      Table3: tByte4_7;
      Table4: tByte0_15;
      Table5: tByte8_11;
      Table6: tByte0_11;
      W:      Word;
    end;


  const
                            {  DS:0002       OWNERCODE                  }
                            {  DS:0018       PROGRAMCODE                }
                            {  DS:002A       KEYFILE                    }
                            {  DS:0038       KEYFILESIZE                }
                            {  DS:003A  - RKPtype start                 }
                            {  DS:0155  - RKPtype end                   }

    RkpLong: LongInt = 1;   {  DS:0156  - longint                   4   }
    RkpExt: String[4] =     {  DS:015A  - string -                  5   }
      '.RKP';
                            {  DS:015F  - dummy #0                  1   }
    RkpName:String[12] =    {  DS:0160  - string -                 13   }
      '000000000000';
                            {  DS:016D  - dummy #0                  1   }
    RkpString: String[32] = {  DS:016E  - string -                 33   }
      '0123456789'+
      'ABCDEFGH'+
      'JKLMN'+
      'PQR'+
      'TUVWXY';
                            {  DS:018F  - dummy #0                  1   }
    RkpRkPlus: String[7] =  {  DS:0190  - string - correct length?  7   }
      '9RkPlus';
                            {  DS:0197  - dummy #0                  1   }
    RkPlusVer_: String[4] = {  DS:0198  - string - correct length?  5   }
      ' 2.4';
                            {  DS:019D  - dummy #0                  1   }
    RkpCopyR: String[28] =  {  DS:019E  - string - correct length? 29   }
      '(c) 1990 Serious Cybernetics';
                            {  DS:01BB  - dummy #0                  1   }
    RkpRights: String[19] = {  DS:01BC  - string - correct length? 20   }
      'ALL RIGHTS RESERVED';
    RkpL01D0: Longint =
                 $00067AA2; {  DS:01D0  - longint                   4   }
    RkpL01D4: Longint =
                 $0006A184; {  DS:01D4  - longint                   4   }
    RkpL01D8: Longint =
                 $0001F3B2; {  DS:01D8  - word                      4   }
    TpuFails: Boolean=False;{  DS:01DC  - boolean                   1   }
                            {  DS:01DD  - dummy #0                  1   }

  const
    RkpTables: tRkpTables = (       { offset        index ranges   }
      Table0: ($00,$02,$03,$04,     { 01DE          0 15           }
               $05,$06,$07,$09,
               $0A,$0B,$0C,$0E,
               $0F,$10,$12,$13);
      Table1: ($01,$08,$0D,$11);    { 01EE          0 3            }
      Table2: ($00,$01,$02,$03,     { 01F2          0 15           }
               $05,$06,$07,$08,
               $09,$0A,$0B,$0D,
               $0E,$0F,$11,$12);    { 01FE                         }
      Table3: ($04,$0C,$10,$13);    { 01FE+4 = 0202 4 7            }
      Table4: ($01,$02,$03,$04,     { 0206          0 15           }
               $05,$07,$08,$09,
               $0B,$0C,$0D,$0E,     { 020E                         }
               $10,$11,$12,$13);
      Table5: ($00,$06,$0A,$0F);    { 020E+8 = 0216 8 11           }
      Table6: ($01,$08,$0D,$11,     { 021A          0 3  4 7  8 11 }
               $04,$0C,$10,$13,
               $00,$06,$0A,$0F);
      W:       $0001                { 0226 }
    );


  function CodeL2S(                     { checked: OK - 0000 }
    L: Longint  { BP+6 }
    ): String;  { BP+A }
  var
    W1: Word;   { BP-2 }
    W2: Word;   { BP-4 }
    B1: Byte;   { BP-5 }
    B2: Byte;   { BP-6 }
    B3: Byte;   { BP-7 }
    B4: Byte;   { BP-8 }
   (* Scratch1:String; { BP-108}  turbo pascal scratch area *)
   (* Scratch2:String; { BP-208}  turbo pascal scratch area *)
   (* Scratch3:String; { BP-308}  turbo pascal scratch area *)
   (* Scratch4:String; { BP-408}  turbo pascal scratch area *)
  begin
    W1 := L div $400;
    W2 := L mod $400;
    B1 := W1 div $20;
    B2 := W1 mod $20;
    B3 := W2 div $20;
    B4 := W2 mod $20;
    CodeL2S := RkpString[B1+1] +
                RkpString[B2+1] +
                RkpString[B3+1] +
                RkpString[B4+1];
  end;


  function CodeS2L(                     { checked: OK - 00EC }
    s: String       { BP+6 }
    ): Longint;     { BP-4 }
  var
  { FuncRes: Longint;   BP-4   Turbo Pascal area for function result }
  { VarStr:  String;    BP-104 Turbo Pascal area for non-var string which gets modified }
    TmpChr:  Char;    { BP-105 }
    UprPos:  Byte;    { BP-106 }
  { Scratch: String;    BP-206 Turbo Pascal scratch string }
  begin
    if s = '' then
      CodeS2L := 0
    else begin
      TmpChr := s[length(s)];
      Delete (s, Length(s), 1);
      UprPos := Pos(Upcase(TmpChr), RkpString);
      if UprPos <> 0 then
        CodeS2L := UprPos-1 + CodeS2L(s)* $0020
      else
        CodeS2L := 0
    end;
  end;


  function Mask4chars(                   { checked: OK - 01B2 }
    L: LongInt    { BP+6 }
    ): Longint;   { BP-4 }
  begin
    Mask4chars := L and $000FFFFF;
  end;


  function PackYearMonth(               { checked: OK - 01DF }
    Year,         { BP+8 }
    Month: Word   { BP+6 }
    ):     Word;  { BP-2 }
  begin
    if (Year < 1991) or
       (Year > 2330) or
       (Month < 1) or
       (Month > 12)
    then
      PackYearMonth := $0007
    else
      PackYearMonth := (Year - 1990) * 12 + Month;
  end;


  function FuncExpYear(                 { checked: OK - 0228 }
    I: Integer
    ): Word;  { $0228 }
  begin
    if I = 7 then
      FuncExpYear := 0
    else
      FuncExpYear := ((I - 1) div 12) + 1990;
  end;


  function FuncExpMonth(                { checked: OK - 025C }
    I: Integer
    ): Word;  { $025C }
  begin
    if I = 7 then
      FuncExpMonth := 0
    else
      FuncExpMonth := ((I - 1) mod 12) + 1;
  end;


  function PackSubKey3(                 { checked: OK - 028F }
    PackedInfoStrings: Longint;   { BP+8 }  { this is a bug in RKPLUS; it should be word }
    PackedYearMonth:   Word       { BP+6 }
    ): LongInt;   { BP-4 }
  var
    B1: Byte;     { BP-5 }
    L1: Longint;  { BP-A }
    L2: Longint;  { BP-E }
  begin
    L1 := 0;
    L2 := 0;
    for B1 := 0 to 15 do begin
      if Odd(PackedInfoStrings shr B1) then
        L1 := L1 or (RkpLong shl RkpTables.Table0[B1]);   { 01DE }
    end; { for }

    for B1 := 0 to 3 do begin
      if Odd(PackedYearMonth shr B1) then
        L2 := L2 or (RkpLong shl RkpTables.Table1[B1]);   { 01EE }
    end; { for }

    PackSubKey3 := L1 or L2;
  end;


  function PackSubKey2(                 { checked: OK - 036B }
    PackedInfoStrings: Word;     { BP+8 }
    PackedYearMonth:   Word      { BP+6 }
    ): Longint;                  { BP-4 }
  var
    B1: Byte;     { BP-5 }
    L1: Longint;  { BP-A }
    L2: Longint;  { BP-E }
  begin
    L1 := 0;
    L2 := 0;
    for B1 := 0 to 15 do begin
      if odd (PackedInfoStrings shr B1) then
        L1 := L1 or (RkpLong shl RkpTables.Table2[B1]);   { 01F2 }
    end; { for }

    for B1 := 4 to 7 do begin
      if odd (PackedYearMonth shr B1) then
        L2 := L2 or (RkpLong shl RkpTables.Table3[B1]);   { 01FE }
    end; { for }

    PackSubKey2 := L1 or L2;
  end;


  function PackSubKey1(                 { checked: OK - 043F }
    PackedInfoStrings: Word;     {BP+8}
    PackedYearMonth:   Word      {BP+6}
    ):  Longint;                 {BP-4}
  var
    B:  Byte;     {BP-5}
    L1: Longint;  {BP-A}
    L2: Longint;  {BP-E}
  begin
    L1 := 0;
    L2 := 0;
    for B := 0 to 15 do begin
      if odd (PackedInfoStrings shr B) then
        L1 := L1 or (RkpLong shl RkpTables.Table4[B])   { 0206 }
    end; { for }

    for B := 8 to 11 do begin
      if odd (PackedYearMonth shr B) then
        L2 := L2 or (RkpLong shl RkpTables.Table5[B])   { 020E }
    end; { For }

    PackSubKey1 := L1 or L2;
  end;


  function SubKeys2PackedYearMonth(     { checked: OK - 0513 }
    L1: Longint;  { BP+E }
    L2: Longint;  { BP+A }
    L3: Longint   { BP+6 }
    ):  Word;     { BP-2 }
  var
    W:  Word;     { BP-4 }
    B:  Byte;     { BP-5 }
  begin
    W := 0;
    for B := 0 to 3 do begin
      if odd (L3 shr RkpTables.Table6[B]) then
        W := W or (RkpTables.W shl B);
    end; { for }

    for B := 4 to 7 do begin
      if odd (L2 shr RkpTables.Table6[B]) then
        W := W or (RkpTables.W shl B);
    end; { for }

    for B := 8 to 11 do begin
      if odd (L1 shr RkpTables.Table6[B]) then
        W := W or (RkpTables.W shl B);
    end; { for }
    SubKeys2PackedYearMonth := W;
  end;


  function TrimLeadSp1(                 { checked: OK - 0604 }
  { r: string;       { BP+A   - Turbo Pascal string return space }
    s: string        { BP+6 }
    ): string;
  var
  { VarStr: String;  { BP-100 - Turbo Pascal value string space }
    B1: Byte;        { BP-101 }
    B2: Byte;        { BP-102 }
  { S1: String;      { BP-202 - Turbo Pascal temporary string storage }
  begin
    B2 := 1;
    for B1 := 1 to $24 do begin
      if B1 > Length(s) then
        s := s + ' '
      else begin
        if (B2 <> 0) and (s[B1] = ' ') then begin
          Delete (s, B1, 1);
          s := s + ' ';
        end
        else begin { B2 = 0 or no space }
          s[B1] := UpCase(s[B1]);
          B2 := 0;
        end; { else }
      end; { else }
    end; { for }
    TrimLeadSp1 := s;
  end;


  function TrimLeadSp2(                 { checked: OK - 0710 }
    s: String
    ): string;
  var
    B1: Byte;
    B2: Byte;
  begin
    B2 := 1;
    for B1 := 1 to $24 do begin
      if B1 > Length(s) then
        s := ' ' + s
      else begin
        if (B2 <> 0) and (s[B1] = ' ') then begin
          Delete(s,B1,1);
          s := ' ' + s;
        end { then }
        else begin
          s[B1] := UpCase(s[B1]);
          B2 := 0;
        end; { else }
      end; { else }
    end; { for }
    TrimLeadSp2 := s;
  end;


  function TrimLeadSp3(                 { checked: OK - 081C }
    s: string
    ): string;
  var
    B1: Byte;
    B2: Byte;
    B3: Byte;
  begin
    B2 := 1;
    s := TrimLeadSp2(s);
    B3 := 1;
    while B3 <> 0 do begin
      if (B2 > length(s)) or
         (s[B2] <> ' ')
      then
        B3 := 0
      else
        Inc(B2);
    end; { while }

    B2 := (B2-1) div 2;

    for B1 := 1 to B2 do begin
      Delete(s, 1, 1);
      s := s + ' ';
    end; { for }

    TrimLeadSp3 := s;
  end;


  function StrUpCase(                   { checked: OK - 091F }
    s: String
    ): String;
  var
    B: Byte;
  begin
    for B := 1 to Length(s) do begin
      s[B] := UpCase(s[B]);
    end; { for }
    StrUpCase := s;
  end;


  function MakeSubKey1(                 { checked: OK - 09A0 }
    PackedYearMonth: Word
    ): Longint;
  var
    s1: String[$24];  { BP- 2A }
    s2: String[$24];  { BP- 50 }
    s3: String[$24];  { BP- 76 }
    b0: Byte;         { BP- 78 }
    b1: Byte;         { BP- 78 }
    b2: Byte;         { BP- 79 }
    b3: Byte;         { BP- 7A }
  begin
    s1 := TrimLeadSp1(ProgramCode + Copy(RkpCopyR, 1,8)   + OwnerCode);
    s2 := TrimLeadSp2(OwnerCode   + Copy(RkpRights,1,$13) + ProgramCode);
    s3 := TrimLeadSp3(ProgramCode + ProgramCode +
                      ProgramCode + ProgramCode +
                      ProgramCode);
    b1 := 0;
    b2 := 0;
    for b3 := 1 to $24 do begin
      b0 := (Byte(s1[b3]) and Byte(s2[b3])) or Byte (s3[b3]);
      b1 := b0 + b1;
      b2 := b0 - b1;   { why??? this is faster: b2 := -b1; b1 := b0 + b1; }
    end; { for }
    MakeSubKey1 := PackSubKey1(b1*256 + b2, PackedYearMonth);
  end;


  function MakeSubKey2(                 { checked: OK - 0B27 }
    s1: String; { BP+12 }
    s2: String; { BP+0E }
    s3: String; { BP+0A }
    b0: Byte;   { BP+08 }
    PackedYearMonth: Word     { BP+06 }
    ): Longint; { BP-04 }
  var
    InfoA: String[5];  { BP-030A }
    InfoB: String[5];  { BP-0310 }
    InfoC: String[5];  { BP-0316 }
    Info1: String[$24];{ BP-033C }
    Info2: String[$24];{ BP-0362 }
    Info3: String[$24];{ BP-0388 }
    b1:    Byte;       { BP-0389 }
    b2:    Byte;       { BP-038A }
    b3:    Byte;       { BP-038B }
    b4:    Byte;       { BP-038C }

  const
    CharF6 = #$F6;
  begin
    if Length(s2) = 0 then
      s2 := s1;

    if Length(s3) = 0 then
      s3 := s2;

    b2 := Hi(PackedYearMonth);
    b3 := Lo(PackedYearMonth);
    InfoA := Char(b0 div 7) +
             Char(b3) +
             Char(b2+2) +
             Char(Byte(b3 * $000C)) +
             CharF6;

    InfoB := Char(b3 - $15) +
             Char(5 - b2) +
             Char(b0 shl 2) +
             Char(b3 xor $FF) +
             Char(b0 mod $20);

    InfoC := Char(b2 div 2) +
             Char(b3 mod 4) +
             Char(-b3) +
             Char(b0 div 3) +
             Char(b2 + 5);

    Info1 := TrimLeadSp1(ProgramCode + s1 + OwnerCode + InfoA);
    Info2 := TrimLeadSp2(InfoB + OwnerCode + s2 + ProgramCode);
    Info3 := TrimLeadSp3(ProgramCode + InfoC + s3 + InfoC + ProgramCode);

    b2 := 0;
    b3 := 0;
    for b4 := 1 to $24 do begin
      b1 := (Byte(Info1[b4]) and Byte(Info2[b4])) or Byte(Info3[b4]);
      b2 := b1+b2;
      b3 := b1-b3;
    end; { for }

    MakeSubKey2 := PackSubKey2(b2*256 + b3, PackedYearMonth)
  end;


  function MakeSubKey3(                 { checked: OK - 0ED9 }
    s1: String; { BP+12 }
    s2: String; { BP+0E }
    s3: String; { BP+0A }
    b0: Byte;   { BP+08 }
    PackedYearMonth:  Word    { BP+06 }
    ): Longint; { BP-4  }
  var
    InfoA: String[5];  { BP-030A }
    InfoB: String[5];  { BP-0310 }
    InfoC: String[5];  { BP-0316 }
    Info1: String[$24];{ BP-033C }
    Info2: String[$24];{ BP-0362 }
    Info3: String[$24];{ BP-0388 }
    b1:    Byte;       { BP-0389 }
    b2:    Byte;       { BP-038A }
    b3:    Byte;       { BP-038B }
    b4:    Byte;       { BP-038C }
  begin
    if Length(s2) = 0 then
      s2 := s1;

    if Length(s3) = 0 then
      s3 := s2;

    b2 := Hi(PackedYearMonth);
    b3 := Lo(PackedYearMonth);

    InfoA := Char(b2 div 7) +
             Char(b0) +
             Char(b3+2) +
             Char(b3 * $000C) +
             Char(b2 - $000B);

    InfoB := Char(b0 - $15) +
             Char(5 - b0) +
             Char(b3 shl 2) +
             Char(b2 xor $FF) +
             Char(b3 mod $0020);

    InfoC := Char(b0 div 2) +
             Char(b2 mod 4) +
             Char(-b0) +
             Char(b3 div 3) +
             Char(b2 + 5);

    Info1 := TrimLeadSp1(InfoA + s1 + Copy(RkpCopyR,1,8) + OwnerCode);
    Info2 := TrimLeadSp2(OwnerCode + Copy(RkpRights,1,$13) + InfoB + s2);
    Info3 := TrimLeadSp3(s3 + InfoC + s2 + InfoC + s1);

    b2 := 0;
    b3 := 0;
    for b4 := 1 to $24 do begin
      b1 := (Byte(Info1[b4]) and Byte(Info2[b4])) or Byte(Info3[b4]);
      b2 := b1+b2;
      b3 := b1-b3;
    end; { for }

    MakeSubKey3 := PackSubKey3(b2*256 + b3, PackedYearMonth)
  end;


  function Pack3SubKeys(                { checked: OK - 12C2 }
    l1: Longint;{ BP+0E }
    l2: Longint;{ BP+0A }
    l3: Longint { BP+06 }
    ): String;  { BP+12 }
  begin
    Pack3SubKeys := CodeL2S(Mask4chars(l1)) +
                    CodeL2S(Mask4chars(l2)) +
                    CodeL2S(Mask4chars(l3));
  end;


  function  BADSYSTEMDATE:  BOOLEAN;  { Proc    8 Entry    0:0000}
  begin
  end;


  function  GETKEYFILESIZE:  INTEGER; { Proc   10 Entry  120:0000}
  begin
  end;


  function MakeKey(                     { checked: OK - 1331 }
    Name1:  String; { BP+14 }
    Name2:  String; { BP+10 }
    Name3:  String; { BP+ C }
    Level:  Byte;   { BP+0A }
    Year:   Word;   { BP+08 }
    Month:  Word    { BP+06 }
    ):      String; { BP+18 }
  var
    SubK1:  Longint;
    SubK2:  Longint;
    SubK3:  Longint;
    PackedYearMonth:  Word;
  begin
    if (TpuFails) or (OwnerCode = '') or (ProgramCode = '')
    then
      MakeKey := RkpName
    else begin
      PackedYearMonth := PackYearMonth(Year, Month);
      SubK1 := MakeSubKey1(PackedYearMonth);
      SubK2 := MakeSubKey2(Name1, Name2, Name3, Level, PackedYearMonth);
      SubK3 := MakeSubKey3(Name1, Name2, Name3, Level, PackedYearMonth);
      MakeKey := Pack3SubKeys(SubK1, SubK2, SubK3);
    end; { else }
  end;


  procedure CreateKey;                  { Checkd: OK - 1447 new }
  begin
    if TpuFails then
    else begin
      if OwnerCode = '' then
        Rkp.Status := NullOwnerCode
      else begin
        if ProgramCode = '' then
          Rkp.Status := NullProgramCode
        else begin
          Rkp.Key := MakeKey(Rkp.Name1,
                             Rkp.Name2,
                             Rkp.Name3,
                             Rkp.Level,
                             Rkp.ExpYear,
                             Rkp.ExpMonth);
          Rkp.Status := Registered;
        end; { else }
      end; { else }
    end; { else }
  end;


  function Key2SubKey1(                 { checked: OK - 1447 }
    s: String
    ): Longint;
  begin
    Key2SubKey1 := CodeS2L(Copy(s,1,4));
  end;


  function Key2SubKey2(                 { checked: OK - 1499 }
    s: String
    ): Longint;
  begin
    Key2SubKey2 := CodeS2L(Copy(s,5,4));
  end;


  function Key2SubKey3(                 { checked: OK - 14EB }
    s: String
    ): Longint;
  begin
    Key2SubKey3 := CodeS2L(Copy(s,9,4));
  end;


  function ValidKey(                    { checked: OK - 153D }
    Name1: String;                     { BP+14 }
    Name2: String;                     { BP+10 }
    Name3: String;                     { BP+ C }
    Level: Byte;                       { BP+ A }
    Key:   String                      { BP+ 6 }
    ): Boolean;
  (*                     RetSeg
                         RetOfs
                         OldBP         BP+ 2
                         SomeByte      BP- 1
                         SomeByte2     BP- 2
                         Local_Name1   BP- 102
                         Local_Name2   BP- 202
                         Local_Name3   BP- 302
                         Local_Key     BP- 402 *)
   var
     TheKey: String[$0C];      { BP-0410 }
     w0412: Word;              { BP-0412 }
     ExpYearRes: Word;         { BP-0414 }
     ExpMonthRes: Word;        { BP-0416 }
     l041A: Longint;           { BP-041A }
     l041E: Longint;           { BP-041E }
     l0422: Longint;           { BP-0422 }
  begin
    if (TpuFails) or (OwnerCode = '') or (ProgramCode = '')
    then
      ValidKey := False
    else begin
      Key := StrUpCase(Key);
      l041A := Key2SubKey1(Key);
      l041E := Key2SubKey2(Key);
      l0422 := Key2SubKey3(Key);
      w0412 := SubKeys2PackedYearMonth(l041A, l041E, l0422);
      ExpYearRes := FuncExpYear(w0412);
      ExpMonthRes := FuncExpMonth(w0412);
      TheKey := MakeKey(Name1, Name2, Name3, Level, ExpYearRes, ExpMonthRes);
    {$ifdef debug}
      Writeln ('expected key: ',TheKey);
      Writeln ('used key: ',    Key);
      DumpStatus;
    {$endif debug}
      if TheKey = Key
      then
        ValidKey := True
      else
        ValidKey := False;
    end; { else }
  end;


  procedure VerifyKey;                  { checked: OK - 16A2 }
  var
    w: Word;
  begin
    if (TpuFails)
    then
      Rkp.Status := BadTpu
    else begin
      if (OwnerCode = '')
      then
        Rkp.Status := NullOwnerCode
      else begin
        if ProgramCode = ''
        then
          Rkp.Status := NullProgramCode
        else begin
          if ValidKey(Rkp.Name1, Rkp.Name2, Rkp.Name3, Rkp.Level, Rkp.Key)
          then begin
            Rkp.Status := Registered;
            w := SubKeys2PackedYearMonth(Key2SubKey1(Rkp.Key), Key2SubKey2(Rkp.Key), Key2SubKey3(Rkp.Key));
            Rkp.ExpYear := FuncExpYear(w);
            Rkp.ExpMonth := FuncExpMonth(w);
          end
          else
            Rkp.Status := InvalidKey;
        end; { else }
      end; { else }
    end; { else }
  end;


  procedure  SETREGINFO(
        arg1:  string;
        arg2:  string;
        arg3:  string;
        arg4:  string;
        arg5:  string;
        arg6:  BYTE;
        arg7:  WORD;
        arg8:  WORD;
        arg9:  string
    );  { Proc   28 Entry   D0:0000}
  begin
  end;


  procedure  GETREGINFO;  { Proc   40 Entry  128:0000}
  begin
  end;


  procedure  SAVEREGINFO; { Proc   48 Entry  150:0000}
  begin
  end;


  const
    EmptyString = '';
  procedure RkpInit;                    { checked: OK - 1748 }
  var
    Dir:  DirStr;            { BP-44 }
    Name: NameStr;           { BP-4E }
    Ext:  ExtStr;            { BP-54 }
    CheckKey: String[$000C]; { BP-62 }
  begin
    FSplit(ParamStr(0), Dir, Name, Ext);
    KeyFile := Name + RkpExt;
    OwnerCode := RkpCopyR;
    ProgramCode := Copy(RkpRkPlus,2,6);
    CheckKey := MakeKey (RkpString, RkpRights, EmptyString, 0, 0, 0);
    if (Key2SubKey1(CheckKey) <> RkpL01D0) or
       (Key2SubKey2(CheckKey) <> RkpL01D4) or
       (Key2SubKey3(CheckKey) <> RkpL01D8)
    then begin
    {$ifdef debug}
      Writeln('TPU check fails');
      Writeln('value     expected     received');
      Writeln('-------------------------------');
      Writeln('key       ',CheckKey,'     ');
      Writeln('1st check ',Key2SubKey1(CheckKey):13,RkpL01D0:13);
      Writeln('2nd check ',Key2SubKey2(CheckKey):13,RkpL01D4:13);
      Writeln('3rd check ',Key2SubKey3(CheckKey):13,RkpL01D8:13);
      Writeln('RkpRights ',RkpRights);
      DumpStatus;
    {$endif debug}
    { TpuFails := True;
      OwnerCode := '';
      ProgramCode := ''; }
    end;
  end;


  {$ifdef debug}
  procedure dumpstatus;
  begin

    with Rkp do begin
      Writeln('SysopName:  ', Name1);
      Writeln('SystemName: ', Name2);
      Writeln('Dummy:      ', Name3);
      Writeln('Key:        ', Key);
      Write  ('Status:     ', Byte(Status),' ');
      Case Status of
        NOTREGISTERED:     Writeln('(Not registered)');
        REGISTERED:        Writeln('(Registered)');
        EXPIREDKEY:        Writeln('(Expired key)');
        INVALIDKEY:        Writeln('(Invalid key)');
        FILEERROR:         Writeln('(File error)');
        NULLOWNERCODE:     Writeln('(Null owner)');
        NULLPROGRAMCODE:   Writeln('(Null program)');
        INVALIDFILE:       Writeln('(Invalid file)');
        BADTPU:            Writeln('(Bad TPU)');
        else               Writeln('(unknown)');
      end;
      Writeln('KeyPath:    ', KeyPath);
      Writeln('Id:         ', Id);
      Writeln('Message:    ', Message);
      Writeln('Level:      ', Level);
      Writeln('ExpYear:    ', ExpYear);
      Writeln('ExpMonth:   ', ExpMonth);
      Writeln;
      Writeln('OwnerCode:  ', OwnerCode);
      Writeln('ProgramCode:', ProgramCode);
      Writeln('KeyFile:    ', KeyFile);
      Writeln('KeyFileSize:', KeyFileSize);
    end;
  end;
  {$endif debug}


begin
  RkpInit;
{$ifdef develop}
  if Rkp.Status <> NOTREGISTERED then begin
    Writeln (RkpRkPlus);
    Writeln (RkPlusVer_);
    Writeln (RkpCopyR);
    Writeln (RkpRights);
    Writeln (RkpL01D0);
    Writeln (RkpL01D4);
    Writeln (RkpL01D8);
    Writeln (TpuFails);
    CodeL2S(0);
    CodeS2L('');
    Mask4chars(0);
    PackYearMonth(0,0);
    FuncExpYear(0);
    FuncExpMonth(0);
    PackSubKey3(0,0);
    PackSubKey2(0,0);
    PackSubKey1(0,0);
    SubKeys2PackedYearMonth(0,0,0);
    TrimLeadSp1('');
    TrimLeadSp2('');
    TrimLeadSp3('');
    StrUpCase('');
    MakeSubKey1(0);
    MakeSubKey2('', '', '', 0, 0);
    MakeSubKey3('', '', '', 0, 0);
    Pack3SubKeys(0,0,0);
    MakeKey('', '', '', 0,0,0);
    Key2SubKey1('');
    Key2SubKey2('');
    Key2SubKey3('');
    ValidKey('','','',0,'');
    VerifyKey;
  end;
{$endif develop}
end.
