{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Setup Program
 *
 * vbc - 200208 - Added Build to version no.
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Program FmSetup;

(* {$M 35000,60000,250000} *)

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File, Fm_List,
     Fm_Hex, Fm_Div, Fm_Init, Fm_Exec,
     Fm_1, Fm_2, Fm_3, Fm_5, Fm_6, Fm_7, Fm_8, Fm_9,
     Overlay;

{$O fm_init}
{$O fm_5}
{$O fm_6}
{$O fm_7}
{$O fm_8}
{$O fm_9}

Var
  OldTextAttr : byte;
  OldExitProc : pointer;


{$I FMSETUP.4}


Procedure Screen;
Begin
  Clrscr;
  Fillscreen(1,1,80,23,7,0,chr(177));
  MkWin(1,1,80,4,1,7,4);
  WriteAt(1,24,1,0,replicate(80,'-'));
  WriteAt(3,2,1,7,'FILEMGR v'+verstr(versionnr)+Build+' '+compiled+' ');
  WriteAt(3,3,1,7,copyright+'. All Rights Reserved.');
  OldTextAttr := TextAttr;
  TextAttr := 3;
  Cursor_Off;
End;


{$F+} Procedure MainHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'System parameters.');
    2 : Writeat(1,25,7,0,'Define groups of file area''s.');
    3 : Writeat(1,25,7,0,'File area information.');
    4 : Writeat(1,25,7,0,'Node setup.');
    5 : Writeat(1,25,7,0,'Define files with special treatment.');
    6 : Writeat(1,25,7,0,'Define daily, weekly and monthly events.');
    7 : Writeat(1,25,7,0,'Configure the FileFind system.');
    8 : Writeat(1,25,7,0,'Announcement messages.');
    9 : Writeat(1,25,7,0,'Export miscellaneous configuration data to text file.');
    10: Writeat(1,25,7,0,'Exit to Dos.');
  End;
End;


Procedure MainLoop;
Var
  Ar  : Array[1..10] of String[15];
  Ge  : Integer;
  Tmp : String;
Begin
  move(setup,setupbak,sizeof(setup));

  readnodeindex;
  readmessages;
  readareaindex;
  readgroups;

  with mwin[1] do
    begin
      x1 := 32;
      x2 := 7;
      y1 := 50;
      y2 := 20;
      st := '';
    end;
  create_window(1);

  ar[1]  := 'System data';
  ar[2]  := 'Group manager';
  ar[3]  := 'Area manager';
  ar[4]  := 'Node manager';
  ar[5]  := 'Exceptions';
  ar[6]  := 'Scheduler';
  ar[7]  := 'FileFinder';
  ar[8]  := 'Message manager';
  ar[9]  := 'Export';
  ar[10] := 'Exit to DOS';

  ge := 1;
  while (ge <> 0) and (ge <> 10) do
    begin
      choosehook := mainhelp;
      decwin(1);
      ge := select_window(1,10,15,@ar,ge,false);
      incwin(1);
      case ge of
        1 : SystemLoop;
        2 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              GroupLoop;
        3 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              AreaLoop;
        4 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              NodeLoop;
        5 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              ExceptionLoop;
        6 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              SchedulerLoop;
        7 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              FileFindLoop;
        8 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              MessageLoop;
        9 : if setup.address[1].zone = 0 then askwindow('','No node address defined','',[#13,#27,#32]) else
              ExportLoop;
      end;
    end;

  If not Samerec(setup,setupbak,sizeof(setup)) then
    Begin
      If Askwindow('','Save changes? (Y/N)','',['y','Y','n','N']) in ['Y','y'] then
        Begin
          Reset(SF);
          Write (SF, SETUP);
          Close(SF);
        End;
    End;

  writeareaindex;
  writenodeindex;

  if setup.semamode <> 0 then
    begin
      if setupbak.semaphorepath <> '' then
        tmp := setup.semaphorepath else tmp := systempath;
      delete_file(tmp+'FMBUSY.NOW');
    end;

  Remove_window(1);
End;


Procedure EndScreen;
Var
  X : Integer;
Begin
  Textattr := oldtextattr;
  Window(1,5,80,25);
  Clrscr;
  Window(1,1,80,25);
  For X := 1 to 5 do Writeln;
  Cursor_on;
End;


{$F+} Procedure ExitProgram; {$F-}
Begin
  ExitProc := OldExitProc;
  If (ExitCode > 0) and (ErrorAddr <> NIL) then
    Begin
      AskWindow('Oops','Error ['+int_to_str(ExitCode)+'] at ['+
        StrHex(Seg(ErrorAddr^),4)+':'+StrHex(Ofs(ErrorAddr^),4)+']',
        'Inform author',[#27,#32,#13]);
      ErrorAddr := NIL;
      ExitProc  := NIL;
    End;
  EndScreen;
End;


Procedure HelpScreen;
Begin
  Writeln(' Usage:');
  Writeln('');
  Writeln('   FMSETUP [command] [switch]');
  Writeln('');
  Writeln(' Commands:');
  Writeln('');
  Writeln('   Index    Create new database index files');
  Writeln('   Pack     Pack database files');
  Writeln('');
  Writeln(' Switches:');
  Writeln('');
  Writeln('   Mono     Force monochrome mode');
  Writeln('   Color    Force color mode');
  Writeln('');
End;

{---------------------------------------}


BEGIN
  OvrInit('FMSETUP.EXE');
  If OvrResult <> OvrOk then
    Begin
      OvrInit('FMSETUP.OVR');
      If OvrResult <> OvrOk then
        Begin
          Writeln(#7+'Cannot open FMSETUP overlay file');
          Halt;
        End;
    End;

  OvrInitEms;
  If OvrResult <> OvrOk then {};


  If paramcount <> 0 then
    Begin
      TextAttr := 7;
      Writeln('');
      TextAttr := 14;
      Writeln('FILEMGR Setup v'+verstr(versionnr)+Build+' '+compiled+' EchoFile Processor.');
      TextAttr := 11;
      Writeln(copyright+'. All Rights Reserved.');
      TextAttr := 7;
      Writeln('');

      FindSystempath;

      If (paramstr(1) = '?')   or  (paramstr(1) = '/?') or
         (paramstr(1) = '-?')  or  (upper(paramstr(1)) = 'HELP') then
        Begin
          HelpScreen;
          Halt;
        End Else
        Begin
          If pos('MONO',upper(paramstr(1))) <> 0 then
            Begin
              mono := true;
              kl1 := 0; kl2 := 3; kl3 := 3; kl4 := 0; kl5 := 7;
            End Else
          If pos('COLOR',upper(paramstr(1))) <> 0 then
            Begin
              kl1 := 8;
              kl2 := 0;
              kl3 := 1;
              kl4 := 1;
              kl5 := 7;
            End Else
          If upper(paramstr(1)) = 'INDEX' then
            Begin
              ReIndex;
              Halt;
            End Else
         If (upper(paramstr(1)) = 'PACK') or (upper(paramstr(1)) = 'PURGE') then
            Begin
              Purge;
              Halt;
            End Else
            Begin
              Writeln(#7+'- Invalid parameter '+upper(paramstr(1))+#10#13);
              HelpScreen;
              Halt;
            End;
        End;
    End;

  Setprompt('Type ''EXIT'' to return to FMSETUP.$_$p$g');
  Ctrlihook := Infoscreen;
  Ctrlzhook := Dosshell;
  OldExitProc := ExitProc;
  ExitProc := @ExitProgram;

  Screen;
  FindSystempath;

  If ReadSetup(true) then
    Begin
      Writeat(79-length(node2str(setup.address[1])),2,1,7,node2str(setup.address[1]));
      MainLoop;
    End;
  EndScreen;
END.
