{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Setup Export (Reports) used with fm_9.inc
 *
 * vbc - 12/03/08 - add site report = all reports except member
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_9;

{$O+}

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div;

Procedure ExportLoop;

Implementation


{$I FM_9.INC}


Function AskNodeNumber( VAR nodenu:nodetype ) : Boolean;
Var Bol : Boolean;
    Tmp : String;
Begin
  with mwin[3] do
    begin
      x1 := 25;
      x2 := 11;
      y1 := 52;
      y2 := 15;
      st := ' Node ';
    end;
  create_window(3);
  writeat(1,25,7,0,expand('Enter the address of the node',79));
  tmp := node2str(nodenu);
  read_string(27,13,23,23,tmp,c_all);
  str2node(tmp,nodenu,setup.address[1],bol);
  if not bol then
    begin
      askwindow('','Invalid node number entered','',[#13,#27,#32]);
      asknodenumber := false;
    end else
      asknodenumber := true;
  if samerec(nodenu,setup.address[1],sizeof(nodenu)) then
    asknodenumber := false;
  if (nodenu.zone = 0) and (nodenu.net = 0) and
     (nodenu.node = 0) and (nodenu.point = 0) then
    asknodenumber := false;

  remove_window(3);
End;


Function AskFileName : String;
Var
  Tmp : String;
Begin
  with mwin[3] do
    begin
      x1 := 6;
      x2 := 12;
      y1 := 75;
      y2 := 16;
      st := ' Filename ';
    end;
  create_window(3);
  Writeat(1,25,7,0,expand('Enter the filename of the report',79));
  tmp := systempath+'REPORT.TXT';
  read_string(8,14,66,100,tmp,c_all);

  if exist(tmp) then
    begin
      if askwindow('','File already exist, overwrite (Y/N) ?','',['y','Y','n','N',#27])
        in ['n','N',#27] then tmp := '';
    end;

  remove_window(3);
  AskFileName := Tmp;
End;


{$F+} Procedure FlowListHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Complete areas list with flow status.');
    2 : Writeat(1,25,7,0,'Complete groups list with flow status.');
    3 : Writeat(1,25,7,0,'Complete nodes list with flow status.');
  End;
End;


Function FlowList : Integer;
Var
  Ar       : Array[1..3] of String[16];
  Ge       : Integer;
Begin
  with mwin[3] do
    begin
      x1 := 27;
      x2 := 11;
      y1 := 46;
      y2 := 17;
      st := ' Flow ';
    end;
  create_window(3);

  ar[1] := 'Areas flow list';
  ar[2] := 'Groups flow list';
  ar[3] := 'Nodes flow list';

  ge := 1;
  decwin(3);
  choosehook := flowlisthelp;
  ge := select_window(3,3,16,@ar,ge,false);
  incwin(3);

  remove_window(3);
  flowlist := ge;
End;


{$F+} Procedure FullListHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Complete list with detailed info.');
    2 : Writeat(1,25,7,0,'Small and compact tag list.');
  End;
End;


Function Full_List : Integer;
Var
  Ar       : Array[1..2] of String[18];
  Ge       : Integer;
Begin
  with mwin[3] do
    begin
      x1 := 28;
      x2 := 11;
      y1 := 49;
      y2 := 16;
      st := ' List ';
    end;
  create_window(3);

  ar[1] := 'Full detailed list';
  ar[2] := 'Compact tag list';

  ge := 1;
  decwin(3);
  choosehook := fulllisthelp;
  ge := select_window(3,2,18,@ar,ge,false);
  incwin(3);

  remove_window(3);
  full_list := ge;
End;


{$F+} Procedure ExportHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Information about nodes.');
    2 : Writeat(1,25,7,0,'Information about groups.');
    3 : Writeat(1,25,7,0,'Information about areas.');
    4 : Writeat(1,25,7,0,'Information about groups and linked areas.');
    5 : Writeat(1,25,7,0,'Information about groups and linked nodes.');
    6 : Writeat(1,25,7,0,'Information about areas and linked nodes.');
    7 : Writeat(1,25,7,0,'Information about a single node and connected areas.');
    8 : Writeat(1,25,7,0,'Information about flow.');
    9 : Writeat(1,25,7,0,'Create a mailer request directory list.');
   10 : Writeat(1,25,7,0,'Full site report.');
  End;
End;

{ -----------  Full site Report ----------- }
Procedure ExportLoop2;    { vbc 120308 }
Var
  full     : Integer;
  Filename : String;
  X        : Word;
  Bol      : Booleanset;

Begin
  full := 1;  { or 2 }
  RFile_Open := False;
  I_File := True;        { open report file and leave open  }
  Filename := systempath+'site.txt';
  Nodes_List(filename,full=1);
  Groups_List(filename,full=1);
  Areas_List(filename,full=1);
  For X := 1 to 255 do Bol[x] := true;
  G_AndAreas_List(filename,bol);
  G_AndNodes_List(filename,bol);
  A_AndNodes_List(filename,bol);
  for full := 1 to 3 do
     flow_List(filename,full);
  request_list(filename,bol);
  RFile_Open := False;
  I_File := False;
End;
                           { vbc 120308  }

Procedure ExportLoop;
Var
  Ar       : Array[1..10] of String[14];
  Ge       : Integer;
  full     : Integer;
  Filename : String;
  Nop      : NodeType;
  X        : Word;
  Bol      : Booleanset;
Begin
  with mwin[2] do
    begin
      x1 := 30;        { start from left }
      x2 := 8;         { start from top  }
      y1 := 47;        { lsdt pos from left }
      y2 := 21;        { 20 -> 21 } { last line from top }
      st := ' Export ';
    end;
  create_window(2);
  I_File := False;      { Not Separate report file  }
  RFile_Open := False;  { Report file not open  }

  ar[1] := 'Nodes';
  ar[2] := 'Groups';
  ar[3] := 'Areas';
  ar[4] := 'Groups & Areas';
  ar[5] := 'Groups & Nodes';
  ar[6] := 'Areas & Nodes';
  ar[7] := 'Member';
  ar[8] := 'Flow';
  ar[9] := 'Mailer request';
  ar[10] := 'Full site rpt';

  ge := 1;
  while ge <> 0 do
    begin
      choosehook := exporthelp;
      decwin(2);
      ge := select_window(2,10,14,@ar,ge,false);  {vbc 110308 }
      incwin(2);
      case ge of
        1 : Begin
              Full := Full_List;
              If full <> 0 then Filename := AskFileName;
              If fileName <> '' then
                If full <> 0 then
                  If not Nodes_List(filename,full=1) then
                    AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        2 : Begin
              Full := Full_List;
              If full <> 0 then Filename := AskFileName;
              If filename <> '' then
                If full <> 0 then
                  If not Groups_List(filename,full=1) then
                    AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        3 : Begin
              Full := Full_List;
              If full <> 0 then Filename := AskFileName;
              If filename <> '' then
                If full <> 0 then
                  If not Areas_List(filename,full=1) then
                    AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        4 : Begin
              For X := 1 to 255 do Bol[x] := true;
              Writeat(1,25,7,0,expand('Select groups to include in this report',79));
              Select_Groups(3,bol,false);

              Filename := AskFileName;
              If filename <> '' then
                If not G_AndAreas_List(filename,bol) then
                  AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        5 : Begin
              For X := 1 to 255 do Bol[x] := true;
              Writeat(1,25,7,0,expand('Select groups to include in this report',79));
              Select_Groups(3,bol,false);

              Filename := AskFileName;
              If filename <> '' then
                If not G_AndNodes_List(filename,bol) then
                  AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        6 : Begin
              For X := 1 to 255 do Bol[x] := true;
              Writeat(1,25,7,0,expand('Select groups to include in this report',79));
              Select_Groups(3,bol,false);

              Filename := Askfilename;

              If filename <> '' then
                If not A_AndNodes_List(filename,bol) then
                  AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        7 : Begin
              Fillchar(nop,sizeof(nop),#0);
              If asknodenumber(nop) then
                Begin
                  Filename := AskFileName;
                  If filename <> '' then
                    If not Member_List(filename,nop) then
                      AskWindow('','Cannot create requested list','',[#13,#27,#32]);
                End;
            End;
        8 : Begin
              Full := Flowlist;
              If full <> 0 then Filename := AskFileName;
              If fileName <> '' then
                If full <> 0 then
                  If not flow_List(filename,full) then
                    AskWindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
        9 : Begin
              For X := 1 to 255 do Bol[x] := true;
              Writeat(1,25,7,0,expand('Select groups to include in this list',79));
              Select_Groups(3,bol,false);
              Filename := AskFileName;
              If filename <> '' then
                If not request_list(filename,bol) then
                  askwindow('','Cannot create requested list','',[#13,#27,#32]);
            End;
       10 : Begin                  { vbc 120308 - site rep  }
              ExportLoop2;
            End;
      end;
    end;
  remove_window(2);
End;

END.
