{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: setup Messages
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_8;

{$O+}

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec;

Procedure MessageLoop;


Implementation


Procedure MessageHelp ( Welke : Byte );
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
   1 : writeat(1,25,7,0,'The identification number of this message');
   2 : writeat(1,25,7,0,'The frequency of posting');
   3 : writeat(1,25,7,0,'The order in which the entries should be sorted');
   4 : writeat(1,25,7,0,'The default header tpl for this message');
   5 : writeat(1,25,7,0,'The default footer tpl for this message');
   6 : writeat(1,25,7,0,'The default entry tpl for this message');
   7 : writeat(1,25,7,0,'The default blockheader for this message');
   8 : writeat(1,25,7,0,'The default blockfooter for this message');
   9 : writeat(1,25,7,0,'The message base type and status for this message');
  10 : writeat(1,25,7,0,'The path to the message base');
  11 : writeat(1,25,7,0,'The maximum size of a message (in Kb)');
  12 : writeat(1,25,7,0,'The to address to use in this message');
  13 : Writeat(1,25,7,0,'The from address to use in this message');
  14 : writeat(1,25,7,0,'The subject to use in this message');
  15 : writeat(1,25,7,0,'The attributes to use in this message');
  16 : writeat(1,25,7,0,'The tearline or pid to use in this message');
  17 : writeat(1,25,7,0,'The origin line to use in this message');
  End;
  If setup.exteditor <> '' then
    begin
      if (welke > 3) and (welke < 9) then
        writeat(64,25,14,0,'Press F2 to edit');
    end;
End;


Procedure DisplayMessage(ge:integer);
Var
  Tmp : String;
Const
  SortStr : Array[Snone..SGroup] of String[5] = ('None ','File ','Area ','Group');
Begin
  Writeat(17,3,foreentry,backentry,expand( int_to_str(ge)+' - '+message.messagename ,50));
  writeat(17,4,foreentry,backentry,expand(Writefrequency(message.freq,message.day),40)); {frequency}
  if message.freq <> imm then
    Writeat(60,3,14,backentry,'Next: '+NextFrequency(message.next)) else
      Writeat(60,3,14,backentry,expand(' ',19));

  Writeat(17,6 ,foreentry,backentry,sortstr[message.sortorder]);
  Writeat(17,7 ,foreentry,backentry,expand(message.headertpl,12));
  Writeat(17,8 ,foreentry,backentry,expand(message.footertpl,12));
  Writeat(17,9 ,foreentry,backentry,expand(message.entrytpl,12));
  if (message.sortorder <> sfile) and (message.sortorder <> snone) then
    begin
      Writeat(17,10,foreentry,backentry,expand(message.blockhdrtpl,12));
      Writeat(17,11,foreentry,backentry,expand(message.blockftrtpl,12));
    end else
    begin
      Writeat(17,10,foreentry,backentry,expand(' ',12));
      Writeat(17,11,foreentry,backentry,expand(' ',12));
    end;

  If Net in message.status then
    tmp := ', Netmail' else
      tmp := ', Echomail';

  If message.msgbaseid <> #0 then
    Begin
      Case message.msgbaseid of
        'S' : begin
                Writeat(17,13,foreentry,backentry,expand('Squish'+tmp,20));
                Writeat(17,14,foreentry,backentry,expand(message.msgbaseidstr,49));
              end;
        'H' : begin
                Writeat(17,13,foreentry,backentry,expand('Hudson'+tmp,20));
                Writeat(17,14,foreentry,backentry,expand(int_to_str(str_to_int(first(3,message.msgbaseidstr))),4));
                Writeat(40,14,foreentry,backentry,expand(last(length(message.msgbaseidstr)-3,message.msgbaseidstr),39));
              end;
        'F' : begin
                Writeat(17,13,foreentry,backentry,expand('Fido'+tmp,20));
                Writeat(17,14,foreentry,backentry,expand(message.msgbaseidstr,49));
              end;
        'J' : begin
                Writeat(17,13,foreentry,backentry,expand('Jam'+tmp,20));
                Writeat(17,14,foreentry,backentry,expand(message.msgbaseidstr,49));
              end;
        'E' : begin
                Writeat(17,13,foreentry,backentry,expand('Ezycom'+tmp,20));
                Writeat(17,14,foreentry,backentry,expand(int_to_str(str_to_int(first(4,message.msgbaseidstr))),4));
                Writeat(40,14,foreentry,backentry,expand(last(length(message.msgbaseidstr)-4,message.msgbaseidstr),39));
              end;
        'P' : begin
                writeat(17,13,foreentry,backentry,expand('Packet',20));
                writeat(17,14,foreentry,backentry,expand(last(length(message.msgbaseidstr)-15,message.msgbaseidstr),49));
              end;
        'T' : begin
                writeat(17,13,foreentry,backentry,expand('Text',20));
                writeat(17,14,foreentry,backentry,expand(message.msgbaseidstr,49));
              end;
      End;
    End Else
    Begin
      Writeat(17,13,foreentry,backentry,expand(' ',20));
      Writeat(17,14,foreentry,backentry,expand(' ',49));
    End;


  If message.msgbaseid <> 'T' then
    Begin
      Writeat(17,15,foreentry,backentry,expand(int_to_str(message.maxsize),3));

      If message.msgto <> '' then
        Begin
          If (Net in message.status) and (first(1,message.msgto) <> '@') then
            Writeat(17,17,foreentry,backentry,expand(message.msgto+', '+node2str(message.tonode),60))
              else Writeat(17,17,foreentry,backentry,expand(message.msgto,60));
        End Else
          Writeat(17,17,foreentry,backentry,expand(' ',60));

      If message.msgfrom <> '' then
        Begin
          Writeat(17,18,foreentry,backentry,expand(message.msgfrom+', '+node2str(setup.address[message.aka]),60));
        End Else
          Writeat(17,18,foreentry,backentry,expand(' ',60));

      Writeat(17,19,foreentry,backentry,expand(message.msgre,50));

      Writeattribs(17,20,79,message.msgattr,net in message.status); {attribs}

      If tearline in message.status then
        Writeat(17,21,foreentry,backentry,'Tearline') else
          Writeat(17,21,foreentry,backentry,'^APID   ');

      If message.origin <> 0 then
        Writeat(17,22,foreentry,backentry,expand(setup.origline[message.origin],60)) else
          Writeat(17,22,foreentry,backentry,expand('Random',60));
    End Else
    Begin
      Fillscreen(17,15,78,22,7,0,' ');
    End;
End;


Procedure WriteMessage(active:integer);
Begin
  writeat(2,3, 7,0,' ID / Descr.  ');
  writeat(2,4, 7,0,' Frequency    ');

  writeat(2,6, 7,0,' Sort order   ');
  writeat(2,7, 7,0,' Header       ');
  writeat(2,8, 7,0,' Footer       ');
  writeat(2,9, 7,0,' File entry   ');
  if (message.sortorder <> sfile) and (message.sortorder <> snone) then
    begin
      writeat(2,10,7,0,' Block header ');
      writeat(2,11,7,0,' Block footer ');
    end else
    begin
      writeat(2,10,7,0,'              ');
      writeat(2,11,7,0,'              ');
    end;

  Writeat(2,13,7,0,' Messagebase  ');
  Case message.msgbaseid of
   'S' : Writeat(2,14,7,0,' Msgbase Name ');
   'H' : Writeat(2,14,7,0,' Board Number            Msgbase Path ');
   'F' : Writeat(2,14,7,0,' Msgbase Path ');
   'J' : Writeat(2,14,7,0,' Msgbase Name ');
   'E' : Writeat(2,14,7,0,' Board Number            Msgbase Path ');
   'P' : Writeat(2,14,7,0,' Packet Path  ');
   'T' : Writeat(2,14,7,0,' Txtfile Name ');
  End;

  if message.msgbaseid <> 'T' then
    begin
      writeat(2,15,7,0,' Max Msg Size ');

      writeat(2,17,7,0,' To           ');
      writeat(2,18,7,0,' From         ');
      writeat(2,19,7,0,' Subject      ');
      writeat(2,20,7,0,' Attributes   ');
      writeat(2,21,7,0,' Program ID   ');
      Writeat(2,22,7,0,' Originline   ');
    end else
    begin
      fillscreen(2,15,16,22,7,0,' ');
    end;

  case active of
   1 : writeat(2,3,kl4,kl5,' ID / Descr.  ');
   2 : writeat(2,4,kl4,kl5,' Frequency    ');
   3 : writeat(2,6,kl4,kl5,' Sort order   ');
   4 : writeat(2,7,kl4,kl5,' Header       ');
   5 : writeat(2,8,kl4,kl5,' Footer       ');
   6 : writeat(2,9,kl4,kl5,' File entry   ');
   7 : writeat(2,10,kl4,kl5,' Block header ');
   8 : writeat(2,11,kl4,kl5,' Block footer ');
   9 : writeat(2,13,kl4,kl5,' Messagebase  ');
  10 : begin
         Case message.msgbaseid of
           'S' : Writeat(2,14,kl4,kl5,' Msgbase Name ');
           'H' : Writeat(2,14,kl4,kl5,' Board Number ');
           'F' : Writeat(2,14,kl4,kl5,' Msgbase Path ');
           'J' : Writeat(2,14,kl4,kl5,' Msgbase Name ');
           'E' : Writeat(2,14,kl4,kl5,' Board Number ');
           'P' : Writeat(2,14,kl4,kl5,' Packet Path  ');
           'T' : Writeat(2,14,kl4,kl5,' Txtfile Name ');
         End;
       end;
  11 : writeat(2,15,kl4,kl5,' Max Msg Size ');
  12 : writeat(2,17,kl4,kl5,' To           ');
  13 : writeat(2,18,kl4,kl5,' From         ');
  14 : writeat(2,19,kl4,kl5,' Subject      ');
  15 : writeat(2,20,kl4,kl5,' Attributes   ');
  16 : writeat(2,21,kl4,kl5,' Program ID   ');
  17 : Writeat(2,22,kl4,kl5,' Originline   ');
  End;
End;

procedure editexec(r:byte);
var res : word;
begin
  cursor_on;
  savescreen;
  case r of
    4 : res := fmExec(setup.exteditor,setup.tplpath+message.headertpl, setup.SwapMethode, $ffff, false, false);
    5 : res := fmExec(setup.exteditor,setup.tplpath+message.footertpl, setup.SwapMethode, $ffff, false, false);
    6 : res := fmExec(setup.exteditor,setup.tplpath+message.entrytpl, setup.SwapMethode, $ffff, false, false);
    7 : res := fmExec(setup.exteditor,setup.tplpath+message.blockhdrtpl, setup.SwapMethode, $ffff, false, false);
    8 : res := fmExec(setup.exteditor,setup.tplpath+message.blockftrtpl, setup.SwapMethode, $ffff, false, false);
  end;
  restorescreen;
  cursor_off;
end;


Procedure EditMessage(var rec:integer);
Var
  ge, x : integer;
  ch, bak  : char;
  areatag,
  tmp,
  tmp1  : string;
  msg   : messagetype;
  bol   : booleanset;
  bb    : boolean;
Begin
  for ge := 1 to 256 do bol[x] := false;
  bol[rec] := true;
  ge := 1;
  move(message,msg,sizeof(message));

  Repeat
    messagehelp(ge);
    writemessage(ge);
    displaymessage(rec);
    ch := readkey;
    case ch of
     #0 : begin
            ch := readkey;
            case ch of
              #72 : {up} if ge > 1 then dec(ge) else ge := 17;
              #80 : {down} if ge < 17 then inc(ge) else ge := 1;
              #67 : {f9}   begin ch := #27; move(msg,message,sizeof(message)); end;
              #68 : {f10}  ch := #27;
              #60 : {f2}  editexec(ge);
            end;
            if (message.sortorder = sfile) or (message.sortorder = snone) then
              begin
                if ge = 7 then if ch = #72 then dec(ge) else ge := 9;
                if ge = 8 then if ch = #80 then inc(ge) else ge := 6;
              end;
            if message.msgbaseid = 'T' then
              begin
                if ge = 17 then if ch = #72 then ge := 10;
                if ge = 11 then if ch = #80 then ge := 1;
              end;
          end;
     #9 : infoscreen;
     #26: dosshell;
     #13: begin
            case ge of
             1 : begin
{                   if samerec(message,msg,sizeof(message)) then
                     begin
                       select_messages(3,bol,true);
                       rec := 0;
                       repeat
                         inc(rec);
                       until (rec > 255) or bol[rec];
                       if mfx[rec].messagenr <> 0 then
                         begin
                           seek(mf,mfx[rec].messagenr-1);
                           read(mf,message);
                         end else
                         begin
                           fillchar(message,sizeof(message),#0);
                           message.messagenr := rec;
                           message.headertpl   := 'HEADER.TPL';
                           message.footertpl   := 'FOOTER.TPL';
                           message.entrytpl    := 'ENTRY.TPL';
                           message.blockhdrtpl := 'BLOCKHDR.TPL';
                           message.blockftrtpl := 'BLOCKFTR.TPL';
                           message.Origin   := 1;
                           message.AKA      := 1;
                           message.Status   := [TearLine] + [Echo];
                           message.MsgBaseId := 'F';
                           message.MsgTo    := 'All';
                           message.MsgFrom  := SETUP.SysopName;
                           message.MsgRe    := 'New files at ' + SETUP.SystemName;
                           message.maxsize  := 16;
                         end;
                       move(message,msg,sizeof(message));
                       displaymessage(rec);
                     end; }
                   Tmp := message.messagename;
                   read_string(20+length(int_to_str(rec)),3,50,50,tmp,c_all);
                   message.messagename := tmp;
                   mfx[rec].messagename := tmp;
                 end;
             2 : begin
                   select_frequency(3,true,message.freq,message.day,message.next);
                   message.next := nextdate(0,message.freq,message.day);
                 end;
             3 : begin
                   if message.sortorder = sgroup then message.sortorder := snone else
                     inc(message.sortorder);
                 end;
             4 : message.headertpl   := select_tpl(3,message.headertpl,true);
             5 : message.footertpl   := select_tpl(3,message.footertpl,true);
             6 : message.entrytpl    := select_tpl(3,message.entrytpl,true);
             7 : message.blockhdrtpl := select_tpl(3,message.blockhdrtpl,true);
             8 : message.blockftrtpl := select_tpl(3,message.blockftrtpl,true);
             9 : begin
                   If message.msgbaseid = 'P' then
                     begin
                       areatag := first(15,message.msgbaseidstr);
                       message.msgbaseidstr := last(length(message.msgbaseidstr)-15,message.msgbaseidstr);
                     end;

                   bak := message.msgbaseid;
                   tmp := message.msgbaseidstr;
                   select_messagebase(3,message.msgbaseid,message.status,tmp,areatag,true);
                   message.msgbaseidstr := tmp;
                   if bak <> message.msgbaseid then message.msgbaseidstr := '';

                   If message.msgbaseid = 'P' then
                     begin
                       if echo in message.status then
                       message.msgbaseidstr := expand(areatag,15) + message.msgbaseidstr else
                         message.msgbaseidstr := expand(' ',15) + message.msgbaseidstr;
                     end;

                 end;
            10 : begin
                   case message.msgbaseid of
                    'S' : Begin
                            Tmp := message.msgbaseidstr;
                            read_string(17,14,49,49,tmp,c_all);
                            message.msgbaseidstr := tmp;
                          End;
                    'H' : Begin
                            Tmp := first(3,message.msgbaseidstr);
                            read_String(17,14,3,3,tmp,c_numbers);
                            Tmp1 := last(length(message.msgbaseidstr)-3,message.msgbaseidstr);
                            read_string(40,14,39,39,tmp1,c_all);
                            checkpath(tmp1);
                            while length(tmp) < 3 do tmp := '0' + tmp;
                            message.msgbaseidstr := tmp + tmp1;
                          End;
                    'F' : Begin
                            Tmp := message.msgbaseidstr;
                            read_string(17,14,49,49,tmp,c_all);
                            checkpath(tmp);
                            message.msgbaseidstr := tmp;
                          End;
                    'J' : Begin
                            Tmp := message.msgbaseidstr;
                            read_string(17,14,49,49,tmp,c_all);
                            message.msgbaseidstr := tmp;
                          End;
                    'E' : Begin
                            Tmp := first(4,message.msgbaseidstr);
                            read_String(17,14,4,4,tmp,c_numbers);
                            Tmp1 := last(length(message.msgbaseidstr)-4,message.msgbaseidstr);
                            read_string(40,14,39,39,tmp1,c_all);
                            checkpath(tmp1);
                            while length(tmp) < 4 do tmp := '0' + tmp;
                            message.msgbaseidstr := tmp + tmp1;
                          End;
                    'P' : Begin
                            Tmp := last(length(message.msgbaseidstr)-15,message.msgbaseidstr);
                            read_string(17,14,49,49,tmp,c_all);
                            message.msgbaseidstr := first(15,message.msgbaseidstr) + tmp;
                          End;
                    'T' : Begin
                            Tmp := message.msgbaseidstr;
                            read_string(17,14,49,49,tmp,c_all);
                            tmp1 := tmp;
                            tmp := file_split(1,tmp);
                            checkpath(tmp);
                            message.msgbaseidstr := tmp1;
                          End;
                   end;
                 end;
            11 : begin
                   tmp := int_to_str(message.maxsize);
                   read_string(17,15,5,3,tmp,c_all);
                   message.maxsize := str_to_int(tmp);
                   if message.maxsize > 16 then message.maxsize := 16;
                 end;
            12 : begin
                   tmp := message.msgto;
                   read_String(17,17,50,35,tmp,c_all);
                   message.msgto := tmp;
                   if first(1,tmp) = '@' then
                     begin
                       if not exist(last(length(tmp)-1,tmp)) then
                         askwindow('Cannot find',last(length(tmp)-1,tmp),'file!',[#13,#27,#32]);
                     end else
                   if net in message.status then
                     begin
                       writeat(17,17,foreentry,backentry,tmp+',');
                       tmp := node2str(message.tonode);
                       read_string(19+length(message.msgto),17,18,23,tmp,c_all);
                       str2node(tmp,message.tonode,setup.address[1],bb);
                       if not bb then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                     end;
                 end;
            13 : begin
                   tmp := message.msgfrom;
                   read_string(17,18,50,35,tmp,c_all);
                   message.msgfrom := tmp;
                   writeat(17,18,foreentry,backentry,tmp+',');
                   message.aka := select_address(3,message.aka,false);
                 end;
            14 : begin
                   tmp := message.msgre;
                   read_string(17,19,50,50,tmp,c_all);
                   message.msgre := tmp;
                 end;
            15 : Select_Attribs(3,message.msgattr,net in message.status);
            16 : Begin
                   if tearline in message.status then
                     message.status := message.status - [tearline] else
                       message.status := message.status + [tearline];
                 end;
            17 : message.origin := select_origin(3,message.origin);
            end;
          end;
    end;
  Until ch = #27;

  If not Samerec(message,msg,sizeof(message)) then
    Begin
      If Askwindow('','Save changes? (Y/N)','',['y','Y','n','N']) in ['Y','y'] then
        Begin
          If mfx[rec].messagenr = 0 then mfx[rec].messagenr := filesize(mf)+1;
          if filesize(mf) > 0 then Seek(mf,mfx[rec].messagenr-1);
          Write(mf, message);
        End;
    End;
End;


Procedure MessageLoop;
Var
  Tel,
  Ge, x : Integer;
  Count : Word;
  Ch    : Char;
  Tmp   : String;
  Grp   : Grouptype;
  Found : Boolean;
  Bol   : BooleanSet;
Begin
  for x := 1 to 256 do bol[x] := false;

  assign(mf,systempath+'messages.fm');
  {$I-} reset(mf); {$I+}
  If ioresult <> 0 then
    begin
      askwindow('','Cannot open '+systempath+'MESSAGES.FM','',[#13,#27,#32]);
      exit;
    end;

  with mwin[2] do
    begin
      x1 := 1;
      x2 := 1;
      y1 := 80;
      y2 := 24;
      st := ' Message Manager ';
    end;
  create_window(2);

  ge := 1;
  ch := #0;

  repeat
    if filesize(mf) < 1 then
      begin
        writecolor(25,7,15,0,'^INS^-new ^ESC^-exit');
        writeat(2,1,11,0,replicate(14,''));
        writemessage(0);
      end else
      begin
        WriteColor(25,7,15,0,'^F4^-search ^F5^-browse ^INS^-new ^DEL^-delete ^ENTER^-edit ^ESC^-exit');
        writeat(2,1,11,0,' '+int_to_str(ge)+' of 255 ');

        if mfx[ge].messagenr <> 0 then
          begin
            seek(mf,mfx[ge].messagenr-1);
            read(mf,message);
          end else
          begin
            fillchar(message,sizeof(message),#0);
            message.aka := 1;
          end;

        writemessage(0);
        displaymessage(ge);
      end;

    ch := readkey;

    if ch = #13 then
      begin
        If mfx[ge].messagenr = 0 then
          begin
            message.messagenr := ge;
            message.headertpl   := 'HEADER.TPL';
            message.footertpl   := 'FOOTER.TPL';
            message.entrytpl    := 'ENTRY.TPL';
            message.blockhdrtpl := 'BLOCKHDR.TPL';
            message.blockftrtpl := 'BLOCKFTR.TPL';
            message.Origin   := 1;
            message.AKA      := 1;
            message.Status   := [TearLine] + [Echo];
            message.MsgBaseId := 'F';
            message.MsgTo    := 'All';
            message.MsgFrom  := SETUP.SysopName;
            message.MsgRe    := 'New files at ' + SETUP.SystemName;
            message.maxsize  := 16;
          end;
        editmessage(ge);
      end;
    if ch = #9 then infoscreen;
    if ch = #26 then dosshell;

    case ch of
      #0 : Begin
             Ch := readkey;
             If ch = #82 then {ins}
               Begin
                 for x := 1 to 256 do bol[x] := false;

                 Ge := 1;                    {zoeken naar eerste lege record}
                 While (ge < 256) and (mfx[ge].messagenr <> 0) do inc(ge);

                 If ge = 256 then
                   Begin
                     Askwindow('','All 255 messages entries are full!','',[#27,#32,#13]);
                   End Else
                   Begin
                     bol[ge] := true;

                     Select_Messages(3,bol,true);

                     ge := 0;
                     repeat
                       inc(ge)
                     until (ge > 255) or bol[ge];

                     If ge < 256 then
                       Begin
                         If mfx[ge].messagenr <> 0 then
                           Begin
                             seek(mf,ge-1);
                             read(mf,message);
                           End Else
                           Begin
                             Seek(mf,filesize(mf));
                             fillchar(message,sizeof(message),#0);
                             message.messagenr := ge;
                             message.headertpl   := 'HEADER.TPL';
                             message.footertpl   := 'FOOTER.TPL';
                             message.entrytpl    := 'ENTRY.TPL';
                             message.blockhdrtpl := 'BLOCKHDR.TPL';
                             message.blockftrtpl := 'BLOCKFTR.TPL';
                             message.Origin   := 1;
                             message.AKA      := 1;
                             message.Status   := [TearLine] + [Echo];
                             message.MsgBaseId := 'F';
                             message.MsgTo    := 'All';
                             message.MsgFrom  := SETUP.SysopName;
                             message.MsgRe    := 'New files at ' + SETUP.SystemName;
                             message.maxsize  := 16;
                           End;
                         displaymessage(ge);
                         editmessage(ge);
                       End;
                   End;
               End;

             if filesize(mf) > 0 then
               begin
                 case ch of
                   #83 : Begin {del}
                           if mfx[ge].messagenr <> 0 then
                             Begin
                               If Askwindow('Remove message '+int_to_str(ge),'Are you sure?','(Y/N)',['y','Y','n','N',#13,#27])
                               in ['Y','y'] then
                                 Begin
                                   seek(mf,mfx[ge].messagenr-1);
                                   fillchar(message, sizeof(message), #0);
                                   write(mf,message);
                                   mfx[ge].messagenr := 0;
                                   mfx[ge].messagename := '';

                                   if askwindow('Remove message '+int_to_str(ge),'from all areas also?',
                                   '(Y/N)',['y','Y','N','n',#27,#13]) in ['y','Y'] then
                                     Begin

                                       If MaxAvail < SizeOf(Sfxt^) then
                                         Begin
                                           Askwindow('','Not enough memory left','',[#13,#27,#32]);
                                         End Else
                                         Begin
                                           Tel := 0;
                                           New(Sfxt);
                                           For X := 1 to AreaIdx do
                                             Begin
                                               Writeat(1,25,7,0,expand(area.tag,80));
                                               Seek(af,afxt^[x].arearec);
                                               Blockread(af,area,sizeof(area),count);
                                               If count = sizeof(area) then
                                                 Begin
                                                   If area.msgid[ge] then
                                                     Begin
                                                       area.msgid[ge] := false;
                                                       {verander}
                                                       inc(tel);
                                                       seek(af,afxt^[x].arearec);
                                                       blockwrite(af,area,sizeof(area),count);
                                                       if count <> sizeof(area) then askwindow('',
                                                       'Cannot add to AREAFILE.FM','',[#13,#27,#32]);
                                                     End;
                                                 End;
                                             End;
                                           Dispose(Sfxt);
                                           Askwindow('Message '+int_to_str(ge),'removed from'
                                           ,int_to_str(tel)+' areas', [#13,#27,#32]);
                                         End;
                                     End;
                                 End;
                             End;
                         End;
                   #62 : begin {f4}
                           Writeat(1,25,7,0,replicate(80,' '));
                           Tmp := '';
                           Writeat(1,25,7,0,'Enter search string: ');
                           Read_String(22,25,40,40,tmp,c_all);

                           If Tmp <> '' then
                             Begin
                               Ge := 0;
                               While (pos(upper(tmp),upper(mfx[ge].messagename)) = 0) and (ge < 256) do
                                 Inc(ge);
                               If ge = 256 then
                                 Begin
                                   AskWindow('',tmp+' not found!','',[#13,#27,#32]);
                                   Ge := 1;
                                 End Else
                                   Displaymessage(ge);

                               WriteColor(25,7,15,0,'^F4^-search ^F5^-browse ^INS^-new '+
                                 '^DEL^-delete ^ENTER^-edit ^ESC^-exit');
                             End;
                         End;
                   #63 : begin {f5}
                           for x := 1 to 256 do bol[x] := false;
                           bol[ge] := true;
                           Select_messages(3,bol,true);
                           x := 0;
                           repeat
                             inc(x);
                           until (x > 255) or bol[x];
                           displaymessage(x);
                           ge := x;
                         end;
                   #79 : ge := 255; {end}
                   #71 : ge := 1;   {home}
                   #77 : begin {left}
                           if ge+1 < 256 then
                             begin
                               if ge+1 > filesize(mf) then
                                 inc(ge) else
                                   begin
                                     seek(mf,ge);
                                     read(mf,message);
                                     inc(ge);
                                   end;
                             end else write(#7);
                         end;
                   #75 : begin {right}
                           if ge-1 > 0 then
                             begin
                               if ge-1 > filesize(mf) then
                                 dec(ge) else
                                   begin
                                     seek(mf,ge-2);
                                     read(mf,message);
                                     dec(ge)
                                   end;
                             end else write(#7);
                         end;
                 end; {case}
               end;
           end; { #0 }
    end; {case}

  until ch = #27;

  remove_Window(2);
  close(mf);
End;


END.

