{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Setup Exceptions
 *
 * vbc 090308 - Clean up spelling errors
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_5;

{$O+}

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec, Fm_List;

Procedure ExceptionLoop;


Implementation


Procedure Display_Exception_Amount;
Begin
  if list_amount < 1 then
    begin
      writecolor(25,7,15,0,'^INS^-new ^ESC^-exit');
      writeat(2,1,11,0,replicate(14,''));
    end else
    begin
      WriteColor(25,7,15,0,'^F3^-move ^INS^-new ^DEL^-delete ^ENTER^-edit ^ESC^-exit');
      Writeat(2,1,11,0,' '+int_to_str(list_amount)+' entries ');
    end;
End;

Procedure Display_Exception;
Begin
  Case ex.Kind of
    ex_move      : Writeat(17,15,foreentry,backentry,'Move file   ');
    ex_adopt     : Writeat(17,15,foreentry,backentry,'Adopt file  ');
    ex_noforward : Writeat(17,15,foreentry,backentry,'No forward  ');
    ex_passthru  : Writeat(17,15,foreentry,backentry,'Passthru    ');
    ex_copyfile  : Writeat(17,15,foreentry,backentry,'Copy file   ');
    ex_otherpath : Writeat(17,15,foreentry,backentry,'Other path  ');
    ex_copyarea  : Writeat(17,15,foreentry,backentry,'Copy to area');
    ex_magic     : Writeat(17,15,foreentry,backentry,'Magic name  ');
    ex_exec      : Writeat(17,15,foreentry,backentry,'Exec command');
    ex_delete    : Writeat(17,15,foreentry,backentry,'Delete file ');
    ex_unpack    : Writeat(17,15,foreentry,backentry,'Unpack file ');
    ex_noannounce: Writeat(17,15,foreentry,backentry,'No announce ');
    ex_nodepath  : Writeat(17,15,foreentry,backentry,'Node path   ');
  End;

  writeat(17,16,foreentry,backentry,expand(ex.mask,12));

  Case ex.Kind of
    ex_move      : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.toarea,20));
                     writeat(17,19,foreentry,backentry,expand(node2str(ex.fromnode),25));
                   End;
    ex_adopt     : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.toarea,20));
                     writeat(17,18,foreentry,backentry,expand(node2str(ex.fromnode),25));
                     writeat(17,19,foreentry,backentry,expand(ex.line[1],62));
                   End;
    ex_noforward : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                   End;
    ex_noannounce: Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                   End;
    ex_passthru  : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                   End;
    ex_copyfile  : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.line[1],62));
                   End;
    ex_otherpath : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.line[1],62));
                   End;
    ex_copyarea  : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.toarea,20));
                     writeat(17,19,foreentry,backentry,expand(node2str(ex.fromnode),25));
                   End;
    ex_magic     : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.line[1],20));
                   End;
    ex_exec      : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.line[1],62));
                   End;
    ex_delete    : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                   End;
    ex_unpack    : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(ex.line[1],62));
                   End;
    ex_nodepath  : Begin
                     writeat(17,17,foreentry,backentry,expand(ex.fromarea,20));
                     writeat(17,18,foreentry,backentry,expand(node2str(ex.fromnode),20));
                     writeat(17,19,foreentry,backentry,expand(ex.line[1],62));
                   End;
  End;
End;

Procedure Write_Exception( active:word );
Begin
  Case ex.Kind of
        ex_move  : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' To Area      ');
                     Writeat(2,19,7,0,' From Node    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' To Area      ');
                             Writeat(1,25,7,0,expand('The file area in which the file must be moved',79));
                           End;
                       5 : Begin
                             Writeat(2,19,kl4,kl5,' From Node    ');
                             Writeat(1,25,7,0,expand('The node address FileMgr must use when moving the file',79));
                           End;
                     End;
                   End;
       ex_adopt  : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' To Area      ');
                     Writeat(2,18,7,0,' From Node    ');
                     Writeat(2,19,7,0,' Description  ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' To Area      ');
                             Writeat(1,25,7,0,expand('The file area in which the file must be adopted',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' From Node    ');
                             Writeat(1,25,7,0,expand('The node address FileMgr must use when adopting the file',79));
                           End;
                       5 : Begin
                             Writeat(2,19,kl4,kl5,' Description  ');
                             Writeat(1,25,7,0,expand('The description to use for this file',79));
                           End;
                     End;
                   End;
    ex_noforward : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                     End;
                   End;
    ex_noannounce: Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                     End;
                   End;
    ex_passthru  : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                     End;
                   End;
    ex_copyfile  : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' Directory    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' Directory    ');
                             Writeat(1,25,7,0,expand('The destination directory for the file',79));
                           End;
                     End;
                   End;
    ex_otherpath : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' Directory    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' Directory    ');
                             Writeat(1,25,7,0,expand('The new destination directory for the file',79));
                           End;
                     End;
                   End;
    ex_copyarea  : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' To Area      ');
                     Writeat(2,19,7,0,' From Node    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' To Area      ');
                             Writeat(1,25,7,0,expand('The file area in which the file must be copied',79));
                           End;
                       5 : Begin
                             Writeat(2,19,kl4,kl5,' From Node    ');
                             Writeat(1,25,7,0,expand('The node address FileMgr must use when copying the file',79));
                           End;
                     End;
                   End;
    ex_magic     : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' Magic name   ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' Magic name   ');
                             Writeat(1,25,7,0,expand('The magic name to update',79));
                           End;
                     End;
                   End;
    ex_exec      : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' Exec command ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' Exec command ');
                             Writeat(1,25,7,0,expand('The exec command to perform',79));
                           End;
                     End;
                   End;
    ex_delete    : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                     End;
                   End;
    ex_unpack    : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' Directory    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' Directory    ');
                             Writeat(1,25,7,0,expand('The directory to unpack the file in',79));
                           End;
                     End;
                   End;
    ex_nodepath  : Begin
                     Writeat(2,15,7,0,' Type         ');
                     Writeat(2,16,7,0,' Filemask     ');
                     Writeat(2,17,7,0,' From Area    ');
                     Writeat(2,18,7,0,' For Node     ');
                     Writeat(2,19,7,0,' Directory    ');
                     Case active of
                       1 : Begin
                             Writeat(2,15,kl4,kl5,' Type         ');
                             Writeat(1,25,7,0,expand('Which kind of exception this is',79));
                           End;
                       2 : Begin
                             Writeat(2,16,kl4,kl5,' Filemask     ');
                             Writeat(1,25,7,0,expand('The file which triggers this exception',79));
                           End;
                       3 : Begin
                             Writeat(2,17,kl4,kl5,' From Area    ');
                             Writeat(1,25,7,0,expand('The file area in which the file comes in',79));
                           End;
                       4 : Begin
                             Writeat(2,18,kl4,kl5,' For Node     ');
                             Writeat(1,25,7,0,expand('For which node this exception is',79));
                           End;
                       5 : Begin
                             Writeat(2,19,kl4,kl5,' Directory    ');
                             Writeat(1,25,7,0,expand('The directory to move the file and *.tic file to',79));
                           End;
                     End;
                   End;

  End;
End;


Procedure Exception_read;
Var
  A : Word;
Begin
  Create_List;
  A := 0;
  Reset(exfile);
  While not eof(exfile) do
    Begin
      Inc(A);
      Read(exfile,ex);

      Case ex.Kind of
        ex_move      : Add_to_List(expand(int_to_Str(a),3)+' Move file    '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.toarea);
        ex_adopt     : Add_to_List(expand(int_to_str(a),3)+' Adopt file   '+expand(ex.mask,14)+
                           ^P+' '+ex.toarea);
        ex_noforward : Add_to_List(expand(int_to_str(a),3)+' Noforward    '+expand(ex.mask,14)+
                           '('+ex.fromarea+')');
        ex_noannounce: Add_to_List(expand(int_to_str(a),3)+' No Announce  '+expand(ex.mask,14)+
                           '('+ex.fromarea+')');
        ex_passthru  : Add_to_List(expand(int_to_str(a),3)+' Passthru     '+expand(ex.mask,14)+
                           '('+ex.fromarea+')');
        ex_copyfile  : Add_to_List(expand(int_to_str(a),3)+' Copy file    '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.line[1]);
        ex_otherpath : Add_to_List(expand(int_to_str(a),3)+' Other path   '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.line[1]);
        ex_copyarea  : Add_to_List(expand(int_to_str(a),3)+' Copy to area '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.toarea);
        ex_magic     : Add_to_List(expand(int_to_str(a),3)+' Magic name   '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.line[1]);
        ex_exec      : Add_to_List(expand(int_to_str(a),3)+' Exec command '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.line[1]);
        ex_delete    : Add_to_List(expand(int_to_str(a),3)+' Delete file  '+expand(ex.mask,14)+
                           ex.fromarea);
        ex_unpack    : Add_to_List(expand(int_to_str(a),3)+' Unpack file  '+expand(ex.mask,14)+
                           expand(ex.fromarea,23)+' '+^P+' '+ex.line[1]);
        ex_nodepath  : Add_to_List(expand(int_to_str(a),3)+' Node path    '+expand(ex.mask,14)+
                           expand(node2str(ex.fromnode),23)+' '+^P+' '+ex.line[1]);
      End;
    End;
End;


Function Select_Type (a:exceptiontype) : ExceptionType;
Var
  sel : byte;
  ch  : char;

   Procedure WriteKind;
   Begin
     Writeat(31,8 ,7,0,' Move file    ');
     Writeat(31,9 ,7,0,' Adopt file   ');
     Writeat(31,10,7,0,' NoForward    ');
     Writeat(31,11,7,0,' Passthru     ');
     Writeat(31,12,7,0,' Copy file    ');
     Writeat(31,13,7,0,' Other path   ');
     Writeat(31,14,7,0,' Copy area    ');
     Writeat(31,15,7,0,' Magic name   ');
     Writeat(31,16,7,0,' Exec command ');
     Writeat(31,17,7,0,' Delete file  ');
     Writeat(31,18,7,0,' Unpack file  ');
     Writeat(31,19,7,0,' No announce  ');
     Writeat(31,20,7,0,' Node path    ');
     Case sel of
      1 : Begin
            Writeat(31,8 ,kl4,kl5,' Move file    ');
            Writeat(1,25,7,0,expand('Move a file from one area into another',79));
          End;
      2 : Begin
            Writeat(31,9 ,kl4,kl5,' Adopt file   ');
            Writeat(1,25,7,0,expand('Adopt a file into an area',79));
          End;
      3 : Begin
            Writeat(31,10,kl4,kl5,' NoForward    ');
            Writeat(1,25,7,0,expand('Do not forward a file to downlinks',79));
          End;
      4 : Begin
            Writeat(31,11,kl4,kl5,' Passthru     ');
            Writeat(1,25,7,0,expand('Make a file passthru, e.g. do not store the file locally',79));
          End;
      5 : Begin
            Writeat(31,12,kl4,kl5,' Copy file    ');
            Writeat(1,25,7,0,expand('Make a copy of a file',79));
          End;
      6 : Begin
            Writeat(31,13,kl4,kl5,' Other path   ');
            Writeat(1,25,7,0,expand('Use a different path for a file',79));
          End;
      7 : Begin
            Writeat(31,14,kl4,kl5,' Copy area    ');
            Writeat(1,25,7,0,expand('Make a copy of a file into another area',79));
          End;
      8 : Begin
            Writeat(31,15,kl4,kl5,' Magic name   ');
            Writeat(1,25,7,0,expand('Update the magic name list',79));
          End;
      9 : Begin
            Writeat(31,16,kl4,kl5,' Exec command ');
            Writeat(1,25,7,0,expand('Execute a program/batchfile on arrival of a file',79));
          End;
     10 : Begin
            Writeat(31,17,kl4,kl5,' Delete file  ');
            Writeat(1,25,7,0,expand('Delete a file on arrival',79));
          End;
     11 : Begin
            Writeat(31,18,kl4,kl5,' Unpack file  ');
            Writeat(1,25,7,0,expand('Unpack an archived file on arrival',79));
          End;
     12 : Begin
            Writeat(31,19,kl4,kl5,' No announce  ');
            Writeat(1,25,7,0,expand('Do not announce a file on arrival',79));
          End;
     13 : Begin
            Writeat(31,20,kl4,kl5,' Node path    ');
            Writeat(1,25,7,0,expand('Place forwarded file(s) to a specific node in a specific directory',79));
          End;
     End;
   End;

Begin
  With mwin[4] do
    Begin
      x1 := 30;
      x2 := 6;
      y1 := 45;
      y2 := 22;
      st := ' Type ';
    End;
  Create_Window(4);
  Case a of
    ex_move      : sel := 1;
    ex_adopt     : sel := 2;
    ex_noforward : sel := 3;
    ex_passthru  : sel := 4;
    ex_copyfile  : sel := 5;
    ex_otherpath : sel := 6;
    ex_copyarea  : sel := 7;
    ex_magic     : sel := 8;
    ex_exec      : sel := 9;
    ex_delete    : sel := 10;
    ex_unpack    : sel := 11;
    ex_noannounce: sel := 12;
    ex_nodepath  : sel := 13;
  End;
  Ch := #0;
  While not (Ch in [#27,#13]) do
    Begin
      WriteKind;
      Ch := Readkey;
      If Ch = #0 then
        Begin
          Ch := Readkey;
          If Ch = #80 then
            begin if sel < 13 then inc(sel) else sel := 1; end else
          If Ch = #72 then
            begin if sel > 1 then dec(sel) else sel := 13; end;
        End Else
      If Ch = #9 then InfoScreen else
      If Ch = #26 then DosShell;
    End;
  Remove_Window(4);
  If Ch = #27 then Select_type := A else
    Begin
      Case sel of
       1 : Select_type := ex_move;
       2 : select_type := ex_adopt;
       3 : select_type := ex_noforward;
       4 : select_type := ex_passthru;
       5 : select_type := ex_copyfile;
       6 : select_type := ex_otherpath;
       7 : select_type := ex_copyarea;
       8 : select_type := ex_magic;
       9 : select_type := ex_exec;
      10 : select_type := ex_delete;
      11 : select_type := ex_unpack;
      12 : select_type := ex_noannounce;
      13 : select_type := ex_nodepath;
      End;
    End;
End;


Procedure Exception_InsHook(new:boolean; rec:word);
Var
  Tmp     : String;
  Ch      : Char;
  Active  : Word;
  exBak   : ExceptionRec;
  Bol     : Boolean;
  s       : exceptiontype;

  Function Select_the_area (tmp:string) : String;
  Var
    X      : Word;
    Exbak2 : ExceptionRec;
  Begin
    if tmp <> '' then
      begin
        x := 0;
        repeat
          inc(x);
        until (upper(afxt^[x].tag) = upper(tmp)) or (x > areaidx);
        if x > areaidx then x := 1;
      end else x := 1;
    exbak2 := ex;
    remove_list;
    x := Select_Area(4,x);
    exception_read;
    ex := exbak2;
    if x <> 0 then select_the_area := afxt^[x].tag
      else select_the_area := '';
  End;

Begin
  exBak := ex;
  With mwin[3] do
    Begin
      x1 := 1;
      x2 := 13;
      y1 := 80;
      y2 := 24;
      st := ' Entry '+int_to_str(rec)+' ';
    End;
  Create_window(3);

  CH := #0;
  Active := 1;

  if new then fillchar(ex,sizeof(ex),#0);

  While Ch <> #27 do
    Begin
      Write_exception(active);
      Display_Exception;
      Ch := Readkey;
      Case Ch of
        #9  : infoscreen;
        #26 : dosshell;
        #13 : Begin
                Case Active of
                  1 : Begin
                        s := Select_type(ex.kind);
                        FillScreen(2,14,79,23,7,0,' ');
                        Fillchar(ex,sizeof(ex),#0);
                        ex.kind := s;
                      End;
                  2 : Begin
                        tmp := ex.mask;
                        read_String(17,16,12,12,tmp,c_file);
                        ex.mask := upper(tmp);
                      End;
                End;
               Case ex.kind of
                 ex_move       : Begin
                                   Case active of
                                     3 : Begin
                                           tmp := ex.fromarea;
                                           read_string(17,17,20,20,tmp,c_all);
                                           if (ex.fromarea = tmp) or (tmp = '') then
                                             begin
                                               ex.fromarea := select_the_area(tmp);
                                             end else ex.fromarea := upper(tmp);
                                         End;
                                     4 : Begin
                                           tmp := ex.toarea;
                                           read_String(17,18,20,20,tmp,c_all);
                                           if (ex.toarea = tmp) or (tmp = '') then
                                             begin
                                               ex.toarea := select_the_area(tmp);
                                             end else ex.toarea := upper(tmp);
                                         End;
                                     5 : Begin
                                           tmp := node2str(ex.fromnode);
                                           read_String(17,19,23,23,tmp,c_all);
                                           str2node(tmp,ex.fromnode,setup.address[1],bol);
                                           if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                                         End;
                                   End;
                                 End;
                 ex_adopt      : Begin
                                   Case active of
                                    3 : Begin {toarea}
                                          tmp := ex.toarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.toarea = tmp) or (tmp = '') then
                                            begin
                                              ex.toarea := select_the_area(tmp);
                                            end else ex.toarea := upper(tmp);
                                        End;
                                    4 : Begin {fromnode}
                                          tmp := node2str(ex.fromnode);
                                          read_String(17,18,23,23,tmp,c_all);
                                          str2node(tmp,ex.fromnode,setup.address[1],bol);
                                          if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                                        End;
                                    5 : Begin {description}
                                          tmp := ex.line[1];
                                          read_string(17,19,62,80,tmp,c_all);
                                          ex.line[1] := tmp;
                                        End;
                                   End;
                                 End;
                 ex_noforward  : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                   End;
                                 End;
                 ex_noannounce : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                   End;
                                 End;
                 ex_passthru   : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                   End;
                                 End;
                 ex_copyfile   : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                    4 : Begin {directory}
                                          tmp := ex.line[1];
                                          read_string(17,18,62,80,tmp,c_all);
                                          checkpath(tmp);
                                          ex.line[1] := upper(tmp);
                                        End;
                                   End;
                                 End;
                 ex_otherpath  : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                    4 : Begin {directory}
                                          tmp := ex.line[1];
                                          read_string(17,18,62,80,tmp,c_all);
                                          checkpath(tmp);
                                          ex.line[1] := upper(tmp);
                                        End;
                                   End;
                                 End;
                 ex_copyarea   : Begin
                                   Case active of
                                     3 : Begin
                                           tmp := ex.fromarea;
                                           read_string(17,17,20,20,tmp,c_all);
                                           if (ex.fromarea = tmp) or (tmp = '') then
                                             begin
                                               ex.fromarea := select_the_area(tmp);
                                             end else ex.fromarea := upper(tmp);
                                         End;
                                     4 : Begin
                                           tmp := ex.toarea;
                                           read_String(17,18,20,20,tmp,c_all);
                                           if (ex.toarea = tmp) or (tmp = '') then
                                             begin
                                               ex.toarea := select_the_area(tmp);
                                             end else ex.toarea := upper(tmp);
                                         End;
                                     5 : Begin
                                           tmp := node2str(ex.fromnode);
                                           read_String(17,19,23,23,tmp,c_all);
                                           str2node(tmp,ex.fromnode,setup.address[1],bol);
                                           if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                                         End;
                                   End;
                                 End;
                 ex_magic      : Begin
                                   Case active of
                                     3 : Begin
                                           tmp := ex.fromarea;
                                           read_string(17,17,20,20,tmp,c_all);
                                           if (ex.fromarea = tmp) or (tmp = '') then
                                             begin
                                               ex.fromarea := select_the_area(tmp);
                                             end else ex.fromarea := upper(tmp);
                                         End;
                                     4 : Begin
                                           tmp := first(20,ex.line[1]);
                                           read_string(17,18,20,20,tmp,c_all);
                                           ex.line[1] := tmp;
                                         End;
                                   End;
                                 End;
                 ex_exec       : Begin
                                   Case active of
                                     3 : Begin
                                           tmp := ex.fromarea;
                                           read_string(17,17,20,20,tmp,c_all);
                                           if (ex.fromarea = tmp) or (tmp = '') then
                                             begin
                                               ex.fromarea := select_the_area(tmp);
                                             end else ex.fromarea := upper(tmp);
                                         End;
                                     4 : Begin
                                           tmp := ex.line[1];
                                           read_string(17,18,60,80,tmp,c_all);
                                           ex.line[1] := tmp;
                                         End;
                                   End;
                                 End;
                 ex_delete     : Begin
                                   Case active of
                                     3 : Begin
                                           tmp := ex.fromarea;
                                           read_string(17,17,20,20,tmp,c_all);
                                           if (ex.fromarea = tmp) or (tmp = '') then
                                             begin
                                               ex.fromarea := select_the_area(tmp);
                                             end else ex.fromarea := upper(tmp);
                                         End;
                                   End;
                                 End;
                 ex_unpack     : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                    4 : Begin {directory}
                                          tmp := ex.line[1];
                                          read_string(17,18,62,80,tmp,c_all);
                                          checkpath(tmp);
                                          ex.line[1] := upper(tmp);
                                        End;
                                   End;
                                 End;
                 ex_nodepath   : Begin
                                   Case active of
                                    3 : Begin
                                          tmp := ex.fromarea;
                                          read_string(17,17,20,20,tmp,c_all);
                                          if (ex.fromarea = tmp) or (tmp = '') then
                                            begin
                                              ex.fromarea := select_the_area(tmp);
                                            end else ex.fromarea := upper(tmp);
                                        End;
                                    4 : Begin
                                          tmp := node2str(ex.fromnode);
                                          read_string(17,18,20,20,tmp,c_all);
                                          str2node(tmp,ex.fromnode,setup.address[1],bol);
                                          if not bol then askwindow('','Invalid node number entered','',[#32,#27,#13]);
                                        End;
                                    5 : Begin {directory}
                                          tmp := ex.line[1];
                                          read_string(17,19,62,80,tmp,c_all);
                                          checkpath(tmp);
                                          ex.line[1] := upper(tmp);
                                        End;
                                   End;
                                 End;
               End;
              End;
        #0  : Begin
                Ch := Readkey;
                Case Ch of
                  #72 : {up}   if active > 1 then dec(active) else
                               begin
                                 case ex.kind of
                                   ex_move      : active := 5;
                                   ex_adopt     : active := 5;
                                   ex_noforward : active := 3;
                                   ex_noannounce: active := 3;
                                   ex_passthru  : active := 3;
                                   ex_copyfile  : active := 4;
                                   ex_otherpath : active := 4;
                                   ex_copyarea  : active := 5;
                                   ex_magic     : active := 4;
                                   ex_exec      : active := 4;
                                   ex_delete    : active := 3;
                                   ex_unpack    : active := 4;
                                   ex_nodepath  : active := 5;
                                 end;
                               end;
                  #80 : {down} begin
                                 case ex.kind of
                                  ex_move      : if active < 5 then inc(active) else active := 1;
                                  ex_adopt     : if active < 5 then inc(active) else active := 1;
                                  ex_noforward : if active < 3 then inc(active) else active := 1;
                                  ex_noannounce: if active < 3 then inc(active) else active := 1;
                                  ex_passthru  : if active < 3 then inc(active) else active := 1;
                                  ex_copyfile  : if active < 4 then inc(active) else active := 1;
                                  ex_otherpath : if active < 4 then inc(active) else active := 1;
                                  ex_copyarea  : if active < 5 then inc(active) else active := 1;
                                  ex_magic     : if active < 4 then inc(active) else active := 1;
                                  ex_exec      : if active < 4 then inc(active) else active := 1;
                                  ex_delete    : if active < 3 then inc(active) else active := 1;
                                  ex_unpack    : if active < 4 then inc(Active) else active := 1;
                                  ex_nodepath  : if active < 5 then inc(active) else active := 1;
                                 end;
                               end;
                End;
              End;
      End;
    End;

  If not samerec(ex,exbak,sizeof(exbak)) then
    Begin
      If AskWindow('Changes have been made','Save changes?','(Y/N)',['y','Y','n','N']) in ['y','Y'] then
        Begin
          Seek(exfile,rec-1);
          Write(exfile,ex); {save rec}

          remove_list;
          exception_read;
        End;
    End;

  Display_Exception_Amount;
  Remove_Window(3);
End;


{$F+} Procedure Exception_Ins; {$F-}
Begin
  Exception_InsHook(true,filesize(exfile)+1);
End;


{$F+} Procedure Exception_F3(rec:word); {$F-}
Var Tmp     : String;
    ex1     : exceptionrec;
    exfile1 : file of exceptionrec;
    x, y    : word;
Begin
  With mwin[3] do
    Begin
      x1 := 25;
      x2 := 10;
      y1 := 57;
      y2 := 14;
      st := ' Move to ';
    End;
  Create_Window(3);
  tmp := int_to_str(filesize(exfile));
  writeat(1,25,7,0,'Enter the position to which this entry must be moved');
  writeat(27,12,7,0,'Move entry '+int_to_str(rec)+' to position: ');
  read_String(53,12,3,3,tmp,c_all);

  x := str_to_int(tmp);

  if (x <> 0) and (x <> rec) then
    begin
      seek(exfile,rec-1);
      read(exfile,ex);

      assign(exfile1,systempath+'FILEMASK.NEW');
      rewrite(exfile1);

      y := 0;
      seek(exfile,0);
      while not eof(exfile) do
        begin
          inc(y);
          read(exfile,ex1);
          if y <> rec then write(exfile1,ex1);
        end;

      y := 0;
      seek(exfile,0);
      seek(exfile1,0);
      while not eof(exfile1) do
        begin
          inc(y);
          read(exfile1,ex1);
          if y = x then write(exfile,ex);
          write(exfile,ex1);
        end;
      if y < x then write(exfile,ex);
      Close(exfile);
      Close(exfile1);
      Erase(exfile1);
    End;
  Remove_Window(3);
  remove_list;
  exception_read;
  display_exception_amount;
End;

{$F+} Function Exception_Del(rec:word) : Boolean; {$F-}
Var
  Exbakfile : File of ExceptionRec;
  x         : Word;
Begin
  Rec := Str_to_Int(Extractwords(1,1,Get_From_List(rec)));

  If Askwindow('Delete entry '+int_to_str(rec),'are you sure?','(Y/N)',['y','Y','n','N']) in ['n','N'] then
    begin
      exception_del := false;
      exit;
    end;

  Remove_List;

  Assign(exbakfile,systempath+'FILEMASK.NEW');
  Rewrite(exbakfile);
  Reset(exfile);
  X := 0;
  While not eof(exfile) do
    Begin
      Inc(x);
      Read(exfile,ex);
      If rec <> x then Write(exbakfile,ex);
    End;
  Close(exfile);
  Erase(exfile);
  Close(exbakfile);
  Rename(exbakfile,systempath+'FILEMASK.FM');
  {del rec from exfile}
  Assign(exfile,systempath+'FILEMASK.FM');
  Reset(exfile);

  Exception_Read;
  Exception_Del := True;
  Display_exception_Amount;
End;


Procedure ExceptionLoop;
Var
  Ch     : Char;
  Tmp    : String;
  Active : Byte;
Begin
  Assign(exfile,Systempath + 'FILEMASK.FM');
  {$I-} Reset(exfile); {$I+}
  If Ioresult <> 0 then
    Begin
      If AskWindow(Upper(Systempath)+'FILEMASK.FM not found','Create new?','(Y/N)',['y','Y','n','N',#27]) in ['y','Y'] then
        Begin
          Rewrite(exfile);
        End Else
        Begin
          Exit;
        End;
    End;

  With mwin[2] do
    Begin
      x1 := 1;
      x2 := 1;
      y1 := 80;
      y2 := 24;
      st := ' Exceptions ';
    End;
  Create_Window(2);

  Ins_Hook := Exception_Ins;
  Del_Hook := Exception_Del;
  F3_Hook := Exception_F3;
  Exception_Read;

  Active := 1;
  Repeat
    Display_exception_Amount;

    Tmp := Show_List (2,true,false {Jump},0 {JumpWord}, active);
    If Tmp <> '' then
      Begin
        active := str_to_int(extractwords(1,1,tmp));
        seek(exfile,active-1);
        read(exfile,ex);
        Exception_Inshook(false,active);
      End;
  Until Tmp = '';

  Remove_List;
  Remove_Window(2);
  Close(exfile);
End;


End.
