PAGE  80,132
TITLE WRDRX  Parse word from RIGHT starting at a given index, Ver 6.20

; WRDRX.ASM - WrdRX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine parses the word at a given index from a string delimited
; by spaces.  The routine searches starting at Index, from RIGHT to left to
; find the beginning of the first word found.
; If Index=0, null is returned.

; This was made a procedure in lieu of a function for speed.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdRX
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+10]
S            EQU     DWORD PTR SS:[bx+6]
Index        EQU     BYTE  PTR SS:[bx+4]

; WrdRX - Parse word from RIGHT starting at a given index.
; procedure WrdRX (VAR Dest: string; S: string; indeX: byte);

WrdRX        PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   cl,es:[di]       ; Get length
; -- Evalute Index --
       mov   dx,cx            ; Save length in DX
       mov   al,Index         ; Get Index
       cmp   al,cl            ; Index<Length?
       ja    AtEnd            ;   no,  use length in CX
       mov   cl,al            ;   yes, use index  in AX
AtEnd: cmp   ch,cl            ; Index=0?
       je    Exit             ;   yes, return null
; -- Test first char --
       add   di,cx            ; Point to S[index]
       mov   al,' '           ; Get Space char to scan
       cmp   al,es:[di]       ; S[index]=space?
       jne   OnTop            ;   no, on top of word

; -- ON SPACE.  Search LEFT for end of word --
       std                    ; Set DF to decrement
       repe  scasb            ; Scan for non-space.
       je    Exit             ; All spaces
       mov   si,di            ; Save offset
       inc   si               ; To Wrd[L]
       inc   si               ; To Wrd[L+1]
       jmp   SHORT Left       ; Find Wrd[1]

; -- ON TOP OF WORD.  Search RIGHT first to end of word -------
OnTop: cld                    ; Set DF to increment
       mov   si,di            ; Save current position
       xchg  cx,dx            ; CX=Length, DX=chars to scan left
       sub   cx,dx            ; Chars to scan right
       inc   cx               ; Count 1st char, too.
       repne scasb            ; Scan for space.
       jne   Dec1             ; At Wrd[L+2]
       dec   di               ; To Wrd[L+1]
Dec1:  xchg  si,di            ; Get initial offset in DI
       mov   cx,dx            ; Reset to chars to scan
       jcxz  SHORT Leng       ; At end of string?

; -- Search left to beginning of partial word --
       std                    ; Set DF to decrement
Left:  repne scasb            ; Scan for end of word.
       jne   Leng             ;   no space
       inc   di               ; To Wrd[0]
; -- Set word length --
Leng:  inc   di               ; To Wrd[1]
       mov   cx,si            ; Get ending offset
       sub   cx,di            ; Word length in CX
       mov   si,di            ; Make offset the source
; -- Reset pointers --
       mov   dx,es            ; Save ES
Exit:  mov   ax,cx            ; Set length in AX
       les   di,Dest          ; Set up destination
       cld                    ; Set DF to increment
       stosb                  ; Save length
       mov   bx,ds            ; Save Pascal's DS
       mov   ds,dx            ; Set source seg
       call  RepMovsB         ; Do fast move of bytes (Skip if CX=0)
       mov   ds,bx            ; Restore Pascal's DS
       ret   10               ; Clear all parameters

WrdRX        ENDP

CODE   ENDS

       END
