PAGE  80,132
TITLE STRPOSR  String Position of Nth Find Routine from Right, Ver 6.20

; STRPOSR.ASM - StrPosR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of Nth occurrence a given character.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrPosR

S            EQU     DWORD PTR [bp+12]
Find         EQU     DWORD PTR [bp+8]
Nth          EQU     BYTE  PTR [bp+6]

; StrPosR - Position of Nth occurrence of Find from the RIGHT.
; function StrPosR (S,Find: string; Nth: byte): byte;

; AH: N Occurrences   AL: First char
; BX: Scratch
; CH: 0              CL: Compare length
; DH: 0              DL: Find[0]-1

StrPosR      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Get S length --
       xor   ax,ax            ; Set AX=0
       mov   cx,ax            ; Set CX=0
       les   di,S             ; Point to dest string
       mov   cl,es:[di]       ; Get S length
       add   di,cx            ; Point to S[last]
; -- Test Find length --
       lds   si,Find          ; Point to Find string
       cld                    ; Set DF to increment
       lodsb                  ; Get Find length
       dec   ax               ; Find[0]-1
       js    Exit1            ; Exit if Find=''
; -- Test scan length --
       sub   cx,ax            ; Chars to scan in CX
       jbe   Exit1            ; Exit if Find[0]-1>=S[0]
       add   si,ax            ; Point to last char
       mov   dx,ax            ; Save in DX
; -- Check Nth for zero --
       mov   al,Nth           ; Get Nth
       add   ah,al            ; Nth=0? (and save in AH)
       jz    Exit4            ; Exit if 0
       std                    ; Set DF to decrement
       lodsb                  ; Get last Find char
; -- Check if just one char --
       cmp   dh,dl            ; Find[0]-1=0? ( 1 char? )
       jz    L2               ;  yes, scan for char
; -- Scan for Find --
       EVEN                   ; Align for speed
L0:    repne scasb            ; Try to match last char
       jne   Exit3            ; None found (ZF=0) (CX=0)
       mov   bx,cx            ; Save count remaining in BX
       mov   cx,dx            ; Set Find scan length
       repe  cmpsb            ; Strings equal?
       xchg  cx,bx            ;   (Swap counts)
       je    L1               ;   yes, a match found
                              ;   no, scan again
; -- Readjust for no match --
       jcxz  Exit3            ; Search done and not found
       sub   bx,dx            ; Number of chars compared (neg)
       sub   si,bx            ; Reset SI
       sub   di,bx            ; Reset DI
       jmp   SHORT L0         ; Continue to next pos
; -- Readjust for match found --
L1:    dec   ah               ; Decrement occurrrence
       je    Exit2            ; Exit if Nth reached
       add   si,dx            ; Reset SI
       sub   cl,dl            ; Jump past last find
       ja    L0               ; Continue if more chars

; -- Report results --
Exit1: mov   cl,-1            ; Set CL=-1 to get result 0
Exit2: inc   cx               ; Make 1-based
Exit3: mov   al,cl            ; Get position in AL
Exit4: pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters

; -- Special scan for just one char --
       EVEN                   ; Align for speed
L2:    repne scasb            ; Scan
       jne   Exit3            ; Not found
       dec   ah               ; Adjust count
       jnz   L2               ; Loop if not finished
       jmp   SHORT Exit2      ; Found position
StrPosR      ENDP

CODE   ENDS

       END
