PAGE  80,132
TITLE STRJC  String Center Justification Routine, Ver 6.20

; STRJC.ASM - StrJC
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine center justifies strings in a field.  If the
; field is smaller than the orginal string, the string is simply returned.
; This routine saves from recopying the string to make it faster.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrJC
        EXTRN   RepMovsB: NEAR
        EXTRN   RepStosB: NEAR

Space        EQU     ' '
S            EQU     DWORD PTR [bp+8]
Field        EQU     BYTE  PTR [bp+6]
Result       EQU     DWORD PTR [bp+12]

; StrJC - Center justifies a string in a field.
; function StrJC (S: string; Field: byte): string;

StrJC        PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       les   di,Result        ; Point to function string
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Load S[0] in AL
       xor   ah,ah            ; Zero extend AL
       mov   bx,ax            ; Save length in BX
       mov   al,Field         ; Get proposed FIELD length
       mov   cx,ax            ; Copy FIELD in CX
       sub   cx,bx            ; Length>FIELD?
       ja    Fits             ;   no, add spaces
       mov   al,bl            ;   yes, string length in AL
       xor   cx,cx            ; Set spaces to zero
Fits:  stosb                  ; Set result length
       mov   al,Space         ; Set AL to space
       shr   cx,1             ; Divide spaces in half
       mov   bh,cl            ; Save space count
       adc   bh,ch            ; Add carry to BH
       call  RepStosB         ; Fast fill of leading spaces
       mov   cl,bl            ; Set string count
       call  RepMovsB         ; Do fast move of bytes
       mov   cl,bh            ; Set space count again
       call  RepStosB         ; Fast fill of trailing spaces
       mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   6                ; Clear all parameters
StrJC        ENDP

CODE   ENDS

       END
