PAGE  80,132
TITLE STRINS  String Delete Routine, Ver 6.20

; STRINS.ASM - StrIns
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine replaces Pascal's slower Insert routine.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrIns
        EXTRN   RepMovsBRev: NEAR

Dest         EQU     DWORD PTR [bp+14]
S            EQU     DWORD PTR [bp+10]
DestIndex    EQU     BYTE  PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]

; StrIns - Inserts an array of characters in a string.
; procedure StrIns (VAR Dest: string; S: string; DestIndex,MaxLen: byte);

; Quit if:
;   S[0]=0
;   Length=0
;   MaxLen < Corrected Index
; Total Length  = Min (MaxLen, D[0]+S[0])
; where D[0]+S[0] = S[0] + (Index-1) + (D[0]-(Index-1))

; DH: move length  DL: insert length


StrIns       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Get Dest length --
       xor   ax,ax            ; Set AX=0
       les   di,Dest          ; At Dest[0]
       mov   al,es:[di]       ; Get length
       mov   cx,ax            ; Save in CX   (CL=Dest[0])
; -- Check S length --
       lds   si,S             ; Point to source string
       mov   al,[si]          ; Get length
       cmp   ah,al            ; Length=0?
       jz    Exit             ;   yes, quit if null string
       mov   dx,ax            ; Save in DX   (DL=S[0])
; -- Get Dest index --
       mov   al,DestIndex     ; Get index
       cmp   ah,al            ; Index>0? (CF=1?)
       sbb   al,ah            ;   yes, decrement
; -- Calculate shifted string length --
       sub   cl,al            ; Index<=Length?  (CL=Move length)
       jae   C1               ;   yes, have to move a substring
       add   al,cl            ;   no, just append, adjust index
       mov   cl,ah            ; Set move length 0
C1:    mov   bx,ax            ; Save in BX   (BL=DestIndex)
; -- Get MaxLen --
       mov   bh,MaxLen        ; Get MaxLen
; -- Calculate proposed total length --
       add   al,cl            ; AL=Dest[0]
       add   al,dl            ; AL=Dest[0]+S[0]=NewDestLen
       jc    Adj              ; Adjust if NewDestLen >=256
       cmp   al,bh            ; Total<=MaxLen?
       jbe   NoAdj            ;   yes, no adjustments necessary

; -- Truncation is needed.  Find out where --
; -- Check Index>MaxLen length --
Adj:   mov   al,bh            ; MaxLen = NewDestLen
       sub   bh,bl            ; MaxLen<=Index-1?
       jbe   Exit             ;   yes, exit
; -- Calc room left for insert --
       sub   bh,dl            ; MaxLen<=Index-1+S[0]?
       jae   C2               ;   no, insert passes length test
       add   dl,bh            ;   yes, truncate insert
       mov   bh,ch            ; Set 0 to nullify shifted string
; -- Set room left for shifted string --
C2:    mov   cl,bh            ; Truncate shifted string

; -- Store new length --
NoAdj: std                    ; Set DF to decrement
       stosb                  ; Save new length
       inc   di               ; At Dest[0]
       add   di,ax            ; At Dest[L]
; -- Append trailing chars --
       jcxz  C3               ; No appending chars
       mov   bx,es            ; Move ES into ...
       mov   ds,bx            ;  ... DS
       mov   si,di            ; Point at same place
       sub   si,dx            ; At Dest[L]
       call  RepMovsBRev      ; Do fast move of bytes
; -- Insert string --
C3:    lds   si,S             ; At S[0]
       mov   cl,dl            ; Set S[0]
       add   si,cx            ; At S[L]
       call  RepMovsBRev      ; Do fast move of bytes
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   12               ; Clear all parameters
StrIns       ENDP

CODE   ENDS

       END
