PAGE  80,132
TITLE STRBREAK  Finds first char from a group of chars, Ver 6.20

; STRBREAK.ASM - StrBrk
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

; Finds the first index in a string a given a list of chars to find starting
; RIGHT from the given index.
; Routine has fully scanned when resulting index is set to zero.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrBrk

S            EQU     DWORD PTR [bp+12]
Breaks       EQU     DWORD PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]

; AH:                 AL: Char to scan
; BX: starting offset
; CH: 0               CL: Count
; DH: Break length    DL: Remaining S length


; function StrBrk (S,Breaks: string; Index: byte): byte;

StrBrk       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       xor   ax,ax            ; Set AX=0
; -- Point to string to be broken --
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Set CX
       jcxz  Exit             ; Exit if null string
; -- Adjust Index (Leave 0 index alone) --
       mov   al,Index         ; Get index value
       cmp   ah,al            ; Index>0?
       sbb   al,ah            ;   yes, decrement
; -- Index-1 within string length? --
       sub   cx,ax            ; Length<=Index-1?
       jbe   Null             ;   yes, exit with 0
       mov   bx,si            ; Save starting offset
       add   si,ax            ; First char to scan in S
       mov   dx,cx            ; Save scan count in DL (DH=0)
; -- Evaluate breaks --
       les   di,Breaks        ; Point to break string
       add   dh,es:[di]       ; Get Breaks length, Breaks = ''?
       jz    Null             ;   yes, return 0
       inc   di               ; To Breaks[1]
       cmp   dh,1             ; One break?
       je    One              ;   yes, special case
       mov   cl,dh            ; Reset Breaks length
; -- Search for break --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get string char
       repne scasb            ; Scan for break
       je    Found            ; Found break
       mov   cl,dh            ; Reset Breaks length
       sub   di,cx            ; To Breaks[1]
       dec   dl               ; S length -1
       jnz   L1               ; Try again
; -- Return new Index=0 --
Null:  mov   si,bx            ; Set SI=BX
; -- Calculate length --
Found: mov   ax,si            ; Get current SI
Found2:sub   ax,bx            ; Calc position
; -- Reset pointers --
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters

; -- One character break --
One:   mov   al,es:[di]       ; Get the break char
       mov   di,ds            ; Copy DS into ...
       mov   es,di            ;  ... ES
       mov   di,si            ; Copy SI into DI
; -- Search for break --
       repne scasb            ; Search for break
       jne   Null             ; Not found
       mov   ax,di            ; Get offset
       jmp   SHORT Found2     ; Found it

StrBrk       ENDP

CODE   ENDS

       END
