PAGE  80,132
TITLE ISSPACE Character Classification Routines, Ver 6.20

; ISSPACE.ASM - IsSpace
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  IsSpace

C       EQU  BYTE  PTR SS:[di+4]

; IsSpace - Returns true if Char is ' ', #$09..#$0D.
; function IsSpace (C: char): boolean;

IsSpace      PROC FAR
       mov   di,sp            ; Set up stack base
       mov   al,C             ; Get character
       xor   bx,bx            ; Set BX=0
       cmp   al,' '           ; C=' '?
       je    Is3              ;   yes, a space
       cmp   al,0Dh           ; C>0Dh?
       ja    ExIs3            ;   no, not a space
       cmp   al,09h           ; C<09h?
       jb    ExIs3            ;   no, not a space
Is3:   inc   bx               ; Set BX=1
ExIs3: xchg  ax,bx            ; Place result in AL
       ret   2                ; Clear parameter
IsSpace      ENDP

CODE   ENDS

       END
