PAGE  80,132
TITLE ISSIGNED Character Classification Routines, Ver 6.20

; ISSIGNED.ASM - IsSigned
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  IsSigned

C       EQU  BYTE  PTR SS:[di+4]

; IsSigned - Returns true if Char is '0'-'9','-', or '+'.
; function IsSigned (C: char): boolean;

IsSigned     PROC FAR
       mov   di,sp            ; Set up stack base
       xor   ax,ax            ; Set false
       mov   cl,C             ; Get character
       cmp   cl,'9'           ; C>'9'?
       ja    Exit             ;   no, can't be a number
       cmp   cl,'0'           ; C>=0?
       jae   Digit            ;   yes, it's a digit
       cmp   cl,'-'           ; C='-'?
       je    Digit            ;   yes, valid sign
       cmp   cl,'+'           ; C='+'?
       jne   Exit             ;   no, not a number
Digit: inc   ax               ;   yes, set true
Exit:  ret   2                ; Clear parameter
IsSigned     ENDP


CODE   ENDS

       END
