PAGE  80,132
TITLE COPY  String Copy Routine, Ver 6.20

; COPY.ASM - Copy
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine replaces Pascal's slower Copy routine.  It automatically
; replaces the routine when used.  It still cannot prevent the extra copy
; that the compiler makes when the routine is complete.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  Copy
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+12]
S            EQU     DWORD PTR SS:[bx+8]
Index        EQU     WORD  PTR SS:[bx+6]
Count        EQU     WORD  PTR SS:[bx+4]

; Copy - Copys an array of characters in a string.
; function Copy (S: string; Index,Count: integer): string;

; Quit if:
;   Count=0
;   Length=0
;   Index>Length

Copy         PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Check S length --
       lds   si,S             ; Point to source string
       les   di,Dest          ; Point to Dest
       cld                    ; Set DF to increment
       lodsb                  ; Get length  (SI+1)
       xor   ah,ah            ; Zero extend AL
       mov   cx,ax            ; Save in CX
;;;    jcxz  @@4              ; -- Wait for JLE below
; -- Adjust Index --
       mov   ax,Index         ; Get index
       dec   ax               ; 0-based.  Index now >0?
                              ; (if ax=-32768, then ax=32767: will jump)
       jg    @@0              ;   yes, index OK
       xor   ax,ax            ;   no, force to 0
; -- Check Index>Length --
@@0:   sub   cx,ax            ; Length<Index?  (CX=Trailing length)
                              ; (if AX>=255, then will quit with null)
                              ; (if Index was -32768: will quit, too)
       jle   @@3              ;   yes, null string
       add   si,ax            ; Source offset
; -- Check Count>0 --
       mov   ax,Count         ; Get Count
       test  ax,ax            ; Count<=0?
       jle   @@3              ;   yes, nothing to copy
       ; 1 <= AX <= 32767
       cmp   ax,cx            ; Count>Trailing?
       ; Since the Count can be large and CX is <=255 ...
       jg    @@1              ;   yes, use trailing count
       xchg  ax,cx            ;   no, use Count
; -- Append trailing chars --
@@1:   mov   ax,cx            ; Copy count to AX
       stosb                  ; Save count
       call  RepMovsB         ; Do fast move of bytes
@@2:   mov   ds,dx            ; Restore Pascal's DS
       retf  8                ; Clear all parameters

@@3:   xor   ax,ax            ; Set AL zero
@@4:   stosb                  ; Save count
       jmp   SHORT @@2        ; Finish routine
Copy         ENDP

CODE   ENDS

       END
