PAGE  80,132
TITLE CHRPOSXI  Position of Char after Index Routine - Ignore Case, Ver 6.20

; CHRPOSXI.ASM - ChrPosXI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of Find from a given indeX to the right
; and IGNORES case.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPosXI
        EXTRN   ChrSrchI: NEAR

S            EQU     DWORD PTR ss:[bx+8]
Find         EQU     BYTE  PTR ss:[bx+6]
indeX        EQU     BYTE  PTR ss:[bx+4]

; ChrPosXI - Position of Find from a given indeX and ignoring the case.
; function ChrPosXI (S: string; Find: char; indeX: byte): byte;

ChrPosXI     PROC FAR
       mov   bx,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Get string length --
       lds   si,S             ; Point to dest string
       xor   ax,ax            ; Set AX=0
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Set length
       jcxz  Exit             ; Quit if null string
; -- Evaluate indeX --
       mov   al,indeX         ; Get Position and test
       cmp   ah,al            ; indeX>0?
       sbb   al,ah            ;   yes, decrement
       sub   cx,ax            ; Chars to scan
       jbe   Exit0            ; None to search
       add   si,ax            ; First char to scan + 1
; -- Search for Find --
       push  ax               ; Save index
       mov   dl,1             ; Search for 1st occurence
       call  ChrSrchI         ; Search for Find
       pop   ax               ; Restore index
       jne   Exit0            ; No match found (ZF=0)
; -- Calculate position --
       sub   bx,si            ; Chars scanned (neg)
       sub   al,bl            ; Calc position (Index-1+(chars scanned))
Exit:  pop   ds               ; Restore Pascal's DS
       ret   8                ; Clear all parameters

Exit0: mov   al,ah            ; Set AL=0
       jmp   SHORT Exit       ;
ChrPosXI     ENDP

CODE   ENDS

       END
