PAGE  80,132
TITLE CHRPOSX  Position of Char After Given Index Routine, Ver 6.20

; CHRPOSX.ASM - ChrPosX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of Find from a given indeX to the right.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPosX

S            EQU     DWORD PTR ss:[bx+8]
Find         EQU     BYTE  PTR ss:[bx+6]
indeX        EQU     BYTE  PTR ss:[bx+4]

; ChrPosX - Position of Find from a given indeX.
; function ChrPosX (S: string; Find: char; indeX: byte): byte;

ChrPosX      PROC FAR
       mov   bx,sp            ; Set up stack base
       les   di,S             ; Point to dest string
       xor   ax,ax            ; Set AX=0
       mov   al,es:[di]       ; Get length
       mov   cx,ax            ; Set length
       jcxz  Exit1            ; Quit if null string
       mov   dx,ax            ; Also save in DX
; -- Evaluate indeX --
       mov   al,indeX         ; Get Position
       cmp   ah,al            ; indeX=0?
       sbb   al,-1            ;   yes, increment
       sub   cx,ax            ; Chars to scan
       jb    Exit2            ; None to search
; -- Set counters --
       inc   cx               ; 1-based
       add   di,ax            ; First char to scan
       mov   al,Find          ; Get Find to scan
       cld                    ; Set DF to increment
       repne scasb            ; Scan
       jne   Exit0            ; Not found
       neg   cx               ; Negate
       add   cx,dx            ; Calc position
Exit0: xchg  ax,cx            ; Place result in AX
Exit1: ret   8                ; Clear all parameters
Exit2: mov   al,ah            ; Set result 0
       ret   8                ; Clear all parameters
ChrPosX      ENDP

CODE   ENDS

       END
