PAGE  80,132
TITLE CHRPOSR  Position of Nth Char Routine from Right, Ver 6.20

; CHRPOSR.ASM - ChrPosR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of Nth occurrence of a given character
; from the RIGHT.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPosR

S            EQU     DWORD PTR SS:[bx+8]
Find         EQU     BYTE  PTR SS:[bx+6]
Nth          EQU     BYTE  PTR SS:[bx+4]

; ChrPosR - Position of Nth occurrence of Find from the RIGHT.
; function ChrPosR (S: string; Find: char; Nth: byte): byte;

ChrPosR      PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Get and evaluate Nth --
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
       add   dl,Nth           ; Get count and test
       jz    Done             ; Quit if no count
; -- Get and evalutate string length --
       les   di,S             ; Point to dest string
       add   cl,es:[di]       ; Get length and test
       jz    Done             ; Quit if no count
       mov   al,Find          ; Get Find to scan
; -- Scan for Find --
       add   di,cx            ; Start at S[last]
       std                    ; Set DF to decrement
       EVEN                   ; Align for speed
L1:    repne scasb            ; Scan
       jne   Done             ; Not found
       dec   dx               ; Adjust count
       jnz   L1               ; Loop if not finished
       inc   cx               ; Position
Done:  xchg  ax,cx            ; Place result in AX
       ret   8                ; Clear all parameters
ChrPosR      ENDP

CODE   ENDS

       END
