PAGE  80,132
TITLE CHRPADC  String Center Justification Routine, Ver 6.20

; CHRPADC.ASM - ChrPadC
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine center justifies a strings in a field by padding characters
; at both ends.  If the field is smaller than the orginal string, the string
; is unaltered.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPadC
        EXTRN   RepStosBRev: NEAR
        EXTRN   RepMovsBRev: NEAR

S            EQU     DWORD PTR [bp+10]
Fill         EQU     BYTE  PTR [bp+8]
Field        EQU     BYTE  PTR [bp+6]

; ChrPadC - Center justifies a string in a field by padding both ends.
; procedure ChrPadC (S: string; Fill: char; Field: byte);

ChrPadC      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get S --
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; Point to source string
       mov   al,[si]          ; Load S[0] in AL
       mov   bx,ax            ; Save length in BX
       mov   cx,ds            ; Move DS into ...
       mov   es,cx            ;  ... ES
; -- Compare Field and length --
       mov   al,Field         ; Get proposed FIELD length
       mov   cx,ax            ; Copy FIELD in CX
       sub   cx,bx            ; Length>=FIELD?
       jbe   Exit             ;   yes, no padding possible
; -- Save new length --
       std                    ; Set DF to decrement
       mov   [si],al          ; Set new length
       mov   di,si            ; At S[0]
       add   si,bx            ; At S[L]
       add   di,ax            ; At S[NewLen]
; -- Pad trailing chars --
       mov   al,Fill          ; Set AL to padding char
       shr   cx,1             ; Divide padding in half
       mov   bh,cl            ; Save space count
       adc   cl,ch            ; Add carry to trailing chars
       call  RepStosBRev      ; Fast fill of trailing chars
; -- Shift string --
       mov   cl,bl            ; Set string count
       call  RepMovsBRev      ; Do fast move of bytes
; -- Pad leading chars --
       mov   cl,bh            ; Set space count again
       call  RepStosBRev      ; Fast fill of leading chars
Exit:  mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   8                ; Clear all parameters
ChrPadC      ENDP

CODE   ENDS

       END
