{
 $Id$
}

 {*****************************************************************************
 *
 * Purpose:  Template procesing
 *
 * vbc 07/03/08 - Fix bug in processing for DD, MM, YY where value < 10
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Nw_Tpl;

Interface

Uses Dos, S_String, F_File, CrossLib,
     Fm_Log, Fm_Struct, Fm_Basic, Nw_Msg;

{-----------------------------------------------------------------------------}


Var
  TplFile     : Text;                  { for usetplfile }

  BlockSize,                           { counters }
  TotalSize   : LongInt;
  BlockCount,
  TotalCount  : Word;


Procedure Convert_Tpl( TplName : String;
                       Info : AnnounceLinkType;
                       UseTplFile : Boolean;          {tplfile must be open!}
                       Aka : Byte;
                       MsgTo : String );

Procedure Empty_Tpl ( TplName : String;
                      UseTplFile : Boolean;           {tplfile must be open!}
                      Aka : Byte;
                      MsgTo : String );

  {  als usefile false is, dan wordt de mkmsg unit gebruikt,
     is usefile true, dan wordt tplfile gebruikt   }


Function string_to_tpl(str:string):string;

{-----------------------------------------------------------------------------}

Implementation


Function string_to_tpl(str:string):string;
begin
  assign(tplfile,'FM_DESC.#$#');
  rewrite(tplfile);
  writeln(tplfile,str);
  close(tplfile);
  assign(tplfile,'FM_DESC2.#$#');
  rewrite(tplfile);
  Convert_Tpl( 'FM_DESC.#$#', ann, true, 0, '');
  close(tplfile);
  delete_file('FM_DESC.#$#');
  reset(tplfile);
  readln(tplfile,str);
  close(tplfile);
  erase(tplfile);
  string_to_tpl := str;
end;


Procedure Convert_Tpl( tplname:string;
                       info:announcelinktype;
                       usetplfile:boolean;
                       aka:byte;
                       msgto : string );

Const
  MetaNr     = 51;
  MetaString : Array[1..MetaNr] of String[15] = (
    'FILENAME',
    'FILEEXT',
    'FILESIZE',
    'FILEKB',
    'FILECRC',
    'FILEDESC',
    'OVERFLOW',
    'FILEORIGIN',
    'FILEFROM',
    'FILEPATH',
    'FILEREPL',
    'FILEMAGIC',
    'FILEEXPORT',
    'FILENODES',
    'FILEDATE',
    'AREATAG',
    'AREANAME',
    'GROUPTAG',
    'GROUPNAME',

    'SYSOPFIRST',
    'SYSOP',
    'SYSTEM',
    'AKA',
    'QUOTE',

    'HOUR',
    'MIN',
    'SEC',
    'DD',
    'D3',
    'DAY',
    'MM',
    'M3',
    'MONTH',
    'YY',
    'Y4',
    'DNR',

    'PROGRAM',
    'MSGTO',
    'MSGFIRST',
    'FSEARCH',

    'BLOCKCOUNT',
    'BLOCKSIZE',
    'BLOCKKB',
    'BLOCKMB',
    'TOTALCOUNT',
    'TOTALSIZE',
    'TOTALKB',
    'TOTALMB',

    'CREDITSLEFT',
    'CREDITSWARN',
    'CREDITSSTOP'
    );

Var
  T         : Text;                                                { tpl file }
  Ch        : String;
  X         : Integer;
  Cnverr    : Integer;
  Overfl    : Array[1..2048] of char;                              { overflow }

  Found     : Boolean;                        { if @word is really a @keyword }
  Overflow  : Boolean;
  Keyword   : String;
  TmpLen    : String;
  TmpBak    : String;
  Functie   : Byte;                             { functie voor keyword/tmplen }
  Currlen   : String;          { huidige column/positie op regel ivm overflow }
  NotOverflow : Boolean;

  Function Word_1(str:string) : Boolean;
  Begin
    If (pos(',',str) = 0) and (pos(':',str) = 0) and (pos(';',str) = 0) then
      Word_1 := True Else
        Word_1 := False;
  End;

  Function Word_2(str:string) : Boolean;
  Begin
    Repeat
      Str := last(length(str)-1,str);
    Until (str[1] = ';') or (str[1] = ':') or (str[1] = ',');
    Str := last(length(str)-1,str);

    If (pos(',',str) = 0) and (pos(':',str) = 0) and (pos(';',str) = 0) then
      Word_2 := True Else Word_2 := False;
  End;

  Procedure Strip_Buffer(useinfodesc:boolean);
  Var
    k : array[0..2048] of char;
    p : array[1..2048] of char;
    x,y : integer;
  Begin
    if not setup.wrapdesc then exit;

    if useinfodesc then
      begin
        for x := 1 to 2048 do p[x] := info.ldesc[x];
      end else
      begin
        for x := 1 to 2048 do p[x] := overfl[x];
      end;

    fillchar(k,sizeof(k),#0);
    x := 1; y := 1;  {verwijderen van meerdere spaties}
    k[0] := ' ';
    repeat
      while ((p[x] = ' ') and (k[y-1] = ' ')) and (x < 2048) do inc(x);
      k[y] := p[x];
      inc(x);
      inc(y);
    until x > 2048;

    if useinfodesc then
      begin
        for x := 1 to 2048 do info.ldesc[x] := k[x];
      end else
      begin
        for x := 1 to 2048 do overfl[x] := k[x];
      end;
  End;

  Procedure WriteIt(Str:String);
  Begin
    If Usetplfile then Write(Tplfile,Str) else DoString(Str);
  End;

  Function FirstWordLdesc : String;
  Var
    Tmp : String;
    X   : Word;
  Begin
    Tmp := '';
    X := 0;
    repeat
      inc(x)
    until (info.ldesc[x] <> ' ') and (info.ldesc[x] <> #13);

    if info.ldesc[x-1] <> #13 then
      if x > 1 then tmp := replicate(x-1,' ')+tmp;

    While (Not (Info.Ldesc[x] in [#0,#13,#32])) and (X < 2048) do
      Begin
        Tmp := Tmp + Info.Ldesc[x];
        Inc(x);
      End;
    FirstWordLdesc := Tmp;
  End;

  Function FirstWordOverfl : String;
  Var
    tmp : string;
    X   : Word;
  Begin
    Tmp := '';
    x := 0;
    repeat
      inc(x)
    until (overfl[x] <> ' ') and (overfl[x] <> #13);

    if overfl[1] <> #13 then
      tmp := replicate(x-1,' ')+tmp;

    While (not (overfl[x] in [#0,#13,#32])) and (X < 2048) do
      Begin
        Tmp := Tmp + Overfl[x];
        Inc(x);
      End;
    FirstWordOverfl := Tmp;
  End;

  Function FormattedDescription : Boolean; {returns true if #13 are in buffer}
  Var X : Word;
      Found : Boolean;
  Begin
    Found := False;
    X := 1;
    While Overfl[x] <> #0 do
      Begin
        If Overfl[x] = #13 then
          Found := True;
        Inc(x);
      End;
    FormattedDescription := Found;
  End;

  Procedure WriteKeyword(x:byte);
  Var Tmp      : String;
      TmpBak   : String;
      Tel      : Word;
      Len      : Word;                                      { length of macro }
      Conv     : Char;                 { macro converten naar upper/lower/etc }
      Star     : Word;                                         { start at pos }
      Justi    : Char;                       { justification right/center/etc }
      Fill     : Char;                     { fill with this instead of spaces }
      T1,T2,T3 : String;                { for splitting tmplen in max 3 parts }

      Procedure ExecuteTemplates;
      Begin
        if star <> 0 then                     { template functies uitvoeren }
          tmp := last(length(tmp)-star,tmp);
        if conv <> #0 then
          case conv of
            'U' : tmp := upper(tmp);
            'L' : tmp := lower(tmp);
            'P' : tmp := proper(tmp);
            '~' : ;
          end;
        if justi <> #0 then
          begin
            case justi of
              'C' : begin
                      if len < length(tmp) then
                        begin
                          tmpbak := replicate(len-length(tmp) div 2,fill);
                          tmp := tmpbak + tmp + tmpbak;
                          if length(tmp) < len then expand(tmp,len);
                        end;
                    end;
              'R' : while length(tmp) < len do tmp := fill + tmp;
            end;
          end else
          begin
            while length(tmp) < len do tmp := tmp + fill;
          end;
        if len > 0 then tmp := first(len,tmp);
      End;


  Begin
    If not overflow then fillchar(overfl,sizeof(overfl),#0);
    Tmp := '';
    Len := 0;
    T1 := ''; T2 := ''; T3 := '';

    Case functie of                       { tmplen opsplitsen in max 3 string }
     0..4   : begin
                T1 := tmplen;
              end;
     10..16 : begin
                repeat
                  t1 := t1 + tmplen[1];
                  tmplen := last(length(tmplen)-1,tmplen);
                until (tmplen[1] = ':') or (tmplen[1] = ';') or (tmplen[1] = ',');
                t2 := last(length(tmplen)-1,tmplen);
              end;
     20..26 : begin
                repeat
                  t1 := t1 + tmplen[1];
                  tmplen := last(length(tmplen)-1,tmplen);
                until (tmplen[1] = ':') or (tmplen[1] = ';') or (tmplen[1] = ',');
                tmplen := last(length(tmplen)-1,tmplen);
                repeat
                  t2 := t2 + tmplen[1];
                  tmplen := last(length(tmplen)-1,tmplen);
                until (tmplen[1] = ':') or (tmplen[1] = ';') or (tmplen[1] = ',');
                t3 := last(length(tmplen)-1,tmplen);
              end;
    End;

    len := 0;         { len, conv, star, justi en  fill opvullen met waarden }
    conv := #0;
    star := 0;
    justi := #0;
    fill := ' ';

    Case functie of                          { opvullen met de juiste waarden }
      0      : len := str_to_int(t1);
      1..4   : begin
                 tmpbak := upper(t1);
                 conv := tmpbak[1];
               end;
      10     : begin
                 len  := str_to_int(t2);
                 star := str_to_int(t1);
               end;
      11..14 : begin
                 len := str_to_int(t2);
                 tmpbak := upper(t1);
                 conv := tmpbak[1];
               end;
      15..16 : begin
                 len := str_to_int(t2);
                 tmpbak := upper(t1);
                 justi := tmpbak[1];
               end;
      20     : begin
                 star := str_to_int(t1);
                 len := str_to_int(t2);
                 fill := t3[1];
               end;
      21..24 : begin
                 tmpbak := upper(t1);
                 conv := tmpbak[1];
                 len := str_to_int(t2);
                 fill := t3[1];
               end;
      25..26 : begin
                 tmpbak := upper(t1);
                 justi := tmpbak[1];
                 len := str_to_int(t2);
                 fill := t3[1];
               end;
    End;

    Case x of
      1 : { FILENAME }   Tmp := info.name;
      2 : { FILEEXT }    Tmp := file_split(4,info.name);
      3 : { FILESIZE }   Tmp := int_to_str(info.size);
      4 : { FILEKB }     If info.size > 1024 then
                           Tmp := int_to_str( info.size div 1024 ) else
                             Tmp := '1';
      5 : { FILECRC }    Tmp := {strhex(} info.crcstr {, 0)} ;
      6 : { FILEDESC }   Begin
                           If info.lcount = 0 then
                             Begin
                               If (len = 0) or (length(info.desc) <= len) then
                                 Begin
                                   Tmp := info.desc;
                                   Tmp := Strip('A',#0,Tmp);
                                 End Else
                                 Begin
                                   If (info.desc[len] = ' ') or (info.desc[len+1] = ' ') then
                                     Begin
                                       Tmp := first(len,info.desc);
                                       Tmp := Strip('A',#0,Tmp);
                                       If last(1,tmp) = ' ' then tmp := first(length(tmp)-1,tmp);

                                       If info.desc[len] = ' ' then
                                         Begin
                                           For tel := len+1 to length(info.desc) do
                                             Overfl[(tel)-len] := info.desc[tel];
                                         End Else
                                         Begin
                                           For tel := len+2 to length(info.desc) do
                                             Overfl[(tel-1)-len] := info.desc[tel];
                                         End;

                                       Overflow := True;
                                     End Else
                                     Begin
                                       Tmp := first(len,info.desc);
                                       tel := Length(tmp);
                                       Repeat Dec(tel) Until (Tmp[tel] = ' ') or (Tmp[tel] = #13);
                                       Tmp := first(tel,info.desc);
                                       Strip('A',#0,Tmp);

                                       If last(1,tmp) = ' ' then tmp := first(length(tmp)-1,tmp);

                                       For tel := length(tmp)+2 to length(info.desc) do
                                         Overfl[tel-(length(tmp)+1)] := info.desc[tel];

                                       Overflow := True;
                                     End;
                                 End;
                             End Else
                             Begin
                               Strip_Buffer(true);
                               If len = 0 then
                                 Begin
                                   If info.lcount > 255 then
                                     Begin
                                       For tel := 1 to 255 do
                                         Tmp := Tmp + info.ldesc[tel];
                                       For tel := 256 to info.lcount do
                                         Overfl[tel-255] := info.ldesc[tel];
                                       Overflow := true;
                                     End Else
                                     Begin
                                       For tel := 1 to info.lcount do
                                         Tmp := Tmp + info.ldesc[tel];
                                     End;
                                 End Else
                                 Begin
                                   If info.lcount <= len then
                                     Begin
                                       For Tel := 1 to info.lcount do
                                         Tmp := Tmp + info.ldesc[tel];
                                       Info.lcount := 0;
                                     End Else
                                     Begin
                                       While (length(tmp)+length(firstwordldesc) <= len) and (info.ldesc[1] <> #13) do
                                         Begin
                                           Tmpbak := Firstwordldesc;
                                           If (tmp = '') or (first(1,tmpbak) = ' ') then
                                             Tmp := Tmp + Tmpbak else
                                               Tmp := Tmp + ' ' + Tmpbak;

                                           For tel := length(tmpbak) to info.lcount do
                                              Info.ldesc[(tel-length(tmpbak))] := Info.ldesc[tel];

                                           Dec(info.lcount,length(tmpbak));
                                         End;
                                       If tmp = '' then
                                         Begin
                                           tmp := firstwordldesc;
                                           For tel := length(tmpbak)+2 to info.lcount do
                                             Info.ldesc[(tel-length(tmpbak))-1] := Info.ldesc[tel];
                                         end;

                                       For tel := 1 to info.lcount do
                                         Overfl[tel] := info.ldesc[tel];
                                       Overflow := true;
                                     End;
                                 End;
                               Tmp := Strip('A',#0,Tmp);
                             End;
                         End;
      7 : { OVERFLOW }   If overflow then
                           Begin
                             writeit(currlen);
                             Strip_Buffer(false);
                             If len = 0 then len := 255;
                             Repeat
                               While ((length(tmp)+length(firstwordoverfl) < len)
                                  or ((length(firstwordoverfl) >= len) and (tmp = ''))) and
                                     (firstwordoverfl <> '') and
                                     ((overfl[1] <> #13) or (tmp = '')) do
                                 Begin
                                   if (tmp = '') and (length(firstwordoverfl) > len) then
                                     begin
                                       tmp := firstwordoverfl;
                                       tmp := first(len,tmp);

                                       for tel := length(tmp)+1 to 2048 do
                                         overfl[tel-length(tmp)] := overfl[tel];
                                       for tel := 2048-(length(tmp)+1) to 2048 do
                                         overfl[tel] := #0;
                                     end else
                                     begin
                                       Tmpbak := FirstwordOverfl;
                                       If (tmp = '') and (first(1,tmpbak) = ' ') and setup.wrapdesc then
                                         tmp := strip('L',' ',tmpbak) else
                                           Tmp := Tmp + Tmpbak;

                                       if overfl[1] = #13 then tmpbak := #13+Tmpbak;

                                       For tel := length(Tmpbak)+1 to 2048 do
                                         Overfl[tel-(length(tmpbak))] := Overfl[tel];

                                       For tel := 2048-(length(tmpbak)+1) to 2048 do
                                         Overfl[tel] := #0;
                                     end;
                                 End;
                               If not FormattedDescription then tmp := Strip('L',' ',tmp);
                               If firstwordoverfl <> '' then
                                 Begin
                                   executetemplates;
                                   tmp := strip('A',#0,tmp);
                                   writeit(strip('R',' ',tmp)+#13#10);
                                   writeit(currlen);
                                   tmp := '';
                                 End else Tmp := strip('R',' ',tmp);

                             Until firstwordoverfl = '';
                             Currlen := '';
                           End;
      8 : { FILEORIGIN } Tmp := node2str(info.origin);
      9 : { FILEFROM }   Tmp := node2str(info.from);
     10 : { FILEPATH }   Begin
                           for tel := 1 to info.cpath do
                             tmp := tmp + node2str(info.path[tel])+' ';
                           tmp := strip('B',' ',tmp);
                         End;
     11 : { FILEREPL }   Tmp := info.replaces;
     12 : { FILEMAGIC }  Tmp := info.magic;
     13 : { FILEEXPORT } If info.expo = 0 then tmp := '0' else
                           Tmp := int_to_str(info.expo);
     14 : { FILENODES }  Begin
                            Tmp := '';
                            AFXinx := 0;
                            While (AFXinx <= Areaidx) and (info.area <> afxt^[afxinx].tag) do
                              Inc(AFXinx);

                            If afxinx <= areaidx then
                              begin
                                GetArea(AFXinx);
                                For tel := 1 to area.exportnr do
                                  begin
                                    if (not NodeEQ(info.From, sfxt^[tel].A)) and
                                       (not nodeeq(info.origin, sfxt^[tel].a)) and
                                       (export in sfxt^[tel].s) then tmp := tmp + node2str(sfxt^[tel].a)+' ';
                                  end;
                              end;
                           tmp := strip('B',' ',tmp);
                         End;
     15 : { FILEDATE }   Tmp := datestring(info.date);
     16 : { AREATAG }    if info.area = '' then
                           Tmp := area.name else    {voor filefind}
                             Tmp := info.Area;      {default}
     17 : { AREANAME }   If (info.area <> '') {and (AreaNr <> 0)} then
                           Begin
                             AFXinx := 1;
                             While (AFXinx <= Areaidx) and
                                   (AFXt^[AFXinx].TAG <> INFO.Area) do Inc (AFXinx);
                             If Afxinx <= Areaidx then
                               Begin
                                 GetArea (AFXinx);
                                 Tmp := AREA.Name;
                               End Else Tmp := info.area;
                           End Else {voor filefind}
                             Tmp := Area.name;
     18 : { GROUPTAG }   Tmp := int_to_Str(info.grp);
     19 : { GROUPNAME }  If info.grp <> 0 then
                           Begin
                             Seek (GF,0);
                             Group.groupnr := 0;
                             While (not EOF(GF)) and (Group.groupnr <> info.grp) do Read(GF, GROUP);
                             If Group.groupnr = info.Grp
                               then Tmp := Group.groupName
                                 else Tmp := '[unknown group]';
                           End Else Tmp := info.area;
     20 : { SYSOPFIRST } Tmp := extractwords(1,1,setup.sysopname);
     21 : { SYSOP }      Tmp := setup.sysopname;
     22 : { SYSTEM }     Tmp := setup.systemname;
     23 : { AKA }        Tmp := Node2Str(setup.address[AKA]);
     24 : { QUOTE }      Tmp := GetQuote;

     25 : { HOUR }       Tmp := int_to_str(Today.Hour);
     26 : { MIN }        Tmp := int_to_str(Today.Min);
     27 : { SEC }        Tmp := int_to_str(Today.Sec);
     28 : { DD }         If Today.Day < 10 then          {vbc 070308 - fix for dd,mm,yy = 01-09  }
                           Tmp := '0'+int_to_str(Today.Day) else
                           Tmp := int_to_str(Today.Day);
     29 : { D3 }         Tmp := first(3,setup.dayarray[today.dow+1]); {Days3[Today.DOW];}
     30 : { DAY }        Tmp := setup.dayarray[Today.DOW+1];
     31 : { MM }         If Today.Month < 10 then
                           Tmp := '0'+int_to_str(Today.Month) else
                           Tmp := int_to_str(Today.Month);
     32 : { M3 }         Tmp := first(3,setup.montharray[Today.Month]);
     33 : { MONTH }      Tmp := setup.Montharray[Today.Month];
     34 : { YY }         If Today.Year-2000 < 10 then
                           Tmp := '0'+int_to_str(Today.Year-2000) else
                           Tmp := int_to_str(Today.Year-2000);
     35 : { Y4 }         Tmp := int_to_str(Today.Year);
     36 : { DNR }        Tmp := daynumber;
     37 : { PROGRAM }    Tmp := 'FileMgr v' + versionstr(setup.VERSION)+Build;
     38 : { MSGTO }      Tmp := Msgto;
     39 : { MSGFIRST }   Tmp := Extractwords(1,1,msgto);
     40 : { FSEARCH }    Tmp := SearchArg;

     41 : { BLOCKCOUNT } Tmp := int_to_str(BlockCount);
     42 : { BLOCKSIZE }  Tmp := int_to_str(BlockSize);
     43 : { BLOCKKB }    If blocksize > 1024 then
                           Tmp := int_to_str( blocksize div 1024 ) else
                             Tmp := '1';
     44 : { BLOCKMB }    If blocksize > (1024*1024) then
                           Tmp := int_to_str( (blocksize div 1024) div 1024 ) else
                             Tmp := '1';
     45 : { TOTALCOUNT } Tmp := int_to_str(TotalCount);
     46 : { TOTALSIZE }  Tmp := int_to_str(TotalSize);
     47 : { TOTALKB }    If totalsize > 1024 then
                           Tmp := int_to_str( totalsize div 1024 ) else
                             Tmp := '1';
     48 : { TOTALMB }    If totalsize > (1024*1024) then
                           Tmp := int_to_str( (totalsize div 1024) div 1024 ) else
                             Tmp := '1';
     49 : { CREDITSLEFT }Tmp := real_to_str(node.credit,0);
     50 : { CREDITSWARN }Tmp := int_to_str(node.warnlevel);
     51 : { CREDITSSTOP }Tmp := int_to_str(node.stoplevel);
    End;

    if tmp <> '' then ExecuteTemplates;

    if overflow and (firstwordoverfl = '') then
      begin
        overflow := false;
        currlen := '';
      end;

    Writeit(tmp);                                  {keyword wegschrijven}
  End;

Begin
  Randomize;

  getdate (today.year, today.month, today.day, today.dow);
  gettime (today.hour, today.min, today.sec, today.hs);

  Assign(T,checkepath(setup.tplpath,true)+tplname);                            { open tpl file }
  {$I-} Reset(T); {$I+}
  If ioresult <> 0 then
    Begin
      Assign(T,tplname);
      {$I-} reset(t); {$I+}
      If ioresult <> 0 then
        Begin
          notifycr(1,'');
          NotifyCr(1,'Cannot open tpl file '+tplname);
          Exit;
        end;
    End;

  notoverflow := false;
  Overflow  := False;
  Keyword   := '';
  TmpLen    := '';
  Functie   := 0;
  Currlen   := '';              {positie/column van huidige regel ivm overflow}

  While not eof(T) do
    Begin
      Readln(T,Ch);

      Repeat

        If pos('@',ch) <> 0 then
          begin
            keyword := extractwords(1,1, last(length(ch)-(pos('@',ch)),ch) );
            currlen := first(pos('@',ch)-1,ch);
            if currlen <> '' then ch := last(length(ch)-length(currlen),ch);
            if ch <> '' then ch := last(length(ch)-(length(keyword)+1),ch);

            if (pos('(',keyword) <> 0) and (pos(')',keyword) <> 0) then
              begin
                tmplen := first(pos(')',keyword),keyword);
                keyword := last(length(keyword)-length(tmplen),keyword);

                tmplen := first(length(tmplen)-1,tmplen);
                tmplen := last(length(Tmplen)-1,tmplen);

                TmpBak := Upper(TmpLen);
                If word_1(tmplen) then
                  Begin
                    Case tmpbak[1] of
                      'U' : functie := 1; {upper}
                      'L' : functie := 2; {lower}
                      'P' : functie := 3; {proper}
                      '~' : functie := 4; {reverse}
                      Else functie := 0; {length}
                    End;
                  End Else
                If word_2(tmplen) then
                  Begin
                    Case tmpbak[1] of
                      'U' : functie := 11; {upper, length}
                      'L' : functie := 12; {lower, length}
                      'P' : functie := 13; {proper, length}
                      '~' : functie := 14; {reverse, length}
                      'R' : functie := 15; {rjusti, length}
                      'C' : functie := 16; {cjusti, length}
                      Else functie := 10; {start, length}
                    End;
                  End Else
                  Begin {3 word}
                    Case tmpbak[1] of
                      'U' : functie := 21; {upper, length, fill}
                      'L' : functie := 22; {lower, length, fill}
                      'P' : functie := 23; {proper, length, fill}
                      '~' : functie := 24; {reverse, length, fill}
                      'R' : functie := 25; {rjusti, length, fill}
                      'C' : functie := 26; {cjusti, length, fill}
                      Else functie := 20; {start, length, fill}
                    End;
                  End;

              end; { if pos('(',keyword <> ... }

          end else { if pos('@',ch) <> ... }
          begin
            currlen := ch;
            keyword := '';
            ch := '';
          end;

        notoverflow := false;

        If keyword <> '' then
          Begin
            Found := false;

            For X := 1 to MetaNr do           {controleren of keyword nu vol is}
              If pos(upper(metastring[x]),Upper(Keyword)) = 1 then
                Begin                                            {is vol}
                  found := true;

                  while length(keyword) > length(metastring[x]) do
                    Begin
                      ch := last(1,keyword) + ch;
                      keyword := first(length(keyword)-1,keyword);
                    End;

                  If (upper(keyword) = 'OVERFLOW') and not overflow then notoverflow := true else
                    Begin
                      if upper(keyword) <> 'OVERFLOW' then WriteIt(currlen);
                      WriteKeyword(x);   {write keyword}
                    End;

                  currlen := '';
                  Keyword := '';
                  If not overflow then
                    Begin
                      Functie := 0;
                      TmpLen := '';
                    End;
                End;

            if not found then writeit(currlen+'@'+keyword);

          End Else  { if keyword <> ... }
          Begin
            WriteIt(currlen);
          End;
      Until Ch = '';
      If not notoverflow then WriteIt(#13#10);
    End; {eof}

  Close(T);
End;


Procedure Empty_Tpl ( tplname:string;
                      usetplfile:boolean;
                      aka:byte;
                      msgto:string );
Var
  Info : announcelinktype;
Begin
  Fillchar(info,sizeof(info),#0);
  Convert_Tpl( tplname, info, usetplfile, aka, msgto );
End;


End.

