{
 $Id$
}
{*****************************************************************************
 *
 *
 * Produce:  Check for variant or version of Operating system
 *  Warning : contains inline assembler / machine code
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_MTask; { multitasking handler }

{$O+}

Interface

uses s_string;

procedure WriteMTaskInfo(var T: Text);

Implementation

{- string to version number conversion ---------------------------------------}

  const
    sBCD : Array[0..15] of Char = '0123456789xxxxxx';

  function sBCDword(w: Word): String;
    function sBCDnibble(b: Byte; LeadZero: Boolean): String;
    begin
      if (B = 0) and not LeadZero then
        sBCDnibble := ''
      else
        sBCDnibble := sBCD[b];
    end;
  begin
    sBCDword :=  sBCDnibble(hi(w) shr 4,  False) +
                 sBCDnibble(hi(w) and $F, True)  + '.' +
                 sBCDnibble(lo(w) shr 4,  True)  +
                 sBCDnibble(lo(w) and $F, True);

  end;

  function s100word(w: Word): String;
    function sDigit(b: Byte; LeadZero: Boolean): String;
    begin
      if (B = 0) and not LeadZero then
        sDigit := ''
      else
        sDigit := sBCD[b mod 10];
    end;
  begin
    s100word :=  sDigit(hi(w) div 10, False) +
                 sDigit(hi(w),        True)  + '.' +
                 sDigit(lo(w) div 10, True)  +
                 sDigit(lo(w),        True);
  end;

  { -- windows -- }

  var
    m1600Result:  Word;
    m160AResult:  Word;
    m160AVersion: Word;
    m160AMode:    Word;
    m4680Result:  Word;

  function inWin: Boolean;
  begin
    asm
      mov AX, $1600
      int $2F
      mov m1600Result,  AX
      mov AX, $160A
      int $2F
      mov m160AResult,  AX
      mov m160AVersion, BX
      mov m160AMode,    CX
      mov AX, $4680
      int $2F
      mov m4680Result,  AX
    end;
    inWin := (lo(m1600Result) <> 0) or
             (m160AResult = 0) or
             (m4680Result = 0);
  end;

  procedure WriteWin(var T: Text);
  begin
    Write (T, '  MS-Windows');
    if m160AResult = 0 then
      begin { Win 3.1 or higher }
        If m1600result = 4 then
          begin
            Writeln(t,' 95 '+s100word(m160AVersion));
          end else
          begin
            Write (T,' ',s100word(m160AVersion));
            case m160AMode of
              2: Write(T, ' standard');
              3: Write(T, ' enhanced');
              else Write (T, ' unknown (',m160AMode,')');
            end;
            Writeln (T, ' mode');
          end;
      end else
      begin
        if lo(m1600Result) <> 0 then
          begin { Windows/386 2.x or Windows 3.0 in enhanced mode }
            case m1600Result of
             1, $FF: Writeln(T, '/386 Version 2.x');
             else    Writeln(T, ' ',s100word(m1600Result));
            end;
          end else
          begin { Windows 3.0 in standard or real mode }
            Writeln(T, ' 3.0');
          end;
      end;
  end;

(*
--------W-2F1600-----------------------------
INT 2F - MS Windows - WINDOWS ENHANCED MODE INSTALLATION CHECK
        AX = 1600h
Return: AL = status
            00h neither Windows 3.x enhanced mode nor Windows/386 2.x running
            01h Windows/386 2.x running
            80h XMS version 1 driver installed (neither Windows 3.x enhanced
                 mode nor Windows/386 2.x running) (obsolete--see note)
            FFh Windows/386 2.x running
        AL = anything else
            AL = Windows major version number >= 3
            AH = Windows minor version number
Notes:  INT 2F/AH=16h comprises an API for non-Windows programs (DOS device
          drivers, TSRs, and applications) to cooperate with multitasking
          Windows/386 2.x and Windows 3.x and higher enhanced mode.
        certain calls are also supported in the Microsoft 80286 DOS extender in
          Windows standard mode
        this function served as the installation check and AX=1610h served to
          get the driver entry point for XMS version 1, which is now obsolete.
          Use AX=4300h and AX=4310h instead
SeeAlso: AX=160Ah,AX=1610h,AX=4300h,AX=4680h
Index:  installation check;XMS version 1
--------W-2F160A-----------------------------
INT 2F - MS Windows 3.1 - IDENTIFY WINDOWS VERSION AND TYPE
        AX = 160Ah
Return: AX = 0000h if call supported
            BX = version (BH=major, BL=minor)
            CX = mode (0002h = standard, 0003h = enhanced)
SeeAlso: AX=1600h,AX=4680h
--------W-2F4680-----------------------------
INT 2F U - MS Windows v3.0 - INSTALLATION CHECK
        AX = 4680h
Return: AX = 0000h MS Windows 3.0 running in real (/R) or standard (/S) mode,
                   or DOS 5 DOSSHELL active
           nonzero  no Windows, Windows prior to 3.0, or Windows3 in enhanced
                    mode
Note:   Windows 3.1 finally provides an installation check which works in all
          modes (see AX=160Ah)
SeeAlso: AX=1600h,AX=160Ah
 *)
   { -- DESQview -- }

  var
    d212BResult:   Byte;
    d212BVersion:  Word;
    c15DE07Window: Word;

  function inDv: Boolean;
  begin
    asm
      mov AH, $2B
      mov AL, $01
      mov CX, $4445; { 'DE' }
      mov DX, $5351; { 'SQ' }
      int $21
      mov d212BResult,  AL
      cmp BX, $0002  { fix old DV 2.00 version bug }
      jne @StoreVersion
      mov BX, $0200
    @StoreVersion:
      mov d212BVersion, BX
      mov c15DE07Window,  0
      mov AX, $DE07
      int $15
      mov c15DE07Window, AX
    end;
    inDv := d212BResult <> $FF;
  end;

  procedure WriteDv(var T: Text);
  begin
    Write (T, '  DESQview Version ',s100word(d212BVersion));
    if d212BVersion >= 2 then
      Writeln(T, ' (window ',c15DE07Window,')')
    else
      Writeln(T);
  end;

(*
--------Q-212B--CX4445-----------------------
INT 21 - DESQview - INSTALLATION CHECK
        AH = 2Bh
        CX = 4445h ('DE')
        DX = 5351h ('SQ')
        AL = subfunction (DV v2.00+)
            01h get version
                Return: BX = version (BH = major, BL = minor)
                Note: early copies of v2.00 return 0002h
Return: AL = FFh if DESQview not installed
Notes:  in DESQview v1.x, there were no subfunctions; this call only identified
          whether or not DESQview was loaded.  DESQview v2.52 performs function
          01h for all subfunction requests 0Ch and higher and appears to ignore
          all lower-numbered functions not listed here.
        DESQview versions 2.5x are part of DESQview/X v1.0x.
BUG:    subfunction 05h does not appear to work correctly in DESQview 2.52
SeeAlso: INT 10/AH=FEh,INT 10/AH=FFh,INT 15/AX=1024h,INT 15/AX=DE30h
--------Q-15DE07-----------------------------
INT 15 - DESQview - "APPNUM" - GET CURRENT PROGRAM'S NUMBER
        AX = DE07h
Return: AX = number of program as it appears on the "Switch Windows" menu
Note:   this API call may be made from a hardware interrupt handler
SeeAlso: AX=DE00h
 *)

   { -- 4DOS -- }

  var
    mD44DResult:  Word;
    mD44DVersion: Word;
    mD44DShell:   Byte;

  function in4DOS: Boolean;
  begin
    asm
      mov AX, $D44D
      mov BH, 0
      int $2F
      mov mD44DResult,  AX
      mov mD44DVersion, BX
      mov mD44DShell,   DL
    end;
    in4DOS := mD44DResult = $44DD;
  end;

  procedure Write4DOS(var T: Text);
  begin
    Writeln(T, '  4DOS Version ',s100word(swap(mD44DVersion)),' shell number ',MD44DShell);
  end;

(*
--------l-2FD44D-----------------------------
INT 2F - 4DOS.COM v2.1+ - API
        AX = D44Dh
        BH = function
            00h installation check
                Return: AX = 44DDh
                        BL = major version number
                        BH = minor version number
                        CX = PSP segment address for current invocation
                        DL = 4DOS shell number (0 for the first (root) shell,
                             updated each time a new copy is loaded)
Note:   bug in v3.00 will crash system if unrecognized value in BH
SeeAlso: AX=D44Eh,AX=E44Dh,INT 21/AX=4403h
Index:  installation check;4DOS|installation check;NDOS
 *)

   { -- DOS -- }

  var
    d3000Version: Word;
    d3000OEM:     Byte;
    d3000ROM:     Byte;
    d4452Type:    Byte;
    d4452ID:      Byte;
    d3306TrueDos: Byte;
    d3306Version: Word;
    d3306Rev:     Byte;
    d3306Memory:  Byte;

  function inDOS: Boolean;
  begin
    asm
      mov AX, $3000
      mov BH, 0
      int $21
      mov d3000Version, AX
      mov d3000OEM, BH
      mov AX, $3001
      int $21
      mov d3000ROM, BH
      mov AX, $4452  { "DR" }
      stc
      int $21
      jc  @haveNoDrDos
    @haveDrDos:
      mov d4452Type,    AH
      mov d4452ID,      AL
      jmp @end
    @haveNoDrDos:
      mov d4452Type, 0
      mov d4452ID,   0

      mov AX, $3306
      int $21
      jnc @storeMsDosInfo

      { this is Dr-DOS }
      mov AL, $FF
    @storeMsDosInfo:
      mov d3306TrueDos, AL
      mov d3306Version, BX
      mov d3306Rev,     DL
      mov d3306Memory,  DH
    @end:
    end;
    inDOS := True;
  end;

  procedure WriteDOS(var T: Text);
  var str : string;
  begin
    Write (T, '  ');
    str := '';

    if d3000Version = $1F03 then
      begin { compaq Version 3.31 }
        str := ' Compaq OEM ';
      end else
      begin
        if (lo(d3000Version) >= $02) and (lo(d3000Version) <= $04) then
          begin { OEM number (as for DOS 2.0-4.0x) }
            case d3000OEM of
              $00: str := 'IBM';
              $01: str := 'Compaq';
              $02: str := 'MS Packaged Product';
              $04: str := 'AT&T';
              $05: str := 'Zenith';
              $06: str := 'Hewlett-Packard';
              $0D: str := 'Packard-Bell';
              $16: str := 'DEC';
              $23: str := 'Olivetti';
              $29: str := 'Toshiba';
              $33: str := 'Novell';
              $34,
              $35: str := 'MS Multimedia Systems';
              $4D: str := 'Hewlett-Packard';
              $66: str := 'PhysTechSoft (PTS-DOS)';
              $99: str := 'General Software''s Embedded';
              $FF: str := 'MS-DOS or Phoenix';
              else str := 'unknown';
            end;
            str := str + ' OEM ';
          end else { MS-DOS } str := 'MS-';
      end;
    str := str + 'DOS '+s100word(swap(d3000Version));

    {-OS/2-}
    if (lo(D3000Version) = 10) or (lo(D3000Version) = 20) then
      Begin
        str := 'OS/2 Version '+int_to_str(lo(d3000Version) div 10)
               +'.'+int_to_str(hi(d3000Version) div 10)+' (DOS Box)';
      End else
      Begin  {-DR-DOS-}
        if d4452Type <> 0 then
          Begin
            Case d4452Type of
              $10: Case d4452Id of
                     $32: str := 'Concurrent PC DOS 3.2';
                     $41: str := 'Concurrent DOS 4.1';
                     $50: str := 'Concurrent DOS/XM 5.0'; {or Concurrent DOS/386 1.1';}
                     $60: str := 'Concurrent DOS/XM 6.0'; {or Concurrent DOS/386 2.0');}
                     $62: str := 'Concurrent DOS/XM 6.2'; {or Concurrent DOS/386 3.0');}
                     $66: str := 'DR Multiuser DOS 5.1';
                     $67: str := 'Concurrent DOS 5.1';
                   end;
              $14: Case d4452Id of
                     $60: str := 'DOS Plus';
                     $63: str := 'DR-DOS 3.41';
                     $64: str := 'DR-DOS 3.42';
                     $65: str := 'DR-DOS 5.00';
                     $67: str := 'DR-DOS 6.00';
                     $70: str := 'PalmDOS';
                     $71: str := 'DR-DOS 6.0 March 1993';
                     $72: str := 'Novell DOS 7.0';
                   end;
              Else str := 'DR-DOS';
            End;
          End else { DR-DOS }
          Begin
            if (lo(d3000Version) >= 5) or (d3306TrueDos <> $FF) then
              begin
                if (d3000ROM and $8 = $8) or (d3306Memory and $8 = $8) then
                  str := str + ' in ROM' else
                    begin
                      if (d3306TrueDOS <> $FF) and (d3306Memory and $10 = $10) then
                        str := str + ' in HMA' else
                          str := str + ' in RAM';
                    End;
              End;
          End;
      End;
    Writeln(T, str);
  End;

(*
--------D-2130-------------------------------
INT 21 - DOS 2+ - GET DOS VERSION
        AH = 30h
---DOS 5+ ---
        AL = what to return in BH
            00h OEM number (as for DOS 2.0-4.0x)
            01h version flag
Return: AL = major version number (00h if DOS 1.x)
        AH = minor version number
        BL:CX = 24-bit user serial number (most versions do not use this)
---if DOS <5 or AL=00h---
        BH = MS-DOS OEM number (see below)
---if DOS 5+ and AL=01h---
        BH = version flag
            bit 3: DOS is in ROM
            other: reserved (0)
Notes:  the OS/2 v1.x Compatibility Box returns major version 0Ah (10)
        the OS/2 v2.x Compatibility Box returns major version 14h (20)
        the Windows/NT DOS box returns version 5.00, subject to SETVER
        DOS 4.01 and 4.02 identify themselves as version 4.00; use
          INT 21/AH=87h to distinguish between the original European MS-DOS 4.0
          and the later PC-DOS 4.0x and MS-DOS 4.0x
        generic MS-DOS 3.30, Compaq MS-DOS 3.31, and others identify themselves
          as PC-DOS by returning OEM number 00h
        the version returned under DOS 4.0x may be modified by entries in
          the special program list (see AH=52h)
        the version returned under DOS 5+ may be modified by SETVER; use
          AX=3306h to get the true version number
SeeAlso: AX=3000h/BX=3000h,AX=3306h,AX=4452h,AH=87h,INT 15/AX=4900h
SeeAlso: INT 2F/AX=122Fh,INT 2F/AX=E002h

Values for MS-DOS OEM number:
 00h    IBM
 01h    Compaq
 02h    MS Packaged Product
 04h    AT&T
 05h    Zenith
 06h    Hewlett-Packard
 0Dh    Packard-Bell
 16h    DEC
 23h    Olivetti
 29h    Toshiba
 33h    Novell (Windows/386 device IDs only)
 34h    MS Multimedia Systems (Windows/386 device IDs only)
 35h    MS Multimedia Systems (Windows/386 device IDs only)
 4Dh    Hewlett-Packard
 66h    PhysTechSoft (PTS-DOS)
 99h    General Software's Embedded DOS
 FFh    Microsoft, Phoenix
--------O-214451-----------------------------
INT 21 - Concurrent DOS v3.2+ - INSTALLATION CHECK
        AX = 4451h
Return: CF set if not Concurrent DOS
            AX = error code (see AH=59h)
        CF clear if successful
            AH = single-user/multiuser nature
                10h single-user
                    AL = operating system version ID (see AX=4452h)
                14h multiuser
                    AL = operating system version ID (see below)
Notes:  as of Concurrent DOS/XM 5.0 (possibly earlier), the version is stored
          in the environment variable VER
        use this function if you are looking for multiuser capabilities,
          AX=4452h for single-user
        this function should never return the single-user values
SeeAlso: AX=4452h,AX=4459h

Values for operating system version ID:
 32h    Concurrent PC DOS 3.2
 41h    Concurrent DOS 4.1
 50h    Concurrent DOS/XM 5.0 or Concurrent DOS/386 1.1
 60h    Concurrent DOS/XM 6.0 or Concurrent DOS/386 2.0
 62h    Concurrent DOS/XM 6.2 or Concurrent DOS/386 3.0
 66h    DR Multiuser DOS 5.1
 67h    Concurrent DOS 5.1
--------O-214452-----------------------------
INT 21 - DR-DOS 3.41+ - DETERMINE DOS TYPE/GET DR-DOS VERSION
        AX = 4452h ("DR")
        CF set
Return: CF set if not DR-DOS
            AX = error code (see AH=59h)
        CF clear if DR-DOS
            DX = AX = version code
            AH = single-user/multiuser nature
                10h single-user
                    AL = operating system version ID (see below)
                14h multiuser
                    AL = operating system version ID (see AX=4451h)
Notes:  the DR-DOS version is stored in the environment variable VER
        use this function if looking for single-user capabilities, AX=4451h
          if looking for multiuser; this call should never return multiuser
          values
SeeAlso: AX=4412h,AX=4451h,AX=4459h

Values for operating system version ID:
 60h    DOS Plus
 63h    DR-DOS 3.41
 64h    DR-DOS 3.42
 65h    DR-DOS 5.00
 67h    DR-DOS 6.00
 70h    PalmDOS
 71h    DR-DOS 6.0 March 1993 "business update"
 72h    Novell DOS 7.0
--------D-213306-----------------------------
INT 21 - DOS 5+ - GET TRUE VERSION NUMBER
        AX = 3306h
Return: BL = major version
        BH = minor version
        DL = revision (bits 2-0, all others 0)
        DH = version flags
            bit 3: DOS is in ROM
            bit 4: DOS in in HMA
        AL = FFh if true DOS version < 5.0
Notes:  this function always returns the true version number, unlike AH=30h,
          whose return value may be changed with SETVER
        because of the conflict from the CBIS PowerLAN redirector (see next
          entry), programs should check whether BH is less than 100 (64h)
          and BL is at least 5 before accepting the returned BX as the true
          version number; however, even this is not entirely reliable when
          that redirector is loaded
        fully reentrant
        OS/2 v2.1 will return BX=0A14h (version 20.10)
        the Windows NT DOS box returns BX=3205h (version 5.50)
BUG:    DR-DOS 5.0 and 6.0 return CF set/AX=0001h for INT 21/AH=33h
          subfunctions other than 00h-02h and 05h, while MS-DOS returns AL=FFh
          for invalid subfunctions
SeeAlso: AH=30h,INT 2F/AX=122Fh
--------N-213306-----------------------------
 *)

   { -- XMS -- }

  var
    m4300Result:  Byte;
    m4310Entry:   Pointer;
    mXMSVersion:  Word;
    mXMSRevision: Word;
    mXMShasHMA:   Word;

  function inXMS: Boolean;
  begin
    asm
      mov AX, $4300
      int $2F
      mov m4300Result,  AL
      cmp AL, $80
      jne @noXMS
      mov AX, $4310
      int $2F
      mov word ptr [m4310Entry],   BX
      mov word ptr [m4310Entry+2], ES
      mov AH, 0
      call [m4310Entry]
      mov mXMSVersion,  AX
      mov mXMSRevision, BX
      mov mXMShasHMA,   DX
      jmp @end
    @noXMS:
      xor AX, AX
      mov word ptr [m4310Entry],   AX
      mov word ptr [m4310Entry+2], AX
      mov mXMSVersion,  0
      mov mXMSRevision, 0
      mov mXMShasHMA,   0
    @end:
    end;
    inXMS := m4300Result = $80;
  end;

  procedure WriteXMS(var T: Text);
  begin
    Write(T, '  XMS Version ',sBCDword(mXMSVersion)
            , ' (Rev ',sBCDword(mXMSRevision));
    if mXMShasHMA <> 0 then begin
      write(T, ' with HMA');
    end;
    Writeln(T, ')');
  end;

(*
--------m-2F4300-----------------------------
INT 2F - EXTENDED MEMORY SPECIFICATION (XMS) v2+ - INSTALLATION CHECK
        AX = 4300h
Return: AL = 80h XMS driver installed
        AL <> 80h no driver
SeeAlso: AX=4310h
Index:  installation check;XMS version 2+
--------m-2F4310-----------------------------
INT 2F - EXTENDED MEMORY SPECIFICATION (XMS) v2+ - GET DRIVER ADDRESS
        AX = 4310h
Return: ES:BX -> driver entry point
Note:   HIMEM.SYS v2.77 chains to previous handler if AH is not 00h or 10h
SeeAlso: AX=4300h

Perform a FAR call to the driver entry point with AH set to the function code
        AH      function
        00h  Get XMS version number
             Return: AX = XMS version (in BCD, AH=major, AL=minor)
                     BX = internal revision number
                     DX = 0001h if HMA (1M to 1M + 64K) exists
                          0000h if HMA does not exist
 *)

   { -- EMS -- }

  type
    char8 = array[0..7] of Char;
    pEMSvectorRec = ^tEMSvectorRec;
    tEMSvectorRec = record
      dummy: array[0..9] of Byte;
      signature: char8;
    end;

  const
    cEMSsignature = 'EMMXXXX0';
    cEMSint = $67;

  var
    mEMSVersion:  Byte;

  function inEMS: Boolean;
  var
    EMSvectorRec: pEMSvectorRec;
  begin
    asm
      mov AH, $35
      mov AL, cEMSint
      int $21
      mov [word ptr EMSvectorRec], 0
      mov [word ptr EMSvectorRec+2], ES
    end;
    inEMS := False;
    if EMSvectorRec <> nil then
      if EMSvectorRec^.signature = cEMSsignature then begin
        inEMS := True;
        asm
          mov mEMSversion, 0
          mov AH, $46
          int cEMSint
          cmp AH, 0
          jne @end
          mov mEMSversion, AL
        @end:
        end;
      end;
  end;

  procedure WriteEMS(var T: Text);
  begin
    Writeln(T, '  EMS Version ', mEMSVersion shr 4, '.', mEMSversion and $F);
  end;

(*
  Function EMSArray.Ems_installed : Boolean;
    Var
      Emm_Device_Name       : string[8];
      Int_67_Device_Name    : string[8];
      Position              : integer;
      Regs                  : registers;
    Begin
        Int_67_Device_Name := '';
        Emm_Device_Name    := 'EMMXXXX0';
        with Regs do
         Begin
          {------------------------------------------------------}
          {   Get the code segment pointed to by interrupt 67h,  }
          {   the EMM interrupt by using DOS function 35h.       }
          {   (get interrupt vector)                             }
          {------------------------------------------------------}
          AH := $35;
          AL := EMM_INT;
          Intr (DOS_int,Regs);
          For Position := 0 to 7 do
            Int_67_Device_Name :=
                    Int_67_Device_Name+Chr (mem[ES:Position+$0A]);
          {------------------------------------------------------}
          {   If the string is the EMM manager signature,        }
          {   'EMMXXXX0', then EMM is installed and ready for    }
          {   use.  If not, then EMM is not present.             }
          {------------------------------------------------------}
          If Int_67_Device_Name = Emm_Device_Name
            then Ems_Installed := True
          Else   Ems_Installed := False
        end; { with Regs do }
    End;
--------m-6746-------------------------------
INT 67 - LIM EMS - GET EMM VERSION
        AH = 46h
Return: AH = status (00h,80h,81h,84h) (see AH=40h)
        AL = EMM version number if AH=00h
 *)

  procedure WriteMTaskInfo(var T: Text);
  begin
    if inWin  then WriteWin  (T);
    if inDV   then WriteDv   (T);
    if inEMS  then WriteEMS  (T);
    if inXMS  then WriteXMS  (T);
    if in4DOS then Write4DOS (T);
    if inDOS  then WriteDOS  (T);
  end;

end.



(*
--------N-7A----BX0010-----------------------interrup.j---
INT 7A - Novell NetWare - SPX Driver - INSTALLATION CHECK
        BX = 0010h
        AL = 00h
Return: AL = FFh if SPX loaded
            BH = SPX major version
            BL = SPX minor version
            CX = maximum SPX connections
            DX = SPX connections available
Note:   this function is supported by Advanced NetWare 2.1+
SeeAlso: BX=0015h
--------N-2FB809-----------------------------interrup.g---
INT 2F - LANtastic Network, NetWare Lite - VERSION CHECK
        AX = B809h
Return: AH = major version
        AL = minor version (decimal)
Notes:  this function is also supported by SilverNET
        NetWare Lite returns its own version number rather than a PC LAN
          compatibility version
SeeAlso: AX=4E53h,AX=B800h,AX=B809h"LAN Manager"
--------N-2FB809-----------------------------interrup.g---
INT 2F - PC LAN Program - VERSION CHECK
        AX = B809h
Return: AH = minor version (decimal)
        AL = major version
Notes:  this function is also supported in this form by LAN Manager, the DOS
          LAN Requester, and 10NET v5.0
        10NET returns version 1.10 (AX=0A01h) for compatibility
SeeAlso: AX=4E53h,AX=B800h,AX=B809h"LANtastic"
--------N-2FB80F-----------------------------interrup.g---
INT 2F - DOS LAN Requester - GET START PARAMETERS
        AX = B80Fh
        CX = size of return data buffer
        ES:DI -> return data buffer
Return: AX = status
             00h     network started
             nonzero network not started
        CX = number of bytes returned in buffer
        ES:DI buffer filled

Format of return data buffer:
Offset  Size    Description
 00h    BYTE    major version
 01h    BYTE    minor version
 02h    WORD    configuration flags given when network was started (see below)
 04h 15 BYTEs   NET START machine name (space padded)
 13h    BYTE    00h
 14h 9  BYTEs   NET START domain name (NULL padded)
 1Dh    BYTE    00h
 1Eh 32 BYTEs   /WRK heuristics string (space padded, not terminated)
 3Eh    WORD    /SRV value
 40h    WORD    /ASG value
 42h    WORD    /NBC value
 44h    WORD    /NBS value
 46h    WORD    /BBC value
 48h    WORD    /BBS value
 4Ah    WORD    /PBC value
 4Ch    WORD    /PBS value
 4Eh    WORD    /PFS value
 50h    WORD    /PFT value
 52h    WORD    /PWT value
 54h    WORD    /KUC value
 56h    WORD    /KST value
 58h    WORD    /NVS value
 5Ah    WORD    /NMS value
 5Ch    WORD    /NDB value
 5Eh    WORD    /MBI value
 60h    BYTE    NetBIOS name number for machine name
 61h    BYTE    NetBIOS name number for domain name
 62h    WORD    NetBIOS sessions required for configuration
 64h    WORD    NetBIOS commands required for configuration
 66h    WORD    NetBIOS names required for configuration
 68h 128 BYTEs  NET START path (LANROOT)
 E8h    BYTE    00h

Bitfields for configuration flags:
 bit 0  /NVS nonzero
 bit 1  /NMS nonzero
 bit 2  /API
 bit 3  /HIM
 bit 4  /LIM
 bit 5  /ENC
 bit 6  /POP
 bit 7  /EMS
 bit 8  /RPL
 bits 9-12 reserved
 bit 13 RDR started
 bit 14 RCV started
 bit 15 User is currently logged on
--------V-2FBC06-----------------------------interrup.g---
INT 2F U - MS Windows 3.0, DOS 5+ EGA.SYS - GET VERSION INFO
        AX = BC06h
Return: BX = 5456h ("TV")
        CH = major version
        CL = minor version
        DL = revision
SeeAlso: AX=BC00h"EGA",INT 10/AH=FAh"EGA"
--------N-2FD800-----------------------------interrup.g---
INT 2F U - Novell NetWare Lite - CLIENT.EXE - INSTALLATION CHECK
        AX = D800h
Return: AL = FFh if installed
            DX = version number (0100h for v1.0, 0101h for v1.1)
            BX = data segment of resident copy
            ES:DI -> private API entry point (see below)
            SI = segment of resident code
SeeAlso: AX=7A00h,AX=D880h

Call CLIENT API entry point with:
        BX = function
            0000h get ???
                Return: DX = CLIENT version??? (0101h for v1.1)
                        ES:BX -> ??? data
            0001h ???
            0002h ???
            0003h ???
            0004h ???
            0005h ???
                DL = ???
                ???
                Return: ???
            0006h get module name???
                ES:DI -> 16-byte buffer
                Return: CX = ???
                        ES:DI filled with "NWLITE_CLIENT" 00h 00h 00h
            0007h ???
                DX:CX = ???
                ???
                Return: ???
            0008h ???
            0009h ???
                DL = ???
                ES:DI -> 16-byte buffer for ???
                Return: CF clear if successful
                            AX = 0000h
                            CX = 0000h
                            SI,DI destroyed
                        CF set on error
                            AX = error code 4903h
            000Ah ???
                AH = subfunction
                    00h get ???
                    01h clear/set ??? flag
                        AL = new state (00h cleared, 01h set)
                    02h set ???
                        DX = new value of ???
                Return: DX = old value of ???
            000Bh ???
                AX = ???
                ???
                Return: ???
            000Ch ???
                AX = ???
                ???
                Return: ???
            000Dh ???
                AX = ???
                ???
                Return: ???
            000Eh get original INT 17
                Return: CF clear
                        ES:BX -> original INT 17
            000Fh ???
            0010h ???
                AX = ???
                ???
                Return: ???
            0011h get ???
                Return: CF clear
                        DL = ???
            0012h get ???
                AL = index of ???
                ES:DI -> 10-byte buffer for ???
                Return: CF clear if successful
                            ES:DI buffer filled
                            AX,CX destroyed
                        CF set on error
                            AX = error code (4907h if AL out of range)
            0013h get ???
                Return: CF clear
                        DH = ???
                        DL = ???
            0014h ???
                DL = ???
                ???
                Return: CF clear if successful
                            ???
                        CF set on error
                            AX = error code 8056h
            0015h ???
                DX = ???
                Return: ES:DI -> ???
            other
                Return: CF set
                        AX = 0001h (invalid function)
--------N-2FD880-----------------------------interrup.g---
INT 2F U - Novell NetWare Lite v1.0+ - SERVER - INSTALLATION CHECK
        AX = D880h
Return: AL = FFh if installed
            DX = version number (0100h for v1.0, 0101h for v1.1)
            BX = data segment of resident copy
            CL = current state (00h SERVER is disabled, 01h SERVER is active)
            ES:DI -> private API entry point (see below)
            SI = ??? (offset of configuration info?)
SeeAlso: AX=7A00h,AX=D800h

Call SERVER API entry point with:
        BX = function
            0000h ???
                ???
                Return: ???
                Note: closes open files by calling INT 21/AH=3Eh
            0001h get connection information
                DX = connection number (0001h-max connections)
                ES:DI -> 28-byte buffer for connection information
                Return: CF clear if successful
                            ES:DI buffer filled
                        CF set on error
                            AX = FFFFh
            other
                Return: CF set
                        AX = 0001h (invalid function)
--------N-7A----BX0010-----------------------
INT 7A - Novell NetWare - SPX Driver - INSTALLATION CHECK
        BX = 0010h
        AL = 00h
Return: AL = FFh if SPX loaded
            BH = SPX major version
            BL = SPX minor version
            CX = maximum SPX connections
            DX = SPX connections available
Note:   this function is supported by Advanced NetWare 2.1+
SeeAlso: BX=0015h
--------N-7F---------------------------------
INT 7F - Non-dedicated NetWare 2.x File Server - ENTER CONSOLE MODE
Notes:  the installation check consists of checking for the signature "Lynn"
          in the four bytes preceding the interrupt handler; if present, the
          current program is running as a DOS task on a non-dedicated NetWare
          2.x file server.
        Before placing the server into "console" mode, it is recommended that
          NetWare broadcast messages be disabled with INT 21/AX=DE00h.
SeeAlso: INT 21/AX=DE00h
Index:  installation check;non-dedicated NetWare server
--------d-214404-----------------------------
INT 21 - DUBLDISK.SYS v2.6 - GET INFO
        AX = 4404h
        BL = drive number of DoubleDisk drive (00h = default, 01h = A:, etc.)
        CX = number of bytes (000Ah-0014h, call ignored otherwise)
        DS:DX -> data record (see below)
Return: CF clear if successful
            AX = number of bytes read
        CF set on error
            AX = error code (01h,05h,06h,0Dh) (see AH=59h)
Program: DUBLDISK.SYS is the device driver portion of DoubleDisk, a disk
          expander by Vertisoft Systems, Inc.
Note:   the installation check consists of scanning memory for the signature
          "FAT 2.6  byte:", which is immediately followed by a data table
SeeAlso: AX=440Dh
Index:  installation check;DUBLDISK.SYS

Format of data record:
Offset  Size    Description
 00h    WORD    (call) signature 4444h
 02h    BYTE    (call) function
                        00h ???
                        01h ???
---function 00h---
 02h    BYTE    (return) ???
 03h    BYTE    (return) ???
---function 01h---
 02h    WORD    (return) 4444h
 04h    WORD    allocation unit size???
 06h    WORD    ???
 08h    WORD    ???
 0Ah    BYTE    ???

Format of signature data table:
Offset  Size    Description
 00h  5 BYTEs   ???
 05h    BYTE    first drive number
 06h    BYTE    number of drives
 07h    ???
--------c-212B--CX4358-----------------------
INT 21 - Super PC-Kwik v3.20+ - INSTALLATION CHECK
        AH = 2Bh
        CX = 4358h ('CX')
Return: AL = FFh if PC-Kwik/PC-Cache not installed
        AL = 00h if installed
            CF clear
            CX = 6378h ('cx')
            BX = ???
            DX = version (DH = major version, DL = binary minor version)
Note:   PC Tools PC-Cache v5.x and Qualitas Qcache v4.00 are OEM versions of
          Super PC-Kwik, and thus support this call (PC-Cache 5.1 corresponds
          to PC-Kwik v3.20)
SeeAlso: INT 13/AH=A0h,INT 13/AH=B0h,INT 16/AX=FFA5h/CX=1111h
Index:  PC-Cache;installation check|Qualitas Qcache;installation check
Index:  installation check;PC-Cache 5.x|installation check;Qualitas Qcache
--------R-212B44BX4D41-----------------------
INT 21 - pcANYWHERE IV/LAN - INSTALLATION CHECK
        AX = 2B44h ('D')
        BX = 4D41h ('MA')
        CX = 7063h ('pc')
        DX = 4157h ('AW')
Return: AX = 4F4Bh ('OK') if large host resident
           = 6F6Bh ('ok') if small host resident
        CX:DX -> API entry point
SeeAlso: INT 16/AH=79h

Call API entry point with:
        AX = 0000h get pcANYWHERE IV version
            DS:SI -> BYTE buffer for host type code
            Return: AH = version number
                    AL = revision number
                    DS:DI buffer byte filled with
                        00h full-featured host
                        01h limited-feature LAN host
                        other API may not be supported
        AX = 0001h initialize operation
            DS:SI -> initialization request structure (see below)
            Return: AX = function status (see below)
        AX = 0002h get status
            Return: AH = current operating mode (see init req structure below)
                    AL = current connection status
                        bit 0: a physical connection is active
                        bit 1: remove screen updating is active
                        bit 2: connection checking is active
                        bit 3: hot key detection is active
                        bit 4: background file transfer is active
        AX = 0003h suspend remote screen updates
            Return: AX = function status (see below)
        AX = 0004h resume screen updates
            Return: AX = function status (see below)
        AX = 0005h end current remote access session
            DS:SI -> termination request structure (see below)
            Return: AX = function status (see below)
        AX = 0006h remove pcANYWHERE IV from memory
            Return: AX = status
                        0000h successful
                        FFD2h unable to release allocated memory
                        FFD1h unable to release interrupt vectors
        AX = 8000h read data from communications channel
            DS:BX -> buffer
            CX = buffer size
            Return: AX >= number of characters read/available
                    AX < 0 on error
        AX = 8001h write data to communications channel
            DS:BX -> buffer
            CX = buffer size
            Return: AX >= number of characters written
                    AX < 0 on error
        AX = 8002h get connection status
            Return: AX = status
                        > 0000h if connection active
                        = 0000h if connection lost
                        < 0000h on error

Format of initialization request structure:
Offset  Size    Description
 00h    BYTE    operating mode
                00h wait for a call
                01h hot key activates
                02h incoming call activates
                03h initiate a call
 01h  3 BYTEs   user ID to append to config file names
 04h    WORD    DS-relative pointer to path for config files
 06h    WORD    DS-relative pointer to path for program files

Format of termination request structure:
Offset  Size    Description
 00h    BYTE    operating mode after termination
                00h wait for a call
                01h hot key activates
                02h incoming call activates
                80h use current mode
                FFh remove from memory

Values for function status:
 0000h  function completed successfully
 FFF2h  unable to establish a connection when operating mode is
        "Initiate a call"
 FFF3h  modem configuration is invalid (corrupt config)
 FFF4h  modem initialization failed (no modem response)
 FFF5h  the communications device could not be initialized
 FFF6h  the host operator aborted the function
 FFF7h  the communications driver type specified in the configuration file is
        different than the one loaded when pcANYWHERE IV was initially started
 FFF9h  the configuration file is invalid
 FFFAh  the configuration file could not be found
 FFFBh  no session is active
 FFFCh  a remote access session is active
 FFFDh  the specified operating mode is invalid
--------O-213000BX3000-----------------------
INT 21 - PC-MOS/386 v3.0 - INSTALLATION CHECK/GET VERSION
        AX = 3000h
        BX = 3000h
        CX = DX = 3000h
Return: AX = PC-MOS version
Program: PC-MOS/386 is a multitasking/multiuser MS-DOS-compatible operating
          system by The Software Link, Inc.
SeeAlso: AH=30h,INT 38/AH=02h,INT 38/AH=10h
--------O-1500-------------------------------
INT 15 - VMiX v2+ - INSTALLATION CHECK
        AH = 00h
Return: DX = 0798h if installed
            AX = version (AH = major, AL = minor)
--------b-154DD4-----------------------------
INT 15 - HP 95LX - INSTALLATION CHECK
        AX = 4DD4h
Return: BX = 4850h ("HP") if HP 95LX
            CX = ??? (0101h)
            DL = ??? (00h)
SeeAlso: INT 0B"HP 95LX",INT 0F"HP 95LX",INT 5F/AH=00h,INT 60/DI=0100h
SeeAlso: INT 61"HP 95LX"
--------p-155300BX0000-----------------------
INT 15 - Advanced Power Management Specification - INSTALLATION CHECK
        AX = 5300h
        BX = 0000h (device ID of system BIOS)
Return: CF clear if successful
            AH = major version (BCD)
            AL = minor version (BCD)
            BX = 504Dh ("PM")
            CX = flags
                bit 0: 16-bit protected mode interface supported
                bit 1: 32-bit protected mode interface supported
                bit 2: CPU idle call reduces processor speed
                bit 3: BIOS power management disabled
                bits 4-7 reserved
        CF set on error
            AH = error code (86h) (see below)

Values for error code:
 01h    power management functionality disabled
 02h    interface connection already in effect
 03h    interface not connected
 04h    real-mode interface not connected
 05h    16-bit protected-mode interface already connected
 06h    16-bit protected-mode interface not supported
 07h    32-bit protected-mode interface already connected
 08h    32-bit protected-mode interface not supported
 09h    unrecognized device ID
 0Ah    invalid parameter value in CX
 0Bh-1Fh reserved for other interface and general errors
 20h-3Fh reserved for CPU errors
 40h-5Fh reserved for device errors
 60h    can't enter requested state
 61h-7Fh reserved for other system errors
 80h    no power management events pending
 81h-85h reserved for other power management event errors
 86h    APM not present
 87h-9Fh reserved for other power management event errors
--------m-673F--CX5145-----------------------
INT 67 U - QEMM-386 v4.23+ - INSTALLATION CHECK
        AH = 3Fh
        CX = 5145h ("QE")
        DX = 4D4Dh ("MM")
Return: AH = 00h if installed
            ES:DI -> QEMM API entry point
Notes:  if no other program has hooked INT 67, an alternate installation
          check is to test for the string
          "QUARTERDECK EXPANDED MEMORY MANAGER 386" at offset 14h in the INT 67
          handler's segment; the word at offset 12h contains the offset in
          the handler's segment of the API entry point
        although this function is still undocumented, Quarterdeck has recently
          documented two alternate methods for determining the QEMM API entry
          point, as well as several of the API functions
        MICEMM (Micronics Expanded Memory Manager) versions 2.0C and 4D support
          the alternate QEMM installation check and entry point functions 00h,
          02h, and 03h; version 4D only provides the signature string if the
          commandline argument "DV" is provided
        386MAX v6.01 responds to this call, but DESQview 2.42 does not
          recognize the returned entry point as providing QEMM's capabilities
          because a) only functions 0Ch (different from QEMM 0Ch) and
                        1000h-1009h are supported,
                  b) status is returned as for EMS functions, not QEMM funcs
                  c) the protected-mode entry point returned by function 1000h
                        only supports functions 0Ch, 1004h, 1005h, and 100Ah
        the string check mentioned above is not supported by 386MAX
SeeAlso: AX=5BF0h,AH=DDh,AX=FFA5h,INT 15/AX=11DEh,INT 21/AX=4402h/SF=01h
SeeAlso: INT 21/AX=4402h"QEMM",INT 21/AX=4402h"386MAX",INT 2F/AX=D201h/BX=5145h

Call QEMM entry point with:
        AH = 00h get QEMM state (documented)
                Return: CF clear
                        AL = QEMM state
                            bit 0 set if QEMM turned OFF
                            bit 1 set if in "Auto" mode
        AH = 01h set QEMM state (documented)
                AL = new state
                    bit 0 set: place QEMM in OFF state
                Return: CF clear if successful
                        CF set on error
        AH = 02h get ???
                Return: CF clear
                        AX = segment of ??? data structure
                        Data Structure
                        Offset  Size    Description
                         00h    DWORD   page table entry for ???
                                ???
        AH = 03h get QEMM version (documented)
                Return: CF clear
                        AX = BX = version in BCD
                Notes:  the most recent official docs state that the version is
                          returned in both AX and BX; older documentation only
                          mentions BX
                        MICEMM returns AX=0001h, BX unchanged
        AH = 04h allocate 4K page and set AUTO/ON mode
                Return: CF clear if successful
                            DX = page number of a 4K page
                        CF set if unable to allocate page
                Note:   QEMM mode unchanged if not AUTO/OFF
        AH = 05h free 4K page and turn QEMM off
                DX = page number returned by function 04h
                Return: CF clear
                Note:   QEMM mode unchanged if not AUTO/ON
        AH = 06h make new mapping context???
                DX = page number of 4K page to hold page table
                Return: CF clear
                Note:   copies page table into given page and then sets ???
                          page table entry to point at copy
        AH = 07h get mapping context
                Return: CF clear
                        DX = page number of page table for current mapping
                                context
        AH = 08h set mapping context???
                DX = linear page number of page table
                Return: CF clear
        AH = 09h get linear page number for page table entry
                CX = page table index
                Return: CF clear
                        DX = linear page number
        AH = 0Ah set linear page number for page table entry
                CX = page table index
                DX = linear page number
                Return: CF clear
        AH = 0Bh map 4K pages
                BX = number of pages
                CX = first page number (must be 0100h to allocate HMA)
                DX = EMS handle (memory belonging to EMS handle will be mapped
                        into the address space beginning with the first page
                        allocated to the handle)
                Return: AH = 00h
        AH = 0Ch get available memory
                Return: CF clear
                        BX = 0001h
                        CX = total 4K pages???
                        DX = number of 4K pages free
        AH = 0Dh ??? (related to callbacks)
                AL = 00h/01h/02h ???
                Return: CF clear
        AH = 0Eh set ??? callbacks
                DS:BX -> FAR routine for ???
                ES:DX -> FAR routine for ???
                Return: CF clear
                Note:   DS:BX callback should return BX=???; ES:DX is called
                          with BX=???, and should set the ??? from which the
                          other handler read the value of BX.  BH and BL
                          appear to be separate values.
        AH = 0Fh unmap 4K pages
                CX = first page number
                DX = number of pages
                Return: CF clear
                        AL = 00h/01h if ???
                Note:   if CX=0100h and DX=0010h, the HMA is remapped to
                          simulate a disabled A20
        AX = 1000h get protected-mode interface
                DS:SI -> 16-byte buffer for two GDT entries
                ES:DI -> buffer for 4K page table
                Return: CF clear
                        EAX = offset of protected-mode API entry point
                        DS:SI buffer filled with two GDT descriptors
                                first is QEMM code segment, second is data???
                        ES:DI buffer filled with 4K page table
                        DI points to first unused page table entry
                SeeAlso: INT 67/AX=DE01h
        AX = 1001h get CPU debug registers
                ES:DI -> buffer for debug registers (8 DWORDs)
                Return: CF clear
                        BL = INT01 handling (see function 1002h)
                        ES:DI buffer filled
        AX = 1002h set CPU debug registers
                BL = INT01 handling
                    00h  reflect all debugging exceptions as V86-mode INT 01's
                    else convert debugging exceptions other than single-step
                           into V86-mode INT 03's, single-step to INT 01's
                ES:DI -> buffer containing debug registers (8 DWORDs)
                Return: CF clear
                Notes:  identical to INT 67/AX=DE09h if BL=01h
                        the INT01 handling flag is set to 01h by the general-
                          protection violation handler for certain privileged
                          instructions
        AX = 1003h get machine status word CR0
                Return: CF clear
                        EAX = contents of CR0
                SeeAlso: INT 67/AX=DE07h
        AX = 1004h allocate a 4K page
                Return: CF clear if successful
                            EDX = linear address of allocated page
                        CF set on error
                SeeAlso: INT 67/AX=DE04h
        AX = 1005h free 4K page
                EDX = linear address of page to free
                Return: CF clear
                SeeAlso: INT 67/AX=DE05h
        AX = 1006h NOP
                Return: CF set
        AX = 1007h get maximum physical memory address
                Return: CF clear
                        EDX = physical address of highest 4K memory page
                SeeAlso: INT 67/AX=DE02h
        AX = 1008h get physical address of page in first megabyte
                CX = page number (linear address shifted right 12 bits)
                Return: CF clear
                        EDX = linear address of page
                SeeAlso: function 1F00h
        AX = 1009h switch to protected mode
                ESI = linear address in first megabyte of system reg values
                        (see INT 67/AX=DE0Ch)
                interrupts disabled
                Return: interrupts disabled
                        GDTR, IDTR, LDTR, TR loaded
                        SS:ESP must have at least 16 bytes space, and the
                                entry point is required to set up a new stack
                                before enabling interrupts
                        EAX, ESI, DS, ES, FS, GS destroyed
        AX = 100Ah switch back to virtual-86 mode
                DS = selector for data segment from function 1000h
                SS:ESP in first megabyte of linear memory
                interrupts disabled
                STACK:  QWORD  return address from FAR call to 32-bit segment
                        DWORD  EIP
                        DWORD  CS
                        DWORD  reserved for EFLAGS
                        DWORD  ESP
                        DWORD  SS
                        DWORD  ES
                        DWORD  DS
                        DWORD  FS
                        DWORD  GS
                will switch to virtual86 mode with interrupts disabled, all
                  segment registers loaded, and EAX destroyed.
        AH = 11h get memory type map
                AL = zero/nonzero ??? (set by QEMM.COM but apparently ignored
                        by QEMM 6.00)
                ES:DI -> 256-byte buffer for memory types
                Return: CF clear
                        BL = ???
                        ES:DI buffer filled
                Note:   each byte of the buffer corresponds to a 4K page, and
                          contains the type of that page: 00h = mappable,
                          02h = mapped ROM, 03h = high RAM, 04h = excluded,
                          05h = video, 06h = ROM, 07h = adapter ROM,
                          08h = split ROM, 09h = page frame, 0Ah = RAMmable,
                          0Bh = conventional
        AH = 12h get HIRAM chain
                Return: CF clear
                        BX = segment of first MCB in high memory
                            0000h if no high memory
        AX = 1300h VIDRAMEGA???
                BL = 00h copy ???
                     nonzero copy ??? (reverse)
                Return: CF clear
                        AL = 00h if all pages clean
                           = 01h if any page dirty
        AX = 1301h check if ???
                DX:DI = start address of range to check ???
                CX = length of range
                Return: CF clear
                        CX = ??? (0000h or 1000h)
        AX = 1302h ???
                BL = ???
                BH = ???
                CX = ???
                SI = offset of ???
                DI = offset of ???
                ???
                Return: CF clear
                        ???
                Note:   disables certain interrupts at the two 8259 PICs during
                          execution; also modifies CRT controller during
                          execution under certain circumstances
        AX = 1303h EMS allocation???
                BX = number of pages (less 1) of EMS to allocate
                Return: CF clear if successful
                            DX = EMS handle
                        CF set on error
        AX = 1304h EMS deallocation
                DX = EMS handle
                Return: CF clear
        AX = 1305h ???
                CX = ???
                Return: CF clear
                Note:   disables certain interrupts at the two 8259 PICs during
                          execution (see AX=130Ch)
        AX = 1306h set DESQview critical section counter address
                ES:BX -> WORD DESQview critical section counter or 0000h:0000h
                Return: CF clear
                Note:   also sets pointer in low-memory part of QEMM to current
                          value of INT 15 if ES:BX not 0000h:0000h
        AX = 1307h ???
                Return: CF clear
                Note:   disables certain interrupts at the two 8259 PICs during
                          execution (see AX=130Ch)
        AX = 1308h ???
                BL = ??? (zero/nonzero)
                Return: CF clear
        AX = 1309h Hercules mode-change support
                ES:BX -> new address for Hercules mode-change callback
                Return: CF clear
                Note:   the callback function is called whenever the CRTC mode
                          register is written, with AL set to the value written
        AX = 130Ah virtualize EGA/VGA I/O ports 03C8h/03C9h???
                CX:DX -> buffer for storing CRTC register contents???
                        or 0000h:0000h to disable
                Return: CF clear
        AX = 130Bh ???
                BL = ???
                Return: CF clear
                        ???
        AX = 130Ch set interrupts to mask
                BX = interrupts to mask out during AX=1302h,AX=1307h,AX=1308h,
                        AX=130Dh,AX=1310h (BL = master PIC, BH = slave PIC)
                Return: CF clear
        AX = 130Dh ???
                ???
                Return: CF clear
                Note:   disables certain interrupts at the two 8259 PICs during
                          execution (see AX=130Ch)
        AX = 130Eh ??? (modifies CRT controller setup)
                ???
                Return: CF clear
        AX = 130Fh reset ???
                Return: CF clear
        AX = 1310h ???
                ???
                Return: CF clear
                Note:   disables certain interrupts at the two 8259 PICs during
                          execution (see AX=130Ch)
        AX = 1311h set ???
                BL = ???
                Return: CF clear
        AX = 1312h (v6.02) NOP???
                Note:   called by DV 2.42, but appears to be a NOP in QEMM 6.02
        AX = 1400h ???
                ES:DI -> ??? data structure (at least 24 bytes)
                BL = ???
                Return: AX = ???
                Data structure
                Offset  Size    Description
                 00h    WORD    ???
                 02h    DWORD   far pointer to ???
                 06h    DWORD   far pointer to ??? pointer array (see below)
                 0Ah    DWORD   far pointer to ???
                 0Eh    DWORD   ???
                 12h    WORD    segment of ???
                 14h    DWORD   far pointer to ???
                Pointer array
                Offset  Size    Description
                 00h    WORD    number of pointers to follow
                 02h  N DWORDs  far pointers to ???
                Note: QEMM converts the pointers into linear addresses in place
        AX = 1401h ???
                Return: CF clear
                        ???
        AX = 1402h ???
                BL = function
                    00h NOP
                    01h ???
                    02h ???
                    other ???
                ES:DI -> ???
                Return: CF clear
                        ???
                Data structure
                Offset  Size    Description
                 00h    WORD    segment of ??? (X, word at X:0136h set to X)
                 02h    WORD    segment of ??? (word at X:0124h set to this)
                 04h    WORD    number of paragraphs of ???
                 06h  3 WORDs   ??? (copied to X:0000h)
                 0Ch    WORD    ???
        AX = 1403h add ??? to list and ??? (execute func 1406h)
                ES:DI -> ??? structure added to end of ??? list
                        (at least 31 bytes, DWORD at offset 06h used for
                         storing pointer to next struc, WORD at offset 00h
                         seems to be a key or index)
                Return: CF clear
        AX = 1404h NOP
        AX = 1405h remove ??? from ??? list
                BX = key???
                Return: CF clear
        AX = 1406h ???
                ???
                Return: CF clear
                        ???
        AX = 1407h ???
                ???
                Return: CF clear
                        ???
        AX = 1408h ???
                ???
                Return: CF clear
                        ???
        AX = 1409h ???
                ???
                Return: CF clear
                        ???
        AX = 140Ah ???
                BX = ???
                Return: CF clear
                        ???
        AX = 140Bh ???
                BX = ???
                Return: CF clear
                        SI = segment of 256-byte buffer???
        AH = 15h ???
                ES:BX -> ??? or 0000h:0000h
                Return: CF clear
     ---QEMM v5.00+ ---
        AX = 1600h get memory access status
                ES:DI -> 256-byte buffer
                Return: ES:DI buffer filled
                Note:   each byte of the buffer indicates the status of a 4K
                          page (bit 0 set if read, bit 1 set if written)
        AX = 1601h set memory access status
                ES:DI -> 256-byte buffer containing access statuses (see above)
        AH = 17h get memory usage statistics
                ES:DI -> 81-byte buffer for memory statistics (see below)
                Return: CF clear
     ---QEMM v5.11+ ---
        AH = 18h check whether conventional memory mapped into address range
                ES:BX = starting address
                CX = number of 4K pages
                Return: CF clear
                        AL = 00h one or more pages is remapped
                             01h all pages in range are conventional memory
                                (physical address == virtual address)
        AH = 19h NOP
                Return: CF set
        AH = 1Ah I/O port access
                AL = subfunction
                    00h get byte from I/O port
                        Return: BL = port value
                    01h send byte to I/O port
                        BL = value to send
                    02h send byte to I/O port, get byte from following port
                        BH = value to send
                        Return: BL = value read
                    03h send bytes to two consecutive I/O ports
                        BH = value for first I/O port (DX)
                        BL = value for second I/O port (DX+1)
                DX = port number
                Return: CF clear
        AH = 1Bh MS Windows 3.x support
                AL = subfunction
                    00h get EMM Import Structure address
                        ES:DI -> buffer for EMM import data structure
                        Return: CF set on error
                                CF clear if successful
                        EMM Import data structure:
                        Offset  Size    Description
                         00h    DWORD   physical address of EMM import struct
                         04h    BYTE    major version (v6.00 sets to 01h)
                         05h    BYTE    minor version (v6.00 sets to 00h/0Bh)
                        SeeAlso: INT 21/AX=4402h/SF=01h
                    01h ???
                        Return: CF set on error
                                CF clear if successful
                    02h ???
                        Return: CF set on error
                                CF clear if successful
                    03h MS Windows initializing
                        CX = segment from which Windows init broadcast made???
                        DL = Windows startup flags???
                        DI = Windows version number (major in upper byte)
                        Return: ???
                        SeeAlso: INT 2F/AX=1605h
                    04h MS Windows terminating
                        Return: CF clear
                    05h determine whether program is driver???
                        DS:DX -> ASCIZ filename
                        Return: CF clear
                                AL = 01h if string ends in ".DRV"
                                   = FFh if string ends in "GDI.EXE"
                                   = 00h otherwise
                    06h ???
                        CX = length of data pointed at by DS:DX
                        DS:DX -> ???
                        Return: CF clear
                    07h BUG: QEMM 6.00-7.01 accept this and branch randomly
                    else Return: CF set
        AH = 1Ch protected-mode hardware interrupt handlers ???
                AL = subfunction
                    00h restore??? IRQ0-7 handlers
                    01h set??? IRQ0-7 handlers
                        ES:DI -> 8 DWORDs containing ???
                    02h restore??? IRQ8-15 handlers
                    03h set??? IRQ8-15 handlers
                        ES:DI -> 8 DWORDs containing ???
                BUG: although the jump table only contains four entries,
                        QEMM 6.00 will attempt to use it for any value of
                        AL between 00h and 2Ah, thus branching unpredictably
                        for AL=04h-2Ah; QEMM v7.01 behaves similarly for
                        AL=04h-1Bh
     ---QEMM v6.00+ ---
        AH = 1Dh Stealth interrupts
                AL = subfunction
                    00h switch to pre-Stealth interrupt vector table
                        Note:   also switches VGA Save table pointer
                                  (0040h:00A8h) and overwrites the vectors
                                  currently assigned for use by the two
                                  interrupt controllers (see INT 67/AX=DE0Ah)
                                  with the vectors for INT 08-0F and 70-77 (to
                                  avoid crashing the system).
                    01h restore user interrupt vector table
                        Notes:  interrupts should be disabled around the
                                  AX=1D00h and AX=1D01h calls because QEMM does
                                  not modify the memory maps to map in ROM, so
                                  an interrupt could be disastrous
                                clears any pending IRQ7 at end of function
                    else
                        Return: CF set
                Note:   functions 1Dxxh are not supported by QEMM v7.01, and
                          always return CF set
        AH = 1Eh Stealth information (documented)
                AL = subfunction
                    00h "QEMM_GET_INFO" get Stealth configuration
                        Return: BL = flags (documented as "reserved")
                                    bit 0: conventional memory sorted
                                    bit 1: conventional memory filled
                                    bit 2: ???
                                    bit 3: ???
                                    bit 4: expanded memory is in use
                                    bit 5: ???
                                BH = reserved (always 00h for v6.00)
                                CL = stealth type (00h none,46h Frame,4Dh Map)
                                CH = suspend/resume interrupt (00h none)
                                DX = reserved (always 0000h for v6.00)
                                SI = reserved (always 0000h for v6.00)
                                DI = reserved (always 0000h for v6.00)
                    01h "QEMM_GET_STEALTH_COUNT" get number of Stealth'ed ROMs
                        Return: CF clear
                                BX = number of Stealth'ed ROMs
                    02h "QEMM_GET_STEALTH_LIST" get Stealth'ed ROM info
                        ES:DI -> buffer for Stealth ROM info (see below)
                        Return: CF clear
                                BX = number of Stealth'ed ROMs
                                ES:DI buffer filled
                    else
                        Return: CF set
        AH = 1Fh page table manipulation (documented)
                AL = subfunction
                    00h "QEMM_GET_PTE" get page table entry
                        CX = page number
                        Return: EDX = page table entry
                                CF clear
                    01h "QEMM_SET_PTE" set page table entry
                        CX = page number
                        EDX = new page table entry
                        Return: CF clear
                        SeeAlso: function 1008h
                    else
                        Return: CF set
        AH = 20h asynchronous disk access support (documented)
                AL = subfunction
                    00h "QEMM_GET_VHI_INFO" get VirtualHDIRQ information
                        Return: CF clear
                                BL = flags
                                    bit 7: VirtualHDIRQ setting respected
                                         (set if Stealth active)
                                    bits 6-1 reserved
                                    bit 0: VirtualHDIRQ currently enabled
                                        (INT 15/AH=90h suppressed when enabled)
                    01h "QEMM_SET_VHI_FINO" set VirtualHDIRQ state
                        BL bit 0 = new VirtualHDIRQ state
                        Return: CF clear
                                BL = old VHI setting (bits 0 and 7, see above)
                    else
                        Return: CF set
        AH = 21h Stealth support (documented)
                AL = subfunction
                    00h "QEMM_COPY_STEALTH_ROMS" copy data from Stealthed addr
                        DS:SI -> start address of hidden memory to copy
                        ES:DI -> buffer for copied data
                        ECX = number of bytes to copy
                        Return: CF clear if successful
                                CF set on error (DS:SI < C000h:0000h or
                                                 DS:SI + ECX > 1M)
                    else
                        Return: CF set
        ---QEMM v6.03+ ---
        AH = 22h DESQview/X support
                AL = subfunction
                    00h get ???
                        Return: CF clear
                                ES:DI -> ???
                    01h set ???
                        ES:DI -> ??? or 0000h:0000h
                        Return: CF clear if successful
                                CF set on error
        ---QEMM v6.04+ ---
        AH = 23h ???
                AL = subfunction
                    00h get ???
                        BX = which ??? to get (must be 0000h for v6.04)
                        Return: CF clear if successful
                                    ES:DI -> ???
                                CF set on error
                    01h set ???
                        BX = which ??? to set (must be 0000h for v6.04)
                        ES:DI -> ???
                        Return: CF clear if successful
                                CF set on error
                    02h clear specified ???
                        BX = which ??? to clear (must be 0000h for v6.04)
                        Return: CF clear if successful
                                CF set on error
                    FFh clear all ???
                    else
                        Return: CF set
        ---QEMM v7.01 only---
        AH = 24h ST-DBL support
                AL = subfunction
                    00h set ???
                        EDX -> information table
                                (EDX = segment SHL 16 + offset)
                    01h ???
        other
                Return: CF set

Format of QEMM 6.0 memory statistics:
Offset  Size    Description
 00h    BYTE    01h if Shadow RAM found, 00h otherwise
 01h    DWORD   initial conventional memory in bytes
 05h    DWORD   initial extended memory in bytes
 09h    DWORD   initial expanded memory in bytes
 0Dh    DWORD   initial "top" or "shadow" memory in bytes
 11h    DWORD   Unavailable conventional memory in bytes
 15h    DWORD   Unavailable extended memory in bytes
 19h    DWORD   Unavailable expanded memory in bytes
 1Dh    DWORD   Unavailable "top" or "shadow" memory in bytes
                Add to offset 49h for Total unavailable top/shadow.
 21h    DWORD   QEMM code size in bytes
 25h    DWORD   QEMM data size in bytes
 29h    DWORD   bytes used for TASKS=
 2Dh    DWORD   DMA buffer size
 31h    DWORD   bytes used for MAPS=
 35h    DWORD   bytes of high RAM
 39h    DWORD   bytes used by mapped ROMs
 3Dh    DWORD   bytes of conventional memory provided by QEMM
 41h    DWORD   bytes of extended memory NOT converted by QEMM (EXT=xxx)
 45h    DWORD   bytes of EMS/XMS pool memory provided by QEMM
 49h    DWORD   Unavailable "top" or "shadow" memory in bytes
                Add to offset 1Dh for Total unavailable top/shadow.
 4Dh    DWORD   conventional memory overhead in bytes
                (set to 0 by QEMM.COM prior to call)

Format of Stealth ROM info [array]:
Offset  Size    Description
 00h    WORD    starting segment of ROM
 02h    WORD    length of ROM in paragraphs
--------m-67FFA5-----------------------------
INT 67 - Microsoft EMM386.EXE v4.20+ - INSTALLATION CHECK
        AX = FFA5h
Return: AX = 845Ah if loaded
            BX:CX -> API entry point
Notes:  this call is available even if EMM386 is not providing EMS
        if no other program has hooked INT 67, an alternate installation
          check is to test for the string
          "MICROSOFT EXPANDED MEMORY MANAGER 386" at offset 14h in the INT 67
          handler's segment; the word immediately preceding this string
          contains the offset of the API entry point
SeeAlso: AH=3Fh,AX=FFA5h/BX=4345h,INT 21/AX=4402h"EMM386.EXE"

Call API entry point with:
        AH = 00h get memory manager's status
            Return: AH = status
                        bit 0: not active (OFF)
                        bit 1: in "Auto" mode
        AH = 01h set memory manager's state
            AL = new state (00h ON, 01h OFF, 02h AUTO)
        AH = 02h Weitek coprocessor support
            AL = subfunction
                00h get Weitek support state
                    Return: AL = status
                                bit 0: Weitek coprocessor is present
                                bit 1: Weitek support is enabled
                01h turn on Weitek support
                02h turn off Weitek support
     --- v4.20-4.41 only ---
        AH = 03h Windows support???
            AL = subfunction (00h, 01h)
        AH = 04h print copyright notice to standard output
                 (using INT 21/AH=09h)
        AH = 05h print available report
                 (the one shown when running EMM386 from the DOS prompt)
--------N-5C---------------------------------
INT 5C - ATALK.SYS - AppleTalk INTERFACE
        DX:BX -> control block (see below)
Return: none
Notes:  this driver can use any interrupt from 5Ch to 70h
        the signature 'AppleTalk' appears 16 bytes prior to the interrupt
          handler; this serves as the installation check
Index:  installation check;ATALK.SYS|installation check;AppleTalk interface

Values for command code:
 01h    "AT_INIT"           initialize the driver
 02h    "AT_KILL"
 03h    "AT_GETNETINFO" get current network info incl init status
 04h    "AT_GETCLOCKTICKS"
 05h    "AT_STARTTIMER"
 06h    "AT_RESETTIMER"
 07h    "AT_CANCELTIMER"
 10h    "LAP_INSTALL"
 11h    "LAP_REMOVE"
 12h    "LAP_WRITE"
 13h    "LAP_READ"
 14h    "LAP_CANCEL"
 20h    "DDP_OPENSOCKET"
 21h    "DDP_CLOSESOCKET"
 22h    "DDP_WRITE"
 23h    "DDP_READ"
 24h    "DDP_CANCEL"
 30h    "NBP_REGISTER"
 31h    "NBP_REMOVE"
 32h    "NBP_LOOKUP"
 33h    "NBP_CONFIRM"
 34h    "NBP_CANCEL"
 35h    "ZIP_GETZONELIST"
 36h    "ZIP_GETMYZONE"
 37h    "ZIP_TAKEDOWN"
 38h    "ZIP_BRINGUP"
 40h    "ATP_OPENSOCKET"
 41h    "ATP_CLOSESOCKET"
 42h    "ATP_SENDREQUEST"
 43h    "ATP_GETREQUEST"
 44h    "ATP_SENDRESPONSE"
 45h    "ATP_ADDRESPONSE"
 46h    "ATP_CANCELTRANS"
 47h    "ATP_CANCELRESPONSE"
 48h    "ATP_CANCELREQUEST"
 50h    "ASP_GETPARMS"
 51h    "ASP_CLOSESESSION"
 52h    "ASP_CANCEL"
 53h    "ASP_INIT"
 54h    "ASP_KILL"
 55h    "ASP_GETSESSION"
 56h    "ASP_GETREQUEST"
 57h    "ASP_CMDREPLY"
 58h    "ASP_WRTCONTINUE"
 59h    "ASP_WRTREPLY"
 5Ah    "ASP_CLOSEREPLY"
 5Bh    "ASP_NEWSTATUS"
 5Ch    "ASP_ATTENTION"
 5Dh    "ASP_GETSTATUS"
 5Eh    "ASP_OPENSESSION"
 5Fh    "ASP_COMMAND"
 60h    "ASP_WRITE"
 61h    "ASP_GETATTENTION"
 70h    "PAP_OPEN"
 71h    "PAP_CLOSE"
 72h    "PAP_READ"
 73h    "PAP_WRITE"
 74h    "PAP_STATUS"
 75h    "PAP_REGNAME"
 76h    "PAP_REMNAME"
 77h    "PAP_INIT"
 78h    "PAP_NEWSTATUS"
 79h    "PAP_GETNEXTJOB"
 7Ah    "PAP_KILL"
 7Bh    "PAP_CANCEL"

Format of AppleTalk control block:
Offset  Size    Description
 00h    WORD    command code (see above)
                OR with the following flags
                8000h start command then return
                4000h wait for interrupt service to complete
 02h    WORD    returned status
                0000h success (already initialized if func 01h)
 04h    DWORD   pointer to completion function
 08h    WORD    network number
 0Ah    BYTE    node ID
---if general func (01h,03h), control block continues:
 0Bh    BYTE    "inf_abridge"
 0Ch    WORD    "inf_config"
 0Eh    DWORD   pointer to buffer
 12h    WORD    buffer size
---if DDP function (20h-24h), control block continues:
 0Bh    BYTE    "ddp_addr_socket"
 0Ch    BYTE    "ddp_socket"
 0Dh    BYTE    "ddp_type"
 0Eh    DWORD   pointer to buffer
 12h    WORD    buffer size
 14h    BYTE    "ddp_chksum"
---if Name Binding Protocol (30h-34h), control block continues:
 0Bh    BYTE    "nbp_addr_socket"
 0Ch    WORD    "nbp_toget"
 0Eh    DWORD   pointer to buffer
 12h    WORD    buffer size
 14h    BYTE    "nbp_interval"
 15h    BYTE    "nbp_retry"
 16h    DWORD   "nbp_entptr"
---if AppleTalk Transaction Protocol (42h), control block continues:
 0Bh    BYTE    "atp_addr_socket"
 0Ch    WORD    "atp_socket"
 0Eh    DWORD   pointer to buffer
 12h    WORD    buffer size
 14h    BYTE    "atp_interval"
 15h    BYTE    "atp_retry"
 16h    BYTE    ATP flags
                bit 5: exactly one transaction
 17h    BYTE    "atp_seqbit"
 18h    BYTE    transaction ID
 19h  4 BYTEs   ATP user bytes
 1Dh    BYTE    number of BDS buffers
 1Eh    BYTE    number of BDS responses
 1Fh    DWORD   pointer to BDS buffers (see below)

Format of Name Binding Protocol Name-to-Address binding entries for NBP_LOOKUP:
Offset  Size    Description
 00h    WORD    "tup_address_network"
 02h    BYTE    "tup_address_notid"
 03h    BYTE    "tup_address_socket"
 04h    BYTE    "tup_enum"
 05h 99 BYTEs   name

Format of BDS entries:
Offset  Size    Description
 00h    DWORD   pointer to buffer
 04h    WORD    size of buffer
 06h    WORD    BDS data size
 08h  4 BYTEs   "bds_userbytes"
--------N-2F8000-----------------------------
INT 2F - EASY-NET - INSTALLATION CHECK
        AX = 8000h
Return: AL = 00h not installed
             FFh installed
Program: EASY-NET is a shareware two-machine serial-port network
--------N-2F8000-----------------------------
INT 2F - Nanosoft, Inc. TurboNET server - INSTALLATION CHECK
        AX = 8000h
Return: AL = FFh if installed
            BX = CS of resident code
            CX = ??? (03FCh)
Program: TurboNET is a NetBIOS-based file redirector and server; a
          demonstration version may be downloaded from Nanosoft's BBS
SeeAlso: AX=8100h
--------N-2FB800-----------------------------
INT 2F - network - INSTALLATION CHECK
        AX = B800h
Return: AL = status
            00h     not installed
            nonzero installed
              BX = installed component flags (test in this order!)
                   bit 6   server
                   bit 2   messenger
                   bit 7   receiver
                   bit 3   redirector
                   bit 1   LANPUP (LANtastic 4.0)
Notes:  this function is supported by LAN Manager, LANtastic, NetWare Lite,
          SilverNET, 10NET, etc.
        LANtastic and NetWare Lite use only BL for the return value, preserving
          BH; LAN Manager and DOS LAN Requester return BH=00h.  This permits
          differentiation between those two groups by setting BH to a nonzero
          value before the call and checking its value on return.
SeeAlso: AX=4E53h,AX=B809h
--------N-2FB800CXF041-----------------------
INT 2F - 10NET - INSTALLATION CHECK
        AX = B800h
        CX = F041h
Return: AL = status
            00h     not installed
            nonzero installed
                BX = installed component flags (test in this order!)
                   bit 6   server
                   bit 2   messenger
                   bit 7   receiver
                   bit 3   redirector
                   bit 1   LANPUP (LANtastic 4.0)
                CX = 10Net data segment
                CX:DX -> 10Net Configuration Table (see AX=5E01h"10NET")
Note:   if CX <> F041h on entry, neither CX nor DX will be changed, and this
          call becomes identical to the standard installation check above
SeeAlso: AX=B800h"network",INT 21/AX=5E01h"10NET"
--------N-2FC000-----------------------------
INT 2F - Novell ODI Link Support Layer (LSL.COM) - INSTALLATION CHECK
        AX = C000h
Return: AL = FFh if installed
            DX:BX -> FAR entry point (see below)
            ES:SI -> signature string "LINKSUP$"
Notes:  LSL.COM may use any multiplex number between C0h and FFh; it searches
          for itself in that range, and installs using the first free multiplex
          number in the range if not already loaded.
        on return, ES = DX for LSL v1.10; LSL makes use of this in its search
          for a previous installation

Call LSL entry point with:
        BX = 0001h "Request MLID Registration"
                ES:SI -> ???
                ???
                Return: AX = completion code (see below)
                        DS:DI -> LSL information block
        BX = 0002h get support entry points
                ES:SI -> buffer for entry point record (see below)
                Return: ES:SI buffer filled
        BX = 0003h "Request MLID API entry point"
                Return: ES:SI -> MLID API entry point
                             (call with BX=function 00h-10h, not range-checked)
Notes:  LSL v1.10 executes BX=0003h for all other values of BX
        see "Novell LAN Driver Developer's Guide, Volume III" for details of
          function 0001h

Values for completion code:
 0000h  successful
 8001h  out of resources
 8002h  bad parameter
 8003h  no more items
 8004h  item not present
 8005h  failed
 8006h  receive overflow
 8007h  canceled
 8008h  bad command
 8009h  duplicate entry
 800Ah  no such handler
 800Bh  no such driver

Format of entry point record:
Offset  Size    Description
 00h    DWORD   pointer to protocol support entry point in LSL (see below)
 04h    DWORD   pointer to general support entry point in LSL (see below)

Call protocol support entry point with:
        BX = function number
            0000h ???
            0001h ???
            0002h ???
            0003h "ScheduleAESEvent"
                ES:SI -> AES ECB to be scheduled (see below for format)
                Return: ES,SI preserved
            0004h "CancelAESEvent"
                ES:SI -> ECB to be cancelled (see below for format)
                Return: ES,SI preserved
            0005h "GetIntervalMarker"
                Return: DX:AX = current interval marker in milliseconds
                        all other registers preserved
            0006h "RegisterStack"
                AX = logical board number
                ES:SI -> bound stack info structure (see below)
                Return: BX = assigned Stack ID if AX=0000h
            0007h "DeRegisterStack"
                AX = protocol stack's assigned Stack ID
            0008h "RegisterDefaultStack"
                AX = logical board number
                ES:SI -> stack info structure (see below)
            0009h "DeRegisterDefaultStack"
                AX = logical board number
            000Ah "RegisterPrescanStack"
                AX = logical board number
                ES:SI -> stack info structure (see below)
            000Bh "DeRegisterPrescanStack"
                AX = logical board number
            000Ch "SendPacket"
                ES:SI -> send ECB
                Return: interrupts disabled
            000Dh ???
            000Eh ???
            000Fh ???
            0010h "GetStackIDFromName"
                ES:SI -> counted NUL-terminated protocol name (max 15 chars)
                Return: BX = Stack ID if AX=0000h
            0011h "GetPIDFromStackIDBoard"
                AX = Stack ID for protocol
                CX = logical board number
                ES:SI -> 6-byte buffer for protocol ID
            0012h "GetMLIDControlEntry"
                AX = logical board number
                Return: ES:SI -> MLID control handler (see below) if AX=0000h
            0013h "GetProtocolControlEntry"
                AX = Stack ID or
                        FFFEh Prescan stack
                            CX = logical board number
                        FFFFh default protocol
                            CX = logical board number
                Return: ES:SI -> protocol stack control entry point if AX=0000h
                                (see below)
            0014h "GetLSLStatistics"
                Return: AX = 0000h (successful)
                        ZF set
                        ES:SI -> LSL statistics table (see below)
            0015h "BindStack"
                AX = protocol stack's assigned Stack ID
                CX = logical board number
            0016h "UnbindStack"
                AX = protocol stack's assigned Stack ID
                CX = logical board number
            0017h "AddProtocolID"
                AX = frame type ID code
                ES:SI -> 6-byte protocol ID
                CX:DI -> counted NUL-terminated short protocol name (max 15 ch)
            0018h "RelinquishControl"
                Return: after LSL performs any necessary background processing
            0019h "GetLSLConfiguration"
                Return: AX = 0000h (successful)
                        ZF set
                        ES:SI -> LSL configuration table (see below)
            001Ah "GetTickMarker"
                Return: AX = number of 55ms ticks since LSL loaded
                        BX destroyed
Return: AX = completion code (see above)
        ZF set if successful
        SS:SP, DS, BP preserved; most other registers may be destroyed

Call general support entry point with:
        BX = function number
            0000h "Allocate Memory" (obsolete)
                 always returns AX=8008h (BAD_COMMAND)
            0001h "Free Memory" (obsolete)
                 always returns AX=8008h (BAD_COMMAND)
            0002h "Realloc Memory" (obsolete)
                 always returns AX=8008h (BAD_COMMAND)
            0003h "Memory Statistics" (obsolete)
                 always returns AX=8008h (BAD_COMMAND)
            0004h "Add Memory To Pool" (obsolete)
                 always returns AX=8008h (BAD_COMMAND)
            0005h "AddGeneralService"
                ES:SI -> General Service Control Block (see below)
            0006h "RemoveGeneralService"
                ES:SI -> General Service Control Block (see below)
            0007h "GetNETcfgPath"
                Return: AX = 0000h (successful)
                        DS:DX -> ASCIZ pathname for NET.CFG
            0008h U ???  (in LSL 1.10)
                Return: AX = 0000h
                        ES:SI -> ??? (a 22-byte data area)
            000Ah "GetCriticalSectionStatus"
                Return: BX = total outstanding calls to "StartCriticalSection"
            000Bh "ServiceEvents"
                interrupts disabled
                Return: interrupts disabled
            0010h "GetStackECB"
                DS:DI -> Lookahead structure (see below)
                interrupts disabled
                Return: ES:SI -> ECB if successful (AX=0000h,ZF set)
                        interrupts disabled
            8000h-FFFFh reserved for user general service providers
Return: AX = completion code (see above)
        ZF set if successful
        SS:SP, DS, BP preserved

Call MLID control handler with:
        AX = logical board number
        BX = function number
            0000h "GetMLIDConfiguration"
                Return: ES:SI -> MLID's configuration table if successful
                                (see below for format)
            0001h "GetMLIDStatistics"
                Return: ES:SI -> MLID's statistics table if successful
                                (see below for format)
            0002h "AddMulticastAddress"
                ES:SI -> 6-byte multicast address to add
            0003h "DeleteMulticastAddress"
                ES:SI -> 6-byte multicast address to delete
            0005h "MLIDShutdown"
                CX = type
                    0000h permanent (also deregisters from LSL)
                    other temporary (shutdown hardware only)
            0006h "MLIDReset" reinitialize board / restart from temp shutdown
            0007h "Create Connection" (obsolete?)
                ???
            0008h "Delete Connection" (obsolete?)
                ???
            0009h "SetLookAheadSize"
                CX = requested lookahead size (00h-80h)
            0010h "PromiscuousChange"
                CX = what to receive promiscuously
                    bit 0: MAC frames
                    bit 1: non-MAC frames
            0011h "RegisterReceiveMonitor"
                CX = subfunction
                    0000h disable receive monitoring
                    else  enable receive monitoring
                ES:SI -> monitor receive routine
                ES:DI -> monitor transmit routine
            0012h "Driver Poll" (obsolete?)
                ???
Return: AX = completion code (see above)
        ZF set if successful
Note:   not all boards/MLIDs support function 0010h; see bit 13 in the MLID
          mode flags field of the MLID's configuration table

Call protocol stack control entry point with:
        BX = function number
            0000h "GetProtocolStackConfiguration"
                Return: ES:SI -> protocol stack's configuration table
                                (see below)
            0001h "GetProtocolStackStatistics"
                Return: ES:SI -> protocol stack's statistics table (see below)
            0002h "BindToMLID"
                CX = board number to bind to
                ES:SI -> implementation-dependant parameter string
            0003h "UnBindFromMLID"
                CX = board number from which protocol should unbind
                ES:SI -> optional implementation-dependant parameter string
            0004h "MLIDDeRegistered"
                CX = board number that has de-registered from LSL
Return: AX = status
            0000h successful
            else implementation-dependant error codes
        ZF set if successful
        SS:SP, DS, BP preserved

Format of AES ECB:
Offset  Size    Description
 00h    DWORD   "AESLink" pointer used by LSL for list management
 04h    DWORD   number of milliseconds to wait
 08h    DWORD   "AESStatus" (is set to 00000000h when AES ESR is invoked)
 0Ch    DWORD   -> function to be invoked when time expires
                ES:SI will point to this structure on entry,
                DS, BP, and SS:SP must be preserved.

Format of LSL Configuration Table:
Offset  Size    Description
 00h    BYTE    major version of configuration table
 01h    BYTE    minor version of configuration table (decimal, 0-99)
 02h  8 BYTEs   reserved
 0Ah    BYTE    LSL major version (decimal)
 0Bh    BYTE    LSL minor version (decimal, 0-99)
---LSL 1.0x ---
 0Ch 14 BYTEs   reserved
---LSL 1.10+ ---
 0Ch    WORD    maximum number of boards which LSL can handle
 0Eh    WORD    maximum number of protocol IDs which LSL can handle
 10h 12 BYTES   reserved

Format of LSL Statistics Table:
Offset  Size    Description
 00h    BYTE    major version of statistics table format
 01h    BYTE    minor version of statistics table format (decimal, 0-99)
 02h    WORD    "GenericCounters" number of counters in static portion of
                table
 04h    DWORD   "ValidCountersMask" bit mask indicating which generic
                counters are actually used.  Bit 31 = TotalTxPackets, bit 30
                is the next field, etc.
 08h    DWORD   "TotalTxPackets" total SendPacket requests made
 0Ch    DWORD   reserved
 10h    DWORD   reserved
 14h    DWORD   "AESEventsCount" number of completed AES events
 18h    DWORD   "PostponedEvents" number of events postponed due to critical
                sections inside the MLIDs
 1Ch    DWORD   "CancelAESFailures" number of times CancelAESEvent failed
 20h    DWORD   reserved
 24h    DWORD   reserved
 28h    DWORD   "TotalRxPackets" total number of GetStackECB requests
 2ch    DWORD   "UnclaimedPackets" total number of packets not consumed by a
                protocol stack
 30h    WORD    "NumberCustom" number of custom variables that follow
 32h  N DWORDs  custom counters
      N DWORDs  -> CustomCounterStrN (one per custom counter)
        var     length-prepended and NULL terminated string for Counter 0
        ...
        var     length-prepended and NULL terminated string for Counter N-1

Format of Protocol Stack Statistics Table:
Offset  Size    Description
 00h    BYTE    statistics table major version
 01h    BYTE    statistics table minor version (decimal, 0-99)
 02h    WORD    number of generic counters following
 04h    DWORD   "ValidCountersMask" (bitmask, bit 31 is TotalTxPackets)
 08h    DWORD   TotalTxPackets
 0ch    DWORD   TotalRxPackets
 10h    DWORD   IgnoredRxPackets
 14h    WORD    number of custom counters
 16h  N DWORDs  custom counters
      N DWORDs  -> CustomCounterStrN (one per custom counter)
        var     length-prepended and NULL terminated string for Counter 0
        ...
        var     length-prepended and NULL terminated string for Counter N-1

Format of Protocol Stack Configuration Table:
Offset  Size    Description
 00h    BYTE    configuration table major version
 01h    BYTE    configuration table minor version (decimal, 0-99)
 02h    DWORD   -> counted NUL-terminated long descriptive name for protocol
 06h    DWORD   -> counted NUL-terminated short name for protocol (15 chars)
 0Ah    BYTE    protocol stack major version
 0Bh    BYTE    protocol stack minor version (decimal, 0-99)
 0Ch 16 BYTEs   reserved for future use

Format of MLID Configuration Table:
Offset  Size    Description
 00h 26 BYTEs   signature 'HardwareDriverMLID        ' (8 spaces on end)
 1ah    BYTE    configuration table major version
 1bh    BYTE    configuration table minor version (decimal, 0-99)
 1ch  6 BYTEs   node address
 22h    WORD    MLID mode flags (see below)
 24h    WORD    board number
 26h    WORD    board instance (if more than one of same board installed)
 28h    WORD    maximum packet size
 2Ah    WORD    BestDataSize
 2Ch    WORD    WorstDataSize
 2Eh    DWORD   -> counted NUL-terminated long name for NIC
 32h    DWORD   -> counted NUL-terminated short name for NIC (8 chars max)
 36h    DWORD   -> counted NUL-terminated Frame and Media type
 3Ah    WORD    reserved (0000h)
 3Ch    WORD    frame type ID
 3Eh    WORD    TransportTime (milliseconds)
 40h    DWORD   -> SourceRouteHandler for TokenRing. (Used by ROUTE.COM)
 44h    WORD    lookahead size
 46h    WORD    line speed (Mbps if high bit clear, else Kbps)
 48h    WORD    QueueDepth
 4Ch  6 BYTEs   reserved (0)
 54h    BYTE    driver major version
 55h    BYTE    driver minor version (decimal, 0-99)
 56h    WORD    flags
                bits 10-9: specialized multicast support
                        00 = Group addressing is default for medium
                        01 = Invalid
                        10 = Filter group address in MLID.
                        11 = Adapter filters group address.
                bit 2: supports Micro Channel cards
                bit 1: supports ISA cards
                bit 0: supports EISA cards
 58h    WORD    send retries
 5Ah    DWORD   ConfigTableLink
 5Eh    WORD    MLID sharing flags (see below)
 60h    WORD    slot number
 62h    WORD    I/O address 1
 64h    WORD    I/O range 1
 66h    WORD    I/O address 2
 68h    WORD    I/O range 2
 6Ah    DWORD   memory address 1
 6Eh    WORD    memory size 1
 70h    DWORD   memory address 2
 74h    WORD    memory size 2
 76h    BYTE    interrupt line 1
 77h    BYTE    interrupt line 2
 78h    BYTE    DMA line 1
 79h    BYTE    DMA line 2

Bitfields for MLID mode flags:
 bit 15 MLID supports Octet Bit Reversal
 bit 14 node address is non-canonical
 bit 13 promiscuous mode is supported
 bit 12-8 reserved
 bit 7  LDataSize field in LookAhead structure supported
 bit 6  raw send supported
 bit 5  MLID needs to be polled by LSL
 bit 4  reserved (0)
 bit 3  multicasting is supported
 bit 2  not currently used by DOS ODI, set to 0.
 bit 1  network card uses DMA.
 bit 0  RealDriverBit, always set to 1.

Bitfields for MLID sharing flags:
 bit 8  NIC can share DMA2
 bit 7  NIC can share DMA1
 bit 6  NIC can share IRQ2
 bit 5  NIC can share IRQ1
 bit 4  NIC can share Memory2
 bit 3  NIC can share Memory1
 bit 2  NIC can share IO2
 bit 1  NIC can share IO1
 bit 0  MLID is currently shut down

Format of MLID Statistics Table:
Offset  Size    Description
 00h    BYTE    driver statistics table major version
 01h    BYTE    driver statistics table minor version (decimal, 0-99)
 02h    WORD    number of generic counters (typically 13)
 04h    DWORD   "ValidCountersMask" (bit mask, bit 31 is TotalTxCount)
 08h    DWORD   TotalTxCount
 0Ch    DWORD   TotalRxCount
 10h    DWORD   NoECBAvailableCount
 14h    DWORD   TxTooBigCount
 18h    DWORD   TxTooSmallCount
 1ch    DWORD   RxOverflowCount
 20h    DWORD   RxTooBigCount
 24h    DWORD   RxTooSmallCount
 28h    DWORD   TxMiscCount
 2ch    DWORD   RxMiscCount
 30h    DWORD   TxRetryCount
 34h    DWORD   RxChecksumErrorCount
 38h    DWORD   RxMismatchCount
 3Ch    WORD    number of custom counters
 3Eh  N DWORDs  custom counters
      N DWORDs  -> CustomCounterStrN (one per custom counter)
        var     length-prepended and NULL terminated string for Counter 0
        ...
        var     length-prepended and NULL terminated string for Counter N-1

Format of bound stack info structure:
Offset  Size    Description
 00h    DWORD   -> protocol stack's short name (counted, NUL-terminated)
 04h    DWORD   -> receive handler
 08h    DWORD   -> control handler

Format of stack info structure:
Offset  Size    Description
 00h    DWORD   -> receive handler
 04h    DWORD   -> control handler

Format of General Service Control Block:
Offset  Size    Description
 00h    DWORD   -> next GSCB (maintained internally by LSL)
 04h    DWORD   -> entry point for general service handler
 08h    WORD    command code for this general service (8000h-FFFFh)
Note:   the control block must not be altered or deallocated until the general
          service is removed

Format of Lookahead structure:
Offset  Size    Description
 00h    DWORD   -> Media header
 04h    DWORD   -> lookahead buffer
 08h    WORD    length of lookahead buffer
 0Ah  6 BYTEs   protocol ID
 10h    WORD    logical board number
 12h    WORD    lookahead size
--------N-2FD880-----------------------------
INT 2F U - Novell NetWare Lite v1.0+ - SERVER - INSTALLATION CHECK
        AX = D880h
Return: AL = FFh if installed
            DX = version number (0100h for v1.0, 0101h for v1.1)
            BX = data segment of resident copy
            CL = current state (00h SERVER is disabled, 01h SERVER is active)
            ES:DI -> private API entry point (see below)
            SI = ??? (offset of configuration info?)
SeeAlso: AX=7A00h,AX=D800h

Call SERVER API entry point with:
        BX = function
            0000h ???
                ???
                Return: ???
                Note: closes open files by calling INT 21/AH=3Eh
            0001h get connection information
                DX = connection number (0001h-max connections)
                ES:DI -> 28-byte buffer for connection information
                Return: CF clear if successful
                            ES:DI buffer filled
                        CF set on error
                            AX = FFFFh
            other
                Return: CF set
                        AX = 0001h (invalid function)
--------Q-2FDE01BX4450-----------------------
INT 2F U - Quarterdeck QDPMI.SYS v1.0 - INSTALLATION CHECK
        AX = DE01h
        BX = 4450h ("DP")
        CX = 4D49h ("MI")
        DX = 3039h ("09")
Return: AL = FFh if installed
            BX = 4D42h ("MB")
            CX = 4921h ("I!")
            DX = 8F4Fh
            ES:DI -> filename of DPMI host overlay
Note:   the installation check consists of testing for the existence of the
          character device QDPMI$$$
SeeAlso: INT 2F/AX=1687h,INT 31/AX=0000h
Index:  installation check;QDPMI
--------c-2FDF00-----------------------------
INT 2F - HyperWare programs - INSTALLATION CHECK
        AX = DF00h
        BX = product code
            4248h ('BH') HyperStb
            4448h ('DH') HyperDisk v4.20+
            4B48h ('KH') HyperKey
            5348h ('SH') HyperScreen
        CX = 0000h
        DX = 0000h
Return: AL = status
            00h not installed
            FFh multiplex number in use
                CX = 5948h ('YH') if selected product installed
                ---HyperDisk---
                BX = code segment of resident portion
                DX = HyperDisk local data version
Program: HyperDisk is a shareware disk cache by HyperWare (Roger Cross)
Note:   AH=DFh is the default; if it is already in use by some other program,
          HyperWare programs then scan multiplex numbers from C0h through FFh
SeeAlso: INT 13/AX=8EEDh
Index:  installation check;HyperDisk|installation check;HyperStb
Index:  installation check;HyperKey|installation check;HyperScreen
Index:  HyperDisk;installation check|HyperStb;installation check
Index:  HyperKey;installation check|HyperScreen;installation check
--------E-2F1687-----------------------------
INT 2F - DOS Protected-Mode Interface - INSTALLATION CHECK
        AX = 1687h
Return: AX = 0000h if installed
            BX = flags
                bit 0: 32-bit programs supported
            CL = processor type (02h=80286, 03h=80386, 04h=80486)
            DH = DPMI major version
            DL = two-digit DPMI minor version
            SI = number of paragraphs of DOS extender private data
            ES:DI -> DPMI mode-switch entry point
        AX nonzero if not installed
SeeAlso: AX=1686h,AX=43E0h,AX=DE01h/BX=4450h,AX=FB42h/BX=0001h
SeeAlso: INT 31/AX=0400h,INT 31/AX=5702h,INT 38/AH=10h

Call mode switch entry point with:
        AX = flags
            bit 0: set if 32-bit program
        ES = real mode segment of buffer for DPMI private data (ignored if
                SI was zero)
Return: CF set on error
            program still in real mode
            AX = error code (DPMI 1.0+)
               8011h unable to allocate all necessary descriptors
               8021h 32-bit program specified, but 16-bit DPMI host
        CF clear if successful
            CS = 16-bit selector corresponding to real-mode CS
            SS = selector corresponding to real-mode SS (64K limit)
            DS = selector corresponding to real-mode DS (64K limit)
            ES = selector to program's PSP (100h byte limit)
            FS = GS = 0
            high word of ESP = 0 if 32-bit program
            program now in protected mode
Note:   this entry point is only called for the initial switch to protected
          mode
--------E-2F43E0-----------------------------
INT 2F - Novell DOS Protected Mode Services (DPMS) - INSTALLATION CHECK
        AX = 43E0h
Return: AX = 0000h if installed
            ES:BX -> registration structure (see below)
Note:   this specification is still in beta
SeeAlso: INT 2F/AX=1687h

Format of registration structure:
Offset  Size    Description
 00h    DWORD   real-mode API entry point
 04h    DWORD   16-bit protected-mode API entry point
 08h  8 BYTEs   reserved (0)
 10h  8 BYTEs   blank-padded server OEM name
 18h    WORD    flags
                bit 0: fast processor reset available (286 only)
                bits 1-15 reserved (undefined)
 1Ah  2 BYTEs   DPMS version (major,minor)
 1Ch    BYTE    CPU type (02h = 286, 03h = 386 or higher)

Call DPMS entry point with:
        AX = 0100h call protected-mode procedure
                CX = number of words of stack to copy
                ES:DI -> callup/down register structure (see below)
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0101h call real-mode procedure (RETF return)
                CX = number of words of stack to copy
                ES:DI -> callup/down register structure (see below)
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0102h call real-mode procedure (IRET return)
                CX = number of words of stack to copy
                ES:DI -> callup/down register structure (see below)
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0103h call real-mode interrupt handler
                BL = interrupt number
                CX = number of words of stack to copy
                ES:DI -> callup/down register structure (see below)
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0200h allocate descriptors
                CX = number of descriptors to allocate
                Return: CF clear if successful
                            AX = first descriptor allocated
                        CF set on error
                            AX = error code (see below)
        AX = 0201h free a descriptor
                BX = descriptor
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0202h create alias descriptor
                BX = descriptor
                Return: CF clear if successful
                            AX = alias descriptor
                        CF set on error
                            AX = error code (see below)
        AX = 0203h build alias to real-mode segment
                BX = descriptor
                CX = real-mode segment
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0204h set descriptor base
                BX = descriptor
                CX:DX = base address
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0205h set descriptor limit
                BX = descriptor
                CX = limit
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0206h set descriptor type/attribute
                BX = descriptor
                CL = type
                CH = attribute
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0207h get descriptor base
                BX = descriptor
                Return: CF clear if successful
                            CX:DX = base address
                        CF set on error
                            AX = error code (see below)
        AX = 0300h get size of largest free block of memory
                Return: CF clear if successful
                            BX:CX = size
                        CF set on error
                            AX = error code (see below)
        AX = 0301h allocate block of extended memory
                BX:CX = size
                Return: CF clear if successful
                            BX:CX = base address
                            SI:DI = handle
                        CF set on error
                            AX = error code (see below)
        AX = 0302h free block of extended memory
                SI:DI = handle
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0303h map linear memory
                ES:[DI] = DDS
                Return: CF clear if successful
                            BX:CX = base address
                            SI:DI = handle
                        CF set on error
                            AX = error code (see below)
        AX = 0304h unmap linear memory
                SI:DI = handle
                Return: CF clear if successful
                        CF set on error
                            AX = error code (see below)
        AX = 0400h relocate segment to extended memory
                ES:SI = base address
                CX = limit
                BL = type
                BH = attribute
                DX = selector or 0000h
                Return: CF clear if successful
                            AX = selector
                            BX:CX = new base address
                            SI:DI = handle
                        CF set on error
                            AX = error code (see below)

Values for error code:
 8000h  general error
 8001h  unsupported function
 8011h  descriptor unavailable
 8012h  linear memory unavailable
 8013h  physical memory unavailable
 8021h  invalid value
 8022h  invalid selector
 8023h  invalid handle

Format of callup/down register structure:
Offset  Size    Description
 00h    DWORD   EDI
 04h    DWORD   ESI
 08h    DWORD   EBP
 0Ch  4 BYTEs   reserved (0)
 10h    DWORD   EBX
 14h    DWORD   EDX
 18h    DWORD   ECX
 20h    DWORD   EAX
 24h    DWORD   EIP
 28h    WORD    CS
 2Ah  2 BYTEs   reserved (0)
 2Ch    DWORD   EFLAGS
 30h    DWORD   ESP
 34h    WORD    SS
 36h  2 BYTEs   reserved (0)
 38h    WORD    ES
 3Ah  2 BYTEs   reserved (0)
 3Ch    WORD    DS
 3Eh  2 BYTEs   reserved (0)
 40h    WORD    FS
 42h  2 BYTEs   reserved (0)
 44h    WORD    GS
 46h  2 BYTEs   reserved (0)
--------c-2F4A10BX0000-----------------------
INT 2F - SMARTDRV v4.00+ - INSTALLATION CHECK AND HIT RATIOS
        AX = 4A10h
        BX = 0000h
        CX = EBABh (v4.1+; see Note)
Return: AX = BABEh if installed
            DX:BX = cache hits
            DI:SI = cache misses
            CX = ???
            BP = version in BCD (4.10 = 0410h)
Notes:  most of the SMARTDRV API, including this call, is supported by
          PC-Cache v8.0
        if DBLSPACE.BIN is installed but SMARTDRV has not yet been installed,
          unless CX=EBABh on entry, DBLSPACE.BIN displays the error message
          "Cannot run SMARTDrive 4.0 with DoubleSpace" and aborts the caller
          with INT 21/AX=4C00h
        SMARTDRV v3.x had a completely different API using IOCTL calls
SeeAlso: AX=4A10h/BX=0001h,AX=4A10h/BX=0004h,AX=4A10h/BX=0005h
SeeAlso: AX=4A10h/BX=0007h,AX=4A10h/BX=1234h,AX=4A11h/BX=0000h
SeeAlso: INT 21/AX=4402h"SMARTDRV",INT 21/AX=4403h"SMARTDRV"
--------d-2F4A11BX0000-----------------------
INT 2F - DBLSPACE.BIN - "GetVersion" - INSTALLATION CHECK
        AX = 4A11h
        BX = 0000h
Return: AX = 0000h (successful)
        BX = 444Dh ("DM")
        CL = first drive letter used by DBLSPACE (0=A:)
        CH = number of drive letters used by DBLSPACE
        DX = internal DBLSPACE.BIN version number (bits 14-0)
                bit 15 set if DBLSPACE.BIN has not yet been relocated to final
                position in memory (i.e. DBLSPACE.SYS /MOVE)
Program: DBLSPACE.BIN is the resident driver for DoubleSpace, the
          disk-compression software bundled with MS-DOS 6.0
SeeAlso: AX=4A11h/BX=0001h,AX=4A11h/BX=0002h,AX=4A11h/BX=0003h
SeeAlso: AX=4A11h/BX=0005h,AX=4A11h/BX=0007h,AX=4A11h/BX=FFFFh
SeeAlso: INT 21/AX=4404h"DBLSPACE"
--------T-2F4B02BX0000-----------------------
INT 2F - DOS 5+ TASK SWITCHER - INSTALLATION CHECK
        AX = 4B02h
        BX = 0000h
        ES:DI = 0000h:0000h
Return: ES:DI = 0000h:0000h if task switcher not loaded
        ES:DI -> task switcher entry point (see below) if loaded
            AX = 0000h
Notes:  the returned entry point is that for the most-recently loaded task
          switcher; the entry points for prior task switchers may be determined
          with the "get version" call (see below)
        this function is supported by PC Tools v8+ CPTASK
SeeAlso: AX=4A05h,AX=4B03h

Call task switcher entry point with:
        AX = 0000h get version
                Return: CF clear if successful
                            AX = 0000h
                            ES:BX -> task switcher version struct (see below)
                        CF set if unsupported function
        AX = 0001h test memory region
                ES:DI -> first byte to be tested
                CX = size of region to test
                Return: CF clear if successful
                            AX = memory type of tested region
                                0000h global
                                0001h global and local
                                0002h local (replaced on session switch)
                        CF set if unsupported function
        AX = 0002h suspend switcher
                ES:DI -> new task switcher's entry point
                Return: CF clear if successful
                            AX = state
                                0000h switcher has been suspended
                                0001h switcher not suspended, new switcher must
                                        abort
                                0002h switcher not suspended, but new switcher
                                        may run anyway
                        CF set if unsupported function
        AX = 0003h resume switcher
                ES:DI -> new task switcher's entry point
                Return: CF clear if successful
                            AX = 0000h
                        CF set if unsupported function
        AX = 0004h hook notification chain
                ES:DI -> callback info structure to be added to chain
                        (see AX=4B01h)
                Return: CF clear if successful
                            AX = 0000h
                        CF set if unsupported function
        AX = 0005h unhook notification chain
                ES:DI -> callback info structure to be removed from chain
                        (see AX=4B01h)
                Return: CF clear if successful
                            AX = 0000h
                        CF set if unsupported function
        AX = 0006h query API support
                BX = asynchronous API identifier
                Return: CF clear if successful
                            AX = 0000h
                            ES:BX -> API info structure (see below) for the
                                        client which provides the highest
                                        level of
                        CF set if unsupported function

Format of task switcher version structure:
Offset  Size    Description
 00h    WORD    major version of supported protocol  (current protocol is 1.0)
 02h    WORD    minor version of supported protocol
 04h    WORD    major version of task switcher
 06h    WORD    minor version of task switcher
 08h    WORD    task switcher ID (see AX=4B03h)
 0Ah    WORD    operation flags
                bit 0: set if task switcher disabled
                bits 1-15: reserved (0)
 0Ch    DWORD   pointer to ASCIZ task switcher name
                ("MS-DOS Shell Task Switcher" for DOSSHELL task switcher)
 10h    DWORD   pointer to previous task switcher's entry point or 0000h:0000h

Format of API info structure:
Offset  Size    Description
 00h    WORD    size of structure in bytes (000Ah)
 02h    WORD    API identifier
                0001h NetBIOS
                0002h 802.2
                0003h TCP/IP
                0004h LAN Manager named pipes
                0005h Novell NetWare IPX
 04h    WORD    major version \ of highest version of API for which the support
 06h    WORD    minor version / level specified in the next field is provided
 08h    WORD    support level
                0001h minimal support
                0002h API-level support
                0003h switcher compatibility
                0004h seamless compatibility
--------N-2F7A00-----------------------------
INT 2F - Novell NetWare - LOW-LEVEL API (IPX) INSTALLATION CHECK
        AX = 7A00h
Return: AL = 00h not installed
           = FFh installed
                ES:DI -> FAR entry point for routines accessed exclusively
                        through INT 7A in NetWare versions through 2.0a.  Call
                        with same values as INT 7A
SeeAlso: AX=7AFFh/BX=0000h,AX=D800h,INT 64"Novell",INT 7A"Novell"
--------N-2F7A40-----------------------------
INT 2F - Novell NetWare - TCP/IP Protocol Stack - INSTALLATION CHECK
        AX = 7A40h
Return: AX = 7AFFh if installed
            BX = ???
                bit 0: ???
                bit 1: ???
                bits 15-2: ???
            CX = version (CH=major, CL=minor)
            DX = 0000h
            ES:DI -> entry point for ???
SeeAlso: AX=7A41h
--------N-2F7A90-----------------------------
INT 2F U - Novell NetWare - NETBIOS.EXE 3+ - INSTALLATION CHECK
        AX = 7A90h
Return: AL = 00h if present
            BX = ???
            CX = PSP segment of NETBIOS resident code
SeeAlso: AX=7AFEh
--------T-21E400-----------------------------
INT 21 - DoubleDOS - INSTALLATION CHECK/PROGRAM STATUS
        AX = E400h
Return: AL = 00h if DoubleDOS not present
           = 01h if running in visible DoubleDOS partition
           = 02h if running in the invisible DoubleDOS partition
SeeAlso: AH=E5h"DoubleDOS",AX=F400h
--------T-21F400-----------------------------
INT 21 - DoubleDOS - INSTALLATION CHECK/PROGRAM STATUS
        AX = F400h
Return: AL = 00h if DoubleDOS not present
           = 01h if running in visible DoubleDOS partition
           = 02h if running in the invisible DoubleDOS partition
SeeAlso: AX=E400h,AH=F5h"DoubleDOS"
--------T-21F5-------------------------------
INT 21 - DoubleDOS - OTHER PROGRAM STATUS
        AH = F5h
Return: AL = 00h no program in other partition
           = 01h program in other partition is running
           = 02h program in other partition is suspended
SeeAlso: AH=E5h"DoubleDOS",AX=F400h"DoubleDOS"

*)
