{
 $Id$
}
{*****************************************************************************
 *
 * Produces:  remote sysop Manager for files
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Man; {manager}

{$X+,V-,O+}

Interface

Uses
  Crt, Dos, S_string, Crosslib, F_file, Fil_spec,
  Nw_msg, Nw_Forw, Fm_struct, Fm_basic, Fm_log, Fm_noti, Fm_hex, Fm_dup,
  MkMsgFid, MKMsgAbs, MKOpen, MKDos, MKstring, MKGlobt;


Function  Verstr ( ver : word ) : string;
Procedure Manager;

Implementation

var
  msgout : absmsgPtr;


Procedure DisposeMessage;
Begin
  If SETUP.KillRcvd then
    Begin
      msgout^.deletemsg;
    End else
    Begin
      msgout^.setrcvd(true);
      msgout^.rewritehdr;
    End;
End;



Function  VerStr ( ver : word ) : String;
Var Tmp : String;
Begin
  Tmp := Int_to_str(ver);
  While length(tmp) < 3 do Tmp := '0' + Tmp;
  Verstr := First(1,tmp)+'.'+last(2,Tmp);
End;


Procedure Manager;
Var
  Sr           : Searchrec;
  Dt           : DateTime;
  Compare      : Longint;
  Tot          : Word;

  D               : AddrType;
  Created         : Boolean;
  Changed         : Boolean;
  Requests        : Boolean;
  UnlinkedWanted  : Boolean;
  HelpWanted      : Boolean;
  QueryWanted     : Boolean;
  ListWanted      : Boolean;
  FlowWanted      : Boolean;
  CostWanted      : Boolean;
  Costgroup,
  Flowgroup       : Word;

  RemFromnode     : Nodetype;
  RemFrom         : Boolean;
  FReply          : Text;
  I               : Integer;
  Nfxinx          : Word;


  Function NodeAllowed( FromNode : NodeType ) : Boolean;
  Var
    Pwd    : string;
  Begin
    Pwd := extractwords(1,1,msgout^.getsubj);
    If wordcnt(msgout^.getsubj) > 1 then
      msgout^.setsubj(extractwords(2,wordcnt(msgout^.getsubj)-1,msgout^.getsubj))
       else msgout^.setsubj('');

    NodeAllowed := False;

    NFXinx := 1;
    While (NFXinx <= Nodeidx) and (Not NodeEQ(NFXt^[NFXinx].ADDRESS, FromNode)) Do Inc(NFXinx);
    If NFXinx <= Nodeidx then
      Begin
        Seek (nf, nfxt^[nfxinx].noderec);
        BlockRead (nf, node,sizeof(node));
        If (Remote in node.Status) then
          Begin
            If (upper(Pwd) = upper(node.MgrPassword)) then
              NodeAllowed := True Else
                Begin
                  NotifyCR(11,'Invalid Mgr Pwd '+Pwd);
                  msgout^.setsubj(pwd);
                End;
          End Else
          Begin
            NotifyCR(11,'Not authorized to use FileMgr');
            msgout^.setsubj('');
          End;
      End Else
      Begin
        Node.SysopName := 'Sysop';
        Node.MgrStatus := [Hold, Direct];
      End;
  End;

  Procedure WriteIt(Str:String);
  Begin
    dostringln(Str);
    Str := Strip('B',#13,str);
    If RemFrom then Writeln(FReply,Str);
  End;

  Procedure Create;
  var tmp : string;
  Begin
    If not Created then
      Begin
        tmp := node.sysopname;
        if tmp = '' then tmp := 'Sysop';

        Init_Message ('F'+setup.netmailpath, true, 0, [net], fromnode, tonode,
                        'FileMgr v'+verstr(versionnr), node.sysopname, 'FileMgr request');
        Open_Message;
        Set_Attrib2(node.mgrstatus);
        Set_Attrib([privat,killsent],'F');
        Dostringln('Your message has been processed by FileMgr, with the following result :'+#13);
        Created := True;
      End;
  End;

  Procedure AddArea (TAG : String; all:boolean);
  Var
    remotefrom : nodetype;
    s      : text;
    afs    : word;
    found  : boolean;
    uplink : word;
    tm     : string;
    TMs    : AbsMsgPtr;

     Function one_group (uplink:byte) : byte;
     var x,y : word;
     begin
       y := 0;
       for x := 1 to 255 do
         if setup.uplink[uplink].groups[x] then inc(y);
       if y > 1 then one_group := 0 else
         begin
           y := 0;
           repeat inc(y); until setup.uplink[uplink].groups[y];
           one_group := y;
         end;
     end;

     Function Access_to_uplink_group (uplink:byte) : boolean;
     var f : boolean;
         x : word;
     begin
       if (setup.uplink[uplink].address.zone = 0) and
          (setup.uplink[uplink].address.net = 0) then
            begin
              access_to_uplink_group := false;
              exit;
            end;
       x := 0;
       f := false;
       repeat
         inc(x);
         if setup.uplink[uplink].groups[x] and node.groups[x] then
           f := true;
       until f or (x = 255);
       access_to_uplink_group := f;
     end;

     procedure forwardrequest(creerarea, adduplink, addnode:boolean);
     var
       i : word;
     begin
        if (forwreq in node.status) or not creerarea {oud area opnieuw} then
          begin
            found := false;
            uplink := 0;
            while not found and (uplink < 20) do
              begin
                inc(uplink);
                If Access_to_uplink_group(uplink) then
                {als node toegang heeft tot 1 van de uplink groups}
                  begin

                    if setup.uplink[uplink].areafile <> '' then
                      begin
                        assign(s,setup.uplink[uplink].areafile);
                        {$I-} reset(s); {$I+}
                        If ioresult = 0 then
                          begin                    {zoeken in file}
                             while not eof(s) and not found do
                               begin
                                 readln(s,tm);
                                 found := extractwords(1,1,upper(tm)) = upper(tag);
                               end;
                             close(s);
                          end;
                      end;
                    if (setup.uplink[uplink].areafile = '') or found then
                      begin
                        NotifyCR(11,TAG+' requested from uplink '+node2str(setup.uplink[uplink].address));
                        WriteIt(TAG+' requested from uplink '+node2str(setup.uplink[uplink].address));
                        if setup.noti_req then
                          WriteToTmpFile(systempath+'fmsystmp.#$',tag+' requested from uplink '+
                            node2str(setup.uplink[uplink].address)+' by '+node2str(node.address));

                        {bericht sturen}
                        TMs := New(FidoMsgPtr, Init);
                        TMs^.SetMsgPath(setup.netmailpath);
                        TMs^.StartNewMsg;
                        TMs^.SetMailType(mmtNetmail);
                        Move(setup.address[setup.uplink[uplink].aka],d,sizeof(d));
                        TMs^.SetOrig(d);
                        Move(setup.uplink[uplink].address,d,sizeof(d));
                        TMs^.SetDest(d);
                        TMs^.SetFrom(setup.sysopname);
                        TMs^.SetTo(setup.uplink[uplink].mgrname);
                        TMs^.SetSubj(setup.uplink[uplink].password);
                        TMs^.SetDate(DateStr(GetDosDate));   {Set msg date mm-dd-yy}
                        TMs^.SetTime(TimeStr(GetDosDate));   {Set msg time hh:mm}
                        TMs^.SetRefer(0);                    {Set reference #, often 0}
                        TMs^.Setlocal(true);
                        TMs^.SetPriv(true);
                        Tms^.putbyte(Tms^.getbyte(186) or 128, 186); {killsent}
                        TMs^.DoKludgeln(msgid(setup.uplink[uplink].address));
                        TMs^.DoKludgeLn(#1'PID: FileMgr '+versionstr(versionnr));
                        If TMs^.OpenMsgBase <> 0 then {};
                        if setup.uplink[uplink].status and $02 = $02 then
                          TMs^.DoStringLn('+'+tag) else Tms^.DostringLn(tag);
                        Tms^.DoStringln('---'+msgtearline);
                        If TMs^.WriteMsg <> 0 then {};
                        If TMs^.CloseMsgBase <> 0 then {};
                        Dispose(TMs, Done);

                        {area creeren}
                        if creerarea then
                          begin
                            afs := areaidx +1;
                            FillChar (afxt^[afs],SizeOf(afxt^[afs]), 0);
                            FillChar (AREA, SizeOf(AREA), 0);
                            FillChar (sfxt^, SizeOf(sfxt^), 0);
                            Afxt^[afs].tag     := TAG;
                            afxt^[afs].grp     := one_group(uplink);
                            afxt^[afs].arearec := filesize(af);
                            area.Tag          := tag;
                            area.Grp          := one_group(uplink);
                            if setup.uplink[uplink].areafile <> '' then
                              area.Name         := extractwords(2,wordcnt(tm)-1,tm) else
                                area.name := upper(tag)+' requested from uplink by '+node2str(node.address);
                            area.Format       := 'FILESBBS.TPL';
                            area.Aka          := setup.uplink[uplink].aka;
                            area.Status := [CRC, Secure, DupCheck, FuzzyDup, Longdesc];
                            area.listspec  := 'FILES.BBS';
                            area.replacemode := 1;

                            inc(areaidx);

                            if one_group(uplink) <> 0 then
                              begin
                                Seek (GF, 0);
                                While (not EOF(GF)) and (GROUP.groupnr <> one_group(uplink)) do Read (GF, GROUP);
                                if GROUP.groupnr = one_group(uplink) then
                                  begin
                                    area.rearchive := group.rearchive;
                                    area.usearchiver := group.usearchiver;
                                    area.batchfile := group.batchfile;
                                    area.replacemode := group.replacemode;
                                    area.msgfile := group.msgfile;
                                    area.inclhost := group.inclhost;
                                    area.incluplink := group.incluplink;
                                    area.usebanner := group.usebanner;
                                    area.addpercent := group.addpercent;
                                    area.alllinks := group.alllinks;
                                    area.block := group.block;
                                    area.costperblock := group.costperblock;
                                  end;
                              end;

                            for i := 1 to 12 do
                              begin
                                area.flow[i].bytes := -1;
                                area.flow[i].files := -1;
                              end;
                          end;

                        if adduplink then
                          begin                 {node op area aansluiten}
                            sfxt^[1].a := setup.uplink[uplink].address;
                            sfxt^[1].s := [export,import];
                            inc(area.exportnr);
                          end;

                        if addnode then
                          begin
                            sfxt^[2].a := node.address; {requesting node}
                            sfxt^[2].s := [export];
                            inc(area.exportnr);
                          end;

                        afxt^[afs].arearec := filesize(af);
                        seek(af, afxt^[afs].arearec);

                        blockwrite(af,area,sizeof(area));
                        blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype));
                        found := true;
                      end;
                  end;
              end; { while not found }
          end; { if forwreq }

     end;

     Procedure SortList(NrExp : Byte);
       Var I,J : Byte;

         Procedure Swp (VAR X,Y : ExportType);
         Var T : ExportType;
         Begin
           Move (X, T, SizeOf(ExportType));
           Move (Y, X, SizeOf(ExportType));
           Move (T, Y, SizeOf(ExportType));
         End;

       Begin { procedure sortlist }
         for I := 1 to NrExp do
           for J := 1 to NrExp do
             with sfxt^[I].A do
               Begin
                 if Zone < sfxt^[J].A.Zone
                   then Swp(sfxt^[I], sfxt^[J])
                     else if Zone = sfxt^[J].A.Zone
                       then if Net < sfxt^[J].A.Net
                         then Swp(sfxt^[I],sfxt^[J])
                           else if Net = sfxt^[J].A.Net
                             then if Node < sfxt^[J].A.Node
                               then Swp(sfxt^[I], sfxt^[J])
                                 else if Node = sfxt^[J].A.Node
                                   then if Point < sfxt^[J].A.Point
                                     then Swp(sfxt^[I],sfxt^[J]);
               End;
       End;

  Begin  { procedure addarea }
    if remfrom then remotefrom := remfromnode else remotefrom := fromnode;

    AFs := 1;
    While (AFs <= Areaidx) and (TAG <> AFXt^[AFs].TAG) do Inc(AFs);
    if AFs <= Areaidx then
      begin
        GetArea (AFs);
        With AREA do
          begin
            if node.groups[area.grp] or (area.grp = 0) then
              begin
                I := 1;
                While (I <= AREA.ExportNr) and (not NodeEQ(sfxt^[I].A, remoteFrom)) do Inc(I);
                if I > ExportNr then
                  begin
                    move(remotefrom,sfxt^[I].A,sizeof(remotefrom));
                    sfxt^[i].s := [export];
                    Inc (AREA.ExportNr);
                    SortList(ExportNr);
                    afxt^[afs].arearec := filesize(af);
                    seek(af, afxt^[afs].arearec);
                    blockwrite(af,area,sizeof(area));
                    blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype));

                    If WhereX > 1 then writeln;
                    NotifyCR(11,TAG + ' added');
                    WriteIt ('Added ' + TAG);

                    if disc in area.status then
                      begin   {disconnected area again aansluiten bij uplink }
                        area.status := area.status - [disc];
                        area.status := area.status - [noti];
                        forwardrequest(false,false,false);
                      end;

                  end else
                  begin
                    if not all then
                      begin
                        NotifyCR(11,'Already active for '+TAG);
                        WriteIt ('Already active for ' + TAG);
                      end;
                  end;
              end else
              begin
                if not all then
                  begin
                    NotifyCR(11,'Not authorized for '+TAG);
                    WriteIt ('Not authorized for '+TAG);
                  end;
              end;
          end;
      end else
      begin
        NotifyCR(11,TAG+' not found');
        WriteIt(TAG+' not found');

        forwardrequest(true,true,true);
      end;
  end;

  Procedure RemoveArea (TAG : String; all:boolean);
  Var
    remotefrom : nodetype;
    I,J : Byte;
    afs : Word;
  begin
    if remfrom then remotefrom := remfromnode else remotefrom := fromnode;

    AFs := 1;
    While (AFs <= Areaidx) and (TAG <> AFXt^[AFs].TAG) do Inc(AFs);
    if AFs <= Areaidx then
      begin
        GetArea (AFs);
        With AREA do
          begin
            I := 1;
            While (I <= ExportNr) and (not NodeEQ(sfxt^[I].A, remoteFrom)) do Inc(I);
            if (I <= ExportNr) and not (mandatory in sfxt^[i].s) then
              begin
                FillChar (sfxt^[i], SizeOf(NodeType), 0);
                for J := I to ExportNr-1 do sfxt^[J] := sfxt^[J+1];
                Dec (ExportNr);

                afxt^[afs].arearec := filesize(af);
                seek(af, afxt^[afs].arearec);
                blockwrite(af,area,sizeof(area));
                blockwrite(af,sfxt^,area.exportnr*sizeof(exporttype));

                NotifyCR (11,TAG + ' removed');
                WriteIt ('Removed ' + TAG );
              end else
              begin
                if i > exportnr then
                  begin
                    if not all then
                      begin
                        NotifyCR(11,'Not active for '+TAG);
                        WriteIt('Not active for '+TAG);
                      end;
                  end else
                  begin
                    Notifycr(11,'The area '+tag+' is mandatory. Area not removed.');
                    WriteIt('The area '+tag+' is mandatory. Area not removed!');
                  end;
              end;
          end;
      end else
      begin
        NotifyCR(11,TAG+' not found');
        WriteIt (TAG+' not found');
      end;
  end;

  Procedure AllAreas(Add : Boolean; Error:Boolean; CH : Byte);
  Var
    I    : Byte;
    Disp : Boolean;
    Nr   : Word;

    Procedure WriteGroup (ID : byte);
    Begin
      Seek (GF,0);
      While (not EOF(GF)) and (GROUP.groupnr <> ID) do Read(GF, GROUP);
      if GROUP.groupnr = ID
        then WriteIt (#13 + GROUP.groupName + #13)
          else WriteIt (#13 + 'Group ''' + int_to_str(ID) + ''' (not described)' + #13);
    End;

  Begin  { procedure allareas }
    If node.Groups[ch] then
      Begin
        Nr := 0;
        Disp := False;
        For AFXinx := 1 to Areaidx do
          begin
            With AFXt^[AFXinx] do
              begin
                if Grp = CH then
                  begin
                    if NOT Disp then
                      begin
                        WriteGroup(Grp);
                        Disp := True;
                      end;
                    Inc (Nr);
                    if Add then AddArea(TAG,true)
                      else RemoveArea(TAG,true);
                  end;
              end;
          end;
        if Add then WriteIt (#13 + int_to_str(Nr) + ' areas added.' +#13)
          else WriteIt (#13 + int_to_str(Nr) + ' areas removed.' +#13);
      End Else
      Begin
        If error then
          WriteIt ('You don''t have access to group '''+int_to_str(CH)+'''' +#13);
      End;
  End;

  Function TICrequest (Address : NodeType; pLine : String) : Boolean;
  VAR
    ATT     : File;
    SR      : SearchRec;
    Mask    : string[12];
    Sent    : Array[1..64] of String;
    SentNr,
    SentInx : Byte;
    Expo    : Exporttype;
    TMP     : File;
    BBS     : Text;
    Work    : String;
    DT      : DateTime;
    DOW     : Word;
    Hinx    : Word;               { HISTORY counter }
    MailStatus : MailStatusType;

    Function GetBbsArea(directory:string) : Word; {0 if not found, anders rec nummer}
    Var
      Found    : Boolean;
      Tel, Max : Word;
    Begin
      If last(1,directory) <> '\' then directory := directory + '\';
      FillChar(BbsArea,Sizeof(bbsarea),#0);
      If Exist(systempath+'filearea.fm') then
        Begin
          Assign (bf, systempath+'filearea.fm');
          Reset (bf,1);
          Max   := (Filesize(bF) div sizeof(bbsarea)) -2;
          Tel := 0;
          Found := False;
          While not found and (tel <= Max) do
            Begin
              Seek(bF, (Tel * SizeOf(Bbsarea)) + sizeof(bbsarea) + 20);
              BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
              If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';
              If Upper(Directory) = Upper(Bbsarea.path) then
                Found := True;
              Inc(Tel);
            End;
          Close(bf);
          If found then GetBbsArea := Tel Else GeTbbsArea := 0;
       End Else GetBbsArea := 0;
    End;

    Procedure ProcessReq;
    Var
      Filebase : byte; {copy van setup.filebase}
      B        : bbsareatype;
      X        : word;
      Name     : string;
    Begin
      Inc (SentNr);
      Sent[SentNr] := SR.Name;
      NotifyCR(11,' -> found '+SR.NAME+' in '+aFXT^[AFXINX].TAG);
      Writeit(' -> found '+Sr.name+' in '+aFXT^[AFXINX].TAG);

      { create a valid INFO record for this file }
      FillChar (INFO, SizeOf(INFO), 0);
      INFO.Status := [Local];
      Info.TAG    := AFXt^[AFXinx].TAG;
      info.FilePath    := Area.Directory;
      info.FileSpec    := SR.Name;
      Assign (TMP, Area.Directory+SR.Name);
      {$I-} Reset (TMP,1); {$I+}
      If ioresult = 0 then
        begin
          info.Size        := FileSize(TMP);
          info.CRCstr      := StrHex(FileCRC(TMP),8);
          Case Setup.Filebase of
            0 : Begin  {files.bbs type filebase}
                  filebase := 0;
                  bbsarea.path := area.listspec;
                End;
            1 : Begin {ra 2.0 filebase}
                  if area.areanr = 0 then
                    Begin
                      filebase := 0;
                      bbsarea.path := area.listspec;
                    End Else
                    Begin
                      filebase := 1;
                      getbbsarea(area.directory);
                      B := BbsArea;
                      If last(1,b.path) <> '\' then b.path := b.path + '\';
                      Reset(bF,1);               {eerste record lezen voor filebase path}
                      Seek(bF, 20);
                      BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
                      If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';
                      Close(bf);
                    End;
                End;
          End; {case}
          If not Find_File (sr.name, filebase, bbsarea.path, b) then
            info.Description := '[no description available]' else
              Begin
                x := 0;
                while x < desc_length do
                  begin
                    inc(x);
                    if x < 255 then info.description := info.description + desc_buffer[x];
                    info.longdesc[x] := desc_buffer[x];
                  end;
                info.longcount := desc_length;
              End;
          FillChar (info.From, SizeOf(info.From), 0);
          if area.AKA > 0 then
            begin
              info.From    := SETUP.Address[area.AKA];
              info.MatchIt := False;
            end else info.MatchIt := True;
          info.Origin       := info.From;
          info.cSeen        := 1;
          if info.MatchIt
            then info.SeenByLst[1] := SETUP.Address[1]
              else info.SeenbyLst[1] := info.From;
          if Address.Point = 0 then
            begin
              info.cSeen        := 2;
              info.SeenbyLst[2] := Address;
            end;
          info.Path[1]      := info.From;
          With DT do
            begin
              GetTime (Hour, Min, Sec, DOW);
              GetDate (Year, Month, Day, DOW);
            end;
          info.PathUnix[1]  := GetUnixDate(DT);
          info.PathStamp[1] := ZoneString(DT, DOW);
          info.cPath        := 1;

          expo.a := node.address;
          expo.s := [export];
          expo.m := node.defstatus;

          name := WriteForwardInfo1(info.filepath+sr.name);
          if node.akaaddress.zone <> 0 then { forwarding to node's main address }
            WriteForwardInfo(expo,node.akaaddress,name) else
              WriteForwardInfo(expo,expo.a,name);
        End;
    End;

  Begin   {procedure tickrequest }
    TICrequest := False;
    Mask    := Upper(Extractwords(2,1,Pline));
    sentinx := 0;

    If mask <> '' then
      Begin
        If Copy(Mask, 1, Pos('.',Mask)-1) <> '*' then
          Begin
            FillChar (Sent, SizeOf(Sent), 0);
            SentNr  := 0;
            Notify(11,'Requested '+expand(mask,12));
            Writeit('Requested '+expand(mask,12));
            AfxInx := 0;
            Repeat
              Inc(AfxInx);
              Seek (AF, AFXt^[AFXinx].AreaRec);
              BlockRead (AF, AREA, SizeOf(AREA));
              If node.groups[area.grp] then
                begin
                  Write(' '+expand(afxt^[AfXinx].tag,20));
                  Write(replicate(21,#8));
                  sentinx := 0;
                  FindFirst (AREA.Directory + mask, READONLY + ARCHIVE, SR);
                  If DOSerror=0 then
                    begin
                      SentInx := 1;
                      While (SentInx <= SentNr) and (Sent[SentInx] <> SR.Name) do Inc(SentInx);


                      {lezen in history.fm voor de juiste area naam}
                      if Is_Dup (sr.name,'',0,0,0,false,false,false,false,false) <> 0 then
                        begin
                          dow := afxinx;
                          while (afxinx <= areaidx) and (afxt^[afxinx].tag <> history.tag) do inc(afxinx);
                          if afxinx > areaidx then afxinx := dow else
                            area.tag := history.tag;
                        end;

                      If SentInx > SentNr then ProcessReq;
                    end;
                  while doserror=0 do findnext(sr);
                end;
            Until (AfxInx >= Areaidx) or (SentInx > 0);

            If SentNr = 0 then
              Begin
                Writeit(' -> no matching files found');
                NotifyCr(11,' -> no matching files found');
              End;
          End;
      End;
  End;

  Procedure Analyze_Msg_Txt;
  Var
    grpinx          : Word;
    pTel            : Word;
    pLine           : String;
    pWord           : String[25];

    Function NextLine : String;
    Var S : String;
    Begin
      S := '';
      If WordCnt(Msgout^.getsubj) = 0 then
        Begin
          s := MsgOut^.GetString(78);
          Nextline := S;
        End Else
        Begin
          S := Upper(Extractwords(1,WordCnt(msgout^.getsubj)-1,msgout^.getsubj));
          If wordcnt(msgout^.getsubj) > 1 then
            Msgout^.setsubj(Extractwords(2,wordcnt(msgout^.getsubj)-1,Msgout^.getsubj))
              else msgout^.setsubj('');
          If S = '-H' then
            NextLine := '%HELP' Else
          If S = '-L' then
            NextLine := '%LIST' Else
          If S = '-Q' then
            NextLine := '%QUERY' Else
          If S = '-U' then
            NextLine := '%UNLINK' Else NextLine := '';
        End;
    End;

  Begin
    Ptel := 0;
    Repeat
      pLine := Upper(NextLine);
      Inc(ptel);
      PLine := Strip('B',' ',pLine);
      pWord := Extractwords(1,1,pLine);

      If pline <> '' then
        Begin                         {empty}
          Case pLine[1] of
            #1  : Dec(Ptel);          {kludge}
            '-' : If first(3,pword) <> '---' then
                    Begin
                      Create;
                      If (First(2,pword) = '-%') and (Length(pLine) > 2)
                        then AllAreas(False, true, str_to_int(last(length(pline)-2,pLine))) else
                           RemoveArea ( extractwords(1,1,last(length(pline)-1,pline)) ,false);
                    End;
            '+' : Begin
                    Create;
                    If (First(2,pword) = '+%') and (Length(pLine) > 2)
                      then AllAreas(True, true, str_to_int(last(length(pline)-2,pline))) else
                        AddArea (  extractwords(1,1,last(length(pline)-1,pline)) ,false );
                  End;
            '%' : If Length(pLine) > 1 then
                    Begin
                      If (Pos('FROM',Pword) <> 0) then
                        Begin
                          Create;
                          If pTel = 1 then
                            Begin
                              If From in node.status then
                                Begin           {vind node waarvoor deze}
                                                {remote maintenance voor}
                                  NFXinx := 0;  {bestemd is}
                                  Str2Node(extractwords(2,1,pline),RemFromNode,setup.address[1],remfrom);
                                  If RemFrom then
                                    Begin
                                      Repeat
                                        Inc(NFXinx);
                                      Until (NFXinx > Nodeidx) or (NodeEQ(NFXt^[NFXinx].ADDRESS,
                                        RemFromNode));
                                      If NFXinx <= Nodeidx then
                                        Begin
                                          Seek (nf, nfxt^[nfxinx].noderec);
                                          blockRead (nf, node,sizeof(node));
                                          If (Remote in node.Status) then
                                            Begin
                                              writeln('(remote maint for '+node2str(remfromnode)+') ');
                                              dostringln('Performing remote maintenance for '
                                               +node2str(remfromnode)+':'+#13);
                                              WritelogCR(11,'Performing remote maintenance for '+node2str(remfromnode));
                                              {tijdelijke file voor kopy}
                                              Assign(Freply,'FMF$FMF.$F$');
                                              {$I-} Rewrite(Freply); {$I+}
                                              If ioresult <> 0 then RemFrom := False;
                                            End Else
                                            Begin
                                              dostringln('You are not allowed to do remote maintenance for '
                                                +node2str(remfromnode));
                                              Pline := '---';
                                              RemFrom := False;
                                            End;
                                        End Else
                                        Begin
                                          dostringln('You are not allowed to do remote maintenance for '
                                            +node2str(remfromnode));
                                          Pline := '---';
                                          RemFrom := False;
                                        End;
                                    End Else
                                    Begin
                                      dostringln('No valid nodenumber '+extractwords(2,1,pline));
                                      Pline := '---';
                                    End;
                                End Else
                                Begin
                                  dostringln('You are not allowed to use the %FROM command, request ignored');
                                  Pline := '---';
                                End;
                            End Else
                            Begin
                              dostringln('%FROM should be the first command, request ignored');
                              Pline := '---';
                              Changed := False;
                            End;
                        End Else
                      If Pos('STATUS',pword) <> 0 then
                        Begin
                          Create;
                          WriteStatusMsg;
                        End Else
                      If (Pos('UNLINK',pword) <> 0) or (pword = '%U') then
                        UnlinkedWanted := True Else
                      If (Pos('LIST',  pword) <> 0) or (pword = '%L') then
                        ListWanted     := True Else
                      If (Pos('QUERY', pword) <> 0) or (pword = '%Q') then
                        QueryWanted    := True Else
                      If (Pos('HELP',  pword) <> 0) or (pword = '%H') then
                        HelpWanted     := True Else
                      If (Pos('COST',  pword) <> 0) or (pword = '%C') then
                        Begin
                          CostWanted     := True;
                          Costgroup := 0;
                          If WordCnt(pline) > 1 then
                            CostGroup := str_to_int(Extractwords(2,1,pline));
                          If costgroup = 0 then
                            begin
                              create;
                              costwanted := false;
                              writeit('You must specify a grouptag when requesting a cost report!');
                            end;
                        End Else
                      If (Pos('VOLUME',pword) <> 0) then
                        Begin
                          create;
                          node.avaraging := str_to_int(extractwords(2,1,pline));
                          writeit('Total maximum file volume set to '+int_to_str(node.avaraging)+' Kb''s');
                          writelogcr(11,'Total maximum file volume set to '+int_to_str(node.avaraging)+' Kb''s');
                          changed := true;
                        End else
                      If (Pos('BUNDLES',pword) <> 0) then
                        Begin
                          create;
                          node.maxsize := str_to_int(extractwords(2,1,pline));
                          writeit('Total maximum bundle size set to '+int_to_str(node.maxsize)+' Kb''s');
                          writelogcr(11,'Total maximum bundle size set to '+int_to_str(node.maxsize)+' Kb''s');
                          changed := true;
                        End else
                      If (Pos('FILESI',pword) <> 0) then
                        Begin
                          create;
                          node.maxfilesize := str_to_int(extractwords(2,1,pline));
                          writeit('Total maximum individual file size set to '+int_to_str(node.maxfilesize)+' Kb''s');
                          writelogcr(11,'Total maximum individual file size set to '+int_to_str(node.maxfilesize)+' Kb''s');
                          changed := true;
                        End else
                      If (Pos('FLOW',  pword) <> 0) or (pword = '%F') then
                        Begin
                          FlowWanted     := True;
                          Flowgroup := 0;
                          If WordCnt(pline) > 1 then
                            FlowGroup := str_to_int(Extractwords(2,1,pline));
                          If flowgroup = 0 then
                            begin
                              create;
                              flowwanted := false;
                              writeit('You must specify a grouptag when requesting a flow report!');
                            end;
                        End Else
                      If (Pos('REQ',   pword) <> 0) or (Pos('RESEND',pword) <> 0) then
                        Begin
                          Create;
                          If not requests then requests := true;
                          If remfrom then
                            Ticrequest(RemFromNode,pLine) else
                              TICrequest (FromNode, pLine);
                        End Else
                      If (Pos('RESUME',pword) <> 0) or (Pos('ACTIVE',pword) <> 0) then
                        Begin
                          Create;
                          NotifyCR(11,'Resume requested');
                          If Pause in node.Status then
                            Begin
                              Node.Status := node.Status - [Pause];
                              WriteIt ('Your system is not on PAUSE anymore. Files will be sent as usual.');
                              WritelogCR(11,node2str(tonode)+' not on pause anymore');
                            End Else WriteIt ('Your system isn''t on PAUSE.');
                          Changed := true;
                        End Else
                      If Pos('TICK',  pword) <> 0 then
                        Begin
                          Create;
                          WriteIt ('Tick/Raid compatible *.TIC files will be sent');
                          WritelogCR (11,'Normal (tick compatible) *.TIC files will be sent');
                          node.tictype := 1;
                          Changed := True;
                        End Else
                      If Pos('FILEM', pword) <> 0 then
                        Begin
                          Create;
                          WriteIt ('FileMgr advanced *.TIC files will be sent');
                          WritelogCR (11,'Filemgr advanced *.TIC files will be sent');
                          node.tictype := 2;
                          changed := true;
                        End Else
                      If Pos('NONE',pword) <> 0 then
                        Begin
                          Create;
                          WriteIt ('No *.TIC files will be sent');
                          WritelogCR (11,'No *.TIC files will be sent');
                          Node.tictype := 0;
                          Changed := True;
                        End Else
                      If (Pos('PAUS',pword) <> 0) or (pos('INACTIVE',pword) <> 0) then
                        Begin
                          Create;
                          NotifyCR(11,'Pause requested');
                          If not (Pause in node.Status) then
                            Begin
                              Node.Status := node.Status + [Pause];
                              WriteIt ('Your system is now on PAUSE. No files will be sent.');
                              WritelogCR(11,node2str(node.address)+' is now on PAUSE');
                            End Else WriteIt ('You were already on PAUSE');
                          Changed := true;
                        End Else
                      If Pos('COMPR',pword) <> 0 then
                        Begin
                          Create;
                          NotifyCR(11,'Compress change requested');
                          If Extractwords(2,1,pline) = '?' then
                            Begin
                              WriteIt('The compression program setup for you is '+zipstr[node.archiver]);
                              WriteIt('Available compression programs:');
                              WriteIt('ZIP'+#13+'ARJ'+#13+'LZH'+#13+'ARC');
                            End Else
                            Begin
                              If (Extractwords(2,1,pline) <> 'ZIP') and (Extractwords(2,1,pline) <> 'ARJ') and
                                 (Extractwords(2,1,pline) <> 'LZH') and (Extractwords(2,1,pline) <> 'ARC') then
                                 WriteIt('Unknown compression program '+extractwords(2,1,pline)) Else
                                   Begin
                                     Changed := True;
                                     If Extractwords(2,1,pline) = 'ZIP' then node.archiver := ZIP else
                                     If Extractwords(2,1,pline) = 'ARJ' then node.archiver := ARJ else
                                     If Extractwords(2,1,pline) = 'LZH' then node.archiver := LZH else
                                     If Extractwords(2,1,pline) = 'ARC' then node.archiver := ARC;
                                     WriteIt('Compression program changed to '+zipstr[node.archiver]);
                                     WriteLogCR(11,'Compression program changed to '+zipstr[node.archiver]);
                                   End;
                            End;
                        End Else
                      If Pos('MGRPWD',pword) <> 0 then
                        Begin
                          Create;
                          If WordCnt(pline) < 2 then
                            Begin
                              NotifyCR(11,'Mgr Pwd change');
                              Node.MgrPassword := Extractwords(2,1,pline);
                              WriteIt ('Manager password changed to '''+node.MgrPassword+'''.');
                              WritelogCR(11,'Manager password changed to '+node.mgrpassword);
                              Changed := true;
                            End Else WriteIt ('You must specify a password.');
                        End Else
                      If Pos('PWD',pword) <> 0 then
                        Begin
                          Create;
                          If WordCnt(pline) = 2 then
                            Begin
                              NotifyCR(11,'Tick Pwd change');
                              Node.Password := Extractwords(2,1,pline);
                              WriteIt ('Tickfile password changed to '''+node.Password+'''.');
                              WritelogCR(11,'Tickfile password changed to '+node.password);
                              Changed := true;
                            End Else WriteIt ('You must specify a password.');
                        End Else
                      If First(2,pword) = '%+' then
                        Begin
                          Create;
                          if Length(pLine) > 2
                            then AllAreas(True, true, str_to_int(last( length(pline)-2 ,pline))) else
                              for GrpInx := 1 to 255 do AllAreas (True, false, GrpInx);
                        End Else
                      If First(2,pword) = '%-' then
                        Begin
                          Create;
                          if Length(pLine) > 2
                            then AllAreas(false, true, str_to_int(last(length(pline)-2,pline))) else
                              for GrpInx := 1 to 255 do AllAreas (False, false, GrpInx);
                        End Else
                        Begin
                          Create;
                          WriteIt('Unknown command : '''+pLine+'''. Use %help for instructions.');
                          helpwanted := true;
                        End;
                    End; {if length pline > 1}
            Else Begin
                   Create;
                   If last(1,pword) = '*' then
                     Begin
                       pword := first(length(pword)-1,pword);
                       For AFXinx := 1 to Areaidx do
                         begin
                           If pos(pword,afxt^[afxinx].tag) <> 0 then
                             AddArea(afxt^[afxinx].tag,false)
                         end;
                     End Else AddArea(pword,false);
                 End;
          End; {case}
        End; {pline <> ''}
    Until (first(3,pline) = '---') or MsgOut^.EOM;  {or geen lijnen meer};
  End;


  Procedure RemoteMaint;
  Var
    PLine : String;
  Begin
    If RemFrom then  {remote maint, stuur betreffende node ook een notify}
      Begin
        Init_Message ('F'+setup.netmailpath, true, 0, [net], remfromnode, setup.address[1],
                      'FileMgr', node.sysopname, 'FileMgr remote maintenance');
        Open_Message;
        Set_Attrib([privat,killsent],'F');

        dostringln(node2str(fromnode)+' has performed remote maintenance for you'+
         ', with the following result :'+#13);

        {$I-} Reset(Freply); {$I+}
        If ioresult = 0 then  {tijdelijke file naar node sturen}
          Begin
            While not eof(Freply) do
              Begin
                Readln(Freply,Pline);
                Dostringln(pline);
              End;
            {$I-} Close(Freply);
            Erase(Freply); {$I+}
            If ioresult <> 0 then {};
          End;

        Dostringln('');
        DoStringln('--- ' + msgtearline);
        Save_Message;
      End;
  End;


{----------------}


Begin
  WriteLogCR (6, 'MGR');
  NotifyCr(8,'Scanning netmail board...');

  With DT do { get todays time }
    begin
      GetDate (Year, Month, Day, Nfxinx);
      GetTime (Hour, Min, Sec, Nfxinx);
    end;
  Compare := GetUnixDate(DT) - (secsinaday * SETUP.Days2Keep);

  MsgOut := New(FidoMsgPtr, Init);
  MsgOut^.SetMsgPath(setup.netmailpath);
  If MsgOut^.OpenMsgBase <> 0 Then
    Begin
      WriteLn('Error opening message base');
      Exit;
    End;

  Tot := 0;


  FindFirst(setup.netmailpath+'*.MSG',archive,sr);
  While doserror = 0 do
    Begin
      inc(tot);
      write( expand( '('+int_to_Str(tot)+')' ,15) ,#13);
      Lees_bericht (compare, true, setup.netmailpath+sr.name{, Msg});
      { is bericht gericht aan filemgr of 1 van de aliasen ?}
      If (fromname <> '') and (toname <> '') then
        Begin

          MsgOut^.SeekFirst(str_to_int(file_split(3,sr.name)));
          If MsgOut^.SeekFound then
            Begin
              MsgOut^.MsgStartUp;
              If upper(msgout^.getto) = upper(toname) then
                Begin
                  Inc (tRequest);
                  Notifycr (11,'Processing areamgr request from '+Node2Str(FromNode));
                  rescan := true;
                  Created        := False;
                  Changed        := False;
                  HelpWanted     := False;
                  FlowWanted     := False;
                  QueryWanted    := False;
                  CostWanted     := False;
                  ListWanted     := False;
                  UnlinkedWanted := False;
                  RemFrom        := False;
                  Requests       := False;
                  If NodeAllowed(FromNode) then       {inlezen noderec }
                    Begin
                      MsgOut^.MsgTxtStartUp;
                      Analyze_Msg_Txt;
                    End Else {node not allowed}
                    Begin
                      Init_Message ('F'+setup.netmailpath, true, 0, [net], fromnode, tonode,
                        'FileMgr v'+verstr(versionnr), node.sysopname, 'FileMgr request failure');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      If MsgOut^.GetSubj = '' then
                        Begin
                          DoStringln('You are not allowed to use FileMgr.');
                          WritelogCr(11,'Not allowed to use FileMgr');
                        End Else
                        Begin
                          Dostringln('Invalid password, '''+msgout^.getSubj+'''');
                          WriteLogCR(11,'Invalid password '''+msgout^.getsubj+'''');
                        End;
                      Created := True;
                    End;
                  If Created then
                    Begin
                      DoStringln('');
                      DoStringln('--- ' + msgtearline);
                      DoStringln(Orig_Line('Use %HELP for instructions',0));
                      Save_Message;
                    End;
                  If RemFrom then RemoteMaint;
                  If HelpWanted then
                    Begin
                      Init_Message('F'+setup.netmailpath,true,0, [net], fromnode, tonode,
                       'FileMgr v'+verstr(versionnr), node.sysopname, 'FileMgr instructions');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      WriteHelpMsg (11);
                      DoStringln('--- ' + msgtearline);
                      Save_Message;
                    End;
                  If FlowWanted then
                    Begin
                      Init_Message('F'+setup.netmailpath,true,0, [net], fromnode, tonode,
                       'FileMgr v'+verstr(versionnr), node.sysopname,'FileMgr flow report');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      WriteFlowMsg(false,flowgroup,11);
                      DoStringln('--- ' + msgtearline);
                      Save_Message;
                    End;
                  If CostWanted then
                    Begin
                      Init_Message('F'+setup.netmailpath,true,0, [net], fromnode, tonode,
                       'FileMgr v'+verstr(versionnr), node.sysopname,'FileMgr cost report');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      WriteflowMsg(true,costgroup,11);
                      DoStringln('--- ' + msgtearline);
                      Save_Message;
                    End;
                  If ListWanted then
                    Begin
                      Init_Message('F'+setup.netmailpath,true,0, [net], fromnode, tonode,
                        'FileMgr v'+verstr(versionnr), node.sysopname, 'FileMgr area list');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      if ListWanted     then WriteListMsg (LIST,11);
                      DoStringln('--- ' + msgtearline);
                      DoStringln(Orig_Line('Use %HELP for instructions',0));
                      Save_Message;
                    End;
                  If QueryWanted then
                    Begin
                      Init_Message('F'+setup.netmailpath,true,0, [net], fromnode, tonode,
                        'FileMgr v'+verstr(versionnr), node.sysopname, 'FileMgr area query');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      if QueryWanted    then WriteListMsg (QUERY,11);
                      DoStringln('--- ' + msgtearline);
                      DoStringln(Orig_Line('Use %HELP for instructions',0));
                      Save_Message;
                    End;
                  If UnlinkedWanted then
                    Begin
                      Init_Message('F'+setup.netmailpath,true,0, [net], fromnode, tonode,
                        'FileMgr v'+verstr(versionnr), node.sysopname, 'FileMgr unlinked areas');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      if UnlinkedWanted then WriteListMsg (UNLINKED,11);
                      DoStringln('--- ' + msgtearline);
                      DoStringln(Orig_Line('Use %HELP for instructions',0));
                      Save_Message;
                    End;
                  DisposeMessage;         { kill it !!    }
                  If Changed then
                    Begin
                      Seek (NF, NFXt^[NFXinx].NodeRec);
                      blockWrite (NF, node, sizeof(node));
                    End;
                End;              { If (I < 15) or (msgout^.getto ... }
            End;                  {   While MsgOut^.SeekFound Do }
        End;  { if i < 21 }
      FindNext(sr);
    End; { if i < 15 }
  Write(expand(' ',15),#13);
  If MsgOut^.CloseMsgBase <> 0 Then {};
  Dispose(MsgOut, Done);

  { disconnecting passthru areas }
  For afxinx := 1 to areaidx do
    Begin
      getarea(afxinx);
      If (area.directory = '') and not (disc in area.status)
         and not (noti in area.status) then
        Begin
          If (area.exportnr = 1) and (import in sfxt^[1].s) then
            Begin
              I := 1;
              While (i < 21) and not (nodeeq(setup.uplink[i].address,sfxt^[1].a)) do inc(i);
              If i <= 20 then
                Begin
                  If setup.uplink[i].groups[area.grp] or (area.grp = 0) then
                    Begin
                      NotifyCr(11,area.tag+' is an empty pass-thru area. Disconnected from uplink '
                        +node2str(setup.uplink[i].address));

                      if setup.noti_disco then
                        WriteToTmpFile(systempath+'fmsystmp.#$',area.tag+
                          ' is an empty pass-thru area. Disconnected from uplink '
                            +node2str(setup.uplink[i].address));
                      {disconnecting}
                      area.status := area.status + [noti];
                      area.status := area.status + [disc];
                      {msg to uplink}
                      Init_Message('F'+setup.netmailpath,true,0, [net], setup.uplink[i].address,
                         setup.address[setup.uplink[i].aka],
                         'FileMgr v'+verstr(versionnr), setup.uplink[i].mgrname, setup.uplink[i].password);
                      Open_Message;
                      Set_Attrib([privat,killsent],'F');
                      DoStringln('-'+area.tag);
                      DoStringln('---'+msgtearline);
                      Save_Message;
                    End else
                    Begin
                      notifycr(11,area.tag+' is an empty pass-thru area.');
                      if setup.noti_empty then
                        WriteToTmpFile(systempath+'fmsystmp.#$',area.tag+' is an empty pass-thru area.');
                      area.status := area.status + [noti];
                    End;
                End else
                Begin
                  notifycr(11,area.tag+' is an empty pass-thru area.');
                  if setup.noti_empty then
                    WriteToTmpFile(systempath+'fmsystmp.#$',area.tag+' is an empty pass-through area.');
                  area.status := area.status + [noti];
                End;
              Seek (af, afxt^[afxinx].arearec);
              Blockwrite (af, area, sizeof(area));
            End;
        End;
    End;
  If Exist(systempath+'fmsystmp.#$') then sendsysopmsg('Pass-through areas');
End;

End.
