/*͸
   OS/2 Video API Version 1.00  13-01-96    (C) 1996 by CodeLand Australia 
   VID.H                                               All Rights Reserved 
  ;*/

#if !defined(BLACK)         /* Foreground colors */
#define BLACK       0                   
#define BLUE        1
#define GREEN       2
#define CYAN        3
#define RED         4
#define MAGENTA     5
#define BROWN       6
#define YELLOW      14
#define WHITE       15
#endif

#if !defined(LGREY)
#define LGREY       7
#define DGREY       8
#define LBLUE       9
#define LGREEN      10
#define LCYAN       11
#define LRED        12
#define LMAGENTA    13
#define _BLACK      0       /* Background colors */
#define _BLUE       16
#define _GREEN      32
#define _CYAN       48
#define _RED        64
#define _MAGENTA    80
#define _BROWN      96
#define _LGREY      112
#endif

#if     !defined(BLINK)
#define BLINK       128     /* Blink attribute */
#endif

#define NUL  0
#define BEL  7
#define BS   8
#define HT   9
#define LF   10
#define FF   12
#define CR   13
#define ESC  27

/* Video information record */
struct _vinfo_t {
    USHORT Adapter;   /* Adapter type                 */
    USHORT Display;   /* Display type                 */
    USHORT NumRows;   /* Number of displayed rows     */
    USHORT NumCols;   /* Number of displayed columns  */
    SHORT CurRow;     /* Initial cursor row           */
    SHORT CurCol;     /* Initial cursor column        */
    BOOL MapAttr;     /* Map color attribs to mono?   */
    SHORT ScanLines;  /* Screen scanlines per row     */
    SHORT CurSSt;     /* Initial cursor scan line st  */
    SHORT CurSEd;     /* Initial cursor scan line end */
};
extern struct _vinfo_t _VidInfo;
extern PCHAR _box_table[];

/**/

#define VidBeep() DosBeep(900,350)

/**/

VOID    VidBox          (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol,
                         SHORT BoxType, SHORT Attr);
VOID    VidClrEol       (VOID);
VOID    VidClrScrn      (VOID);
VOID    VidFill         (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol,
                         SHORT Ch, SHORT Attr);
VOID    VidGetCurSz     (PSHORT Sline, PSHORT Eline);
VOID    VidGotoXY       (SHORT Row, SHORT Col);
VOID    VidHideCur      (VOID);
SHORT   VidMapAttr      (SHORT Attr);
VOID    VidLgCursor     (VOID);
VOID    VidPrintC       (SHORT Row, SHORT Col, SHORT Attr, CHAR Ch);
VOID    VidPrintS       (SHORT Row, SHORT Col, SHORT Attr, PCHAR Str);
USHORT  VidReadChAt     (SHORT Row, SHORT Col);
VOID    VidReadCur      (PSHORT Row, PSHORT Col);
VOID    VidRevAttr      (SHORT Row, SHORT Col, SHORT Count);
SHORT   VidRevsAttr     (SHORT Attr);
VOID    VidSetCurSz     (SHORT Sline, SHORT Eline);
VOID    VidShowCur      (VOID);
VOID    VidSpc          (SHORT Count);
VOID    VidVideoInit    (VOID);
VOID    VidcClrScrn     (SHORT Ch, SHORT Attr);
VOID    VidSmCursor     (VOID);
PSHORT  VidSSave        (VOID);
VOID    VidSRestore     (PSHORT sbuf);
SHORT   VidTabStop      (SHORT column, SHORT tabwidth);
ULONG   VidTimer        (VOID);

/**/

