/*͸
   OS/2 Video API Version 1.00  13-01-96    (C) 1996 by CodeLand Australia 
   VID.C Low level video routines                      All Rights Reserved 
  ;*/

#include <malloc.h>
#include <string.h>
#define INCL_DOS
#define INCL_VIO
#include <os2.h>

#include "vid.h"

/* Video information structure */
struct _vinfo_t _VidInfo = {
    25,      /* Number of displayed rows     */
    80,      /* Number of displayed columns  */
    FALSE,   /* Map color attribs to mono?   */
};

/* Access box table characters via: _box_table[boxtype][x] */
/* boxtype is the number of the box type you want to use (0 - 5)
   x will be one of the following:
   0 - upper left corner
   1 - upper horizontal line
   2 - upper right corner
   3 - left vertical line
   4 - right vertical line
   5 - lower left corner
   6 - lower horizontal line
   7 - lower right corner
   8 - middle junction
   9 - left vertical junction
   10 - right vertical junction
   11 - upper horizontal junction
   12 - lower horizontal junction
*/
PCHAR _box_table[] = {
    "Ŀô",    /* box type 0 */
    "ͻͼ̹",    /* box type 1 */
    "ķĽǶ",    /* box type 2 */
    "͸;Ƶ",    /* box type 3 */
    "",    /* box type 4 */
    "             "     /* box type 5 */
};

/**/

/* Initialize video */
VOID VidVideoInit (VOID)
{
    VIOCONFIGINFO vioinConfig;
    VIOMODEINFO viomi;

    vioinConfig.cb = sizeof(vioinConfig);     /* Structure length   */
    VioGetConfig(
        0,
        &vioinConfig,                         /* Configuration data */
        0);                                   /* Video handle       */

    _VidInfo.Adapter=vioinConfig.adapter;
    _VidInfo.Display=vioinConfig.display;

    viomi.cb=sizeof(viomi);                   /* Structure length   */
    VioGetMode(&viomi,0);                     /* Get mode info      */

    _VidInfo.NumRows=viomi.row;               /* Save cursor rows   */
    _VidInfo.NumCols=viomi.col;               /* Save cursor cols   */
    _VidInfo.ScanLines=viomi.vres/viomi.row;  /* Save scanlines     */

    /* Save the initial cursor location and size */
    VidReadCur(&_VidInfo.CurRow,&_VidInfo.CurCol);
    VidGetCurSz(&_VidInfo.CurSSt,&_VidInfo.CurSEd);
}

/**/

/* Sets cursor coordinates */
VOID VidGotoXY (SHORT Row, SHORT Col)
{
    VioSetCurPos(
        Row,                         /* cursor row    */
        Col,                         /* cursor column */
        0);                          /* video handle  */
}

/**/

/* Reads the current cursor coordinates */
VOID VidReadCur (PSHORT Row, PSHORT Col)
{
    VioGetCurPos(
        (PUSHORT)Row,          /* Row address    */
        (PUSHORT)Col,          /* Column address */
        0);                    /* Video handle   */
}

/**/

/* Hides the cursor */
VOID VidHideCur (VOID)
{
    VIOCURSORINFO vc;

    VioGetCurType(&vc,0);
    if(vc.attr!=-1) { vc.attr=-1; VioSetCurType(&vc,0); }
}

/**/

/* Shows the cursor */
VOID VidShowCur (VOID)
{
    VIOCURSORINFO vc;

    VioGetCurType(&vc,0);
    if(vc.attr=-1) { vc.attr=0; VioSetCurType(&vc,0); }
}

/**/

/* Sets the cursor shape and size */
VOID VidSetCurSz (SHORT Sline, SHORT Eline)
{
    VIOCURSORINFO vc;

    VioGetCurType(&vc,0);

    vc.yStart=Sline; vc.cEnd=Eline;
    VioSetCurType(&vc,0);
}

/**/

/* Gets the cursor shape and size */
VOID VidGetCurSz (PSHORT Sline, PSHORT Eline)
{
    VIOCURSORINFO vc;

    VioGetCurType(&vc,0);
    *Sline=vc.yStart; *Eline=vc.cEnd;
}

/**/

/* Sets a small cursor  */
VOID VidSmCursor (VOID)
{
    VidShowCur();
    VidSetCurSz(_VidInfo.ScanLines-3,_VidInfo.ScanLines-2);
}

/**/

/* Sets a large cursor  */
VOID VidLgCursor (VOID)
{
    VidShowCur();
    VidSetCurSz(2,_VidInfo.ScanLines-2);
}

/**/

/* Converts an attribute to monochrome equivalent  */
SHORT VidMapAttr (SHORT Attr)
{
    if(_VidInfo.MapAttr) {            /* If monochrome mapping is on */
        switch(Attr&112) {          /* Test for a light background */
            case _LGREY:
            case _GREEN:
            case _CYAN:
            case _BROWN:
                Attr=Attr&240;      /* Foreground = black */
                Attr=Attr|112;      /* Background = light grey */
                break;
            default:
                if((Attr&15)==8)    /* If foreground = dark grey */
                    Attr=Attr&247;  /* Clear intensity bit */
                Attr=Attr|7;        /* Foreground = light grey */
                Attr=Attr&143;      /* Background = black */
        }
    }

    return Attr;                    /* Return converted attribute */
}

/**/

/* Fills an area of screen with a character & attribute  */
VOID VidFill (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol, SHORT Ch, SHORT Attr)
{
    BYTE bCell[2];

    /* Check for monochrome adapter, adjust attribute */
    Attr=VidMapAttr(Attr);

    bCell[0] = (UCHAR)Ch;   /* Space character       */
    bCell[1] = (UCHAR)Attr; /* Attribute             */

    VioScrollUp(Srow,Scol,Erow,Ecol,1+Erow-Srow,bCell,0);
}

/**/

/* Clears the screen using given attribute and homes the cursor  */
VOID VidcClrScrn (SHORT Ch, SHORT Attr)
{
    BYTE bCell[2];

    bCell[0]=(UCHAR)Ch;
    bCell[1]=(UCHAR)Attr;   /* Attribute             */

    VioScrollUp(
        0,                  /* Top row               */
        0,                  /* Left column           */
        0xFFFF,             /* Bottom row            */
        0xFFFF,             /* Right column          */
        0xFFFF,             /* Number of lines       */
        bCell,              /* Cell to write         */
        0);                 /* AVIO video handle     */

    VioSetCurPos(0, 0, 0);
}

/**/

/* Clears the screen and homes the cursor */
VOID VidClrScrn (VOID)
{
    VidcClrScrn(0x20,0x07);
}

/**/

/* Displays specified number of spaces on the screen  */
VOID VidSpc (SHORT Count)
{
    USHORT usRow, usColumn;
    BYTE bCell[2];

    VioGetCurPos(
        &usRow,          /* Row address              */
        &usColumn,       /* Column address           */
        0);              /* Video handle             */

    bCell[0] = 0x20;     /* Space character          */
    bCell[1] = 0x07;     /* Gray (EGA)               */

    VioWrtNCell(
        bCell,           /* address of attribute     */
        Count,           /* number of cells to write */
        usRow,           /* row                      */
        usColumn,        /* column                   */
        0);              /* video handle             */
}

/**/

/* Clears to the end of line */
VOID VidClrEol (VOID)
{
    USHORT usRow, usColumn;
    BYTE bCell[2];

    VioGetCurPos(
        &usRow,          /* Row address         */
        &usColumn,       /* Column address      */
        0);              /* Video handle        */

    bCell[0] = 0x20;     /* Space character     */
    bCell[1] = 0x07;     /* Gray (EGA)          */

    VioScrollRt(
        usRow,           /* Top row             */
        usColumn,        /* Left column         */
        usRow,           /* Bottom row          */
        0xFFFF,          /* Right column        */
        0xFFFF,          /* Columns             */
        bCell,           /* Cell to write       */
        0);              /* Video handle        */
}

/**/

/* Reverses the attribute given */
SHORT VidRevsAttr (SHORT Attr)
{
    return (((Attr>>4)&0x07)|((Attr<<4)&0x70)|(Attr&0x80)|(Attr&0x08));
}

/**/

/* Reverses attribute of one or more characters */
VOID VidRevAttr (SHORT Row, SHORT Col, SHORT Count)
{
    SHORT i;
    USHORT Cnt=(USHORT)Count;
    CHAR achCells[264];

    VioReadCellStr(
        achCells,              /* buffer for string                     */
        &Cnt,                  /* points to variable for string length  */
        Row,                   /* starting location (row)               */
        Col,                   /* starting location (column)            */
        0);                    /* video handle                          */

    /* Reverse the attributes */
    for(i=1;i<=Count*2;i+=2) achCells[i]=(CHAR)VidRevsAttr(achCells[i]);

    VioWrtCellStr(
        achCells,
        Count,
        Row,
        Col,
        0);
}

/**/

/* Reads character and attribute at location */
USHORT VidReadChAt (SHORT Row, SHORT Col)
{
    CHAR achCell[2];
    USHORT cb=2;

    VioReadCellStr(
        achCell,               /* Buffer for string                     */
        &cb,                   /* Points to variable for string length  */
        Row,                   /* Starting location (row)               */
        Col,                   /* Starting location (column)            */
        0);                    /* Video handle                          */

    return *(USHORT *)achCell;
}

/**/

/* Displays a character at specified location on screen */
VOID VidPrintC (SHORT Row, SHORT Col, SHORT Attr, CHAR Ch)
{
    CHAR achCellString[2];

    /* Check for monochrome adapter, adjust attribute */
    Attr=VidMapAttr(Attr);

    achCellString[0]=(UCHAR)Ch;
    achCellString[1]=(UCHAR)Attr;

    VioWrtCellStr(
        achCellString,
        2,
        Row,
        Col,
        0);

    /* VioWrtCharStrAtt(&Ch,1,Row,Col,(PBYTE)&Attr,0); */
}

/**/

/* Prints a string at specified location */
VOID VidPrintS (SHORT Row, SHORT Col, SHORT Attr, PCHAR Str)
{
    SHORT At;

    /* Check for monochrome adapter, adjust attribute */
    At=VidMapAttr(Attr);

    VioWrtCharStrAtt(Str,strlen(Str),Row,Col,(PBYTE)&At,0);
}

/**/

/* Displays a text box on the screen */
VOID VidBox (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol, SHORT BoxType, SHORT Attr)
{
    SHORT i;
    SHORT crow, ccol, wide, tall;

    /* Check for monochrome adapter, adjust attribute */
    Attr=VidMapAttr(Attr);

    /* Calculate width and height */
    wide=Ecol-Scol-1;
    tall=Erow-Srow-1;

    /* Display top and bottom horizontal borders */
    ccol=Scol+1;
    {
        BYTE abCell[2];

        abCell[0]=(UCHAR)_box_table[BoxType][1]; abCell[1]=(UCHAR)Attr;
        VioWrtNCell(abCell,wide,Srow,ccol,0);
        abCell[0]=(UCHAR)_box_table[BoxType][6]; abCell[1]=(UCHAR)Attr;
        VioWrtNCell(abCell,wide,Erow,ccol,0);
    }

    /* Display left and right vertical borders */
    crow=Srow+1;
    for(i=0;i<tall;i++,crow++) {
        VidPrintC(crow,Scol,Attr,_box_table[BoxType][3]);
        VidPrintC(crow,Ecol,Attr,_box_table[BoxType][4]);
    }

    /* Display corners */
    VidPrintC(Srow,Scol,Attr,_box_table[BoxType][0]);
    VidPrintC(Srow,Ecol,Attr,_box_table[BoxType][2]);
    VidPrintC(Erow,Scol,Attr,_box_table[BoxType][5]);
    VidPrintC(Erow,Ecol,Attr,_box_table[BoxType][7]);
}

/**/

/* Saves the current screen */
PSHORT VidSSave (VOID)
{
    USHORT crow, bytes;
    SHORT *q, *sbuf;

    /* Allocate memory from heap to hold screen contents */
    if((sbuf=(PSHORT)malloc((_VidInfo.NumRows*_VidInfo.NumCols*
        sizeof(SHORT))+1))!=NULL) {
        /* Calculate info on window */
        q=sbuf; bytes=_VidInfo.NumCols*2;

        for(crow=0;crow<_VidInfo.NumRows;crow++) {
            VioReadCellStr((PCH)q,&bytes,crow,0,0);
            q+=_VidInfo.NumCols;
        }
    }

    /* Return address of allocated buffer or NULL if allocation error */
    return sbuf;
}

/**/

/* Restores a previously saved screen */
VOID VidSRestore (PSHORT sbuf)
{
    USHORT crow, bytes;
    SHORT *q;

    /* Initialize buffer pointer to start of buffer */
    q=sbuf; bytes=_VidInfo.NumCols*2;

    for(crow=0;crow<_VidInfo.NumRows;crow++) {
        VioWrtCellStr((PCH)q,bytes,crow,0,0);
        q+=_VidInfo.NumCols;
    }

    /* Free buffer */
    free(sbuf);
}

/**/

/* Calculates next tab stop from given column */
SHORT VidTabStop (SHORT column, SHORT tabwidth)
{
    SHORT sum;

    sum=column+tabwidth;
    return (sum-(sum%tabwidth));
}

/**/

/* Returns value of an emulated BIOS timer */
ULONG VidTimer (VOID)
{
    DATETIME DateTime;
    ULONG value;

    DosGetDateTime(&DateTime);

    value = (ULONG) DateTime.hours    * (60L * 60L * 100L) +
            (ULONG) DateTime.minutes  * (60L * 100L)       +
            (ULONG) DateTime.seconds  * (100L)             +
            (ULONG) DateTime.hundredths;

    /* Turn it into "ticks" 18.2 per second */
    value = (ULONG) ((double)value / 5.494); 

    return value;
}

/**/

