/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   SORT.C Sort routines                                All Rights Reserved 
  ;*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "ued.h"

#define QSLO (SortDir?1:-1)
#define QSHI (SortDir?-1:1)

/**/

PCHAR SortStr[_SORT_NUM]= {
    "File Order",
    "2nd Name",
    "1st Name",
    "Alias",
    "Location",
    "Telephone",
    "Data Phone",
    "Msg Area",
    "File Area",
    "Access LVL",
    "Date Lcall",
    "Date PWChg",
    "Call Count",
    "Kb DnLoads",
    "Kb UpLoads",
    "LR Pointer"
};

CHAR SortChr[_SORT_NUM]="O21ALTPMFVDWCKUR";

SHORT SortTyp=0;
SHORT SortDir=0;

static SHORT (*compare)();  /* Compare function pointer */
static USHORT *Uidx=NULL;

/**/

static SHORT CompStr (const VOID *i, const VOID *j);
static SHORT CompLname (const VOID *i, const VOID *j);
static SHORT CompDate (const VOID *i, const VOID *j);
static SHORT CompShort (const VOID *i, const VOID *j);
static SHORT CompUshort (const VOID *i, const VOID *j);
static SHORT CompUlong (const VOID *i, const VOID *j);

/**/

/* Returns true on success */
SHORT PASCAL Sort (SHORT WinOffset)
{
    USHORT count, rc, cbBytesRead;
    ULONG ulNewPtr;
    CHAR Announce[40], tbuf[16];

    if(Ud->SortTyp==SortTyp&&Ud->SortDir==SortDir) return 0; /* Already done */

    /* File order */
    if(SortTyp==0) {
        if(!SortDir) for(count=0;count<U_MR;count++) Ud->Uidx[count]=count;
        else for(count=1;count<Ud->Unum;count++) Ud->Uidx[count]=Ud->Unum-count;
        Ud->SortTyp=SortTyp; /* Set new current sort method */
        Ud->SortDir=SortDir; /* Set new current sort direction */
        CurRec=0; /* Go to beginning */
        UserIdxRead(Ud,0); /* Load user struct with first record */
        return 1;
    }

    /* Allocate array storage, sort announce, set compare */
    if((Ud->SortArray=(PVOID *)malloc(Ud->Unum*sizeof(PCHAR)))==NULL) return 0;
    memset(Ud->SortArray,'\0',Ud->Unum*sizeof(PCHAR));
    switch(SortTyp) {
        case 1 : /* Sort by last name */
            strcpy(Announce,"Indexing by Last Name");
            compare=CompLname;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(36*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 2 : /* Sort by first name */
            strcpy(Announce,"Indexing by First Name");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(36*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 3 : /* Sort by alias */
            strcpy(Announce,"Indexing by Alias");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(21*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 4 : /* Sort by city */
            strcpy(Announce,"Indexing by City");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(36*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 5 : /* Sort by Telephone */
            strcpy(Announce,"Indexing by Telephone");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(15*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 6 : /* Sort by Data Phone */
            strcpy(Announce,"Indexing by Data Phone");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(19*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 7 : /* Sort by Msg Area */
            strcpy(Announce,"Indexing by Msg Area");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(MAX_ALEN*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 8 : /* Sort by File Area */
            strcpy(Announce,"Indexing by File Area");
            compare=CompStr;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(MAX_ALEN*sizeof(CHAR)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 9 : /* Sort by level */
            strcpy(Announce,"Indexing by Access Level");
            compare=CompShort;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(SHORT)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 10 : /* Sort by date lastcall */
            strcpy(Announce,"Indexing by Lastcall Date");
            compare=CompDate;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(SCOMBO)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 11 : /* Sort by date PWC */
            strcpy(Announce,"Indexing by PW Change Date");
            compare=CompDate;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(SCOMBO)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 12 : /* Sort by calls */
            strcpy(Announce,"Indexing by Number of Calls");
            compare=CompUshort;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(USHORT)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 13 : /* Sort by Dnloads */
            strcpy(Announce,"Indexing by Number of Dnloads");
            compare=CompUlong;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(ULONG)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 14 : /* Sort by Uploads */
            strcpy(Announce,"Indexing by Number of Uploads");
            compare=CompUlong;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(ULONG)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
        case 15 : /* Sort by LR Pointer */
            strcpy(Announce,"Indexing by LastRead Pointer");
            compare=CompUshort;
            for(count=0;count<Ud->Unum;count++) {
                if((Ud->SortArray[count]=(PVOID)malloc(sizeof(USHORT)))==NULL) {
                    free(Ud->SortArray); Ud->SortArray=NULL;
                    return 0;
                }
            }
            break;
    }

    /* Allocate/Copy/Convert existing Uidx array for secondary compares */
    Uidx=(USHORT *)malloc(Ud->Unum*sizeof(USHORT));
    if(Uidx==NULL) {
        /* Deallocate array storage */
        for(count=0;count<Ud->Unum;count++)
            if(Ud->SortArray[count]!=NULL) free(Ud->SortArray[count]);
        free(Ud->SortArray); Ud->SortArray=NULL;
        return 0;
    }
    for(count=0;count<Ud->Unum;count++) Uidx[Ud->Uidx[count]]=count;

    /* Rewind the user file */
    rc=DosChgFilePtr(Ud->Ufh,(LONG)0,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=(ULONG)0) {
        free(Uidx); Uidx=NULL;
        /* Deallocate array storage */
        for(count=0;count<Ud->Unum;count++)
            if(Ud->SortArray[count]!=NULL) free(Ud->SortArray[count]);
        free(Ud->SortArray); Ud->SortArray=NULL;
        return 0;
    }

    if(!WinOpen(11+WinOffset,22,13+WinOffset,56,bdr,WHITE|_RED,WHITE|_RED))
        return 0;
    WINSHADOW();
    WinPrintS(0,5,WHITE|_RED,"Scanning Record       1");

    /* Scan all records */
    for(count=0;count<Ud->Unum;count++) {

        if(!((count+1)%100)) {
            sprintf(tbuf,"%5u",count+1);
            WinPrintS(0,23,WHITE|_RED,tbuf);
        }

        /* if(UserRead(Ud,count)) break; */
        rc=DosRead(Ud->Ufh,Ud->Usr,Ud->Usiz,&cbBytesRead);
        if(rc||cbBytesRead!=Ud->Usiz) break;

        switch(SortTyp) {
            case 1 : /* Sort by last name */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->name);
                break;
            case 2 : /* Sort by first name */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->name);
                break;
            case 3 : /* Sort by alias */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->alias);
                break;
            case 4 : /* Sort by city */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->city);
                break;
            case 5 : /* Sort by Telephone */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->phone);
                break;
            case 6 : /* Sort by Data Phone */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->dataphone);
                break;
            case 7 : /* Sort by Msg Area */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->msg);
                break;
            case 8 : /* Sort by File Area */
                strcpy((PCHAR)Ud->SortArray[count],Ud->Usr->files);
                break;
            case 9 : /* Sort by level */
                *(USHORT *)Ud->SortArray[count]=Ud->Usr->priv;
                break;
            case 10 : /* Sort by date lastcall */
                *(SCOMBO *)Ud->SortArray[count]=Ud->Usr->ludate;
                break;
            case 11 : /* Sort by date PWC */
                *(SCOMBO *)Ud->SortArray[count]=Ud->Usr->date_pwd_chg;
                break;
            case 12 : /* Sort by calls */
                *(USHORT *)Ud->SortArray[count]=Ud->Usr->times;
                break;
            case 13 : /* Sort by Dnloads */
                *(ULONG *)Ud->SortArray[count]=Ud->Usr->down;
                break;
            case 14 : /* Sort by Uploads */
                *(ULONG *)Ud->SortArray[count]=Ud->Usr->up;
                break;
            case 15: /* Sort by LR Pointer */
                *(USHORT *)Ud->SortArray[count]=Ud->Usr->lastread_ptr;
                break;
        }
    }

    Ud->SortTyp=SortTyp; /* Set new current sort method */
    Ud->SortDir=SortDir; /* Set new current sort direction */
    CurRec=0; /* Go to beginning */
    UserRead(Ud,0); /* Load user struct with first record */

    WinClear(); WinCenters(0,WHITE|_RED,Announce);

    /* Sort the index to type compare */
    UserIdxSort(Ud,compare);

    WinClose(); /* Close the announce window */

    /* Deallocate array storage */
    free(Uidx); Uidx=NULL;
    for(count=0;count<Ud->Unum;count++)
        if(Ud->SortArray[count]!=NULL) free(Ud->SortArray[count]);
    if(Ud->SortArray!=NULL) {
        free(Ud->SortArray);
        Ud->SortArray=NULL;
    }

    return 1; /* Success */
}

/**/

#define C_STR(a)    ( (PCHAR)   Ud->SortArray[*((USHORT *)(a))])
#define C_SHORT(a)  (*(PSHORT)  Ud->SortArray[*((USHORT *)(a))])
#define C_DATE(a)   (*(SCOMBO *)Ud->SortArray[*((USHORT *)(a))])
#define C_USHORT(a) (*(PUSHORT) Ud->SortArray[*((USHORT *)(a))])
#define C_ULONG(a)  (*(PULONG)  Ud->SortArray[*((USHORT *)(a))])
#define C_SECND(a)  (Uidx[*((USHORT *)(a))])

static SHORT CompStr (const VOID *i, const VOID *j)
{
    SHORT reg;

    reg=stricmp(C_STR(i),C_STR(j));
    if(!reg) {
        if( C_SECND(i) > C_SECND(j) ) return 1;
        if( C_SECND(i) < C_SECND(j) ) return -1;
    }
    return(reg?(reg>0?QSHI:QSLO):0);
}

static SHORT CompLname (const VOID *i, const VOID *j)
{
    SHORT reg;
    CHAR *iname=strrchr(C_STR(i),' ');
    CHAR *jname=strrchr(C_STR(j),' ');

    if(iname&&jname) {
        reg=stricmp(iname+1,jname+1);
        if(reg) return(reg>0?QSHI:QSLO);
        reg=stricmp(C_STR(i),C_STR(j));
        if(!reg) {
            if( C_SECND(i) > C_SECND(j) ) return 1;
            if( C_SECND(i) < C_SECND(j) ) return -1;
        }
        return(reg?(reg>0?QSHI:QSLO):0);
    }
    reg=stricmp(C_STR(i),C_STR(j));
    if(!reg) {
        if( C_SECND(i) > C_SECND(j) ) return 1;
        if( C_SECND(i) < C_SECND(j) ) return -1;
    }
    return(reg?(reg>0?QSHI:QSLO):0);
}

static SHORT CompDate (const VOID *i, const VOID *j)
{
    if( C_DATE(i).msg_st.date.yr > C_DATE(j).msg_st.date.yr ) return QSLO;
    if( C_DATE(i).msg_st.date.yr < C_DATE(j).msg_st.date.yr ) return QSHI;
    if( C_DATE(i).msg_st.date.mo > C_DATE(j).msg_st.date.mo ) return QSLO;
    if( C_DATE(i).msg_st.date.mo < C_DATE(j).msg_st.date.mo ) return QSHI;
    if( C_DATE(i).msg_st.date.da > C_DATE(j).msg_st.date.da ) return QSLO;
    if( C_DATE(i).msg_st.date.da < C_DATE(j).msg_st.date.da ) return QSHI;
    if( C_DATE(i).msg_st.time.hh > C_DATE(j).msg_st.time.hh ) return QSLO;
    if( C_DATE(i).msg_st.time.hh < C_DATE(j).msg_st.time.hh ) return QSHI;
    if( C_DATE(i).msg_st.time.mm > C_DATE(j).msg_st.time.mm ) return QSLO;
    if( C_DATE(i).msg_st.time.mm < C_DATE(j).msg_st.time.mm ) return QSHI;
    if( C_DATE(i).msg_st.time.ss > C_DATE(j).msg_st.time.ss ) return QSLO;
    if( C_DATE(i).msg_st.time.ss < C_DATE(j).msg_st.time.ss ) return QSHI;
    if( C_SECND(i) > C_SECND(j) ) return 1;
    if( C_SECND(i) < C_SECND(j) ) return -1;
    return 0;
}

static SHORT CompShort (const VOID *i, const VOID *j)
{
    if( C_SHORT(i) > C_SHORT(j) ) return QSLO;
    if( C_SHORT(i) < C_SHORT(j) ) return QSHI;
    if( C_SECND(i) > C_SECND(j) ) return 1;
    if( C_SECND(i) < C_SECND(j) ) return -1;
    return 0;
}

static SHORT CompUshort (const VOID *i, const VOID *j)
{
    if( C_USHORT(i) > C_USHORT(j) ) return QSLO;
    if( C_USHORT(i) < C_USHORT(j) ) return QSHI;
    if( C_SECND(i) > C_SECND(j) ) return 1;
    if( C_SECND(i) < C_SECND(j) ) return -1;
    return 0;
}

static SHORT CompUlong (const VOID *i, const VOID *j)
{

    if( C_ULONG(i) > C_ULONG(j) ) return QSLO;
    if( C_ULONG(i) < C_ULONG(j) ) return QSHI;
    if( C_SECND(i) > C_SECND(j) ) return 1;
    if( C_SECND(i) < C_SECND(j) ) return -1;
    return 0;
}

/**/

