/*͸
   OS/2 Video API Version 1.00  04-09-96    (C) 1996 by CodeLand Australia 
   LIST.C ListBox routines                             All Rights Reserved 
  ;*/

#define DEBUG

#include <stdio.h> /* DEBUG */
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <conio.h>

#define INCL_DOS
#define INCL_VIO
#define INCL_KBD
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "list.h"

/**/

static VOID DispAllItems (PLIST Plist);
static VOID DispItem (PLIST Plist, SHORT item, SHORT bar);
static VOID PreExit (PLIST Plist, WINDOW w);
static VOID CloseWindow (PLIST Plist, WINDOW w);
static VOID FreeList (PLIST Plist);

/**/

#if defined(DEBUG)
VOID ListShadow (VOID);
VOID main (SHORT argc, PCHAR argv[])
{
    PUSHORT ScrnSave;
    SHORT i, bdrtype=0;
    CHAR str[16];
    PLIST Plist=NULL;

    /* Init the video api */
    VidVideoInit();

    /* Save screen and display background */
    ScrnSave=VidSSave(); VidHideCur(); VidcClrScrn(0xB0,WHITE|_LGREY);

    /*
    if(!WinOpen(4,30,22,50,bdrtype,BLUE|_LGREY,BLUE|_LGREY)) return;
    WinShadow(DGREY|_BLACK);
    */

    ListBeg(&Plist,8,25,12,10,bdrtype,BLUE|_LGREY,BLUE|_LGREY,ListShadow);
    /* ListBegC(&Plist,2,2,12,10); */
    for(i=0;i<500;i++) {
        sprintf(str,"Item %2d",i+1); ListItem(Plist,str,i);
    }
    ListEnd(Plist,0,BLUE|_LGREY,WHITE|_RED);
    ListGet(Plist);

    /* WinClose(); */

    /* Restore the screen and cursor */
    VidSRestore(ScrnSave); VidShowCur();

    exit(0);
}
VOID ListShadow (VOID)
{
    WinShadow(DGREY|_BLACK);
}
#endif

/**/

SHORT ListBeg (PLIST *Plist, SHORT srow, SHORT scol, SHORT length, SHORT width,
    SHORT btype, SHORT battr, SHORT wattr, VOID (*open)(VOID))
{
    /* Allocate memory for new list record */
    if((*Plist=malloc(sizeof(LIST)))==NULL)
        return (_WinInfo.errno=W_ALLOCERR);

    /* Save info in list record */
    (*Plist)->srow=(UCHAR)srow;
    (*Plist)->scol=(UCHAR)scol;
    (*Plist)->erow=(UCHAR)(srow+length+1);
    (*Plist)->ecol=(UCHAR)(scol+width+1);
    (*Plist)->btype=(UCHAR)btype;
    (*Plist)->battr=(UCHAR)VidMapAttr(battr);
    (*Plist)->wattr=(UCHAR)VidMapAttr(wattr);
    (*Plist)->open=open;
    (*Plist)->usecurr=0;
    (*Plist)->ListItemNum=0;
    (*Plist)->DisplayCount=length;
    (*Plist)->DisplayOffset=0;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT ListBegC (PLIST *Plist, SHORT srow, SHORT scol, SHORT length, SHORT width)
{
    SHORT len, wid;

    len=length; wid=width;
    if(len>_WinInfo.active->erow-_WinInfo.active->srow-1-srow)
        len=_WinInfo.active->erow-_WinInfo.active->srow-1-srow;
    if(wid>_WinInfo.active->ecol-_WinInfo.active->scol-1-scol)
        wid=_WinInfo.active->ecol-_WinInfo.active->scol-1-scol;

    /* Call ListBeg() using current window parameters */
    if(
        ListBeg(Plist,srow,scol,len,wid,
        _WinInfo.active->btype,
        _WinInfo.active->battr,_WinInfo.active->wattr,NULL)
    ) return(_WinInfo.errno);

    /* Turn on use-current-window flag */
    (*Plist)->usecurr=1;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT ListItem (PLIST Plist, PCHAR str, SHORT tagid)
{
    PLISTITEM Pitem;

    /* Make sure that ListBeg() or ListBegC() has been called */
    if(NULL==Plist) return (_WinInfo.errno=W_NOMNUBEG);

    /* Allocate memory for new item record */
    if((Plist->ListItem[Plist->ListItemNum]=(PLISTITEM)malloc(sizeof(LISTITEM)))==NULL)
        return (_WinInfo.errno=W_ALLOCERR);
    Pitem=Plist->ListItem[Plist->ListItemNum];

    /* Save info in item record */
    strcpy(Pitem->data,str);
    Pitem->tagid  = tagid;

    (Plist->ListItemNum)++;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT ListEnd (PLIST Plist, SHORT taginit, SHORT textattr, SHORT barattr)
{
    SHORT i, found;

    /* Make sure that the specified initial tagid matches the */
    /* tagid of one of the defined list items in this list    */
    for(i=0;i<Plist->ListItemNum;i++) {
        if(Plist->ListItem[i]->tagid==taginit) { found=1; break; }
    }
    if(!found) return (_WinInfo.errno=W_INVTAGID);

    /* Add rest of list information to list record */
    Plist->textattr  = (UCHAR)VidMapAttr(textattr);
    Plist->barattr   = _VidInfo.MapAttr ?
        (UCHAR)VidRevsAttr(Plist->textattr) : (UCHAR)barattr;

    return (_WinInfo.errno=W_NOERROR); /* Return with no error */
}

/**/

SHORT ListGet (PLIST Plist)
{
    USHORT xch;
    WINDOW w;

    /* Make sure we have a defined list */
    if(NULL==Plist) { _WinInfo.errno=W_NOMNUDEF; return -1; }

    /* Set current item to first item */
    Plist->ListItemCur=0; Plist->DisplayOffset=0;

    /* Open list's window (unless list is to use current window) */
    if(!Plist->usecurr) {
        w=WinHandle();
        if(!WinOpen(Plist->srow,Plist->scol,
            Plist->erow,Plist->ecol,Plist->btype,
            Plist->battr,Plist->wattr)
        ) return -1;

        /* Call list open */
        if(Plist->open!=NULL) (*Plist->open)();
    }

    /* Display items and selection bar */
    DispAllItems(Plist); DispItem(Plist,0,1);

    /* Main process of function */

    for(;;) {
        /* Read keyboard for keypress */
        _kbinfo.inmenu=TRUE; xch=MenuGetXCh(); _kbinfo.inmenu=FALSE;

        /* Process keypress */
        switch(xch) {
            case 0x011b:    /* Esc */
                /* If Esc checking is on, erase selection bar, */
                /* free list records and return to caller      */
                if(_WinInfo.esc) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    PreExit(Plist,w);
                    _WinInfo.errno=W_ESCPRESS;
                    return -1;
                }
                break;

            case 0x4700:    /* Home */
                if(Plist->ListItemCur) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    Plist->ListItemCur=0;
                    if(Plist->DisplayOffset) {
                        Plist->DisplayOffset=0;
                        DispAllItems(Plist);
                    }
                    DispItem(Plist,Plist->ListItemCur,1);
                }
                break;

            case 0x4800:    /* UpArrow */
                if(Plist->ListItemCur) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    Plist->ListItemCur--;
                    if(Plist->ListItemCur-Plist->DisplayOffset<0) {
                         Plist->DisplayOffset--;
                         DispAllItems(Plist);
                    }
                    DispItem(Plist,Plist->ListItemCur,1);
                }
                break;

            case 0x4900:    /* PgUp */
                if(Plist->ListItemCur) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    Plist->ListItemCur-=Plist->DisplayCount;
                    if(Plist->ListItemCur<0) Plist->ListItemCur=0;
                    if(Plist->ListItemCur-Plist->DisplayOffset<0) {
                         Plist->DisplayOffset-=Plist->DisplayCount;
                         if(Plist->DisplayOffset<0) Plist->DisplayOffset=0;
                         DispAllItems(Plist);
                    }
                    DispItem(Plist,Plist->ListItemCur,1);
                }
                break;

            case 0x5000:    /* DownArrow */
                if(Plist->ListItemCur<Plist->ListItemNum-1) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    Plist->ListItemCur++;
                    if(Plist->ListItemCur-Plist->DisplayOffset>Plist->DisplayCount-1) {
                         Plist->DisplayOffset++;
                         DispAllItems(Plist);
                    }
                    DispItem(Plist,Plist->ListItemCur,1);
                }
                break;

            case 0x5100:    /* PgDn */
                if(Plist->ListItemCur<Plist->ListItemNum-1) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    Plist->ListItemCur+=Plist->DisplayCount;
                    if(Plist->ListItemCur>Plist->ListItemNum-1) Plist->ListItemCur=Plist->ListItemNum-1;
                    if(Plist->ListItemCur-Plist->DisplayOffset>Plist->DisplayCount-1) {
                         Plist->DisplayOffset+=Plist->DisplayCount;
                         if(Plist->DisplayOffset>Plist->ListItemNum-Plist->DisplayCount) Plist->DisplayOffset=Plist->ListItemNum-Plist->DisplayCount;
                         DispAllItems(Plist);
                    }
                    DispItem(Plist,Plist->ListItemCur,1);
                }
                break;

            case 0x4f00:    /* End */
                if(Plist->ListItemCur<Plist->ListItemNum-1) {
                    DispItem(Plist,Plist->ListItemCur,0);
                    Plist->ListItemCur=Plist->ListItemNum-1;
                    Plist->DisplayOffset=Plist->ListItemNum-Plist->DisplayCount;
                    if(Plist->DisplayOffset<0) Plist->DisplayOffset=0;
                    DispAllItems(Plist);
                    DispItem(Plist,Plist->ListItemCur,1);
                }
                break;

            case 0x1c0d:    /* Enter */
                /* Display list item with selection bar */
                DispItem(Plist,Plist->ListItemCur,1);
                /* Free list records, and return tag                 */
                /* identifier of current list item                   */
                PreExit(Plist,w);
                _WinInfo.errno=W_NOERROR;
                return (Plist->ListItem[Plist->ListItemCur]->tagid);
            default:
                break;
        }
    }
}

/**/

static VOID DispAllItems (PLIST Plist)
{
    SHORT i;

    /* Display items */
    for(i=Plist->DisplayOffset;
        i<Plist->DisplayOffset+Plist->DisplayCount && i<Plist->DisplayOffset+Plist->ListItemNum;
        i++
        ) DispItem(Plist,i,0);
}

/**/

static VOID DispItem (PLIST Plist, SHORT item, SHORT bar)
{
    PCHAR p;
    SHORT width, textend, wrow, wcol, i, ch, chattr;

    /* Error check */
    if(item<0 || item>Plist->ListItemNum-1) return;

    /* Initialize width of output and end of text */
    p=Plist->ListItem[item]->data;
    width=(Plist->ecol-Plist->scol)-1;
    textend=strlen(p);
    wcol=Plist->usecurr?Plist->scol:0;
    wrow=Plist->usecurr?Plist->srow+item-Plist->DisplayOffset:item-Plist->DisplayOffset;

    /* Display list item including selection bar */
    for(i=0;i<width;i++) {
        /* See if currently in bar region.  if so, then use  */
        /* a space for the character. otherwise use the      */
        /* character from the current position in the string */
        ch=(i<1||i>textend)?' ':(*p++);

        /* Select attribute of character to be displayed based upon if      */
        /* selection bar was specified, if the list item is non-selectable, */
        /* if the character is a tag character, or none of the above.       */
        if(bar) chattr=Plist->barattr;
        else chattr=Plist->textattr;

        /* Display character in selected attribute */
        WinPrintC(wrow,wcol++,chattr,ch);
    }
}

/**/

static VOID PreExit (PLIST Plist, WINDOW w)
{
    CloseWindow(Plist,w); FreeList(Plist);
}

/**/

/* Closes the current list's window and reactivates the window open */
/* prior to opening the current list window  */
static VOID CloseWindow (PLIST Plist, WINDOW w)
{
    if(!Plist->usecurr) { WinClose(); WinActiv(w); }
}

/**/

/* Frees a list and all of its subitems */
static VOID FreeList (PLIST Plist)
{
    SHORT i;

    for(i=0;i<Plist->ListItemNum;i++) free(Plist->ListItem[i]);
    free(Plist); /* Free the list itself */
}

/**/

