/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   BROWSE.C Browse routines                            All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "ued.h"

#define SCRNHEIGHT (_VidInfo.NumRows)        /* Height of screen in lines   */
#define CMDLINE    (SCRNHEIGHT - 5)          /* Command Line Placement      */
#define VIEWHEIGHT (SCRNHEIGHT - 9)          /* Number of view records      */

/* Field display */
#define VIEW_STRT  1     /* Absolute data display column    */
#define VIEW_BRDR  1     /* Divider width between columns   */
#define VIEW_NAME 28     /* Name field width                */
#define VIEW_CITY 24     /* City field width                */
#define VIEW_PRIV  9     /* Priv field width                */
#define VIEW_CALL  6     /* Call field width                */

#define VIEW_XPIR  5     /* Xpire field width               */
#define VIEW_PHON 14
#define VIEW_MSGS 14
#define VIEW_FILE 14
#define VIEW_TRAN  9
#define VIEW_COMP  9

#define VIEW_ALIS 13
#define VIEW_FCAL  8
#define VIEW_LCAL  8
#define VIEW_DOBT  8
#define VIEW_UPLD  7
#define VIEW_DNLD  7
#define VIEW_CRDT  6
#define VIEW_DEBT  6

#define COL_A 0
#define COL_B 71
#define COL_1 VIEW_STRT
#define COL_2 VIEW_STRT+VIEW_NAME+VIEW_BRDR
#define COL_3 VIEW_STRT+VIEW_NAME+VIEW_BRDR+VIEW_CITY+VIEW_BRDR
#define COL_4 VIEW_STRT+VIEW_NAME+VIEW_BRDR+VIEW_CITY+VIEW_BRDR+VIEW_PRIV+VIEW_BRDR

#define COL_5 VIEW_STRT
#define COL_6 VIEW_STRT+VIEW_XPIR+VIEW_BRDR
#define COL_7 VIEW_STRT+VIEW_XPIR+VIEW_BRDR+VIEW_PHON+VIEW_BRDR
#define COL_8 VIEW_STRT+VIEW_XPIR+VIEW_BRDR+VIEW_PHON+VIEW_BRDR+VIEW_MSGS+VIEW_BRDR
#define COL_9 VIEW_STRT+VIEW_XPIR+VIEW_BRDR+VIEW_PHON+VIEW_BRDR+VIEW_MSGS+VIEW_BRDR+VIEW_FILE+VIEW_BRDR
#define COL10 VIEW_STRT+VIEW_XPIR+VIEW_BRDR+VIEW_PHON+VIEW_BRDR+VIEW_MSGS+VIEW_BRDR+VIEW_FILE+VIEW_BRDR+VIEW_TRAN+VIEW_BRDR

#define COL11 VIEW_STRT
#define COL12 VIEW_STRT+VIEW_ALIS+VIEW_BRDR
#define COL13 VIEW_STRT+VIEW_ALIS+VIEW_BRDR+VIEW_FCAL+VIEW_BRDR
#define COL14 VIEW_STRT+VIEW_ALIS+VIEW_BRDR+VIEW_FCAL+VIEW_BRDR+VIEW_LCAL+VIEW_BRDR
#define COL15 VIEW_STRT+VIEW_ALIS+VIEW_BRDR+VIEW_FCAL+VIEW_BRDR+VIEW_LCAL+VIEW_BRDR+VIEW_DOBT+VIEW_BRDR
#define COL16 VIEW_STRT+VIEW_ALIS+VIEW_BRDR+VIEW_FCAL+VIEW_BRDR+VIEW_LCAL+VIEW_BRDR+VIEW_DOBT+VIEW_BRDR+VIEW_UPLD+VIEW_BRDR
#define COL17 VIEW_STRT+VIEW_ALIS+VIEW_BRDR+VIEW_FCAL+VIEW_BRDR+VIEW_LCAL+VIEW_BRDR+VIEW_DOBT+VIEW_BRDR+VIEW_UPLD+VIEW_BRDR+VIEW_DNLD+VIEW_BRDR
#define COL18 VIEW_STRT+VIEW_ALIS+VIEW_BRDR+VIEW_FCAL+VIEW_BRDR+VIEW_LCAL+VIEW_BRDR+VIEW_DOBT+VIEW_BRDR+VIEW_UPLD+VIEW_BRDR+VIEW_DNLD+VIEW_BRDR+VIEW_CRDT+VIEW_BRDR

#define MAXPAN 2 /* Highest Bpan number, first=0. For horz panning */

/**/

SHORT Bpan=0;                /* Global pan display variable */

/**/

/* BrowseScreen() menu aid functions */
static VOID PASCAL SetHKeys (VOID);
static VOID PASCAL ClearMenu (VOID);
static VOID PASCAL RunSearch (VOID);
static VOID NextDisp (VOID);
static VOID PrevDisp (VOID);
static VOID FrstBrec (VOID);
static VOID PrevBrec (VOID);
static VOID PgUpBrec (VOID);
static VOID PgDnBrec (VOID);
static VOID NextBrec (VOID);
static VOID LastBrec (VOID);

/* Static screen display functions */
static VOID PASCAL ShowLabels (VOID);

/* Data display functions */
static VOID PASCAL ShowDisplay (VOID);
static VOID PASCAL ShowHighest (VOID);
static VOID PASCAL ShowIndex (VOID);

/* Data editing functions */
static VOID EditPerm (VOID);
static VOID EditDel (VOID);
static VOID EditPrivDn (VOID);
static VOID EditPrivUp (VOID);
static VOID PASCAL WriteRec (VOID);

/**/

/*
   Ŀ
    UEDit  PERMANENT  DELETED  Index File Order      Record 00001 of 00505 
   Ĵ
     Name                       City                  Access     Calls     
    1234567890123456789012345  12345678901234567890  AsstSysOp  00000    
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
     1234567890123456789012345  12345678901234567890  AsstSysOp  00000     
   Ĵ
    First PageUp - + PageDn Last               Prm Del  Upgd  Srch    EDIT 
    Edit Access Lang Tran Comp Video Help Flag Prm Del  Upgd  Srch  BROWSE 
   
*/
VOID BrowseScreen (VOID)
{
    SHORT done, selection=11;

    if(!WinOpen(1,2,SCRNHEIGHT-2,75,bdr,battr,wattr)) return;
    WINSHADOW();
    ShowLabels(); /* Write the label strings */
    ClearMenu();

    ShowDisplay(); /* Display records to screen */

    done=0;
    while(!done) {
        if(selection<1||selection>11) selection=11;
        SetHKeys();
        MenuBegC();
        MenuItem(CMDLINE, 1, "First",  'F', 1,0,       NULL, 0, 0); /* First  */
        MenuItem(CMDLINE, 7, "PageUp", 0,   2,0,       NULL, 0, 0); /* PageUp */
        MenuItem(CMDLINE,14, "-",      '-', 3,0,       NULL, 0, 0); /* -      */
        MenuItem(CMDLINE,16, "+",      '+', 4,0,       NULL, 0, 0); /* +      */
        MenuItem(CMDLINE,18, "PageDn", 0,   5,0,       NULL, 0, 0); /* PageDn */
        MenuItem(CMDLINE,25, "Last",   'L', 6,0,       NULL, 0, 0); /* Last   */
        MenuItem(CMDLINE,44, "Prm",    'P', 7,0,       NULL, 0, 0); /* Perm   */
        MenuItem(CMDLINE,48, "Del",    'D', 8,0,       NULL, 0, 0); /* Del    */
        MenuItem(CMDLINE,53, "Upgd",   'U', 9,0,       NULL, 0, 0); /* Upgd   */
        MenuItem(CMDLINE,59, "Srch",   'S',10,0,       NULL, 0, 0); /* Srch   */
        MenuItem(CMDLINE,67, "EDIT",   'E',11,0,       NULL, 0, 0); /* EDIT   */
        MenuEnd(selection,M_HORZ|M_SAVE,0,0,BLUE|_LGREY,LBLUE|_LGREY,
            BLACK|_LGREY,WHITE|_RED);
        selection=MenuGet();
        MenuFreOnKey(); /* Disable the hotkey functions */
        ClearMenu();

        switch(selection) { /* Process the menu */
            case  1: FrstBrec();   break;                       /* First  */
            case  2: PgUpBrec();   break;                       /* PgUp   */
            case  3: PrevBrec();   break;                       /* Prev   */
            case  4: NextBrec();   break;                       /* Next   */
            case  5: PgDnBrec();   break;                       /* PgDn   */
            case  6: LastBrec();   break;                       /* Last   */
            case  7: EditPerm();   break;                       /* Perm   */
            case  8: EditDel();    break;                       /* Del    */
            case  9: if(UpGrde()) {                             /* Upgd   */
                         WriteRec();
                         ShowDisplay(); /* Display record to screen */
                     }
                     break;
            case 10: RunSearch();  break;
            case 11: MainStat=STAT_EDIT; done++; break; /* Exit   */
            case -1: TheMenu();
                     switch(MenuStat) {
                     case MENU_QUIT:
                         CfgCheck(); /* Check for INI change/save  */
                         MainStat=STAT_QUIT;
                         ++done; break;
                     case MENU_PACK : /* Pack the base  */
                         ShowIndex();
                         /* Flow through! */
                     case MENU_NEWR : /* Add new record */
                         ShowHighest();
                         ShowDisplay(); /* Display record to screen */
                         break;
                     case MENU_SORT : /* Index */
                         TONEFOUND();
                         ShowIndex();
                         ShowDisplay();
                         break;
                       case MENU_CFGS : /* Cfg change */
                         ShowDisplay();
                         break;
                       case MENU_GDEL:
                         ShowDisplay();
                         break;
                     }
                     break;
            default: break;
        }
    }

    WinClose();
}

/**/

static VOID PASCAL SetHKeys (VOID)
{
    MenuSetOnKey(0x4700,FrstBrec,0);   /* Turn on HOME key          */
    MenuSetOnKey(0x4F00,LastBrec,0);   /* Turn on END key           */
    MenuSetOnKey(0x4800,PrevBrec,0);   /* <Up Arrow>                */
    MenuSetOnKey(0x4A2D,PrevBrec,0);   /* <Grey ->                  */
    MenuSetOnKey(0x4900,PgUpBrec,0);   /* PgUp                      */
    MenuSetOnKey(0x5100,PgDnBrec,0);   /* PgDn                      */
    MenuSetOnKey(0x5000,NextBrec,0);   /* <Down Arrow>              */
    MenuSetOnKey(0x4E2B,NextBrec,0);   /* <Grey +>                  */
    MenuSetOnKey(0x0F09,NextDisp,0);   /* TAB - display toggle      */
    MenuSetOnKey(0x0F00,PrevDisp,0);   /* TAB - display toggle      */
    MenuSetOnKey(0x5300,EditDel,0);    /* <Del>                     */
    MenuSetOnKey(0x333C,EditPrivDn,0); /* "<" - Priv down           */
    MenuSetOnKey(0x343E,EditPrivUp,0); /* ">" - Priv up             */
}

/**/

static VOID PASCAL ClearMenu (VOID)
{
    /* WinFill(CMDLINE,0,CMDLINE,71,' ',BLUE|_LGREY); */
    WinPrintS(CMDLINE, 0,BLUE|_LGREY," First PageUp - + PageDn Last               Prm Del  Upgd  Srch    EDIT ");
    WinPrintS(CMDLINE, 1,LBLUE|_LGREY,"F");
    WinPrintS(CMDLINE,14,LBLUE|_LGREY,"-");
    WinPrintS(CMDLINE,16,LBLUE|_LGREY,"+");
    WinPrintS(CMDLINE,25,LBLUE|_LGREY,"L");
    WinPrintS(CMDLINE,44,LBLUE|_LGREY,"P");
    WinPrintS(CMDLINE,48,LBLUE|_LGREY,"D");
    WinPrintS(CMDLINE,53,LBLUE|_LGREY,"U");
    WinPrintS(CMDLINE,59,LBLUE|_LGREY,"S");
    WinPrintS(CMDLINE,67,LBLUE|_LGREY,"E");
}

/**/

static VOID PASCAL RunSearch (VOID)
{
    UsrSearch(); ShowDisplay();
}

/**/

static VOID NextDisp (VOID)
{
    if(Bpan<MAXPAN) Bpan++; /* Move to next display,    */
    else Bpan=0;            /* or wrap the pan          */
    ShowLabels();           /* Write the field headers  */
    ShowDisplay();          /* Write the display        */
}

/**/

static VOID PrevDisp (VOID)
{
    if(Bpan>0) Bpan--;      /* Move to next display,    */
    else Bpan=MAXPAN;       /* or wrap the pan          */
    ShowLabels();           /* Write the field headers  */
    ShowDisplay();          /* Write the display        */
}

/**/

static VOID FrstBrec (VOID)
{
    /* If nothing to do */
    if(CurRec==0) return;

    CurRec=0;
    ShowDisplay(); /* Display record to screen */
}

/**/

static VOID PrevBrec (VOID)
{
    /* If nothing to do */
    if(CurRec<1) return;

    --CurRec;
    ShowDisplay(); /* Display record to screen */
}

/**/

static VOID PgUpBrec (VOID)
{
    SHORT NewRec;

    /* If nothing to do */
    if(CurRec<1) return;

    NewRec=CurRec-VIEWHEIGHT;
    if(NewRec<0) NewRec=0;

    CurRec=NewRec;
    ShowDisplay(); /* Display record to screen */
}

/**/

static VOID PgDnBrec (VOID)
{
    SHORT NewRec;

    /* If nothing to do */
    if((USHORT)CurRec>=Ud->Unum-1) return;

    NewRec=CurRec+VIEWHEIGHT;
    if((USHORT)NewRec>Ud->Unum-1) NewRec=Ud->Unum-1;

    CurRec=NewRec;
    ShowDisplay(); /* Display record to screen */
}

/**/

static VOID NextBrec (VOID)
{
    /* If nothing to do */
    if((USHORT)CurRec>=Ud->Unum-1) return;

    ++CurRec;
    ShowDisplay(); /* Display record to screen */
}

/**/

static VOID LastBrec (VOID)
{
    /* If nothing to do */
    if((USHORT)CurRec==Ud->Unum-1) return;

    CurRec=Ud->Unum-1;
    ShowDisplay(); /* Display record to screen */
}

/**/

static VOID PASCAL ShowLabels (VOID)
{
    CHAR cbuf[36];

    WinPrintS( 0, 1,battr,"UED");
    WinPrintS( 0,28,qattr,"Index"); ShowIndex();
    WinPrintS( 0,50,qattr,"Record       of");
    ShowHighest();
    WinHLine(1,0,72,bdr,battr);
    WinPrintS(1,1,qattr,"tab"); WinPrintS(1,5,battr,"123");
    WinHLine(CMDLINE-1,0,72,bdr,battr);

    /* Write the field headers */
    WinFill(2,COL_A,VIEWHEIGHT+2,COL_B,' ',wattr); /* Clear the whole area */
    switch(Bpan) {
        case 0:
        WinPrintS(1,5,qattr,"1"); /* Active screen number */
        WinPrintS(2,COL_1,wattr,FormStrSetSz(strcpy(cbuf,"Name"  ),VIEW_NAME));
        WinPrintS(2,COL_2,wattr,FormStrSetSz(strcpy(cbuf,"City"  ),VIEW_CITY));
        WinPrintS(2,COL_3,wattr,FormStrSetSz(strcpy(cbuf,"Access"),VIEW_PRIV));
        WinPrintS(2,COL_3+7,qattr,"<>");
        WinPrintS(2,COL_4,wattr,FormStrSetSz(strcpy(cbuf,"Calls" ),VIEW_CALL));
        WinFill(3,COL_1,VIEWHEIGHT+2,COL_1+VIEW_NAME-1,' ',fattr);
        WinFill(3,COL_2,VIEWHEIGHT+2,COL_2+VIEW_CITY-1,' ',fattr);
        WinFill(3,COL_3,VIEWHEIGHT+2,COL_3+VIEW_PRIV-1,' ',fattr);
        WinFill(3,COL_4,VIEWHEIGHT+2,COL_4+VIEW_CALL-1,' ',fattr);
        break;
        case 1:
        WinPrintS(1,6,qattr,"2"); /* Active screen number */
        WinPrintS(2,COL_5,wattr,FormStrSetSz(strcpy(cbuf,"Xpiry"    ),VIEW_XPIR));
        WinPrintS(2,COL_6,wattr,FormStrSetSz(strcpy(cbuf,"Phone"    ),VIEW_PHON));
        WinPrintS(2,COL_7,wattr,FormStrSetSz(strcpy(cbuf,"Msg. Area"),VIEW_MSGS));
        WinPrintS(2,COL_8,wattr,FormStrSetSz(strcpy(cbuf,"File Area"),VIEW_FILE));
        WinPrintS(2,COL_9,wattr,FormStrSetSz(strcpy(cbuf,"File Tran"),VIEW_TRAN));
        WinPrintS(2,COL10,wattr,FormStrSetSz(strcpy(cbuf,"File Comp"),VIEW_COMP));
        WinFill(3,COL_5,VIEWHEIGHT+2,COL_5+VIEW_XPIR-1,' ',fattr);
        WinFill(3,COL_6,VIEWHEIGHT+2,COL_6+VIEW_PHON-1,' ',fattr);
        WinFill(3,COL_7,VIEWHEIGHT+2,COL_7+VIEW_MSGS-1,' ',fattr);
        WinFill(3,COL_8,VIEWHEIGHT+2,COL_8+VIEW_FILE-1,' ',fattr);
        WinFill(3,COL_9,VIEWHEIGHT+2,COL_9+VIEW_TRAN-1,' ',fattr);
        WinFill(3,COL10,VIEWHEIGHT+2,COL10+VIEW_COMP-1,' ',fattr);
        break;
        case 2:
        WinPrintS(1,7,qattr,"3"); /* Active screen number */
        WinPrintS(2,COL11,wattr,FormStrSetSz(strcpy(cbuf,"Alias"   ),VIEW_ALIS));
        WinPrintS(2,COL12,wattr,FormStrSetSz(strcpy(cbuf,"FrstCall"),VIEW_FCAL));
        WinPrintS(2,COL13,wattr,FormStrSetSz(strcpy(cbuf,"LastCall"),VIEW_LCAL));
        WinPrintS(2,COL14,wattr,FormStrSetSz(strcpy(cbuf,"BrthDate"),VIEW_DOBT));
        WinPrintS(2,COL15,wattr,FormStrSetSz(strcpy(cbuf,"KB UpLd" ),VIEW_UPLD));
        WinPrintS(2,COL16,wattr,FormStrSetSz(strcpy(cbuf,"KB DnLd" ),VIEW_DNLD));
        WinPrintS(2,COL17,wattr,FormStrSetSz(strcpy(cbuf,"Credit"  ),VIEW_CRDT));
        WinPrintS(2,COL18,wattr,FormStrSetSz(strcpy(cbuf,"Debit"   ),VIEW_DEBT));
        WinFill(3,COL11,VIEWHEIGHT+2,COL11+VIEW_FCAL-1,' ',fattr);
        WinFill(3,COL12,VIEWHEIGHT+2,COL12+VIEW_FCAL-1,' ',fattr);
        WinFill(3,COL13,VIEWHEIGHT+2,COL13+VIEW_LCAL-1,' ',fattr);
        WinFill(3,COL14,VIEWHEIGHT+2,COL14+VIEW_DOBT-1,' ',fattr);
        WinFill(3,COL15,VIEWHEIGHT+2,COL15+VIEW_UPLD-1,' ',fattr);
        WinFill(3,COL16,VIEWHEIGHT+2,COL16+VIEW_DNLD-1,' ',fattr);
        WinFill(3,COL17,VIEWHEIGHT+2,COL17+VIEW_CRDT-1,' ',fattr);
        WinFill(3,COL18,VIEWHEIGHT+2,COL18+VIEW_DEBT-1,' ',fattr);
        break;
    }
}

/**/

static VOID PASCAL ShowDisplay (VOID)
{
    USHORT i;
    CHAR cbuf[80];

    /* Current record number */
    FormCvtIC(cbuf,CurRec+1,5); WinPrintS( 0,57,WHITE|_BLACK,cbuf);

    for(i=0;i<VIEWHEIGHT;i++) {
        if(i+CurRec>=Ud->Unum) { /* Blank remaining screen display */
            WinPrintS(3+i,COL_A,qattr," "); WinPrintS(3+i,COL_B,qattr," ");
            *cbuf='\0';
            switch(Bpan) {
                case 0:
                WinPrintS(3+i,COL_1,fattr,FormStrSetSz(cbuf,VIEW_NAME));
                WinPrintS(3+i,COL_2,fattr,FormStrSetSz(cbuf,VIEW_CITY));
                WinPrintS(3+i,COL_3,fattr,FormStrSetSz(cbuf,VIEW_PRIV));
                WinPrintS(3+i,COL_4,fattr,FormStrSetSz(cbuf,VIEW_CALL));
                break;
                case 1:
                WinPrintS(3+i,COL_5,fattr,FormStrSetSz(cbuf,VIEW_XPIR));
                WinPrintS(3+i,COL_6,fattr,FormStrSetSz(cbuf,VIEW_PHON));
                WinPrintS(3+i,COL_7,fattr,FormStrSetSz(cbuf,VIEW_MSGS));
                WinPrintS(3+i,COL_8,fattr,FormStrSetSz(cbuf,VIEW_FILE));
                WinPrintS(3+i,COL_9,fattr,FormStrSetSz(cbuf,VIEW_TRAN));
                WinPrintS(3+i,COL10,fattr,FormStrSetSz(cbuf,VIEW_COMP));
                break;
                case 2:
                WinPrintS(3+i,COL11,fattr,FormStrSetSz(cbuf,VIEW_ALIS));
                WinPrintS(3+i,COL12,fattr,FormStrSetSz(cbuf,VIEW_FCAL));
                WinPrintS(3+i,COL13,fattr,FormStrSetSz(cbuf,VIEW_LCAL));
                WinPrintS(3+i,COL14,fattr,FormStrSetSz(cbuf,VIEW_DOBT));
                WinPrintS(3+i,COL15,fattr,FormStrSetSz(cbuf,VIEW_UPLD));
                WinPrintS(3+i,COL16,fattr,FormStrSetSz(cbuf,VIEW_DNLD));
                WinPrintS(3+i,COL17,fattr,FormStrSetSz(cbuf,VIEW_CRDT));
                WinPrintS(3+i,COL18,fattr,FormStrSetSz(cbuf,VIEW_DEBT));
                break;
            }
        }
        else { /* Display record */
            if(0==UserIdxRead(Ud,i+CurRec)) {
                if(i==0) { /* Record status */
                    if(Ud->Usr->delflag&UFLAG_PERM) WinPrintS(0,8,LRED|_BLUE, "PERMANENT");
                    else                            WinPrintS(0,8,DGREY|_BLUE,"permanent");
                    if(Ud->Usr->delflag&UFLAG_DEL)  WinPrintS(0,19,LRED|_BLUE, "DELETED");
                    else                            WinPrintS(0,19,DGREY|_BLUE,"deleted");
                }
                WinPrintS(3+i,COL_A,qattr,Ud->Usr->delflag&UFLAG_DEL?"":" ");
                if(Ud->Usr->delflag&UFLAG_PERM) WinPrintS(3+i,COL_A,qattr,"");
                WinPrintS(3+i,COL_B,qattr,Ud->Usr->extra?"":" ");
                switch(Bpan) {
                    case 0:
                    WinPrintS(3+i,COL_1,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->name),VIEW_NAME));
                    WinPrintS(3+i,COL_2,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->city),VIEW_CITY));
                    WinPrintS(3+i,COL_3,fattr,ShowPriv(Ud->Usr->priv));
                    FormCvtIC(cbuf,Ud->Usr->times,VIEW_CALL); WinPrintS(3+i,COL_4,fattr,cbuf);
                    break;
                    case 1:
                    if(Ud->Usr->xp_flag&XFLAG_EXPDATE) {
                        WinPrintS(3+i,COL_5,fattr,"Date");
                    }
                    else if(Ud->Usr->xp_flag&XFLAG_EXPMINS) {
                        WinPrintS(3+i,COL_5,fattr,"Time");
                    }
                    else WinPrintS(3+i,COL_5,fattr,"None");
                    WinPrintS(3+i,COL_6,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->phone),VIEW_PHON));
                    WinPrintS(3+i,COL_7,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->msg),VIEW_MSGS));
                    WinPrintS(3+i,COL_8,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->files),VIEW_FILE));
                    WinPrintS(3+i,COL_9,fattr,ShowProt(Ud->Usr->def_proto));
                    strcpy(cbuf,UedCfg.comp[Ud->Usr->compress>15?0:Ud->Usr->compress]);
                    WinPrintS(3+i,COL10,fattr,FormStrSetSz(cbuf,VIEW_COMP));
                    break;
                    case 2:
                    WinPrintS(3+i,COL11,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->alias),VIEW_ALIS));
                    WinPrintS(3+i,COL12,fattr,ShowDate(&(Ud->Usr->date_1stcall),cbuf));
                    WinPrintS(3+i,COL13,fattr,ShowDate(&(Ud->Usr->ludate),cbuf));
                    WinPrintS(3+i,COL14,fattr,ShowDOB(Ud->Usr->dob_day,Ud->Usr->dob_month,Ud->Usr->dob_year,cbuf));
                    FormCvtLC(cbuf,Ud->Usr->up,VIEW_UPLD); WinPrintS(3+i,COL15,fattr,cbuf);
                    FormCvtLC(cbuf,Ud->Usr->down,VIEW_DNLD); WinPrintS(3+i,COL16,fattr,cbuf);
                    FormCvtIC(cbuf,Ud->Usr->credit,VIEW_CRDT); WinPrintS(3+i,COL17,fattr,cbuf);
                    FormCvtIC(cbuf,Ud->Usr->debit,VIEW_DEBT); WinPrintS(3+i,COL18,fattr,cbuf);
                    break;
                }
            }
        }
    }
}

/**/

/* Display number of records */
static VOID PASCAL ShowHighest (VOID)
{
    CHAR num[10];

    FormCvtIC(num,Ud->Unum,5); WinPrintS(0,66,WHITE|_BLACK,num);
}

/**/

static VOID PASCAL ShowIndex (VOID)
{
    CHAR cbuf[16];
    WinPrintS( 0,34,WHITE|_BLACK,FormStrSetSz(strcpy(cbuf,SortStr[Ud->SortTyp]),10));
}

/**/

static VOID EditPerm (VOID)
{
    /* Read current record */
    if(UserIdxRead(Ud,CurRec)) return;

    if(!(Ud->Usr->delflag&UFLAG_PERM)&&Ud->Usr->delflag&UFLAG_DEL) {
        /* Undelete record */
        Ud->Usr->delflag=Ud->Usr->delflag&~UFLAG_DEL;
    }
    Ud->Usr->delflag =
        Ud->Usr->delflag&UFLAG_PERM ?
        Ud->Usr->delflag&~UFLAG_PERM  : Ud->Usr->delflag|UFLAG_PERM;

    WriteRec();
    ShowDisplay();
}

/**/

static VOID EditDel (VOID)
{
    /* Read current record */
    if(UserIdxRead(Ud,CurRec)) return;

    /* Don't delete 1st record */
    if(0==CurRec && !(Ud->Usr->delflag&UFLAG_DEL)) return;

    if(Ud->Usr->delflag&UFLAG_PERM&&!(Ud->Usr->delflag&UFLAG_DEL)) {
        /* Unlock record */
        Ud->Usr->delflag=Ud->Usr->delflag&~UFLAG_PERM;
    }
    Ud->Usr->delflag =
        Ud->Usr->delflag&UFLAG_DEL ?
        Ud->Usr->delflag&~UFLAG_DEL : Ud->Usr->delflag|UFLAG_DEL;

    WriteRec();
    ShowDisplay();
}

/**/

static VOID EditPrivDn (VOID)
{
    SHORT val;

    /* Read current record */
    if(UserIdxRead(Ud,CurRec)) return;

    val=GetPriv(Ud->Usr->priv); /* Get current priv index */
    val++;
    if(val<UedCfg.PrivNum) {
        Ud->Usr->priv = UedCfg.PrivValue[val];
        WriteRec();
        ShowDisplay();
    }
}

/**/

static VOID EditPrivUp (VOID)
{
    SHORT val;

    /* Read current record */
    if(UserIdxRead(Ud,CurRec)) return;

    val=GetPriv(Ud->Usr->priv); /* Get current priv index */
    val--;
    if(val>=0) {
        Ud->Usr->priv = UedCfg.PrivValue[val];
        WriteRec();
        ShowDisplay();
    }
}

/**/

static VOID PASCAL WriteRec (VOID)
{
    if(!IsRegistered && ++RegWriteCount>UNREGWRITELIMIT) {
        Mesage("Unregistered write limit exceeded!",11,20,13,60);
        TONEERROR(); MenuWaitKeyT(17); WinClose();
    }
    else TONEUPDATE();

    UserIdxWrite(Ud,CurRec);
}

/**/

