#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <time.h>


#define PRGNAME "Xenia TimeSync"
#define VERSION "1.98.04+"

#if defined(__OS2__)
#define XS_OS "OS/2"
#elif defined(__MSDOS__)
#define XS_OS "DOS"
#elif defined(_Windows)
#define XS_OS "Windows"
#elif defined(__TOS__)
#define XS_OS "ST"
#endif


static int anyfound (char *name)
{
    struct find_t ffblk;
    int res;

    res = _dos_findfirst(name,_A_NORMAL,&ffblk) ? 0 : 1;
#ifdef __WATCOMC__
    _dos_findclose(&ffblk);
#else
    while (!_dos_findnext(&ffblk));
#endif

    return (res);
}


void main (int argc, char *argv[])
{
	char syncfile[128], buffer[128], address[128], flagdir[128];
	char *p;
	int i;
	int task = 1;
	int found = 0;
	long curtime, timediff, synctime;
	int dstshift;
	FILE *fp;

	fprintf(stderr,"%s; Version %s %s, Created on %s at %s\n",
		       PRGNAME, VERSION, XS_OS, __DATE__, __TIME__);
	fprintf(stderr,"Design & COPYRIGHT (C) 1993-1996 by Arjen G. Lentz; ALL RIGHTS RESERVED\n");
	fprintf(stderr,"(this utility is part of Xenia Mailer version 1.97.14 & up)\n");
	fprintf(stderr,"A ShareWare project of LENTZ SOFTWARE-DEVELOPMENT, Amersfoort, The Netherlands\n\n");

	putenv("TZ=GMT0");
	tzset();

	for (i = 1; i <= argc; i++) {
	    if (argv[i])
	       task = atoi(argv[i]);
	    else if (i > 1) break;

	    if ((p = getenv("MAILER")) != NULL) {
	       strcpy(syncfile,p);
	       if (syncfile[strlen(syncfile) - 1] != '\\') strcat(syncfile,"\\");
	    }
	    else
	       syncfile[0] = '\0';
	    sprintf(&syncfile[strlen(syncfile)],"XENIA%u.SNC",task);

	    if ((fp = fopen(syncfile,"rt")) == NULL) {
	       fprintf(stderr,"No %s file '%s' found\n",PRGNAME,syncfile);
	       continue;
	    }

	    fgets(buffer,127,fp);
	    fclose(fp);

	    if (sscanf(buffer,"%lx %ld %d %s %s",
		       &synctime,&timediff,&dstshift,flagdir,address) != 5) {
		printf("%s file '%s' did not contain valid information\n",PRGNAME,syncfile);
	       unlink(syncfile);
	       continue;
	    }

	    sprintf(buffer,"%sTASK.*",flagdir);
	    if (anyfound(buffer)) {
	       fprintf(stderr,"%s postponed, mail session(s) in progress\n",PRGNAME);
	       exit (1);
	    }

	    unlink(syncfile);
	    curtime = time(NULL);

	    if (labs(curtime - synctime) > (24L * 3600L)) {
	       printf("%s file '%s' information older than one day!\n",PRGNAME,syncfile);
	       continue;
	    }

	    curtime += timediff;
	    stime(&curtime);

	    printf(PRGNAME);
	    if (task) printf(" (task %d)",task);
	    printf("\n");
	    printf("Synchronizing clock with %s (was %+ld:%02ld min. difference)\n",
		   address, timediff / 60L, labs(timediff % 60L));

	    if (dstshift)
	       printf("Transition from %s to %s time\n",
		      timediff > 0 ? "normal (winter)" : "daylight savings (summer)",
		      timediff	> 0 ? "daylight savings (summer)" : "normal (winter)");

	    printf("Time now: %s", ctime((time_t *) &curtime));  /* ctime() appends \n */

	    found = 1;
	}

	exit (found ? 0 : 1);
}


/* end of xensync.c */
