/* Version:
 * $Header:   C:/tb/src/reqmisc.c_v   1.0   15 Nov 1990 01:20:50   JacK  $
 *
 * $Log:   C:/tb/src/reqmisc.c_v  $
 * 
 *    Rev 1.0	15 Nov 1990 01:20:50   JacK
 * Initial revision.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys\stat.h>
#if defined(__OS2__) || defined(__MSDOS__)
#include <dos.h>
#elif defined(__TOS__)
#include <osbind.h>
#include "stat.h"
#endif


void prepfname (char *dst, char *src)
{ 
	int i, delim;
  
	for (delim=8, i=0; *src && i<11; src++) {
	    if (*src=='.') {
	       if (i > 8)
		  i = 8;
	       else
		  while (i < 8)
			dst[i++] = ' ';
	       delim = 11;
	    }
	    else if (*src=='*') {
	       while (i < delim)
		   dst[i++] = '?';
	    }
	    else
	       dst[i++] = *src;
	}/*for*/
  
	while (i < 11)
	      dst[i++] = ' ';
	dst[i] = '\0';
}/*prepfname()*/


#if defined(__MSDOS__) || defined(__OS2__)

static struct find_t ffblk;

char *ffirst (char *name)
{
    return (_dos_findfirst(name,_A_NORMAL,&ffblk) ? NULL : ffblk.name);
}/*ffirst()*/


char *fnext (void)
{
    return (_dos_findnext(&ffblk) ? NULL : ffblk.name);
}/*fnext()*/


void fnclose (void)
{
#ifdef __WATCOMC__
    _dos_findclose(&ffblk);
#else
    while (fnext());
    fnext();
#endif
}/*fnclose()*/


void getfinfo (struct stat *statbuf)
{
    struct tm t;

    t.tm_sec   = ((ffblk.wr_time & 0x001f) << 1);	  /* seconds after the minute -- [0,61] */
    t.tm_min   = ((ffblk.wr_time & 0x07e0) >> 5);	  /* minutes after the hour   -- [0,59] */
    t.tm_hour  = ((ffblk.wr_time & 0xf800) >> 11);	  /* hours after midnight     -- [0,23] */
    t.tm_mday  = (ffblk.wr_date & 0x001f);		  /* day of the month	      -- [1,31] */
    t.tm_mon   = ((ffblk.wr_date & 0x01e0) >> 5) - 1;	  /* months since January     -- [0,11] */
    t.tm_year  = (((ffblk.wr_date & 0xfe00) >> 9) + 80);  /* years since 1900			*/
    t.tm_isdst = 0;
    statbuf->st_atime = statbuf->st_mtime = statbuf->st_ctime = mktime(&t);
    statbuf->st_size  = ffblk.size;
}

#endif /* __MSDOS__ || __OS2__ */


#if defined(__TOS__)

static char ff_dta[80];

char *ffirst (char *filespec)
{
	char *his_dta = (char *)Fgetdta();

	Fsetdta(ff_dta);

	if (Fsfirst(filespec,7) != -33L) {
	   Fsetdta(his_dta);
	   return (ff_dta+0x1e);
	}

	Fsetdta(his_dta);
	return (NULL);
}

char *fnext (void)
{
	char *his_dta = (char *)Fgetdta();

	Fsetdta(ff_dta);

	if (Fsnext() == 0L) {
	   Fsetdta(his_dta);
	   return (ff_dta+0x1e);
	}

	Fsetdta(his_dta);
	return (NULL);
}

#endif


char *strip (char *s)
{
	char *p, *q;

	p=q=s;
	while (*p==' ') p++;
	while (*p) *q++=*p++;
	*q='\0';
	if (q!=s) {
	   while (*--q==' ');
	   *++q='\0';
	}

	return (s);
}/*strip()*/


void splitpath (char *filepath, char *path, char *file)
{
	char *p,*q;

	for (p=filepath;*p;p++) ;
	while (p!=filepath && *p!=':' && *p!='\\' && *p!='/') --p;
	if (*p==':' || *p=='\\' || *p=='/') ++p;	/* begin     */
	q=filepath;
	while (q!=p) *path++=*q++;			/* copy path */
	*path='\0';
	strcpy(file,p);
}/*splitpath()*/


void mergepath (char *filepath, char *path, char *file)
{
	strcpy(filepath,path);
	strcat(filepath,file);
}/*mergepath()*/


/* end of reqmisc.c */
