#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#if defined(__OS2__)
#define EXENAME "FAXSWAP2"
#else
#define EXENAME "FAXSWAP"
#endif


typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned long  dword;
typedef struct _zfaxhdr ZFAXHDR;
struct _zfaxhdr {			/* --------------------------------- */
	char title[6];			/* Title	   "ZyXEL"NUL	     */
	word version;			/* Version	   2		     */
	word reserved;			/* Reserved	   0		     */
	word scanwidth; 		/* Page ScanWidth  A4=1728	(wd) */
	word pagecount; 		/* Page Count	   1-n		     */
	word resolution;		/* Res & coding    0-3 (see above)   */
};
typedef struct _qfxhdr QFXHDR;
struct _qfxhdr {
	char  title[8]; 	//  0-7
	word  pages;		//  8-9
	word  scan_last;	// 10-11
	dword scan_total;	// 12-15
	word  scale_hor;	// 16-17
	word  scale_ver;	// 18-19
	byte  fill[12]; 	// 20-31
	dword page_ofs[376];	// 32-1535
} qfxhdr;



/*---------------------------------------------------------------------------*/
void main (int argc, char *argv[])
{
	FILE *fp;
	byte swaptable[256];
	byte buf[1024];
	long ofs;
	int i, j;

	fprintf(stderr,EXENAME "; Byteswap a FAX file (raw, ZyXEL or QFX format)\n");
	fprintf(stderr,"COPYRIGHT (C) 1994-1996 by Arjen G. Lentz; ALL RIGHTS RESERVED\n\n");

	if (argc != 2) {
	   fprintf(stderr,"Usage: " EXENAME " <faxfile>\n");
	   exit (0);
	}

	if ((fp = fopen(argv[1],"r+b")) == NULL) {
	   fprintf(stderr,"Can't open faxfile '%s'\n",argv[1]);
	   exit (1);
	}

	for (i = 0; i < 256; i++) {
	    /* swap the low order 4 bitswith the high order */
	    j = (((i & 0x01) << 7) |
		 ((i & 0x02) << 5) |
		 ((i & 0x04) << 3) |
		 ((i & 0x08) << 1) |
		 ((i & 0x10) >> 1) |
		 ((i & 0x20) >> 3) |
		 ((i & 0x40) >> 5) |
		 ((i & 0x80) >> 7));
	    swaptable[i] = (byte) j;
	}

	if (fread(buf,sizeof (ZFAXHDR),1,fp) == 1 &&
	    !strnicmp((char *) buf,"ZYXEL",5))
	   ofs = sizeof (ZFAXHDR);
	else if (!strnicmp((char *) buf,"QLIIFAX",7))
	   ofs = sizeof (QFXHDR);
	else
	   ofs = 0L;

	fprintf(stderr,"%s: %s fax format\n", argv[1],
		ofs ? (ofs == sizeof (QFXHDR) ? "QFX" : "ZyXEL" ) : "Raw");
	fseek(fp,(long) ofs,SEEK_SET);
	while ((i = fread(buf,1,1024,fp)) > 0) {
	      ofs += i;
	      fprintf(stderr,"%ld\r",ofs);
	      for (j = 0; j < i; j++)
		  buf[j] = swaptable[buf[j]];
	      fseek(fp,(long) -i,SEEK_CUR);
	      if ((i = fwrite(buf,1,i,fp)) < 0)
		 break;
	      fseek(fp,(long) 0L,SEEK_CUR);
	}
	fclose(fp);
	if (i < 0) {
	   fprintf(stderr,"File read/write error\n");
	   exit (1);
	}
	fprintf(stderr,"Done!     \n");
	exit (0);
}


/* end of faxswap.c */
