UNIT Session;
{ͻ}
{ Main loop in Portal of Power                  Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{                                                                          }
{                        (C) Copyright 1998-2000 by                        }
{                          The German Portal Team                          }
{          Carsten Brandt, Michael Kleefeld and Marcus Roeckrath           }
{                                                                          }
{                                                                          }
{ Changes made                                                             }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 30 July 1998                                         }
{ Last Modification : 16 March 2000                                        }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE PortalMain;

IMPLEMENTATION

USES Dos, OpDate, OpCrt, OpWindow, OpFrame, OpDos, OpEntry, OpEdit, OpCmd,
     OpKey, OpRoot, OpString, OpInline, ApTimer,
     PFix, Display, Com, Modem, OutMan, Event, Util, NlComp, OutUtil,
     FileFwd, MailUtil, YooHoo2U, Nodelist, FileUtil, TextEdit, AreaMan,
     DumbTerm, Config, NlMan, Init, Globals, FuncReq, List, PoPTypes,
     Input, MTask, Keyboard, LogFile, ScrBlank, DosShell,
{$IFNDEF Gamma}
     OutMan2,
{$ENDIF}
     PopStatu, InterCom, OutInfo, OproUtil, StrUtil, Tick, Usage, UserEdit,
     Resource ,MailScan, NewExp, NewImp, Fax, FuncSrvr, NetFile, LCR, RngAnaly
{$IFNDEF OS2}
     , Macro
{$ELSE}
     , VpUtils
{$ENDIF}
{$IFDEF Repacker}
     ,Repacker
{$ENDIF}
{$IFDEF Msgpack}
     ,MsgPack
{$ENDIF}
{$IFDEF MSGOBJECT}
     ,PoPEd
{$ENDIF}
     ;

  PROCEDURE SynchTime;
  VAR
    DT1, DT2 : DateTimeRec;
    d, m, y : Integer;
    h, min, sec : Byte;
  BEGIN
    DT1.D:=Today;
    DT1.T:=CurrentTime;
    IncDateTime(DT1, DT2, 0, SynchTimeDiff);
    DateToDMY(DT2.D, d, m, y);
    TimeToHMS(DT2.T, h, Min, Sec);
    SetTime(Word(h), Word(min), Word(sec), 0); SetDate(y, m, d);
    AddLog('+', 'Syncronizing time with remote');
  END;

  PROCEDURE DoPortalTasks;
  BEGIN
    DropCarrier;
    MakeModemBusy;
    ParseRequest;
    IF GotSomeFiles THEN
    BEGIN
      ProcessTicks;
      ForwardFiles(False);
    END;
{$IFNDEF NoMailScanner}
    IF GotSomeMail AND (CurrentEvent.typ AND etTossMail<>0) THEN
      RunMailScanner(CurrentEvent.Typ AND (NOT etScanMail));
{$ELSE}
    ScanNetMail;
{$ENDIF}
    CompileNodeList(False);
    UpdateNetMailFlag;
  END;

  PROCEDURE CheckModemResponse(Forced: Boolean);
  LABEL
    NoBody, ItIsAlive, EMSIStart, KeepOnRocking;
  VAR
    StartTime,
    EndTime      : DateTimeRec;
    DTEBaud, w,
    RealBaudRate : Word;
    f            : TBufTextFile;
    BBSNum, InByte,
    i, ErrLvl    : Byte;
    t,
    WaitForUser  : EventTimer;
    OkStr        : String[10];
    CheckEMSI    : S127;
    BatName      : S12;
    ModemRes     : S80;
    WaitWin      : WindowPtr;

    PROCEDURE SendIntro;
    BEGIN
      IF Cfg.UseEMSI THEN ComPort^.WriteStr(EMSIREQStr);
      ComPort^.WriteStr(Char(Cr)+'* Network Address '+Address2Str(Cfg.Addresses[Cfg.MainAdrNum])+
                        ' Using Portal of Power v'+Ver+Char(Cr));
    END;

    FUNCTION ShowBanner: Boolean;
    VAR
      Banner  : TBufTextFile;
      Ch, Ch1 : Char;
      Done    : Boolean;
      i       : Integer;
    BEGIN
      ComPort^.WriteByte(Byte(lf), True);
      IF NOT Banner.Init(Cfg.Banner, SOpenRead+ShareDenyW, 512) THEN
      BEGIN
        AddLog('!','Can''t find banner file: '+cfg.banner);
        ShowBanner:=False;
      END ELSE
      BEGIN
        Done:=False; Ch1:=#0;
        WHILE NOT Banner.EoF AND NOT Done DO
        BEGIN
          Banner.Read(Ch, 1);
          ComPort^.WriteByte(Byte(Ch), True);
          IF ComPort^.KeyPressed THEN
          BEGIN
            ComPort^.Peek(Byte(Ch1));
            IF (Pos(UpCase(Ch1),OkStr)=0) THEN
            BEGIN
              Ch1:=Char(ComPort^.ReadByte);
              CheckEMSI:=CheckEMSI+Ch1;
              IF POS(EMSIINQStr,CheckEMSI)>0 THEN
              BEGIN
                InByte:=0;
                Break;
              END;
            END ELSE
              Done:=True;
          END ELSE
            Ch1:=#0;
        END;
        IF Done THEN
        BEGIN
          ComPort^.PurgeOut;
          InByte:=Byte(Ch1);
        END;
        ShowBanner:=(Pos(UpCase(Ch1),OkStr)>2) and Done;
        Banner.Done;
      END;
    END;

    PROCEDURE ShowFileToRemote(CONST FileName: PathStr);
    VAR
      f : TBufTextFile;
      b : Byte;
    BEGIN
      IF f.Init(FileName, SOpenRead+ShareDenyW, 512) THEN
      BEGIN
        AddLog(':', 'Showing: '+FileName+' to remote');
        WHILE NOT f.Eof AND ComPort^.Carrier DO
        BEGIN
          f.Read(b, 1); ComPort^.WriteByte(b, False);
        END;
        f.Done;
        ComPort^.FlushTx;
      END;
    END;

    FUNCTION PrintableChars(CONST s: String): Boolean;
    VAR
      i : Byte;
    BEGIN
      PrintableChars:=True;
      FOR i:=1 TO Length(s) DO
        IF (s[i]<#32) OR (s[i]>#128) THEN PrintableChars:=False;
    END;


  BEGIN
    WaitWin:=Nil;
    ModemRes:='';
    IF ComPort^.KeyPressed THEN
      ModemRes:=ModemReadStr
    ELSE
      IF NOT Forced THEN Exit;
    IF (ModemRes='RING') OR (Copy(ModemRes,1,5)='RING ') OR (Forced) THEN
    BEGIN
      IF Forced THEN AddLog(':', 'Forced modem answer') ELSE AddLog('#', ModemRes);
      IF ((CurrentEvent.Typ AND etNoAnswer)=0) OR (Forced) THEN
      BEGIN
        IF Cfg.Modem.UseRingAnaly THEN
          IF (NOT Forced) AND (NOT RingAnalyzerAnswerCall(ModemRes)) THEN Goto NoBody;
        IF Cfg.Modem.Answer<>'' THEN TranslateModemString(Cfg.Modem.Answer);
      END ELSE
        Goto NoBody;
    END ELSE
      Exit;
    Tell(WaitWin, 'Waiting for modems to connect    ', 'Incomming call', (ScreenHeight DIV 2)-1, 2);
    NewTimerSecs(t, Cfg.Modem.WaitTime);
    REPEAT
      GiveUpTime;
      IF (GotESC) OR (TimerExpired(t)) THEN
      BEGIN
        IF TimerExpired(t) THEN AddLog('#', 'Timeout waiting for connect');
        GOTO NoBody;
      END;
      IF ComPort^.KeyPressed THEN ModemRes:=ModemReadStr ELSE ModemRes:='';
      IF (ModemRes<>'') AND (Copy(ModemRes, 1, 2)<>'AT') AND PrintableChars(ModemRes) THEN
      BEGIN
        AddLog('#', ModemRes);
        ErrLvl:=CheckConnectExit(ModemRes);
        IF ErrLvl<>0 THEN
        BEGIN
          FillChar(Call, SizeOf(Call), 0);
          Call.Zone:=-1;
          AddToCallList(1, Call, ModemRes);
          KillWindow(WaitWin);
          SpawnWithErrorLevel(ErrLvl, 'Exit on CONNECT string', False, FALSE);
        END;
        IF (ModemRes='NO CARRIER') {OR (ModemRes='RING')} THEN GOTO NoBody;
      END;
      WaitWin^.wFastText(LongIntForm('###',RemainingTimeInSecs(t)),1,32);
    UNTIL (Copy(ModemRes,1,7)='CONNECT') OR ((Pos('+FCO', ModemRes)>0) AND (Cfg.Modem.InternalFax));
    KillWindow(WaitWin); WaitWin:=Nil;
    IF (Pos('+FCO', ModemRes)>0) AND (Cfg.Modem.InternalFax) THEN
    BEGIN
      GetFax;
      GOTO NoBody;
    END;
    RealBaudRate:=GetRealBaudRate(ModemRes);
    IF IsLockedBaud(ModemRes) THEN
    BEGIN
      ComPort^.SetBaudRate(Cfg.Modem.BaudRate);
      ComPort^.SetCurrentBaud(RealBaudRate);
      AddLog('#','DTE Speed: '+Long2Str(Cfg.Modem.BaudRate)+', Line speed: '+Long2Str(Realbaudrate));
    END ELSE
    BEGIN
      ComPort^.SetBaudRate(RealBaudRate);
    END;
    ComPort^.PurgeIn;
    FullDuplex:=CheckBiOverride(ModemRes);
    WaitForSlowModem;
    UpdateStatusWindow;
    MNPFilter;
    NewTimerSecs(WaitForUser, 3);
    InByte:=0;
    CheckEMSI:='';
    CalculateEventTimes(True);
    WHILE (ComPort^.Carrier) AND (NOT TimerExpired(WaitForUser)) AND NOT (InByte IN [Escape,Lf,Cr,32,YooHoo,TSync]) DO
      IF ComPort^.KeyPressed THEN
      BEGIN
        InByte:=ComPort^.ReadByte;
        IF (InByte>31) AND (InByte<128) THEN
        BEGIN
          CheckEMSI:=CheckEMSI+Char(InByte);
          IF Length(CheckEMSI)>100 THEN Delete(CheckEMSI,1,50);
          IF (Cfg.UseEMSI) AND (POS(EMSIINQStr,CheckEMSI)<>0) THEN
          BEGIN
            InByte:=0;
            GOTO EMSIStart;
          END;
        END;
      END ELSE
        GiveUpTime;
    IF NOT ComPort^.Carrier THEN
    BEGIN
      AddLog(':', 'Caller disappeared?');
      GOTO NoBody;
    END;
    IF (InByte<>YooHoo) AND (InByte<>TSync) THEN
    BEGIN
      OkStr:=Char(TSync)+Char(YooHoo);
      FOR i:=1 TO 5 DO
        IF (Cfg.BBS.Multi[i].Key>' ') AND (Cfg.BBS.Multi[i].BatName<>'') THEN
          OkStr:=OkStr+Cfg.BBS.Multi[i].Key;
      IF (Cfg.BBS.Multi[1].Key<=' ') OR (Cfg.BBS.Multi[i].BatName='') THEN OkStr:=OkStr+Char(Escape);
      SendIntro;
      IF cfg.banner<>'' THEN
        IF ShowBanner THEN GOTO ItIsAlive;
      IF POS(EMSIINQStr,CheckEMSI)>0 THEN GOTO EmsiStart;
      IF (CurrentEvent.Typ AND etUsers)=0 THEN
        ComPort^.WriteStr(Char(lf)+Cfg.DoingMailText+Char(cr)+Char(lf))
      ELSE
        IF Cfg.BBS.Multi[1].Key<=' ' THEN ComPort^.WriteStr(Char(lf)+Cfg.PressESCText+Char(cr)+Char(lf));
      NewTimerSecs(WaitForUser, 30);
      REPEAT
        IF ComPort^.KeyPressed THEN
        BEGIN
          InByte:=ComPort^.ReadByte;
          IF (InByte>31) AND (InByte<127) THEN
          BEGIN
            CheckEMSI:=CheckEMSI+Char(InByte);
            IF (Cfg.UseEMSI) AND (POS(EMSIINQStr,CheckEMSI)<>0) THEN
            BEGIN
              InByte:=0;
              GOTO EMSIStart;
            END;
            IF Length(CheckEMSI)>100 THEN Delete(CheckEMSI,1,50);
          END;
        END ELSE
        BEGIN
          GiveUpTime;
          InByte:=0;
        END;
        CASE UpCase(Char(InByte)) OF
          Char(Lf),
          Char(Cr),
          Char(32) : SendIntro;
          ELSE IF POS(UpCase(Char(InByte)),OKStr)>2 THEN GOTO ItIsAlive;
        END;
      UNTIL (TimerExpired(WaitForUser)) OR (InByte IN [Escape,YooHoo,TSync]) OR (NOT ComPort^.Carrier);
      IF NOT ComPort^.Carrier THEN
      BEGIN
        AddLog(':', 'Caller disappeared?');
        GOTO NoBody;
      END;
    END;
    IF InByte IN [YooHoo,TSync] THEN
    BEGIN
EMSIStart:
      StopClock;
      MyWin(IntroWin,1,ScreenHeight-1,80,ScreenHeight,2,'',False);
      Inc(StatRec^.DayStat[0].MailSessions);
      UpdateConnectStat(CSMail, CSIn, RealBaudRate, ModemRes);
      FSent:=0; FReceived:=0;
      StartTime.T:=CurrentTime; StartTime.D:=Today;
      SynchTimeDiff:=0;
      ReceiveMailSession(InByte);
      EndTime.T:=CurrentTime;
      EndTime.D:=Today;
      UpdateUsageStat(StartTime,EndTime,USMailIn);
      LogLinkStat;
      IF Abs(SynchTimeDiff)>10 THEN SynchTime;
      RemoveUnDialable(Call);
      IF FReceived<>0 THEN DoPortalTasks;
      IF (CurrentEvent.MailExit>0) AND GotSomeMail THEN
      BEGIN
        SetInterCom(ICUnpackMail,Call,False);
        IF Cfg.TaskType=2 THEN
          RequestFunction(fsExit+(256*CurrentEvent.MailExit))
        ELSE
          SpawnWithErrorlevel(CurrentEvent.MailExit, 'Exit after mail', True, TRUE);
      END
      ELSE
        IF (CurrentEvent.FilesExit>0) AND GotSomeFiles THEN
        BEGIN
          SetInterCom(ICUnpackMail,Call,False);
          IF Cfg.TaskType=2 THEN
            RequestFunction(fsExit+(256*CurrentEvent.FilesExit))
          ELSE
            SpawnWithErrorlevel(CurrentEvent.FilesExit, 'Exit after files', True, TRUE);
        END
        ELSE
          IF CurrentEvent.PollExit>0 THEN
          BEGIN
            IF Cfg.TaskType=2 THEN
              RequestFunction(fsExit+(256*CurrentEvent.PollExit))
            ELSE
              SpawnWithErrorlevel(CurrentEvent.PollExit, 'Exit after poll', True, TRUE);
          END;
      NewTimer(OutBoundReRead, 0);
    END ELSE
    BEGIN
ItIsAlive:
      UpdateConnectStat(CSUser, CSIn, RealBaudRate, ModemRes);
      IF (CurrentEvent.Typ AND etUsers)=0 THEN
      BEGIN
        AddLog('#', 'Hanging up on user in mail session');
        ModemHangUp;
        InitModemForEvent;
        GOTO NoBody;
      END ELSE
      BEGIN
        IF RealBaudRate<Cfg.BBS.MinBaud THEN
        BEGIN
          AddLog('*','Ax''ing too slow caller');
          IF ExistFile(Cfg.BBS.MinBaudFile) THEN ShowFileToRemote(Cfg.BBS.MinBaudFile);
          Pause(1000);
          GOTO NoBody;
        END;
        BBSNum:=0;
        IF Cfg.BBS.Multi[1].Key>' ' THEN
        BEGIN
          REPEAT
            IF POS(UpCase(Char(InByte)),Okstr)<3 THEN
            BEGIN
              WHILE Not ComPort^.KeyPressed AND  (NOT TimerExpired(WaitForUser)) DO
                GiveUpTime;
              IF ComPort^.KeyPressed AND ComPort^.Carrier THEN InByte:=ComPort^.ReadByte;
            END;
            BBSNum:=1;
            IF TimerExpired(WaitForUser) THEN
            BEGIN
              InByte:=Byte(Cfg.BBS.Multi[1].Key);
              GOTO KeepOnRocking;
            END;
            WHILE (BBSNum<5) And (Cfg.BBS.Multi[BBSNum].Key<>UpCase(Char(InByte))) DO
              Inc(BBSNum);
          UNTIL (Cfg.BBS.Multi[BBSNum].Key=UpCase(Char(InByte))) OR Not ComPort^.Carrier;
        END;
KeepOnRocking:
        IF NOT ComPort^.Carrier THEN GOTO NoBody;
        Inc(StatRec^.DayStat[0].BBSSessions);
        ComPort^.WriteStr(Char(cr)+Char(lf)+Cfg.EnterBBSText+Char(cr)+Char(lf));
        AddLog('#','Entering BBS-'+Long2Str(RealBaudRate));
        f.Init(MakeTaskFileName('BBSBATCH.BAT'), SCreate, 128);
        IF InitStatus<>0 THEN AddLog('!', 'Error: '+Long2Str(InitStatus)+' when creating: '+MakeTaskFileName('BBSBATCH.BAT'));
        IF (BBSNum>0) AND (Cfg.BBS.Multi[BBSNum].BatName<>'') THEN
          BatName:=Cfg.BBS.Multi[BBSNum].BatName
        ELSE
          BatName:='SPAWNBBS';
        IF IsLockedBaud(ModemRes) THEN DTEBaud:=Cfg.Modem.BaudRate ELSE DTEBaud:=RealBaudRate;
        f.WriteLn(BatName+' '+Long2Str(RealBaudRate)+' '+
                  Long2Str(Cfg.Modem.Commport)+' '+
                  Long2Str(TimeToNextForcedEvent DIV 60)+' '+
                  Long2Str(Cfg.TaskNumber)+' '+
                  Long2Str(DTEBaud)+' '+GetExtraInfo(ModemRes));
        f.Done;
        IF SetInterCom(ICUserInBBS,Call,False) THEN
        BEGIN
          w:=Cfg.BBS.UserErrorLevel;
          IF w=0 THEN w:=RealBaudRate DIV 100;
          SpawnWithErrorlevel(w, 'Spawning to BBS', False, FALSE);
        END;
      END;
    END;
NoBody:
    SetInterCom(ICIdle,Call,False);
    IF WaitWin<>Nil THEN KillWindow(WaitWin);
    DropCarrier;
    InitModemForEvent;
    StartClock;
  END;

  FUNCTION FindSpecialModemDial: S40;
  VAR
    s : S40;
    i : Byte;
  BEGIN
    s:='';
    FOR i:=0 TO 7 DO
      IF (1 SHL Cfg.Modem.ModemType[i].Bit) AND NodeListEntry.ModemType<>0 THEN
      BEGIN
        s:=Cfg.Modem.ModemType[i].Dial;
        Break;
      END;
    IF s='' THEN s:=Cfg.Modem.Dial;
    FindSpecialModemDial:=s;
  END;

  FUNCTION NoConnect(CONST s: STRING): Boolean;
  BEGIN
    NoConnect:=((s='BUSY') Or (s='VOICE') Or (Copy(s,1,2)='NO'));
  END;

  PROCEDURE Dial(Manuel: Boolean);
  LABEL
    Fubar;
  VAR
    NumRinging   : Byte;
    dt1,dt2      : DateTimeRec;
    i,
    Baud         : Word;
    Temp         : windowptr;
    RealBaudRate : Word;
    Escaped      : Boolean;
    ModemRes     : S80;
    s            : STRING;
    BusyFile     : File;
    Seconds,
    t            : EventTimer;
    TempPhone    : S60;

    PROCEDURE ShowCallCost;
    VAR
      NodeCost : LongInt;
      Days     : Word;
      Seconds  : LongInt;
    BEGIN
      dt2.t:=CurrentTime; dt2.d:=Today;
      UpdateUsageStat(dt1,dt2,USMailOut);
      Datetimediff(dt1,dt2,days,seconds);
      { IF Seconds<10 THEN Seconds:=10; }
      NodeCost:=(((days*86400)+seconds+LONGINT(Cfg.Modem.ConnectTime)+59) DIV 60)*NodelistEntry.RealCost;
      StatRec^.DayStat[0].Cost:=StatRec^.DayStat[0].Cost+NodeCost;
      AddLog(':', 'Connected to: '+Address2Str(Call)+' for: '+
                  TimeToTimeString('hh:mm:ss', (days*86400)+Seconds+LONGINT(Cfg.Modem.ConnectTime))+
                  ' cost: '+Long2Str(NodeCost));
    END;

    PROCEDURE UpdateCallsOutStat(AStart, AFinish: DateTimeRec;
                                 AnAddress: TFidoAddress;
                                 AfilesIn, AFilesOut: Word;
                                 AConnectSpeed: LongInt);
    VAR
      CallStat : TCallStat;
      CallStatFile : TNetFile;
      FName    : PathStr;
      NodeCost : LongInt;
      Days     : Word;
      Seconds      : LongInt;
    BEGIN
      FillChar(CallStat, SizeOf(CallStat), 0);
      FName:=StartPath+MakeTaskFileName('PORTAL.SCO');
      IF CallStatFile.Open(FName, SizeOf(CallStat), True) THEN
      BEGIN
        DateTimeDiff(dt1,dt2,Days,Seconds);
        { IF Seconds<10 THEN Seconds:=10; }
        NodeCost:=(((Days*86400)+Seconds+LONGINT(Cfg.Modem.ConnectTime)+59) DIV 60)*NodelistEntry.RealCost;
        WITH CallStat DO
        BEGIN
          Start        := AStart;
          Finish       := AFinish;
          Address      := AnAddress;
          MailerType   := RemHello.ProductCode;
          SystemName   := AsciiZ2Str(RemHello.SystemName,60);
          SysOpName    := AsciiZ2Str(RemHello.SysOp,20);
          FilesIn      := AFilesIn;
          FilesOut     := AFilesOut;
          Cost         := (((Days*86400)+Seconds+LONGINT(Cfg.Modem.ConnectTime)+59) DIV 60)*NodelistEntry.RealCost;
          ConnectSpeed := AConnectSpeed;
        END;
        CallStatFile.PutRec(CallStat, CallStatFile.FileSize);
        CallStatFile.Close;
      END ELSE
        AddLog('!', 'Error opening/creating: '+FName);
    END;

    FUNCTION Best(w1, w2: Word): Word;
    BEGIN
      Best:=w2;
      IF w1<>0 THEN Best:=w1;
    END;

  BEGIN
    RemapAddress(Call);
    IF (NodelistEntry.PhoneNumber='') And (NodesRec.Phone='') THEN
    BEGIN
      IF Manuel THEN
      BEGIN
        s:='';
        IF InputString(10,8,20,20,2,'Node does NOT exist','Phone : ',s) THEN
        BEGIN
          WITH NodeListEntry DO
          BEGIN
            Adr.Zone:=Call.zone;
            Adr.Net:=Call.net;
            Adr.Node:=Call.node;
            Systemname:='Unknown node!!!';
            phonenumber:=s;
          END;
        END ELSE
          Exit;
      END ELSE
        Exit;
    END ELSE
      IF NodesRec.Phone<>'' THEN NodelistEntry.PhoneNumber:=NodesRec.Phone;
    IF Manuel AND ((NodelistEntry.Flags AND nlf_CrashMail)=0) AND
       NOT Confirm(Address2Str(Call)+' is not a CM system - call anyway?', 'Y', 9) THEN Exit;
    Data.NextTime.StartTics:=0;
    AddLog(':','Polling: '+Address2Str(Call)+', '+NodelistEntry.SystemName);
    IF ComPort^.KeyPressed THEN
    BEGIN
      ModemRes:=ModemReadStr;
      IF (ModemRes='RING') OR (Copy(ModemRes,1,5)='RING ') THEN
      BEGIN
        IF (CurrentEvent.Typ AND etNoAnswer)=0 THEN
        BEGIN
          AddLog(':','Incoming call detected - Answering modem');
          NewTimerSecs(t, 5);
          WHILE Not ComPort^.KeyPressed AND Not TimerExpired(t) DO  { Wait for another ring }
            GiveUpTime;
          CheckModemResponse(False);
        END ELSE
        BEGIN
          AddLog(':','Incoming call detected - dial aborted');
          AddLog('#', ModemRes);
        END;
        Exit;
      END;
      ModemRes:='';
    END;
    IF NOT MarkNodeBusy(BusyFile, Call) THEN
    BEGIN
      AddLog(':',Address2Str(Call)+' is marked busy - skipping');
      Exit;
    END ELSE
      UnMarkNodeBusy(BusyFile);
    IF NOT SetInterCom(ICPolling,Call,False) THEN Exit;
    ComPort^.WriteByte(Cr, True);
    mywin(Temp,15,8,65,20,2,'Dialing',True);
    WITH NodelistEntry, Temp^,Cfg.Color[2] DO
    BEGIN
      wFastText('Address    :',2,2);
      wfastwrite(Address2Str(Call),2,15,HighLightColor);
      wFastText('System     :',3,2);
      wfastwrite(SystemName,3,15,HighLightColor);
      wFastText('Sysop      :',4,2);
      wfastwrite(SysopName,4,15,HighLightColor);

      wFastText('Misc.Info  :',5,2);
      wfastwrite(MiscInfo,5,15,HighLightColor);
      IF cfg.Modem.BaudRate<BaudRate THEN Baud:=cfg.Modem.BaudRate ELSE Baud:=BaudRate;
      s:='';
      FOR i:=0 TO 7 DO
        IF (1 SHL Cfg.Modem.ModemType[i].Bit) AND ModemType<>0 THEN
          s:=s+', '+Cfg.NlCompiler.MTypeStr[Cfg.Modem.ModemType[i].Bit];
      wFastText('Baud (Max) :',6,2);
      wfastwrite(Long2Str(Baud)+' ('+Long2Str(BaudRate)+s+')',6,15,HighLightColor);
      wFastText('Calling    :',7,2);
      wFastText('Provider   :',8,2);
      wFastText('Zone       :',9,2);
      wFastText('Cost/Min   :',10,2);
    END;
    Inc(StatRec^.DayStat[0].CallsOut);
    IF FoundInNodes And (NodesRec.SpecialDials[CurrentEvent.SpecDial]<>'') THEN
      s:=NodesRec.SpecialDials[CurrentEvent.SpecDial] ELSE s:=FindSpecialModemDial;

    IF IsOurAddress(Call) THEN Nodelistentry.PhoneNumber:=PhoneTranslation(Nodelistentry.PhoneNumber);
    IF Cfg.Modem.UseLCR THEN TempPhone := LeastCostRouting(Nodelistentry.PhoneNumber)
    ELSE BEGIN
      LCR.Costs := MaxLongint;
      LCR.Provider := '?';
      LCR.Zone := '?';
      TempPhone := Nodelistentry.PhoneNumber;
    END;
    WITH NodelistEntry, Temp^,Cfg.Color[2] DO
    BEGIN
      IF LCR.Costs < MaxLongint THEN RealCost := LCR.Costs;
      wfastwrite(TempPhone,7,15,HighLightColor);
      wfastwrite(LCR.Provider,8,15,HighLightColor);
      wfastwrite(LCR.Zone,9,15,HighLightColor);
      wfastwrite(Long2Str(RealCost),10,15,HighLightColor);
    END;
    TranslateModemString(s+TempPhone+'|');
    AddLog(':','Dialing: '+s+TempPhone);
    NewTimerSecs(Seconds, Cfg.Modem.WaitTime);
    Escaped:=False; NumRinging:=0;
    REPEAT
      IF ComPort^.KeyPressed THEN
      BEGIN
        ModemRes:=ModemReadStr;
        IF (Copy(ModemRes,1,2)<>'AT') AND (ModemRes<>'') THEN
        BEGIN
          AddLog('#',ModemRes);
          IF Copy(ModemRes, 1, 7)='RINGING' THEN Inc(NumRinging);
          IF (Cfg.MaxRinging>0) AND (NumRinging>=Cfg.MaxRinging) THEN
          BEGIN
            AddLog('!', 'I hear too much ringing in my ears....');
            UpdateUnDialable(Call, 1, 0);
            Escaped:=True;
          END;
        END;
      END ELSE
      BEGIN
        ModemRes:='';
        GiveUpTime;
      END;
      IF GotESC THEN Escaped:=True;
    UNTIL (NoConnect(ModemRes)) OR (Copy(modemres,1,7)='CONNECT') OR (Escaped) OR (TimerExpired(Seconds));
    KillWindow(Temp);
    IF Escaped THEN
    BEGIN
      AddLog(':','Poll aborted, hanging up');
      ModemHangUp;
      InitModemForEvent;
      SetInterCom(ICIdle,Call,False);
      NewTimerSecs(Data.NextTime, CalculateNextTime);
      Exit;
    END;

    dt1.d:=Today; dt1.t:=CurrentTime;
{    IF ((CurrentEvent.Typ AND etNoAnswer)=0) AND
        (Copy(ModemRes, 1, 7)='NO DIAL') AND (Cfg.Modem.Answer<>'') THEN
     BEGIN
       SetInterCom(ICIdle,Call,False);
       CheckModemResponse(True);
       NewTimerSecs(Data.NextTime, CalculateNextTime);
       Exit;
     END; }

    WaitForSlowModem;
    IF (Copy(ModemRes,1,7)='CONNECT') AND (ComPort^.Carrier) THEN
    BEGIN
      StopClock;
      RealBaudRate:=GetRealBaudRate(ModemRes);
      UpdateConnectStat(CSMail, CSOut, RealBaudRate, ModemRes);
      IF (((NodesRec.CheckConnect IN [#0,' ']) And (Cfg.ConnectFastest)) Or (NodesRec.CheckConnect='Y')) And
         (RealBaudRate<Best(NodesRec.MinConnectBaud, Baud)) THEN
      BEGIN
        AddLog('!','Too slow connection - Poll aborted');
        ShowCallCost;
        GOTO Fubar;
      END;
      IF IsLockedBaud(ModemRes) THEN
      BEGIN
        ComPort^.SetBaudRate(Cfg.Modem.BaudRate);
        ComPort^.SetCurrentBaud(RealBaudRate);
        AddLog('#','DTE Speed: '+Long2Str(Cfg.Modem.BaudRate)+', Line speed: '+Long2Str(Realbaudrate));
      END ELSE
      BEGIN
        ComPort^.SetBaudRate(RealBaudRate);
      END;
      FullDuplex:=CheckBiOverride(ModemRes);
      UpdateStatusWindow;
      FSent:=0; FReceived:=0;
      IF NOT SetInterCom(ICConnect,Call,False) THEN
      BEGIN
        ShowCallCost;
        GOTO Fubar;
      END;
      MNPFilter;
      SynchTimeDiff:=0;
      IF StartMailSession THEN
      BEGIN
        ShowCallCost;
        UpdateCallsOutStat(dt1,dt2,call,FReceived,FSent,RealBaudRate);
        IF Abs(SynchTimeDiff)>10 THEN SynchTime;
        LogLinkStat;
        RemoveUnDialable(Call);
        IF FReceived<>0 THEN DoPortalTasks;
        IF (CurrentEvent.MailExit<>0) AND GotSomeMail AND SetInterCom(ICUnpackMail,Call,False) THEN
        BEGIN
          IF Cfg.TaskType=2 THEN
            RequestFunction(fsExit+(256*CurrentEvent.MailExit))
          ELSE
            SpawnWithErrorlevel(CurrentEvent.MailExit, 'Exit after mail', True, TRUE);
        END
        ELSE
          IF (CurrentEvent.FilesExit>0) AND GotSomeFiles AND SetInterCom(ICUnpackMail,Call,False) THEN
          BEGIN
            IF Cfg.TaskType=2 THEN
              RequestFunction(fsExit+(256*CurrentEvent.FilesExit))
            ELSE
              SpawnWithErrorlevel(CurrentEvent.FilesExit,'Exit after files', True, TRUE);
          END;
      END ELSE
      BEGIN
        UpdateUnDialable(Call, 0, 1);
        ShowCallCost;
      END;
    END ELSE
    BEGIN
      IF ModemRes<>'BUSY' THEN ShowCallCost;
      IF TimerExpired(Seconds) THEN AddLog('#', 'Other end did not answer');
      IF cfg.Modem.UseNConAnaly THEN NoConnectAnalyzer(ModemRes)
      ELSE UpdateUnDialable(Call, 1, 0);
    END;
    NewTimer(OutBoundReRead, 0);
    AddLog(':', 'Poll completed');
FuBar:
    SetInterCom(ICIdle, Call, False);
    ModemHangUp;
    InitModemForEvent;
    UpdateStatusWindow;
    StartClock;
    NewTimerSecs(Data.NextTime, CalculateNextTime);
  END;

  PROCEDURE PollNode;
  VAR
    TmpPtr : POutList;
  BEGIN
    WITH Data DO
    BEGIN
      IF Poll.Zone+Poll.Net+Poll.Node+Poll.Point=0 THEN
      BEGIN
        Poll:=cfg.Addresses[Cfg.MainAdrNum];
        Poll.Node:=0;
        Poll.Point:=0;
      END;
      IF GetConfirmAddress(11,2,Poll,1500) THEN
      BEGIN
        Call:=Poll;
        TmpPtr:=POutList(OutList^.Head);
        WHILE (TmpPtr<>Nil) And Not CmpAdr(Poll,TmpPtr^.Address) DO
          TmpPtr:=POutList(OutList^.Next(TmpPtr));
        IF TmpPtr<>Nil THEN
        BEGIN
          CLOutListPtr:=TmpPtr; FLOutListPtr:=TmpPtr;
          UpdateOutboundWindow;
        END;
        Dial(True);
      END;
    END;
  END;

  PROCEDURE PortalMain;
  VAR
    MSFlags        : LONGINT;
    TmpWin         : WindowPtr;
    OldOutPtr,
    SaveOutPtr     : POutList;
    MustReRead,
    ResetTimers,
    PortalFinished,
    JustScrolled   : Boolean;
    TmpCh          : Char;
    i,Tmp          : Byte;
    ii             : Integer;
    InKey          : Word;
    Fs, LastChoice : LongInt;
    s              : String;
    fp             : LongInt;
    SemaforeTimer,
    ReturnFromLog  : EventTimer;

    PROCEDURE CheckSemaforeFiles;
    VAR
      ELevel : Byte;
      Ok : Integer;
      Sr : SearchRec;
      Adr: TFidoAddress;
    BEGIN
      s:=StartPath+MakeTaskFileName('PORTAL.E*');
      FindFirst(s, AnyFile, sr);
      IF DOSError=0 THEN
      BEGIN
        Val('$'+Copy(sr.name,Length(Sr.Name)-1,2), ELevel, Ok);
        IF Ok=0 THEN
        BEGIN
          Adr.Zone:=ELevel;
          IF SetInterCom(ICSemExit, Adr, False) THEN
          BEGIN
            FindClose(sr);
            DeleteFile(StartPath+Sr.Name);
            SpawnWithErrorlevel(ELevel,'Semafore exit', True, TRUE);
          END;
        END;
      END;
      FindClose(sr);
      NewTimerSecs(SemaforeTimer, 60);
    END;

    FUNCTION StillHaveMail(CONST Adr: TFidoAddress): Boolean;
    VAR
      sr        : SearchRec;
      s         : PathStr;
      FoundMail : Boolean;
    BEGIN
      s:=HoldFileName(Adr, False)+'?LO';
      FindFirst(s, Archive, Sr);
      WHILE (DOSError=0) AND (Sr.Name[10]='H') DO
        FindNext(Sr);
      FoundMail:=(DOSError=0);
      FindClose(Sr);
      IF NOT FoundMail THEN
      BEGIN
        s:=HoldFileName(Adr, False)+'?UT';
        FindFirst(s, Archive, Sr);
        WHILE (DOSError=0) AND (Sr.Name[10]='H') DO
          FindNext(Sr);
        FoundMail:=(DOSError=0);
        FindClose(Sr);
      END;
      StillHaveMail:=FoundMail;
    END;

  BEGIN
    LastChoice:=0;
    PortalFinished:=False;
{$IFNDEF NOMAILSCANNER}
    MSFlags:=0;
    IF CmdLineFlags AND clMailScan<>0 THEN MSFlags:=MSFlags OR etScanMail;
    IF CmdLineFlags AND clMailToss<>0 THEN MSFlags:=MSFlags OR etTossMail;
    IF CmdLineFlags AND clMailPack<>0 THEN MSFlags:=MSFlags OR etPackMail;
    IF MSFlags<>0 THEN RunMailScanner(MSFlags);
{$ENDIF}
    NewTimerSecs(ScreenBlank, Cfg.Screen.BlankTime);
    NewTimerSecs(ModemReInit, Cfg.Modem.Reinit);
    NewTimerSecs(ActivitySemafore, ActivitySemaforeTime);
    NewTimerSecs(SemaforeTimer, 15);
    NewTimerSecs(ReturnFromLog, 30);
    REPEAT
      Topic:=10;
      HiddenCursor;
      JustScrolled:=False;
      IF Cfg.TaskType=1 THEN FunctionServer;
      IF PoPKeyPressed THEN
      BEGIN
        InKey:=PopReadKeyWord;
        StopClock; ResetTimers:=True;
        CASE Char(Lo(InKey)) OF
          '+',
          '-': IF OutList^.Size>0 THEN
               BEGIN
                 IF Char(Lo(InKey))='-' THEN
                   GlueNode(CLOutListPtr^.Address)
                 ELSE
                   UnGlueNode(CLOutListPtr^.Address);
                 CLOutListPtr^.Glued:=(Char(Lo(InKey))='-');
                 UpdateOutboundWindow;
               END;
          #13: IF (CmdLineFlags AND clNoModem=0) AND (OutList^.Size>0) And (CLOutListPtr^.Known) AND (Not InLogWin) THEN
               BEGIN
                 WITH CLOutListPtr^ DO
                   Call:=Address;
                 Dial(True);
               END;
          ELSE BEGIN
                 CASE InKey OF
                   AltA : IF Cfg.BBS.BBSType<>btNone THEN
                          BEGIN
                            MakeModemBusy;
                            AreaManager;
                          END;
                   AltB : BEGIN
                            NewTimer(ScreenBlank, 0);
                            ResetTimers:=False;
                          END;
                   AltC : IF CmdLineFlags AND clNoModem=0 THEN
                          BEGIN
                            AddLog(':','Immediate call requested');
                            NewTimer(Data.NextTime, 0);
                            ResetTimers:=False;
                          END;
                   AltD : IF Cfg.DumbTerm.ExtTermErrorlevel = 0 THEN TerminalMode
                          ELSE SpawnWithErrorlevel(Cfg.DumbTerm.ExtTermErrorlevel, 'Exit to external terminal', False, TRUE);
                   AltE : IF (Cfg.Editor<>'') THEN
                          BEGIN
                            IF (SetInterCom(ICMsgEdit,Call,False)) THEN
                            BEGIN
                              MakeModemBusy;
                              AddLog('!','Invoking message reader');
                              ii:=ShellToDos(GetEnv('COMSPEC'),'/C '+cfg.editor,true);
                              IF ii=0 THEN
                              BEGIN
                                AddLog(':','Returning from message reader');
                                IF NOT ComPort^.KeyPressed THEN
                                BEGIN
                                  UpdateNetMailFlag;
                                  NewTimerSecs(OutboundReRead, 1) ;
                                END;
                              END ELSE
                                AddLog('!', 'Error '+Long2Str(ii)+' when invoking message reader');
                            END;
                          END ELSE
                          BEGIN
{$IFDEF MSGOBJECT}
                            PoPEdMain;
{$ENDIF}
                          END;
                   AltF : DisplayKeys(False);
{                  AltG : SystemInfo;        See KEYBOARD.PAS }
{                  AltH : ??}
                   AltI : ExpandOutboundEntry;
{                  AltJ : JumpToDOS;         See KEYBOARD.PAS }
{                  AltK : KeyboardMacros;    See KEYBOARD.PAS }
                   AltL : BEGIN
                            mywin(TmpWin,19,11,61,13,2,'Lock Keyboard',True);
                            TmpWin^.wFastText(' Enter password, ESC=Abort, CR=Finished ', 1, 1);
                            Data.KbdPassword := '';
                            REPEAT
                              TmpCh := Char(Lo(PopReadKeyWord));
                              IF Not (TmpCh IN [#27,#13]) THEN Data.KbdPassword := Data.KbdPassword + TmpCh;
                            UNTIL TmpCh IN [#27,#13];
                            IF (TmpCh <> #27) And (Data.KbdPassword <> '') THEN BEGIN
                              TmpWin^.wFastText(' Retype password, ESC=Abort, CR=Finished', 1, 1);
                              Data.KbdPasswordR := '';
                              REPEAT
                                TmpCh := Char(Lo(PopReadKeyWord));
                                IF Not (TmpCh IN [#27,#13]) THEN Data.KbdPasswordR := Data.KbdPasswordR + TmpCh;
                              UNTIL TmpCh IN [#27,#13];
                              IF (TmpCh <> #27) AND (Data.KbdPassword = Data.KbdPasswordR) THEN BEGIN
                                TmpPassword := ''; KeyboardLock := True;
                                AddLog(':','Keyboard locked');
                              END ELSE
                                Data.KbdPassword := '';
                              Data.KbdPasswordR := '';
                            END ELSE
                              Data.KbdPassword := '';
                            KillWindow(TmpWin);
{$IFNDEF OS2}
                            WriteMacroStatus;
{$ENDIF}
                          END;
{$IFNDEF NoMailScanner}
                   AltM : RunMailScanner(0);
{$ENDIF}
                   AltN : BEGIN
                            MakeModemBusy;
                            NodeListManager;
                          END;
                   AltO : BEGIN
                            MakeModemBusy;
                            OutboundManager;
                            NewTimerSecs(OutboundReRead, 1) ;
                          END;
                   CtrlO: IF (Cfg.ExtOutboundMan<>'') THEN
                          BEGIN
                            IF SetInterCom(ICOutman,Call,True) THEN
                            BEGIN
                              MakeModemBusy;
                              AddLog('!','Invoking external outbound manager');
                              ii:=ShellToDos(GetEnv('COMSPEC'),'/C '+cfg.ExtOutboundMan,true);
                              IF ii=0 THEN
                              BEGIN
                                AddLog(':','Returning from external outbound manager');
                                NewTimerSecs(OutboundReRead, 1) ;
                              END ELSE
                                AddLog('!', 'Error '+Long2Str(ii)+' when invoking external outbound manager');
                            END;
{$IFNDEF Gamma}
                          END ELSE
                          BEGIN
                            MakeModemBusy;
                            IF OutList^.Size>0 THEN
                              Call:=CLOutListPtr^.Address
                            ELSE
                              FillChar(Call, SizeOf(Call), 0);
                            NewOutboundManager(Call);
                            NewTimerSecs(OutboundReRead, 1) ;
{$ENDIF}
                          END;
                   AltP : IF CmdLineFlags AND clNoModem=0 THEN PollNode;
                   AltQ : IF Cfg.BBS.BBSType <> btNone THEN BEGIN
                            MakeModemBusy;
                            ListMain;
                          END;
{$IFDEF Repacker}
                   AltR : BEGIN
                            MakeModemBusy;
                            RunRepacker;
                          END;
{$ENDIF}
                   AltS : PortalStatus;
                   AltT : IF SetInterCom(ICTextEdit,Call,True) THEN
                          BEGIN
                            MakeModemBusy;
                            RunTextEditor('');
                          END;
                   AltU : IF (Cfg.BBS.BBSType<>btNone) And (SetInterCom(ICUserEd,Call,False)) THEN UserEditor;
                   AltV : BEGIN
                            MakeModemBusy;
                            CompileNodeList(True);
                          END;
                   AltW : IF OutList^.Size>0 THEN
                            DisplaySingleNode(CLOutListPtr^.Address);
                   Esc,
                   AltX : PortalFinished:=AskFinish;
                   AltY : BEGIN
                            MakeModemBusy;
                            ScanNetMail;
                            UpdateNetMailFlag;
                          END;
                   AltZ : BEGIN
                            MakeModemBusy;
                            ProcessTicks;
                            ForwardFiles(Confirm('Add files to forward list','N',8));
                            NewTimer(OutboundReRead, 0) ;
                          END;
                   CtrlR: NewTimer(OutboundReRead, 0);
                   F2   : BEGIN
                            LoadMainMenu;
                            MainMenu^.Draw;
                            InMainMenu:=True;
                            MainMenu^.Process;
                            InMainMenu:=False;
                            LastChoice:=MainMenu^.MenuChoice;
{$IFNDEF OS2}
                            IF LastChoice IN [90..97] THEN
                              MacroMenu(LastChoice)
                            ELSE
{$ENDIF}
                            BEGIN
                              IF (LastChoice<1) OR (LastChoice>40) THEN
{!!!  NOT (MainMenu^.MenuChoice IN [1..40]) THEN}
                                MainMenu^.EraseAllSubMenus(True, True);
                              MainMenu^.Erase;
                            END;
                              IF (LastChoice>=1) AND (LastChoice<=40) THEN
                              BEGIN
                                StuffKey(F10);
                                Continue;
                              END ELSE
                              BEGIN
                                CASE LastChoice OF
{                                  200 : NewTimer(OutboundReRead, 0); }
                                  210 : InitModemForEvent;
                                  211 : CheckModemResponse(True);
                                  212 : BEGIN
                                          MakeModemBusy;
                                          NewTimerSecs(ModemReInit, 60*60);
                                        END;
                                  213 : ShowAbout;
                                  214 : ExportConfig;
                                  215 : ImportConfig;
{$IFDEF MSGPACK}
                                  216 : PackMsg(false);
{$ENDIF}
                                  AltX: PortalFinished:=True;
                                  ELSE  StuffKey(LastChoice);
                                END;
                                LastChoice:=0;
                              END;
                          END;
                   F9   : AboutToday;
                   F10  : IF SetInterCom(ICConfig,Call,False) THEN
                          BEGIN
                            LastChoice := 0;
                            Configuration(False, LastChoice);
                            IF LastChoice=0 THEN
                            BEGIN
                              ChangeEvent(True);
                              UpdateStatusWindow;
{                             OutboundReRead:=TimerSet(100);}
                            END ELSE
                            BEGIN
{$IFNDEF OS2}
                              IF LastChoice IN [90..97] THEN MacroMenu(LastChoice);
{$ENDIF}
                              CASE LastChoice OF
                                1..40 : StuffKey(F10);
{                                200 : NewTimer(OutboundReRead, 0); }
                                210 : InitModemForEvent;
                                211 : CheckModemResponse(True);
                                212 : BEGIN
                                        MakeModemBusy;
                                        NewTimerSecs(ModemReInit, 60*60);
                                      END;
                                213 : ShowAbout;
                                214 : ExportConfig;
                                215 : ImportConfig;
                                AltX: PortalFinished:=True;
                                ELSE  StuffKey(LastChoice);
                              END;
                              IF NOT (LastChoice IN [1..40]) THEN LastChoice:=0 ELSE Continue;
                            END;
                          END;
                   Home : IF InLogWin THEN
                          BEGIN
                            IF CurrentLogView[1]>0 THEN
                            BEGIN
                              PortalLog.Seek(0);
                              i:=0;
                              REPEAT
                                Inc(i);
                                CurrentLogView[i]:=PortalLog.FilePos;
                                PortalLog.ReadLine(s);
                              UNTIL i=LogLines+1;
                              ReWriteLogWindow;
                            END;
                          END ELSE
                          BEGIN
                            IF OutList^.Size>1 THEN
                            BEGIN
                              CLOutListPtr:=POutList(OutList^.Head);
                              FLOutListPtr:=CLOutListPtr;
                              UpdateOutboundWindow;
                            END;
                          END;
                   Up   : IF InLogWin THEN
                          BEGIN
                            IF CurrentLogView[1]>2 then
                            BEGIN
                              fp:=CurrentLogView[1];
                              Move(CurrentLogView[1],CurrentLogView[2],(LogLines)*4);
                              PortalLog.Seek(fp+2);
                              PortalLog.ReadLineBack(S);
                              CurrentLogView[1]:=PortalLog.FilePos-2;
                              WITH ActivityWindow^ DO
                              BEGIN
                                ScrollVert(-1);
                                WriteLogLine(S,1);
{$IFDEF UseScrollBars}
                                DrawSlider(FrRR,CurrentLogView[1]);
{$ENDIF}
                              END;
                              JustScrolled:=True;
                            END;
                          END ELSE
                          BEGIN
                            IF (CLOutListPtr<>Nil) And (OutList^.Prev(CLOutListPtr)<>Nil) THEN
                            BEGIN
                              IF CLOutListPtr=FLOutListPtr THEN FLOutListPtr:=POutList(OutList^.Prev(FLOutListPtr));
                              CLOutListPtr:=POutList(OutList^.Prev(CLOutListPtr));
                              UpdateOutboundWindow;
                            END;
                          END;
                   PgUp : IF InLogWin THEN
                          BEGIN
                            IF CurrentLogView[1]>2 then
                            BEGIN
                              i:=LogLines-1;
                              REPEAT
                                fp:=CurrentLogView[1];
                                Move(CurrentLogView[1],CurrentLogView[2],(LogLines)*4);
                                PortalLog.Seek(fp+2);
                                PortalLog.ReadLineBack(S);
                                CurrentLogView[1]:=PortalLog.FilePos-2;
                                Dec(i);
                              Until (i=0) or (CurrentLogView[1]<2);
                              ReWriteLogWindow;
                              JustScrolled:=True;
                            END;
                          END ELSE
                          BEGIN
                            IF OutList^.Size>1 THEN
                            BEGIN
                              Tmp:=1;
                              WHILE (OutList^.Prev(CLOutListPtr)<>Nil) And (Tmp<4) DO
                              BEGIN
                                Inc(Tmp);
                                CLOutListPtr:=POutList(OutList^.Prev(CLOutListPtr));
                                IF OutList^.Prev(FLOutListPtr)<>Nil THEN
                                  FLOutListPtr:=POutList(OutList^.Prev(FLOutListPtr));
                              END;
                              UpdateOutboundWindow;
                            END;
                          END;
                 EndKey : IF InlogWin THEN
                          BEGIN
                            IF EndLogView[1]<>CurrentLogView[1] THEN
                            BEGIN
                              CurrentLogView:=EndLogView;
                              ReWriteLogWindow;
{$IFDEF UseScrollBars}
                              ActivityWindow^.DrawSlider(FrRR,CurrentLogView[LogLines+1]);
{$ENDIF}
                            END;
                          END ELSE
                          IF OutList^.Size>1 THEN
                          BEGIN
                            CLOutListPtr:=POutList(OutList^.Tail);
                            FLOutListPtr:=CLOutListPtr; Tmp:=1;
                            WHILE (OutList^.Prev(FLOutListPtr)<>Nil) And (Tmp<4) DO
                            BEGIN
                              FLOutListPtr:=POutList(OutList^.Prev(FLOutListPtr));
                              Inc(Tmp);
                            END;
                            UpdateOutboundWindow;
                          END;
                   Down : If InLogWin then
                          BEGIN
                            FS:=PortalLog.FileSize;
                            IF CurrentLogView[Loglines+1]<FS-2 Then
                            BEGIN
                              Move(CurrentLogView[2],CurrentLogView[1],(LogLines)*4);
                              PortalLog.Seek(CurrentLogView[LogLines]);
                              PortalLog.ReadLine(s);
                              CurrentLogView[LogLines+1]:=CurrentLogView[LogLines]+Length(s)+2;
                              WITH ActivityWindow^ DO
                              BEGIN
                                ScrollVert(1);
                                WriteLogLine(s,LogLines);
{$IFDEF UseScrollBars}
                                DrawSlider(FrRR,CurrentLogView[LogLines+1]);
{$ENDIF}
                              END;
                              JustScrolled:=True;
                            END;
                          END ELSE
                          BEGIN
                            IF (CLOutListPtr<>Nil) And (OutList^.Next(CLOutListPtr)<>Nil) THEN
                            BEGIN
                              CLOutListPtr:=POutList(OutList^.Next(CLOutListPtr));
                              SaveOutPtr:=FLOutListPtr; Tmp:=1;
                              WHILE (SaveOutPtr<>CLOutListPtr) And (Tmp<>5) DO
                              BEGIN
                                Inc(Tmp);
                                SaveOutPtr:=POutList(OutList^.Next(SaveOutPtr));
                              END;
                              IF Tmp=5 THEN FLOutListPtr:=POutList(OutList^.Next(FLOutListPtr));
                              UpdateOutboundWindow;
                            END;
                          END;
                   PgDn : IF InLogWin THEN
                          BEGIN
                            FS:=PortalLog.FileSize;
                            IF CurrentLogView[LogLines+1]<FS-2 then
                            BEGIN
                              i:=LogLines-1;
                              REPEAT
                                Move(CurrentLogView[2],CurrentLogView[1],(LogLines)*4);
                                PortalLog.Seek(CurrentLogView[LogLines]);
                                PortalLog.ReadLine(S);
                                CurrentLogView[LogLines+1]:=CurrentLogView[LogLines]+Length(s)+2;
                                Dec(i);
                              Until (i=0) or (CurrentLogView[LogLines+1]>FS-4);
                              ReWriteLogWindow;
                              JustScrolled:=True;
                            END;
                          END ELSE
                          BEGIN
                            IF OutList^.Size>1 THEN
                            BEGIN
                              Tmp:=1;
                              WHILE (OutList^.Next(CLOutListPtr)<>Nil) And (Tmp<4) DO
                              BEGIN
                                Inc(Tmp);
                                CLOutListPtr:=POutList(OutList^.Next(CLOutListPtr));
                                FLOutListPtr:=POutList(OutList^.Next(FLOutListPtr));
                              END;
                              UpdateOutboundWindow;
                            END;
                          END;
                   CtrlF1..CtrlF10 :
                          IF cfg.fkey[1,Hi(InKey)-93].errorlevel<>0 THEN
                          BEGIN
                            ComPort^.SetDtr(Low);
                            WITH cfg.fkey[1,Hi(InKey)-93] DO
                              SpawnWithErrorlevel(ErrorLevel, 'Function key exit "'+description+'"', True, TRUE);
                          END;
                   AltF1..AltF10 :
                          IF cfg.fkey[2,Hi(InKey)-103].errorlevel<>0 THEN
                          BEGIN
                            ComPort^.SetDtr(Low);
                            WITH cfg.fkey[2,Hi(InKey)-103] DO
                              SpawnWithErrorlevel(ErrorLevel,'Function key exit "'+description+'"', True, TRUE);
                          END;
                   Tab  : BEGIN
                            InLogWin:=Not InLogWin;
                            UpdateFrames;
                            NewTimerSecs(ReturnFromLog, 30);
                          END;
                   ELSE   ResetTimers:=False;
                 END;             {case ch2 of}
               END;               { #0 }
        END;                      {case ch of}
        IF Cfg.Modem.Answer<>'' THEN
        BEGIN
          IF NOT ComPort^.Carrier AND ComPort^.KeyPressed THEN
          BEGIN
            ComPort^.PurgeIn;
            NewTimerSecs(ModemReInit, 10);
          END;
        END;
        StartClock;
        SetInterCom(ICIdle,Call,False);
        IF ResetTimers THEN
        BEGIN
          NewTimerSecs(ScreenBlank, cfg.Screen.BlankTime);
          IF TimerExpired(Data.NextTime) THEN NewTimerSecs(Data.NextTime, 15);
        END;
      END ELSE
        GiveUpTime;
      IF NOT PortalFinished THEN
      BEGIN
        IF JustScrolled THEN
        BEGIN
          NewTimerSecs(ReturnFromLog, 30);
          IF Not ComPort^.Keypressed THEN Continue;
        END;
        CheckModemResponse(False);
        IF (InLogWin) And (TimerExpired(ReturnFromLog) Or
           ((Cfg.Screen.BlankTime<>0) AND TimerExpired(ScreenBlank))) THEN
        BEGIN
          InLogWin:=False;
          UpdateFrames;
        END;
        IF TimerExpired(ScreenBlank) And (Cfg.Screen.BlankTime>0) THEN BEGIN
          IF (CmdLineFlags AND clShutDown) = clShutDown THEN BEGIN
            SetInterCom(ICUnused, Call, FALSE);
            SpawnWithErrorlevel(0, 'Exit on activated screen blanker', FALSE, TRUE);
          END;
          TurnScreen(Off);
        END;
        IF (Cfg.Modem.ReInit<>0) AND (TimerExpired(ModemReInit)) THEN
          InitModemForEvent;
        IF ((Cfg.RereadOnCall) AND (TimerExpired(Data.NextTime)) AND
           NOT (MailToSend) AND ((CurrentEvent.Typ AND etReceive)=0)) OR
           (TimerExpired(OutboundReRead)) THEN
        BEGIN
          GetOutboundInformation;
          UpdateOutboundWindow;
          CheckSemaforeFiles;
        END;
        ChangeEvent(False);
        IF TimerExpired(Data.NextTime) THEN
        BEGIN
          IF (CmdLineFlags AND clNoModem=0) AND (OutList^.Size>0)  THEN
          BEGIN
            OldOutPtr:=CLOutListPtr;
            CLOutListPtr:=POutList(OutList^.Head);
            IF Data.LastCalled.Zone>0 THEN
            BEGIN
              WHILE (CLOutListPtr<>Nil) And
                    (Address2Sort(CLOutListPtr^.Address)<Address2Sort(Data.LastCalled)) DO
                CLOutListPtr:=POutList(OutList^.Next(CLOutListPtr));
              IF CLOutListPtr=Nil THEN CLOutListPtr:=POutList(OutList^.Head);
            END;
            SaveOutPtr:=CLOutListPtr;
            MustReRead:=False;
            FillChar(Call, SizeOf(Call), 0);
            REPEAT
              IF OutList^.Next(CLOutListPtr)<>NIL THEN
                CLOutListPtr:=POutList(OutList^.Next(CLOutListPtr))
              ELSE
                CLOutListPtr:=POutList(OutList^.Head);
              IF CLOutListPtr^.Known AND SendableData(CLOutListPtr) THEN
                Call:=ClOutListPtr^.Address;
              IF (Call.Net<>0) AND NOT StillHaveMail(Call) THEN
              BEGIN
                Call.Net:=0;
                MustReRead:=True;
              END;
            UNTIL (CLOutListPtr=SaveOutPtr) OR (Call.Net<>0);
            IF Call.Net<>0 THEN
            BEGIN
              Data.LastCalled:=Call;
              FLOutListPtr:=CLOutListPtr;
              UpdateOutboundWindow;
              Dial(False);
            END ELSE
              CLOutListPtr:=OldOutPtr;
            IF MustReRead THEN
            BEGIN
              NewTimer(OutboundReRead, 0);
              AddLog('!','Mail seems to have been sent without my knowledge - forcing rescan!');
            END;
          END;
          NewTimerSecs(Data.NextTime, CalculateNextTime);
        END;
        IF TimerExpired(SemaforeTimer) THEN CheckSemaforeFiles;
        IF (ActivitySemaforeTime > 0) AND TimerExpired(ActivitySemafore) THEN
          WriteActivitySemafore;
      END;
    UNTIL PortalFinished;
    SetInterCom(ICUnused,Call,False);
{$IFDEF StackCheck}
    LogStackUsage;
{$ENDIF}
    AddLog('+','End, Portal of Power v'+Ver);
    ComPort^.SetDtr(Low);
    Dispose(ComPort, Done);
  END;

END.
