UNIT MailCfg;
{ͻ}
{ Mail related configuration                    Last changed: 01.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, OpField, OpString, OpWindow, OproUtil;

VAR
  Save     : BOOLEAN;
  ESR      : TPoPEntryScreen;

PROCEDURE GetEsrAndWin(EsrNum, Col: Byte; VAR Esr: TPoPEntryScreen; VAR Win: WindowPtr);

PROCEDURE NetMail;
PROCEDURE EchoMail;
PROCEDURE Nodes;
PROCEDURE _NodesInit(VAR Buffer); far;
PROCEDURE MiscOptions;
PROCEDURE FilesToForward;
PROCEDURE FwdMiscOptions;

PROCEDURE IncNodeStat(VAR Value; ID: Word; Factor: Integer; VAR s:String);
PROCEDURE IncFreeArea(VAR Value; ID: Word; Factor: Integer; VAR s:String);
PROCEDURE IncArcType(VAR Value; ID: Word; Factor: Integer; VAR s:String);
PROCEDURE EditOkFile;

PROCEDURE TickAreas;
PROCEDURE TickMisc;
PROCEDURE NodeListSegSetup;

PROCEDURE SchedulerSetup;
PROCEDURE IncSCDAction(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncAKAUsed(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);

PROCEDURE BrowseAreas;
FUNCTION  Str2Bin(S: String; Var B: Byte): Boolean;
FUNCTION  ValidateBin(EFP: EntryFieldPtr; Var ErrCode: Word; Var ErrorSt: StringPtr): Boolean;
PROCEDURE BinConv(EFP: EntryFieldPtr; PostEdit: Boolean);

IMPLEMENTATION

USES Dos, OpCrt, OpDate, OpCmd, OpConst, OpEntry,
     Globals, Input, Resource, StrUtil, NetFile, RBrowser, MailUtil,
     PoPTypes, ArcView;

VAR
  p : Pointer;

  PROCEDURE GetEsrAndWin(EsrNum, Col: Byte; VAR Esr: TPoPEntryScreen; VAR Win: WindowPtr);
  BEGIN
    GetEsr(EsrNum, Col, Esr);
    MyWin(Win, 1, ScreenHeight-1, 80, ScreenHeight, Col, '', False);
    WITH Win^, Cfg.Color[Col] DO
    BEGIN
      wFastText('F1=Help',1,2);
    END;
  END;

  FUNCTION BrowseHeader(i:BYTE):STRING;
  VAR
    s:STRING;
  BEGIN
    CASE i OF
      1 : s:='Area name             GroupName   Area path';            { Tick }
      2 : s:='Main area tag                    Description';           { Echo }
      3 : s:='FileName      From             PopFixName  Description'; { Fwd }
      4 : s:='Address          Lvl  Keys      BBS Open';               { Nodes }
      5 : s:='Sta Magicname  Path                     '+               { Ok }
             '   Password   Lvl Keys     Free';
      6 : s:='Nodelist  Nodediff  New packed nodelist path';           { Nls }
      7 : s:='Num Sub Action/Type          Send to'+CharStr(' ',39)+' S';   { Sched }
      ELSE s:='';
    END;
    BrowseHeader:=CPad(s,78);
  END;

{--- TickAreas --------------------------------------------------------------}

  PROCEDURE TickPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    CASE Esr^.GetCurrentID OF
      3 : IF TestDirectoryPath(ESR^,TTickArea(P^).AreaPath,False) THEN Save:=True;
      5 : IF TestDirectoryPath(ESR^,TTickArea(P^).AnnouncePath,False) THEN Save:=True;
    END;
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  FUNCTION _GetTickStr(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TTickArea(Buffer) DO
      _GetTickStr:=CPad(AreaName,22)+CPad(GroupName,12)+CPad(AreaPath,42);
  END;

  PROCEDURE _EditTick(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Save:=False;
    REPEAT
      Esr.Process;
    UNTIL Esr.GetLastCommand IN [ccQuit,ccDone];
    Changed:=Save;
  END;

  PROCEDURE _InitTick(VAR Buffer); far;
  BEGIN
    FillChar(Buffer, SizeOf(TTickArea), 0);
    WITH TTickArea(Buffer) DO
    BEGIN
      CheckCRC:=True;
      FilesBBS:='FILES.BBS';
      CheckDupe:=True;
    END;
  END;

  FUNCTION _IsGreaterTick(VAR B1,B2): Boolean; far;
  BEGIN
    _IsGreaterTick:=
      Pad(TTickArea(B1).GroupName,10)+TTickArea(B1).AreaName>Pad(TTickArea(B2).GroupName,10)+TTickArea(B2).AreaName;
  END;

  PROCEDURE TickAreas;
  VAR
    ExitCode : Word;
    f        : TNetFile;

    PROCEDURE MakeTickScreen;
    BEGIN
      GetEsr(EsrTickSetup,2,Esr);
      p:=Esr.GetUserRecord;
      Esr.SetPostEditProc(TickPostEdit);
      EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
    END;

  BEGIN
    f.Open(StartPath+PoPTickFileName,SizeOf(TTickArea),True);
    MakeTickScreen;
    BrowseRecords(f,P^,ExitCode,'Tick File',BrowseHeader(1),
                  _GetTickStr,_EditTick,_InitTick,_IsGreaterTick);
    Esr.Done;
    f.Close;
  END;

{--- Message Areas Setup ----------------------------------------------------}

  PROCEDURE BrowsePostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF Esr^.CurrentFieldModified THEN Save:=True;
    CASE Esr^.GetCurrentID OF
      3 : BEGIN
            IF (TMsgArea(p^).Directory='') And (ConFirm('Passthrough area?','Y',12)) THEN Exit;
{           IF (TMsgArea(p^).Directory[2]=':') AND TestDirectoryPath(ESR^, TMsgArea(p^).Directory, False) THEN Save:=True; }
          END;
    END;
  END;

  FUNCTION _GetEchoAreasStr(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TMsgArea(Buffer) DO
      _GetEchoAreasStr:=CPad(EchoNames[1],33)+CPad(Description,40);
  END;

  PROCEDURE _EditEchoAreas(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Save:=False;
    REPEAT
      Esr.Process;
    UNTIL Esr.GetLastCommand IN [ccQuit,ccDone];
    Changed:=Save;
  END;

  PROCEDURE _InitEchoAreas(VAR Buffer); far;
  BEGIN
    FillChar(Buffer,SizeOf(TMsgArea),0);
  END;

  FUNCTION _IsGreaterEchoAreas(VAR B1,B2): Boolean; far;
  BEGIN
    _IsGreaterEchoAreas:=TMsgArea(B1).EchoNames[1]>TMsgArea(B2).EchoNames[1];
  END;

  PROCEDURE BrowseAreas;
  VAR
    ExitCode  : Word;
    AreasFile : TNetFile;

    PROCEDURE MakeEntryScreen;
    BEGIN
      GetEsr(EsrEchoAreas,2,Esr);
      p:=Esr.GetUserRecord;
      ESR.SetPostEditProc(BrowsePostEdit);
      WITH EntryCommands DO
      BEGIN
        AddCommand(ccUser2,1,$3c00,0);
        AddCommand(ccUser4,1,$3e00,0);
        AddCommand(ccUser5,1,$3f00,0);
        AddCommand(ccUser8,1,$4200,0);
        AddCommand(ccUser9,1,$4300,0);
      END;
    END;

  BEGIN
    AreasFile.Open(PoPMsgAreaFileName,SizeOf(TMsgArea),True);
    MakeEntryScreen;
    BrowseRecords(AreasFile,p^,ExitCode,'Echo areas',BrowseHeader(2),
                 _GetEchoAreasStr,_EditEchoAreas,_InitEchoAreas,_IsGreaterEchoAreas);
    Esr.Done;
    AreasFile.Close;
  END;

{--- Netmail setup ----------------------------------------------------------}

  PROCEDURE NetMailPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    WITH Esr^ DO
    BEGIN
      IF CurrentFieldModified THEN ConfigChanged:=True;
      IF GetCurrentID=0 THEN
        IF TestDirectoryPath(Esr^, Cfg.MailScanner.NetMailDir, True) THEN ConfigChanged:=True;
    END;
  END;

  PROCEDURE NetMail;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrNetMailSetup, 2, Esr, Win);
    WITH ESR DO
    BEGIN
      SetPostEditProc(NetMailPostEdit);
      EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
      REPEAT
        Process;
      UNTIL GetLastCommand IN [ccDone,ccQuit];
    END;
    Esr.Done;
    KillWindow(Win);
  END;


{--- Echomail setup ---------------------------------------------------------}

  PROCEDURE EchoMailPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    WITH Esr^ DO
    BEGIN
      IF CurrentFieldModified THEN ConfigChanged:=True;
      CASE GetCurrentID OF
        0 : IF (GetLastCommand=ccUser2) AND SelectFile(Cfg.MailScanner.RouteFile) THEN ConfigChanged:=True;
        1 : IF TestDirectoryPath(Esr^, Cfg.MailScanner.SaveDupesDir,True) THEN ConfigChanged:=True;
      END;
    END;
  END;

  PROCEDURE EchoMail;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrEchoMailSetup,2,Esr,Win);
    WITH ESR DO
    BEGIN
      SetPostEditProc(EchoMailPostEdit);
      EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
      REPEAT
        Process;
      UNTIL GetLastCommand IN [ccDone,ccQuit];
    END;
    Esr.Done;
    KillWindow(Win);
  END;

{--- Files To Forward -------------------------------------------------------}

  PROCEDURE FwdPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF (ESR^.GetCurrentID=6) AND TestDirectoryPath(ESR^,TFileFwd(p^).WhereToPut,True) THEN Save:=True;
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  FUNCTION FwdGetString(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TFileFwd(Buffer) DO
      FwdGetString:=CPad(FileName,14)+CPad(Address2Str(GetFrom),17)+
                    CPad(PortalFixName,12)+CPad(Description,33);
  END;

  PROCEDURE FwdEdit(VAR Buffer; VAR Changed: Boolean; RecNum,MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Save:=False;
    REPEAT
      Esr.Process;
    UNTIL ESR.GetLastCommand IN [ccDone,ccQuit];
    Changed:=Save;
  END;

  PROCEDURE FwdInitBuf(VAR Buffer); far;
  BEGIN
    FillChar(Buffer, SizeOf(TFileFwd),0);
  END;

  FUNCTION FwdIsGreater(VAR B1,B2): Boolean; far;
  BEGIN
    FwdIsGreater:=TFileFwd(B1).FileName>TFileFwd(B2).FileName;
  END;

  PROCEDURE FilesToForward;
  VAR
    FwdFile  : TNetFile;
    ExitCode : Word ;

    PROCEDURE MakeFwdScreen;
    BEGIN
      GetEsr(EsrFileFwdSetup,2,Esr);
      p:=Esr.GetUserRecord;
      WITH EntryCommands, ESR DO
      BEGIN
        SetPostEditProc(FwdPostEdit);
        EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
      END;
    END;

  BEGIN
    FwdFile.Open(PoPFileFwdFileName,SizeOf(TFileFwd),True);
    MakeFwdScreen;
    BrowseRecords(FwdFile,p^,ExitCode,'Files to forward',BrowseHeader(3),
                  FwdGetString,FwdEdit,FwdInitBuf,FwdIsGreater);
    Esr.Done;
    FwdFile.Close;
  END;


{--- File Forward Misc ------------------------------------------------------}

  PROCEDURE FwdMiscPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    WITH Esr^ DO
    BEGIN
      IF CurrentFieldModified THEN ConfigChanged:=True;
      CASE GetCurrentID OF
        0 : IF TestDirectoryPath(Esr^,Cfg.FwdFile.SecureDir,True) THEN ConfigChanged:=True;
      END;
    END;
  END;

  PROCEDURE FwdMiscOptions;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrFileFwdMisc,2,Esr,Win);
    WITH Esr DO
    BEGIN
      SetPostEditProc(FwdMiscPostEdit);
      REPEAT
        Process;
      UNTIL GetLastCommand IN [ccQuit,ccDone];
    END;
    Esr.Done;
    KillWindow(Win);
  END;

{--- Nodes Setup ------------------------------------------------------------}

  PROCEDURE NodePostEdit(Esr: EntryScreenPtr); far;
  VAR
    Ta:TTickArea;
    fw:TFileFwd;
    em:TMsgArea;
  BEGIN
    CASE Esr^.GetCurrentID OF
       3 : IF NodesRec.Address.Point<>0 THEN ESR^.ChangeProtection(4, On) ELSE
             ESR^.ChangeProtection(4,Off);
       9 : IF Esr^.GetLastCommand=ccUser2 THEN
           BEGIN
             MultiSelect(NodesRec.Address,'Echo mail areas',BrowseHeader(2),
                         'ARE',em,SizeOf(TMsgArea),em.SendTo,_GetEchoAreasStr,Esr);
           END;
      10 : IF Esr^.GetLastCommand=ccUser2 THEN
           BEGIN
             MultiSelect(NodesRec.Address,'Files to forward',BrowseHeader(3),
                         'FWD',fw,SizeOf(TFileFwd),fw.SendTo,FwdGetString,Esr);
           END;
      12 : IF Esr^.GetLastCommand=ccUser2 THEN
           BEGIN
             MultiSelect(NodesRec.Address,'Tick areas',BrowseHeader(1),'TIC',
                         Ta,SizeOf(TTickArea),Ta.GetFrom,_GetTickStr,Esr);
          END;
      ELSE
      IF Esr^.GetLastCommand=ccUser2 THEN
      BEGIN
        Esr^.SetNextField(Esr^.GetCurrentID);
        Esr^.SetLastCommand(ccNone);
      END;
    END;
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  FUNCTION Str2Bin(S: String; Var B: Byte): Boolean;
  VAR
    i, Bin : Byte;

  FUNCTION BinMag(b:BYTE):BYTE;
  BEGIN
    BinMag:=$80 SHR (i-1);
  END;

  BEGIN
    Str2Bin:=False;
    Bin:=0;
    s:=LeftPadCh(s,'0',8);
    FOR i:=1 TO 8 DO
      IF s[i]='1' THEN Inc(Bin,BinMag(i)) ELSE
        IF S[i]<>'0' THEN Exit;
    Str2Bin:=True;
    B:=Bin;
  END;

  FUNCTION ValidateBin(EFP: EntryFieldPtr; Var ErrCode: Word; Var ErrorSt: StringPtr): Boolean;
  VAR
    Flag:BOOLEAN;
    B: Byte;
    S: String[80];
  BEGIN
    ValidateBin:=False;
    WITH EFP^ DO
    BEGIN
      StripPicture(efEditSt^,s);
      CASE efPicture^[1] OF
        '1' : Flag:=Str2Bin(s,b);
        '2' : BEGIN
                Flag:=True;
                FOR b:=1 TO 8 DO
                  IF NOT (s[b] IN ['Y','N']) THEN Flag:=False;
              END;
      END;
      IF Not Flag THEN
      BEGIN
        ErrCode:=ecBadFormat;
        ErrorSt:=@emInvalidNumber;
      END ELSE
        ValidateBin:=True;
    END;
  END;

  PROCEDURE BinConv(EFP: EntryFieldPtr; PostEdit: Boolean);
  VAR
    s: String[80];
    i:BYTE;
    n:integer;
    ch:CHAR;
  BEGIN
    WITH EFP^ DO
    BEGIN
      IF PostEdit THEN
      BEGIN
        StripPicture(efEditSt^, s);
        n:=1;
        BYTE(efVarPtr^):=0;
        FOR i:=1 TO 8 DO
        BEGIN
          CASE efPicture^[1] OF
            '1' : IF s[i]='1' THEN INC(BYTE(efVarPtr^),n);
            '2' : IF s[i]='Y' THEN INC(BYTE(efVarPtr^),n);
          END;
          n:=n SHL 1;
        END;
      END ELSE
      BEGIN
        s:='';
        n:=1;
        FOR i:=0 TO 7 DO
        BEGIN
          CASE efPicture^[1] OF
            '1' : IF BYTE(efVarPtr^) AND n=n THEN ch:='1' ELSE ch:='0';
            '2' : IF BYTE(efVarPtr^) AND n=n THEN ch:='Y' ELSE ch:='N';
          END;
          n:=n SHL 1;
          s:=s+ch;
        END;
        MergePicture(s, efEditSt^);
      END;
    END;
  END;

  FUNCTION _NodesGetStr(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TNodeInfo(Buffer) DO
      _NodesGetStr:=CPad(Address2Str(Address),17)+LongIntForm('###',Level)+
                    '  '+ReverseStr(BinaryB(Keys))+'  '+TimeToTimeString('hh:mm',OpenFrom)+
                    ' - '+TimeToTimeString('hh:mm',OpenTo);
  END;

  PROCEDURE IncArcType(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<7 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=7;
    END;
    s:=PackerExtension(ShortInt(Value));
  END;

  PROCEDURE _NodesEdit(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    IF NodesRec.Address.Point<>0 THEN ESR.ChangeProtection(4,On) ELSE ESR.ChangeProtection(4,Off);
    Save:=False;
    ESR.Process;
    Changed:=Save;
  END;

  PROCEDURE _NodesInit(VAR Buffer);
  BEGIN
    FillChar(Buffer, SizeOf(TNodeInfo),0);
    TNodeInfo(Buffer).UseFullDuplex:=' ';
    TNodeInfo(Buffer).CheckConnect:=' ';
    TNodeInfo(Buffer).UseFake:=' ';
    TNodeInfo(Buffer).Flavor:='H';
    TNodeInfo(Buffer).UseEMSI:=' ';
    TNodeInfo(Buffer).SendFwdLetter:=True;
  END;

  FUNCTION _NodesIsGreater(VAR B1,B2): Boolean; far;
  BEGIN
    _NodesIsGreater:=Address2Sort(TNodeInfo(B1).Address)>Address2Sort(TNodeInfo(B2).Address);
  END;

  PROCEDURE Nodes;
  VAR
    NodesFile   : TNetFile;
    ExitCode    : Word;

    PROCEDURE MakeNodesScreen;
    BEGIN
      GetEsr(EsrNodesSetup,2,Esr);
      WITH EntryCommands,Esr DO
      BEGIN
        SetPostEditProc(NodePostEdit);
        EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
      END;
    END;

  BEGIN
    NodesFile.Open(StartPath+PoPNodesFileName,SizeOf(TNodeInfo),True);
    MakeNodesScreen;

    BrowseRecords(NodesFile,NodesRec,ExitCode,'Nodes Setup',BrowseHeader(4),
                 _NodesGetStr,_NodesEdit,_NodesInit,_NodesIsGreater);

    Esr.Done;
    NodesFile.Close;
    DisposeNodesIdx;
  END;

{--- Mailscanner Misc Options -----------------------------------------------}

  PROCEDURE MailScanMiscPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    WITH Esr^ DO
    BEGIN
      IF CurrentFieldModified THEN ConfigChanged:=True;
      CASE GetCurrentID OF
        0 : IF TestDirectoryPath(Esr^,Cfg.MailScanner.BadMsgs,True) THEN ConfigChanged:=True;
      END;
    END;
  END;

  PROCEDURE MiscOptions;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMailScanMisc,2,Esr,Win);
    WITH Esr DO
    BEGIN
      SetPostEditProc(MailScanMiscPostEdit);
      REPEAT
        Process;
      UNTIL GetLastCommand IN [ccQuit,ccDone];
    END;
    Esr.Done;
    KillWindow(Win);
  END;


{--- OkFile Setup -----------------------------------------------------------}

  FUNCTION NStatStr(Stat: TNodeStat): S3;
  BEGIN
    CASE Stat OF
      nsUnKnown : NStatStr:='All';
      nsKnown   : NStatStr:='Kwn';
      nsPassword: NStatStr:='Pwd';
    END;
  END;

  PROCEDURE IncNodeStat(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    s:=NStatStr(TNodeStat(Value));
  END;

  FUNCTION FreeAreaStr(CONST FreeArea: TFreeArea): S9;
  BEGIN
    CASE FreeArea OF
      faNoWay    : FreeAreaStr:='No way!  ';
      faIfAccess : FreeAreaStr:='If access';
      faTotally  : FreeAreaStr:='Totally  ';
      ELSE         FreeAreaStr:='?????????';
    END;
  END;

  PROCEDURE IncFreeArea(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    s:=FreeAreaStr(TFreeArea(Value));
  END;

  PROCEDURE OkPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  FUNCTION _GetOkStr(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TOkFile(Buffer) DO
      _GetOkStr:=NStatStr(NodeStat)+' '+CPad(MagicName,11)+CPad(FilePath,28)+
                 CPad(Password,11)+LongIntForm('###',Level)+' '+ReverseStr(BinaryB(Keys))+' '+FreeAreaStr(FreeArea);
  END;

  PROCEDURE _EditOk(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Save:=False;
    Esr.Process;
    Changed:=Save;
  END;

  PROCEDURE _InitOk(VAR Buffer); far;
  BEGIN
    FillChar(Buffer, SizeOf(TOkFile), 0);
  END;

  FUNCTION _IsGreaterOk(VAR B1,B2): Boolean; far;
  VAR
    M1, M2 : S20;
  BEGIN
    IF TOkFile(B1).MagicName='' THEN M1:=CharStr(#255, 20) ELSE M1:=TOkFile(B1).MagicName;
    IF TOkFile(B2).MagicName='' THEN M2:=CharStr(#255, 20) ELSE M2:=TOkFile(B2).MagicName;
    _IsGreaterOk:=M1+TOkFile(B1).FilePath>M2+TOkFile(B2).FilePath;
  END;

  PROCEDURE EditOkFile;
  VAR
    ExitCode : Word;
    f        : TNetFile;

    PROCEDURE MakeOkFileScreen;
    BEGIN
      GetEsr(EsrOkFileSetup,2,Esr);
      p:=Esr.GetUserRecord;
      Esr.SetPostEditProc(OkPostEdit);
    END;

  BEGIN
    f.Open(StartPath+PoPOkFileName,SizeOf(TOkFile),True);
    MakeOkFileScreen;
    BrowseRecords(f,p^,ExitCode,'OK FILE',BrowseHeader(5),
                  _GetOkStr,_EditOk,_InitOk,_IsGreaterOk);
    Esr.Done;
    f.Close;
  END;

{--- Tick Misc --------------------------------------------------------------}

  PROCEDURE TickMiscPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF Esr^.CurrentFieldModified THEN ConfigChanged:=TRUE;
    CASE Esr^.GetCurrentID OF
      0 : IF TestDirectoryPath(Esr^,Cfg.Tick.DupeDir, True) THEN ConfigChanged:=True;
      1 : IF TestDirectoryPath(Esr^,Cfg.Tick.HoldDir, True) THEN ConfigChanged:=True;
    END;
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  PROCEDURE TickMisc;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMiscTickSetup, 2, Esr, Win);
    WITH Esr DO
    BEGIN
      SetPostEditProc(TickMiscPostEdit);
      EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
      REPEAT
        Process;
      UNTIL GetLastCommand IN [ccDone,ccQuit];
    END;
    Esr.Done;
    KillWindow(Win);
  END;


{--- Nodelist Segments ------------------------------------------------------}

  PROCEDURE NLSPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF (ESR^.GetCurrentID=4) AND
       TestDirectoryPath(ESR^,TNodeListSeg(p^).NewNLPath,True) THEN Save:=True;
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  FUNCTION _GetNLSStr(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TNodeListSeg(Buffer) DO
      _GetNLSStr:=CPad(NodeListName,10)+CPad(DiffFileName,10)+CPad(NewNlPath,42);
  END;

  PROCEDURE _EditNLS(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Save:=False;
    REPEAT
      Esr.Process;
    UNTIL Esr.GetLastCommand IN [ccQuit,ccDone];
    Changed:=Save;
  END;

  PROCEDURE _InitNLS(VAR Buffer); far;
  BEGIN
    FillChar(Buffer,SizeOf(TNodeListSeg),0);
  END;

  FUNCTION _IsGreaterNLS(VAR B1,B2): Boolean; far;
  BEGIN
    _IsGreaterNLS:=TNodeListSeg(B1).NodeListName>TNodeListSeg(B2).NodeListName;
  END;

  PROCEDURE NodeListSegSetup;
  VAR
    ExitCode : Word;
    f        : TNetFile;

    PROCEDURE MakeNLSScreen;
    BEGIN
      GetEsr(EsrNodeListSeg,2,Esr);
      p:=Esr.GetUserRecord;
      Esr.SetPostEditProc(NLSPostEdit);
      EntryCommands.addcommand(ccUser2,1,Word(256)*60,0);
    END;

  BEGIN
    f.Open(StartPath+PoPNLSegmentFileName,SizeOf(TNodeListSeg),True);
    MakeNLSScreen;
    BrowseRecords(f,p^,ExitCode,'Nodelist segments',BrowseHeader(6),
                  _GetNLSStr,_EditNLS,_InitNLS,_IsGreaterNLS);
    Esr.Done;
    f.Close;
  END;

  { NodelistSeg: End ======================================================== }

  { Scheduler: Start ------------------------------------------------------ }

  FUNCTION ActionName(i: BYTE):S10;
  VAR
    s:S20;
  BEGIN
    CASE i OF
      0 : s:='Poll';
      1 : s:='Change';
      2 : s:='Route';
      3 : s:='Pack';
      4 : s:='Kill Poll';
    END;
    ActionName:=s;
  END;

  PROCEDURE IncSCDAction(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
  CONST
    MaxType=4;
  BEGIN
    CASE Factor OF
      +1 : BEGIN
             INC(ShortInt(Value));
             IF ShortInt(Value)>MaxType THEN ShortInt(Value):=0;
           END;
      -1 : BEGIN
             DEC(ShortInt(Value));
             IF ShortInt(Value)<0 THEN ShortInt(Value):=MaxType;
           END;
    END;
    s:=ActionName(BYTE(Value));
  END;

  PROCEDURE IncAKAUsed(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
  VAR
    x:BYTE;
  BEGIN
    REPEAT
      CASE Factor OF
        +1 : BEGIN
               INC(ShortInt(Value));
               IF ShortInt(Value)>MaxAddresses THEN ShortInt(Value):=0;
             END;
        -1 : BEGIN
               DEC(ShortInt(Value));
               IF ShortInt(Value)<0 THEN ShortInt(Value):=MaxAddresses;
             END;
      END;
      x:=BYTE(Value);
      IF x=0 THEN x:=Cfg.MainAdrNum;
    UNTIL (Cfg.Addresses[x].Zone<>0) OR (Factor=0);
    IF BYTE(Value)=0 THEN s:='(DEFAULT)'
                     ELSE s:=Address2Str(Cfg.Addresses[x]);
  END;

  FUNCTION _GetSCDStr(VAR Buffer; VAR f: TNetFile): String; far;
  BEGIN
    WITH TSchedule(Buffer) DO
      _GetSCDStr:=LongIntForm('###',Number)+' '+LongIntForm('###',SubLine)+' '+
                  CPad(ActionName(Action),21)+CPad(Adr[1],46)+' '+Stat;
  END;

  PROCEDURE SCDPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF ESR^.CurrentFieldModified THEN Save:=True;
  END;

  PROCEDURE _EditSCD(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Save:=False;
    REPEAT
      Esr.Process;
    UNTIL Esr.GetLastCommand IN [ccQuit,ccDone];
    Changed:=Save;
  END;

  PROCEDURE _InitSCD(VAR Buffer); far;
  BEGIN
    FillChar(Buffer,SizeOf(TSchedule),0);
    TSchedule(Buffer).Stat:='H';
  END;

  FUNCTION _IsGreaterSCD(VAR B1,B2): Boolean; far;

    FUNCTION Key(VAR B):S2;
    BEGIN
      Key:=CHAR(TSchedule(B).Number)+CHAR(TSchedule(B).SubLine);
    END;

  BEGIN
    _IsGreaterSCD:=Key(B1)>Key(B2);
  END;

  PROCEDURE SchedulerSetup;
  VAR
    ExitCode : Word;
    f        : TNetFile;

    PROCEDURE MakeSCDScreen;
    BEGIN
      GetEsr(EsrScheduleSetUp,2,Esr);
      Esr.SetPostEditProc(SCDPostEdit);
      p:=Esr.GetUserRecord;
    END;

  BEGIN
    f.Open(StartPath+PoPScheduleFileName,SizeOf(TSchedule),True);
    MakeSCDScreen;
    BrowseRecords(f,p^,ExitCode,'Scheduler SetUp',BrowseHeader(7),
                  _GetSCDStr,_EditSCD,_InitSCD,_IsGreaterSCD);
    Esr.Done;
    f.Close;
  END;


END.
