UNIT FileFwd;
{ͻ}
{ File forwarding, with letter and security     Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE ForwardFiles(AddSome: Boolean);

IMPLEMENTATION

USES Dos, OpDos, OpString, OpDate, OpRoot,
     OutUtil, FileUtil, OproUtil, Globals, OpusMsg, PTpl, StrUtil, MailUtil,
     LogFile, InterCom, Send2Utl, NetFile, Input, SimpDB, PoPTypes, Util,
     NodeList, AreaMisc, FuncSrvr;

VAR
  FwdRec : PFileFwd;

  PROCEDURE MoveFile(CONST FileName, WhereToPut: PathStr; Touch: Boolean);
  BEGIN
    AddLog('+','Moving '+JustFileName(FileName)+' to '+WhereToPut);
    CopyFile(FileName, AddBackSlash(WhereToPut)+JustFileName(FileName), Touch, True);
  END;

  PROCEDURE AddFileToFilesBbs(CONST WhereToPut: PathStr; CONST FileName, Description: String);
  LABEL
    DoItAgain;
  VAR
    Line, Newname, S: STRING;
    NewFilesBBS,
    FilesBbs :  PBufTextFile;
    Flag: Boolean;
    i   : Byte;
  BEGIN
    NewName:=MakeTaskFileName(AddBackSlash(WhereToPut)+'FILES.$$$');
    New(NewFilesBBS, Init(NewName, SCreate, Max64k(MaxAvail DIV 2)));
    New(FilesBbs, Init(WhereToPut+'FILES.BBS', SOpenRead, Max64k(MaxAvail-1024)));
    IF FilesBbs=NIL THEN
    BEGIN
      AddLog('!','No FILES.BBS found in '+WhereToPut+', creating one');
      NewFilesBBS^.WriteLn(#13#10' Once upon a time in the west....'#13#10);
      Flag:=True;
    END ELSE
    BEGIN
      Flag:=False;
      IF FwdRec^.AddBeforeLine>0 THEN
      BEGIN
        FOR i:=2 TO FwdRec^.AddBeforeLine DO
          IF NOT FilesBBS^.EoF THEN
          BEGIN
            FilesBBS^.ReadLn(s);
            NewFilesBBS^.WriteLn(s);
          END;
      END ELSE
      BEGIN
DoItAgain:
        IF FilesBBS<>NIL THEN
        BEGIN
          WHILE NOT FilesBBS^.EoF DO
          BEGIN
            FilesBBS^.ReadLn(s);
            NewFilesBBS^.WriteLn(s);
          END;
        END;
        Flag:=True;
      END;
    END;
    Line:=CPad(FileName,13)+ReplaceStr(Description, FileName);
    IF Cfg.AreaMan.InsDLCnt THEN AddDlC(Line);
    NewFilesBbs^.WriteLn(Line);
    IF FilesBbs<>NIL THEN
    BEGIN
      IF NOT Flag AND (FwdRec^.AddBeforeLine>0) THEN GOTO DoItAgain;
      Dispose(FilesBbs, Done);
      FilesBbs:=NIL;
    END;
    Dispose(NewFilesBBS, Done);
    DeleteFile(AddBackSlash(WhereToPut)+'FILES.BAK');
    Flag:=False;
    IF ExistFile(WhereToPut+'FILES.BBS') AND (NOT RenameFile(WhereToPut+'FILES.BBS',WhereToPut+'FILES.BAK')) THEN Flag:=TRUE;
    IF (NOT Flag) AND (NOT RenameFile(newname,WhereToPut+'FILES.BBS')) THEN Flag:=TRUE;
    IF (NOT Flag) AND ExistFile(WhereToPut+'FILES.BAK')  AND (NOT DeleteFile(WhereToPut+'FILES.BAK')) THEN Flag:=TRUE;
    IF Flag THEN AddLog('!','Error updating '+WhereToPut+'FILES.BBS');
  END;

  PROCEDURE ForwardFiles(AddSome: Boolean);
  TYPE
    FwdSysOpType=RECORD
      adr      : TFidoAddress;
      Name     : S35;
      MsgName  : S12;
    END;
    TabType=ARRAY[1..150] OF FwdSysOpType;
  VAR
    FwdFile   : TNetFile;
    Sr        : SearchRec;
    s,
    ss        : String;
    MsgHeadRec : MsgHdrType;
    BufSiz    : WORD;
    i, Got    : Integer;
    f         : File;
    TitF      : PTitFile;
    Buf       : Pointer;
    MsgDir,NewName : PathStr;
    Tf        : PBufTextFile;
    NumSysOpNames : BYTE;
    SysOpName : ^TabType;
    SendTab   : SendToTabType;
    Found     : BOOLEAN;
    Ift       : TInboundFile;
    NodeStat  : TNodeStat;

    PROCEDURE SendFileToNodes(CONST SendTo: SendToType; CONST FileName: PathStr);
    VAR
      NodeRec : TNodeInfo;
      Temp    : String;
      x,i,Num : BYTE;
      ch      : CHAR;

      FUNCTION FindSysOpEntry(CONST Adr: TFidoAddress): BYTE;
      VAR
        i,x:BYTE;
      BEGIN
        x:=0;
        FOR i:=1 TO NumSysOpNames DO
          IF CmpAdr(Adr,SysOpName^[i].Adr) THEN
          BEGIN
            x:=i;
            Break;
          END;
        FindSysOpEntry:=x;
      END;

    BEGIN
      IF (SendTo[1]='') And (SendTo[2]='') THEN
        AddLog('+','No forward of '+JustFileName(FileName))
      ELSE
      BEGIN
        FOR i:=1 TO 2 DO
        BEGIN
          IF SendTo[i]<>'' THEN AddLog('+','Sending '+JustFileName(FileName)+' to '+SendTo[i]);
        END;
        ReadSendTo(SendTo,SendTab,Num);
        FOR i:=1 TO Num DO
        BEGIN
          IF (FindNodeInfo(NodeRec,SendTab[i])) And (NodeRec.SendFwdLetter) THEN
          BEGIN
            x:=FindSysOpEntry(SendTab[i]);
            IF x=0 THEN
            BEGIN
              FwdSysOpName:=GetSysOpName(SendTab[i]);
              INC(NumSysOpNames);
              SysOpName^[NumSysOpNames].Name:=FwdSysOpName;
              SysOpName^[NumSysOpNames].Adr:=SendTab[i];
              SysOpName^[NumSysOpNames].MsgName:=ForceExtension(InventPktName,'TMP');
              x:=NumSysOpNames;
            END;
            temp:=MsgDir+'\'+SysOpName^[x].MsgName;
            IF NOT ExistFile(temp) THEN
            BEGIN
              New(tf, Init(Temp, SCreate, 256));
              IF tf<>NIL THEN
              BEGIN
                tf^.WriteLn(KludgeLines(Cfg.Addresses[Cfg.MainAdrNum],SendTab[i]));
                Dispose(tf, Done);
              END ELSE
                AddLog('!', 'Not enough memory to open: '+Temp);
              AddTpl(temp,'FWDHEADER',sr);
            END;
            OkPath:=FwdRec^.Description;
            AddTpl(temp,'FWDBODY',sr);
          END;
          CASE NodeRec.Flavor OF
            'N' : ch:='F';
            'C',
            'I',
            'D' : ch:=NodeRec.Flavor;
            ELSE ch:='H';
          END;
          SendAFile(FileName,SendTab[i],Ch,STNothing);
        END;
      END;
    END;

    PROCEDURE AddFilesToForwardList;
    VAR
      b   : Boolean;
      s   : PathStr;
      Adr : TFidoAddress;
    BEGIN
      FILLCHAR(Adr,SizeOf(Adr),0);
      REPEAT
        s:=Cfg.Inbound[nsKnown]+'*.*';
        b:=SelectFile(s);
        IF b THEN
        BEGIN
          IF GetAddress(8,2,Adr,1502) THEN
          BEGIN
            FILLCHAR(Ift,SizeOf(Ift),0);
            WITH Ift DO
            BEGIN
              s:=JustFileName(s)+'.';
              FileName:=COPY(s,1,POS('.',s)-1);
              From:=Adr;
              RecvDate:=Today;
              RecvTime:=CurrentTime;
              TaskNum:=Cfg.TaskNumber;
            END;
            TitF^.AddRec(Ift);
          END;
        END;
      UNTIL NOT b;
    END;

    PROCEDURE RemoveExcessFiles;
    TYPE
      SrType=RECORD
        Name : S12;
        Time : LONGINT;
      END;
      TabType=ARRAY[1..255] OF SrType;
    VAR
      Tab:^TabType;
      i,Num:INTEGER;
      sr : SearchRec;
      DelStr : String;

      PROCEDURE SortTab;
      VAR
        i:INTEGER;
        Flag:BOOLEAN;
        t:SrType;
      BEGIN
        Flag:=TRUE;
        WHILE Flag DO
        BEGIN
          Flag:=FALSE;
          FOR i:=1 TO Num-1 DO
            IF Tab^[i].Time>Tab^[i+1].Time THEN
            BEGIN
              t:=Tab^[i];
              Tab^[i]:=Tab^[i+1];
              Tab^[i+1]:=t;
              Flag:=TRUE;
            END;
        END;
      END;

    BEGIN
      IF FwdRec^.KeepMax>0 THEN
      BEGIN
        New(Tab);
        Num:=0;
        FINDFIRST(AddBackSlash(FwdRec^.WhereToPut)+FwdRec^.FileName,Archive,sr);
        WHILE DosError=0 DO
        BEGIN
          INC(Num);
          WITH Tab^[Num] DO
          BEGIN
            Name:=sr.Name;
            Time:=sr.Time;
          END;
          FINDNEXT(sr);
        END;
        FindClose(sr);
        SortTab;
        DelStr:='';
        FOR i:=1 TO Num-FwdRec^.KeepMax DO
        BEGIN
          IF DeleteFile(AddBackSlash(FwdRec^.WhereToPut)+Tab^[i].Name) THEN
            DelStr:=DelStr+' '+Tab^[i].Name;
        END;
        IF DelStr<>'' THEN
          AddLog('*', 'To keep a max of '+Long2Str(FwdRec^.KeepMax)+' I have deleted: '+Trim(DelStr));
        Dispose(Tab);
      END;
    END;

  BEGIN
{$IFNDEF PoPLite}
    IF (Cfg.TaskType=2) AND (NOT AddSome) THEN
    BEGIN
      RequestFunction(fsForwardFiles);
      EXIT;
    END;
    FillChar(SendTab, SizeOf(SendTab), 0);
    IF Not SetInterCom(ICFileFwd,SendTab[1],False) THEN Exit;

    IF FwdFile.Open(PoPFileFwdFileName, SizeOf(TFileFwd),False) THEN
    BEGIN
      AddLog('+','Searching for files to forward');
      NumSysOpNames:=0;
      New(SysOpName);
      New(FwdRec);
      New(TitF, Open(True));
      IF AddSome THEN AddFilesToForwardList;
      MsgDir:=StartPath+'FWDMSG.'+HexB(Cfg.TaskNumber);
      MakeFullDir(MsgDir);
      FOR NodeStat:=nsUnKnown TO nsPassword DO
      BEGIN
        IF (Cfg.InboundToDo[NodeStat] AND itd_File)<>0 THEN
        BEGIN
          IF Cfg.FwdFile.PreCmd<>'' THEN RunCmd(Cfg.FwdFile.PreCmd,Cfg.Inbound[NodeStat]);
          WHILE Not FwdFile.EoF DO
          BEGIN
            FwdFile.Read(FwdRec^, Keep, Wait);
            FindFirst(Cfg.Inbound[NodeStat]+FwdRec^.FileName, AnyFile, Sr);
            WHILE DosError=0 DO
            BEGIN
              Assign(f, Cfg.Inbound[NodeStat]+Sr.Name); FileMode:=ShareRW+ShareDenyRW;
              Reset(f);
              IF IOResult<>0 THEN
              BEGIN
                AddLog('!','Can''t access: '+Sr.Name+' skipping file!');
                FindNext(Sr);
                Continue;
              END ELSE
                Close(f);

              { Check at vi ikke processer en fil der er blevet renamet til .SEC }
              IF (JustExtension(Sr.Name)='SEC') AND (Pos('.*', FwdRec^.FileName)>0) THEN Continue;

              IF (FwdRec^.CheckDate) AND (Sr.Time<=FwdRec^.LastForward) THEN
              BEGIN
                IF Cfg.FwdFile.SecureDir='' THEN
                  NewName:=UniqueName(Cfg.Inbound[NodeStat]+ForceExtension(Sr.name,'OLD'))
                ELSE
                  NewName:=UniqueName(Cfg.FwdFile.SecureDir+Sr.name);
                IF CopyFile(Cfg.Inbound[NodeStat]+Sr.Name,NewName, False,True)=0 THEN
                BEGIN
                  AddLog('!',Sr.Name+' is not a new file, renamed to: '+JustFileName(NewName));
                END ELSE
                  AddLog('!','Error moving '+Sr.Name+' to '+NewName)
              END ELSE
              BEGIN
                Found:=TitF^.FindFile(Sr.Name, Ift);
                IF NOT Found THEN
                BEGIN
                  FillChar(Ift,SizeOf(Ift),0);
                  Found:=True;
                END ELSE
                  Found:=(FwdRec^.GetFrom.Zone=0) OR (CmpAdr(FwdRec^.GetFrom, Ift.From));
                IF NOT Found THEN
                BEGIN
                  IF Cfg.FwdFile.SecureDir='' THEN
                    NewName:=UniqueName(Cfg.Inbound[NodeStat]+ForceExtension(Sr.name,'SEC'))
                  ELSE
                    NewName:=UniqueName(Cfg.FwdFile.SecureDir+Sr.name);
                  IF CopyFile(Cfg.Inbound[NodeStat]+Sr.Name,NewName, False,True)=0 THEN
                  BEGIN
                    WITH FwdRec^.GetFrom DO
                      AddLog('!','SECURITY: Got '+Sr.Name+' From: '+Address2Str(Ift.From)+
                                 ' should be: '+Address2Str(FwdRec^.GetFrom)+', renamed to: '+JustFileName(Newname));
                  END ELSE
                    AddLog('!','Error moving '+Sr.Name+' to '+NewName)
                END ELSE
                BEGIN
                  IF (ExistFile(AddBackSlash(FwdRec^.WhereToPut)+Sr.Name)) And (FwdRec^.KillDupe) THEN
                  BEGIN
                    DeleteFile(Cfg.Inbound[NodeStat]+Sr.Name);
                    AddLog('!','Killing dupe: '+Sr.Name);
                  END ELSE
                  BEGIN
                    IF DriveFree(Byte(FwdRec^.WhereToPut[1])-64)>Sr.Size THEN
                    BEGIN
                      IF FwdRec^.BeforeCmd<>'' THEN
                      BEGIN
                        Ss:=FwdRec^.BeforeCmd;
                        Replace(ss,'$FILENAME',sr.Name,0);
                        RunCmd(ss,Cfg.Inbound[NodeStat]);
                      END;
                      IF ExistFile(Cfg.Inbound[NodeStat]+Sr.name) THEN
                      BEGIN
                        MoveFile(Cfg.Inbound[NodeStat]+Sr.Name,AddBackSlash(FwdRec^.WhereToPut),FwdRec^.TouchFile);
                        IF (FwdRec^.AddToFiles) AND (Cfg.BBS.BBSType<>btOpus170) THEN
                          AddFileToFilesBbs(AddBackSlash(FwdRec^.WhereToPut), Sr.Name, FwdRec^.Description);
                        SendFileToNodes(FwdRec^.SendTo,AddBackSlash(FwdRec^.WhereToPut)+Sr.Name);
                        IF FwdRec^.AfterCmd<>'' THEN
                        BEGIN
                          Ss:=FwdRec^.AfterCmd;
                          Replace(ss,'$FILENAME',sr.Name,0);
                          RunCmd(ss,Copy(FwdRec^.WhereToPut,1,Length(AddBackSlash(FwdRec^.WhereToPut))-1));
                        END;
                        FwdRec^.LastForward:=Sr.Time;
                        RemoveExcessFiles;
                        FwdFile.PutRec(FwdRec^,FwdFile.FilePos-1) ;
                      END ELSE
                        AddLog('!','File '+Sr.Name+' disappered???');
                    END ELSE
                      AddLog('!','Not enough space on '+FwdRec^.WhereToPut[1]+': to move '+Sr.Name);
                  END; {else dupe}
                END;
              END; {else old}
              FindNext(Sr);
            END; {while doserror}
            FindClose(Sr);
            FwdFile.UnLock(FwdFile.FilePos-1);
          END; {while not eof}
        END;
      END;
      FwdFile.Close;
      Dispose(TitF, Close);
      FindFirst(MsgDir+'\*.*', Archive,sr);
      IF DosError=0 THEN
      BEGIN
        AddLog('*','Writing forward messages');
        IF MaxAvail>65520 THEN BufSiz:=65520 ELSE BufSiz:=MaxAvail;
        GetMem(buf,BufSiz);
        WHILE DOSERROR=0 DO
        BEGIN
          AddTpl(MsgDir+'\'+Sr.Name,'FWDFOOT',sr);
          FillChar(MsgHeadRec,SizeOf(MsgHeadRec),0);
          WITH MsgHeadRec DO
          BEGIN
            Str2AsciiZ(Cfg.SysOp,FromUser,36);
            FwdSysOpName:='SysOp';
            FOR i:=1 TO NumSysOpNames DO
              IF (SysOpName^[i].MsgName=sr.name) THEN
               BEGIN
                 FwdSysOpName:=SysOpName^[i].Name;
                 Break;
               END;
            Str2AsciiZ(FwdSysOpName,ToUser,36);
            Str2AsciiZ(Cfg.FwdFile.Subject,Subject,72);
            SetTimeStamp(MsgHeadRec);
            DestNode:=SysOpName^[i].Adr.Node;
            OrigNode:=Cfg.Addresses[Cfg.MainAdrNum].Node;
            DestNet:=SysOpName^[i].Adr.Net;
            OrigNet:=Cfg.Addresses[Cfg.MainAdrNum].Net;
            Attribute:=Byte(Cfg.FwdFile.MsgPrivate)+Byte(Cfg.FwdFile.KillSent)*$80+
                       MsgLocal;
          END;
          Assign(f, MsgDir+'\'+Sr.Name); FileMode:=ShareRead+ShareDenyW;
          Reset(f,1);
          FillChar(Buf^,BufSiz,0);
          BlockRead(f,Buf^,BufSiz,Got);
          Close(f);
          WITH Cfg.MailScanner DO
            IF NetMailDir<>'' THEN
              WriteMsg(NetMailDir,GetHighestMsg(NetMailDir)+1, MsgHeadRec,Got,Buf);
          DeleteFile(MsgDir+'\'+Sr.Name);
          FindNext(sr);
        END;
        FindClose(sr);
        FreeMem(Buf,BufSiz);
      END;
      RmDir(MsgDir);
      Dispose(FwdRec);
      Dispose(SysOpName);
      AddLog('+','File forward done');
    END;
{$ELSE}
  AddLog('!', 'Not implemented in Portal of Power/Lite');
{$ENDIF}
  END;

END.
