///////////////////////////////////////////////////////////////////////////
//                                                                       //
// GIO2.H   --  Gern's 32-bit I/O routines 2.0 for OS/2 2.x              //
//              (ver.  2.00 - to be called from multi-threaded pgm)      //
//                                                                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

// ERROR_USER_DEFINED_BASE  is  0xFF00  -or-  65280

#define COMERR_PORT_NOT_OPEN                ERROR_USER_DEFINED_BASE + 1
#define COMERR_INVALID_PORT_NAME            ERROR_USER_DEFINED_BASE + 2
#define COMERR_NO_MEMORY                    ERROR_USER_DEFINED_BASE + 3
#define COMERR_NO_HCOMINFO                  ERROR_USER_DEFINED_BASE + 4
#define COMERR_OPENING_PORT                 ERROR_USER_DEFINED_BASE + 5
#define COMERR_SETTING_BPS_RATE             ERROR_USER_DEFINED_BASE + 6
#define COMERR_SETTING_LINE_CONTROL         ERROR_USER_DEFINED_BASE + 7
#define COMERR_CARRIER_DROPPED              ERROR_USER_DEFINED_BASE + 8
#define COMERR_NO_CHAR_WAITING              ERROR_USER_DEFINED_BASE + 9
#define COMERR_TIMED_CHAR_NOT_RECEIVED      ERROR_USER_DEFINED_BASE + 10
#define COMERR_BUFFER_ALLOCATION            ERROR_USER_DEFINED_BASE + 11
#define COMERR_BLOCK_TIMEOUT                ERROR_USER_DEFINED_BASE + 12

// ComOpen 'OpenFlags'
#define LEAVEPORTOPEN       0x00000001
#define OPENPORTSHARED      0x00000002
#define OPENWRITETHROUGH    0x00000004
#define ISPIPESERVER        0x00000010
#define ISPIPECLIENT        0x00000020
#define IGNORECARRIER       0x00000040

#ifndef BSEDEV_INCLUDED

typedef struct _DCBINFO
{
    USHORT usWriteTimeout;
    USHORT usReadTimeout;
    BYTE   fbCtlHndShake;
    BYTE   fbFlowReplace;
    BYTE   fbTimeout;
    BYTE   bErrorReplacementChar;
    BYTE   bBreakReplacementChar;
    BYTE   bXONChar;
    BYTE   bXOFFChar;
} DCBINFO, *PDCBINFO;

typedef struct _MODEMSTATUS 
{
    BYTE fbModemOn;
    BYTE fbModemOff;
} MODEMSTATUS, *PMODEMSTATUS;

#endif

typedef ULONG HCOMINFO, *PHCOMINFO;

// Extended Bit Rate Structure
typedef struct _EXTBITRATES
{
    ULONG   BPSRate;  // actual rate
    BYTE    Fraction;
    ULONG   MinBPS;
    BYTE    MinFraction;
    ULONG   MaxBPS;
    BYTE    MaxFraction;
} EXTBITRATES, *PEXTBITRATES;

APIRET EXPENTRY ComOpen(PSZ, HFILE, ULONG, BYTE, SHORT, SHORT, ULONG, PHCOMINFO);

APIRET EXPENTRY ComClose(HCOMINFO);

APIRET EXPENTRY ComSetLineControl(HCOMINFO, BYTE, SHORT, SHORT);

APIRET EXPENTRY ComSetFlowControl(HCOMINFO);

APIRET EXPENTRY ComGetBPS(HCOMINFO, PEXTBITRATES);

APIRET EXPENTRY ComSetBPS(HCOMINFO, ULONG);

APIRET EXPENTRY ComGetDCB(HCOMINFO, PDCBINFO);

APIRET EXPENTRY ComSetDCB(HCOMINFO, PDCBINFO);

APIRET EXPENTRY ComSetDTR(HCOMINFO, SHORT);

APIRET EXPENTRY ComSetRTS(HCOMINFO, SHORT);

BOOL   EXPENTRY ComGetDCD(HCOMINFO);

BOOL   EXPENTRY ComGetCTS(HCOMINFO);

APIRET EXPENTRY ComXONEnable(HCOMINFO);

APIRET EXPENTRY ComXONDisable(HCOMINFO);

APIRET EXPENTRY ComTXStart(HCOMINFO);

APIRET EXPENTRY ComTXStop(HCOMINFO);

APIRET EXPENTRY ComTXPurge(HCOMINFO);

APIRET EXPENTRY ComTXCharImm(HCOMINFO, BYTE);

ULONG  EXPENTRY ComTXChar(HCOMINFO, BYTE, BOOL);

APIRET EXPENTRY ComTXString(HCOMINFO, PSZ, BOOL);

APIRET EXPENTRY ComTXBlock(HCOMINFO, PBYTE, ULONG, BOOL);

BOOL   EXPENTRY ComTXEmpty(HCOMINFO);

VOID   EXPENTRY ComTXFlush(HCOMINFO, ULONG);

APIRET EXPENTRY ComTXCount(HCOMINFO, PUSHORT);

APIRET EXPENTRY ComRXPurge(HCOMINFO);

APIRET EXPENTRY ComRX(HCOMINFO, PSHORT, ULONG, BOOL, BOOL);

APIRET EXPENTRY ComRXBlock(HCOMINFO, PBYTE, ULONG, ULONG, BOOL, PULONG);

APIRET EXPENTRY ComRXString(HCOMINFO, PBYTE, ULONG, SHORT, ULONG, BOOL);

BOOL   EXPENTRY ComRXEmpty(HCOMINFO);

APIRET EXPENTRY ComRXCount(HCOMINFO, PUSHORT);

VOID   EXPENTRY ComPause(HCOMINFO);

VOID   EXPENTRY ComResume(HCOMINFO);

VOID   EXPENTRY ComBreak(HCOMINFO, BOOL);

APIRET EXPENTRY ComConnect(HCOMINFO);

APIRET EXPENTRY ComDisConnect(HCOMINFO);

VOID   EXPENTRY ComGetHandle(HCOMINFO, PULONG);

///////////////////////////////////////////////////////////////////////////
// Macros for peeking/receiving individual chars

#define ComRXChar(x,y,c) ComRX(x,y,0,FALSE,c)

#define ComRXCharTimed(x,y,c,z) ComRX(x,y,z,FALSE,c)

#define ComRXPeek(x,y,c) ComRX(x,y,0,TRUE,c)

#define ComRXPeekTimed(x,y,c,z) ComRX(x,y,z,TRUE,c)
