{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}
Unit Mouse; { Mouse routines }
Interface
Const
  { For Which Pressed calls }
  LeftB   = $1;
  RightB  = $2;
  MiddleB = $4;
Const
  MouseInstalled: boolean = false;
  DidMouseCheck: boolean = false;

{}
Procedure DefineSubroutine(WhichOnes: Integer; NewProc: Pointer);
Procedure GetMousePos(Var X,Y,Button: Integer);
Procedure HideMouseCursor;
Procedure QueryBtnDn(Button: Integer; Var Status,Times,X,Y: Integer);
Procedure QueryBtnUp(Button: Integer; Var Status,Times,X,Y: Integer);
Procedure SetMouseCursor(C: char);
Procedure SetMousePos(X,Y: Integer);
Procedure SetMouseWindow(X1,Y1,X2,Y2: Integer);
Procedure ShowMouseCursor;
{}
Function InitMouse: Integer;
Function MousePressed: Boolean;
Function WhichPressed: Integer;
{}

Implementation
Const
  MIO = $33; { Mouse Services }

Procedure DoCheck;
{ The whole point behind this is to have it not initialize the mouse until
  needed. This feature is not implemented at this point. }
begin
  If not didmousecheck then begin
    MouseInstalled := (InitMouse <> 0);
    Didmousecheck := true;
  end;
end;

Procedure DefineSubroutine(Whichones: Integer; NewProc: pointer); assembler;
{ Bitfields for "whichones"
  Bit(s)  Description
   0    call if mouse moves
   1    call if left Button pressed
   2    call if left Button released
   3    call if right Button pressed
   4    call if right Button released
   5    call if middle Button pressed
   6    call if middle Button released
   7-15 unused

   Values interrupt procedure is called with:
     AX = condition mask (same bit assignments as call mask)
     BX = Button state
     CX = cursor column
     DX = cursor row
     SI = horizontal mickey count
     DI = vertical mickey count
    Note: In text modes, the row and column will be reported as a multiple of
	  the character cell size, normally 8x8 pixels
}
asm
  mov ax, 000Ch
  mov cx, WhichOnes
  les dx, NewProc
  int MIO
end;

Function MousePressed: boolean; Assembler;
Asm
  Mov Ax, 0003h
  Int MIO
  cmp Bx, 00h  { Result is in BX, will be non zero if mouse pressed }
  Je  @No
  mov al, true { MousePressed := true; }
  Jmp @End
 @No:
  xor al, al   { MousePressed := false; }
 @End:
End;

Function WhichPressed: Integer; Assembler;
Asm
  Mov Ax, 0003h
  Int MIO
  mov ax, bx
End;

Function InitMouse: Integer; Assembler;
Asm
  Xor ax, ax { Mov Ax, 0000h }
  Int MIO
  { Result in AX }
End;

Procedure ShowMouseCursor; Assembler;
Asm
  Mov Ax, 0001h
  Int MIO
End;

Procedure HideMouseCursor; Assembler;
Asm
  Mov Ax, 0002h
  Int MIO
End;

Procedure GetMousePos(Var X,Y,Button: Integer); Assembler;
Asm
  Mov Ax, 0003h
  Int MIO
  { Store the results }
  Les di, Button; mov [ES:DI], bx
  Les di, x; mov [ES:DI], cx
  Les di, y; mov [ES:DI], dx
End;

Procedure SetMousePos(X,Y: Integer); Assembler;
Asm
  Mov Ax, 0004h
  Mov Cx, X
  Mov Dx, Y
  Int MIO
End;

Procedure QueryBtnDn(Button: Integer; var status,times,x,y: Integer); Assembler;
Asm
  Mov Ax, 0005h
  Mov bx, Button
  Int MIO

  { Store what's returned }
  Les di, Status; Mov [ES:DI],ax
  Les di, Times; Mov [ES:DI],bx
  Les di, X; Mov [ES:DI],cx
  Les di, Y; Mov [ES:DI],dx
End;

procedure QueryBtnUp(Button: Integer; var status,times,x,y: Integer); Assembler;
Asm
  Mov Ax, 0006h
  Mov bx, Button
  Int MIO

  { Store what's returned }
  Les di, Status; Mov [ES:DI],ax
  Les di, Times; Mov [ES:DI],bx
  Les di, X; Mov [ES:DI],cx
  Les di, Y; Mov [ES:DI],dx
End;

Procedure SetMouseWindow(X1,Y1,X2,Y2: Integer); Assembler;
Asm
  { Set X positions }
  Mov ax, 0007h
  Mov cx, x1
  Mov dx, x2
  Int MIO

  { Set Y positions }
  Mov Ax, 0008h
  Mov cx, y1
  Mov dx, y2
  Int MIO
End;

Procedure SetMouseCursor(C: char); Assembler;
asm
  mov  ax, 000Ah
  mov  bx, 0000h
  mov  cx, 7700h
  push ax { Save AX }
  mov  ax, 0077h       { Basically: mov dx, 77h and ordchar }
  and  al, c
  mov  dx, ax
  pop  ax { Restore AX }
  int  mio
end;

Begin
  DoCheck;
End.
