/***************************************************************************
 *                                                                         *
 *  BndStat Source, Version 1.52                                          *
 *  Copyright (c) 2008 by Gert Andersen.  All rights reserved.             *
 *                                                                         *
 *  You can contact the author at the following addresses:                 *
 *                                                                         *
 *  Gert Andersen      FidoNet     2:236/150                               *
 *  Internet           E-Mail      gert@kofo.org                           *
 *                                                                         *
 *  You can download this program from: http://www.kofobbs.dk              *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "./myalloc.c"
#if defined (_MSC_VER) && (_MSC_VER >= 1200)
#include "../vcdef/str.c"
#endif

static char *mnames[] = 
{
	"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
};

typedef struct entry
{
	char *addr;
	unsigned long sent;
	unsigned long rcvd;
} s_entry, *ps_entry;

ps_entry entries;
unsigned long entries_count;

char *log_name,*out_ses,*out_nodes,*buff,any_day,q;

int scan_log()
{
	FILE *log,*ses,*nodes;
	unsigned long i,j;
	char *s0, *s1, *s2, *s3, st, nf;
	char ses_str[] = "] done (";
	char *date, *addr, c_date[10];
	unsigned long sent, rcvd, tot_sent=0, tot_rcvd=0;
	time_t     ct;
	struct tm  *lt;


	ct = time(NULL);
	lt = localtime(&ct);
	sprintf(c_date,"%02u %3s",lt->tm_mday,mnames[lt->tm_mon]);

	if ((log=fopen(log_name,"rb")) == NULL)
	{
		fprintf(stderr,"Cannot open file: \"%s\"\n\n",log_name);
		exit(2);
	}	

	if (out_ses != NULL)
	{
		if ((ses=fopen(out_ses,"wb")) == NULL)
		{
			fprintf(stderr,"Cannot open file: \"%s\"\n\n",out_ses);
			exit(2);
		}	
	}

	if (out_nodes != NULL)
	{
		if ((nodes=fopen(out_nodes,"wb")) == NULL)
		{
			fprintf(stderr,"Cannot open file: \"%s\"\n\n",out_nodes);
			exit(2);
		}	
	}

	fprintf(stderr,"Processing file: \"%s\"...\n",log_name);
	
	buff=smalloc(256);

	if (!q) printf("\n                           Sessions History\n\n");
	if (!q) printf("\n");
        if (!q) printf("  No.       Session         Address      D    Sent      Rcvd   \n");
        if (!q) printf("\n");
	if (out_ses != NULL) fprintf(ses,"\n                           Sessions History\n\n");
	if (out_ses != NULL) fprintf(ses,"\n");
	if (out_ses != NULL) fprintf(ses,"  No.       Session         Address      D    Sent      Rcvd   \n");
	if (out_ses != NULL) fprintf(ses,"\n");
                                                                 
	i=0;
	entries_count=0;

        while (fgets(buff,255,log))
	{
	        if (buff==NULL) continue;

		if (strstr(buff,ses_str) != NULL)
		{
			sent=rcvd=0;

			/* parse a binkd log str */

			s0=strtok(buff," \t\r\n");
			if (s0==NULL) continue;
			s1=strtok(NULL,"[");
			if (s1==NULL) continue;
			date=smalloc(strlen(s1)+1);
			strcpy(date,s1);
			if (any_day && strstr(date,c_date) == NULL) continue;
			s1=strtok(NULL,",");
			if (s1==NULL) continue;
			while(s1[0] && s1[0] != '(') s1++;
			if (s1==NULL) continue;
			st='u';
			while(s1[0] && s1[0] != ' ') 
			{
				s1++;
				if (s1[0] == 'f') st='i';
				if (s1[0] == 't') st='o';
			}
			if (strchr(s1,'@')!=NULL)
			{
				j=strlen(s1)-1;
				while(j && s1[j] && s1[j] != '@') {s1[j]=0; j--;}
				s1[j]=0;
			}
			if (s1==NULL) continue;
			addr=smalloc(strlen(s1)+1);
			strcpy(addr,s1);						
			s1=strtok(NULL,")");
			if (s1==NULL) continue;
			while(s1[0] && s1[0] != '(') s1++;
			if (s1==NULL) continue;
			s1++;			
			j=strlen(s1)-1;
			while(j && s1[j] && s1[j] != ' ') {s1[j]=0; j--;}
			s2=strtok(s1,"/");
			if (s2==NULL) continue;
			s3=strtok(NULL,"\0");
			if (s3==NULL) continue;
			sent=atol(s2);
			rcvd=atol(s3);
			tot_sent += sent;
			tot_rcvd += rcvd;

			/* end of parsing */ 

                        i++;

			nf = 0;

			for (j = 0; j < entries_count; j++) 
			{
				if (strcmp(entries[j].addr,addr)) 
				{
					entries[j].sent += sent;
					entries[j].rcvd += rcvd;
					nf = 1;
				}
			}

			if (!nf) 
			{
				entries_count++;
   				entries = srealloc (entries,entries_count * sizeof(s_entry));
				entries[entries_count-1].addr = (char *) smalloc(strlen(addr)+1);
				strcpy (entries[entries_count-1].addr,addr);
				entries[entries_count-1].sent = sent;
				entries[entries_count-1].rcvd = rcvd;
			}
			
                                
                        if (!q) printf("%6ld  %-16s%-16s %c %9ld %9ld \n",i,date,addr,st,sent,rcvd);
                        if (out_ses != NULL) fprintf(ses,"%6ld  %-16s%-16s %c %9ld %9ld \n",i,date,addr,st,sent,rcvd);
		}

	}

        if (!q) printf("\n\n");
	if (out_ses != NULL) fprintf(ses,"\n\n");

	if (!q) printf("Total bytes sent: %12ld\n",tot_sent);
	if (out_ses != NULL) fprintf(ses,"Total bytes sent: %12ld\n",tot_sent);
	if (!q) printf("Total bytes rcvd: %12ld\n",tot_rcvd);
	if (out_ses != NULL) fprintf(ses,"Total bytes rcvd: %12ld\n\n",tot_rcvd);

	if (!q) printf("\n                 Nodes Statistics\n\n");
	if (!q) printf("\n");
        if (!q) printf("  No.       Address         Sent      Rcvd   \n");
        if (!q) printf("\n");
	if (out_nodes != NULL) fprintf(nodes,"\n                 Nodes Statistics\n\n");
	if (out_nodes != NULL) fprintf(nodes,"\n");
        if (out_nodes != NULL) fprintf(nodes,"  No.       Address         Sent      Rcvd   \n");
        if (out_nodes != NULL) fprintf(nodes,"\n");
	

	for (j=0;j<entries_count; j++)
	{
		if (!q) printf("%6ld %-18s%9ld %9ld \n",j+1,entries[j].addr,entries[j].sent,entries[j].rcvd);
		if (out_nodes != NULL) fprintf(nodes,"%6ld %-18s%9ld %9ld \n",j+1,entries[j].addr,entries[j].sent,entries[j].rcvd);
        }

        if (!q) printf("\n");
	if (out_nodes != NULL) fprintf(nodes,"\n\n");
	printf("\n");

	free(buff);
	fclose(log);
	if (out_ses != NULL) 
	{
		fflush(ses);
		fclose(ses);
	}
	if (out_nodes != NULL) 
	{
		fflush(nodes);
		fclose(nodes);
	}

	return 0;
}

int main(int argc,char *argv[])
{

	int i;
		
	fprintf(stderr,"BinkD statistics generator, version 1.52 for Linux platforms \n");
	fprintf(stderr,"(C) 2008 by Gert Andersen, 2:236/150, http://www.kofobbs.dk\n\n");

	any_day=q=0;

	if (argc<2)
	{
		fprintf(stderr,"USAGE: bndstat [-d] [-q] [-s<file>] [-n<file>] <log_file>\n\n");
		fprintf(stderr,"       -d        generate statistics for current day\n");
		fprintf(stderr,"       -q        do not display the statistics\n");
		fprintf(stderr,"       -s<file>  write sessions statistics in <file>\n");
		fprintf(stderr,"       -n<file>  write nodes statistics in <file>\n\n");
		exit(2);
	}

	for (i=1; i<argc; i++)
	{
		if (argv[i][0] == '-') 
		{
			switch (argv[i][1])
			{
				case 'd':
						{
							any_day=1;
							continue;
						}
				case 'q':
						{
							q=1;
							continue;
						}
				case 's':
						{
							out_ses=smalloc(strlen(argv[i]));
							sprintf(out_ses,argv[i]+2);
							continue;
						}
				case 'n':
						{
							out_nodes=smalloc(strlen(argv[i]));
							sprintf(out_nodes,argv[i]+2);
							continue;
						}
				default: 
						{
							fprintf(stderr,"Invalid switch: \"%c\"\n",argv[i][1]);
							exit(2);
						}
			}

		} else
		{
			log_name=smalloc(strlen(argv[i])+1);
			strcpy(log_name,argv[i]);
		}
	}

	scan_log();
	fprintf(stderr,"Done!\n\n");
	
	return 0;
}
