@ECHO OFF

REM   *************************************************************
REM   * SAMPLE.BAT -- This file contains several sample batch     *
REM   * files for running Iron Ox and Iron Ox for OS/2.  (See the *
REM   * file SYSOP.DOC for a more complete explanation of the     *
REM   * various options and switches).  The examples here cover:  *
REM   *                                                           *
REM   * 1. The standard command-line on a DOS or OS/2 system.     *
REM   * 2. Multinode installation/specifying node number.         *
REM   * 3. Handling non-standard ports under DOS without FOSSIL.  *
REM   * 4. Specifying dropfile location (if not the current dir). *
REM   * 5. Running the OS/2 version from a DOS BBS under OS/2.    *
REM   *************************************************************

REM   *************************************************************
REM   * The following line is usually all you need to run Ox with *
REM   * DOOR.SYS, DORINFO1.DEF, SFDOORS.DAT, and CHAIN.TXT!       *
REM   * If you have a FOSSIL installed or are running the OS/2    *
REM   * version of Iron Ox, this command line will work even if   *
REM   * you have non-standard IRQ's/comm ports.                   *
REM   *                                                           *
REM   * This batch file will work on multinode systems running    *
REM   * with any dropfiles *except* DORINFO1.DEF/DORINFOx.DEF.    *
REM   * See below for a multinode DORINFO example.                *
REM   *************************************************************

C:\DOOR\IRONOX\IRONOX.EXE

REM   *************************************************************
REM   * This is the line you might use to run the game on a       *
REM   * non-standard COM3 with address 3E8, IRQ 5 if you *AREN'T* *
REM   * running a FOSSIL driver or the OS/2 version of the door.  *
REM   *************************************************************
REM
REM   C:\DOOR\IRONOX\IRONOX.EXE /P:3E8 /I:5

REM   *************************************************************
REM   * If you are using DORINFOx.DEF on a multinode system, you  *
REM   * will need to specify the correct node number on the       *
REM   * command line.  This example would be used for node two.   *
REM   * If you have an environment variable defined for the node  *
REM   * number (e.g., SET NODE=1), you can use the environment    *
REM   * variable in place of the number (e.g., /N:%NODE%).        *
REM   *************************************************************
REM
REM   C:\DOOR\IRONOX\IRONOX.EXE /N:2

REM   *************************************************************
REM   * Most BBS'es (e.g., Wildcat, RemoteAccess) start doors     *
REM   * from the same directory where they create their door      *
REM   * information file.  Use a batch file like this one if you  *
REM   * are running a BBS that doesn't start door execution in    *
REM   * the same place as it puts its door information file.      *
REM   * (Maximus, e.g., is often set up to put it elsewhere.)     *
REM   *************************************************************
REM
REM   C:\DOOR\IRONOX\IRONOX.EXE C:\MAX\

REM   *************************************************************
REM   * OS/2 only!  This is the batch file you'd use to start     *
REM   * Iron Ox for OS/2 from a DOS BBS running in the OS/2 DOS   *
REM   * box.  This example uses the utility OS2EXEC by Eberhard   *
REM   * Mattes; see the sysop docs for information on how to set  *
REM   * up and/or get a copy of OS2EXEC.                          *
REM   *************************************************************
REM
REM   OS2EXEC C:\DOOR\IRONOX\IRONOX.EXE /PORT
