program EAInstall ;


uses DOS, CRT, ApMisc, ApArchiv, ApZip, FastTTT5, WinTTT5, KeyTTT5, MiscTTT5 ;

(* USES DOS, Crt, FastTTT5, WinTTT5, KeyTTT5, MenuTTT5,
     ReadTTT5, DirTTT5, StrnTTT5, JPString ;  *)

const
   Version          = '2.00' ;

var
   FML          : FileMaskList ;
   ZFL          : ZipFileList ;
   ZNP          : ZipNodePtr ;
   ch           : char ;
   i,j,k,l      : INTEGER ;
   BlockCount   : INTEGER ;
   FileCount,
   f,b          : LONGINT ;
   n            : byte ;
   ff           : text ;

 Procedure Welcome;
 { paints an introduction screen }
 begin
     CreateScreen(3,25);
     Activate_Virtual_Screen(3);   {all subsequent writes will be to screen 3}
     FillScreen(1,1,80,22,white,blue,chr(177)) ;
     ClearText(1,23,80,24,white,lightgray) ;
     WriteCenter(23,black,lightgray,'Another fine program from JPSoft') ;
     WriteCenter(24,black,lightgray,'EA INSTALL '+version+' - Copyright 1995 by John Parlin') ;

     FBox(18,5,63,15,white,blue,2);      { draw a single line filled box }
     WriteBetween(20,61,8,white,blue,'Eclectic Avenue '+version+' Installation Utility') ;
     WriteBetween(20,61,11,white,blue,'Written by John Parlin') ;
     Activate_Visible_Screen;
 end;  {proc Welcome}


Procedure Press_A_Key ;
BEGIN
   DelayKey(1000) ;
   TempMessageBox(28,18,white,red,6,'Press any key to continue') ;
END ;


Procedure ShowProgressWindow ;
Begin
   GrowMkWin(25,4,55,6,white,cyan,6) ;
   WriteBetween(25,55,5,black,cyan,'JPSoft Product Installation') ;
   GrowMkWin(15,10,65,17,15,1,7) ;
   WriteBetween(15,65,11,white,blue,'Installation Progress') ;
   WriteAt(20,13,yellow,blue,'') ;
   WriteAt(20,15,yellow,blue,'File Installed:') ;
   BlockCount := 0 ;
   FileCount := 0 ;
End ;


Procedure WriteBlock ;
Begin
   inc(blockcount) ;
   WriteAt(BlockCount+19,13,yellow,blue,'') ;
End ;


Procedure WriteLast ;
Var
   ii  : byte ;
Begin
   while blockcount < 40 do begin
      writeblock ;
   end ;
   delay(1000) ;
End ;


{$F+}
Function ExtractSuccess(var CDH : CentralDirHead ;
                        Fname   : PathStr ;
                        ErrCode : Word) : Boolean ;
Begin
   Inc(FileCount,1000) ;
   if ErrCode <> 0 then
   begin
      writelast ;
      DoneZipFile ;
      DoneFileMaskList(FML) ;
      RmWin ;
      ClrScr ;
      OnCursor ;
      textcolor(7) ;
      textbackground(0) ;
      clrscr ;
      Halt(99) ;
   end ;

   if filecount >= f then begin
      filecount := 0 ;
      if blockcount < 40 then begin
         writeblock ;
      end ;
   end ;

   cleartext(36,15,64,15,yellow,blue) ;
   writeat(36,15,yellow,blue,fname) ;
End ;
{$F-}



BEGIN
   OffCursor ;
   welcome ;
   SlideRestoreScreen(3,up) ;
   Press_A_Key ;
   DisposeScreen(3) ;
   OffCursor ;
   FillScreen(1,1,80,22,white,blue,chr(177)) ;
   ClearText(1,23,80,24,white,lightgray) ;
   WriteCenter(23,black,lightgray,'Another fine program from JPSoft') ;
   WriteCenter(24,black,lightgray,'EA INSTALL '+version+' - Copyright 1995 by John Parlin') ;
   GrowMkWin(15,11,65,13,15,1,7) ;
   WriteBetween(15,65,12,14,1,'Do you wish to install Eclectic Avenue? [Y,n]: ') ;
   REPEAT
      ch := UPCASE(ReadKey) ;
      IF ch = #13 THEN ch := 'Y' ;
   UNTIL ch IN ['Y','N'] ;
   RmWin ;
   IF ch = 'N' THEN BEGIN
      GrowMkWin(26,11,52,13,15,1,7) ;
      WriteBetween(26,52,12,14,1,'Installation Aborted.') ;
      delaykey(5000) ;
      RmWin ;
      ClrScr ;
      OnCursor ;
      textcolor(7) ;
      textbackground(0) ;
      Halt(99) ;
   END ;

   if exist('DEFAULT.BRD') then
      n := copyfile('DEFAULT.BRD','DEFAULT.$$$') ;

   InitFileMaskList(FML) ;
   InitZipFileList(ZFL) ;
   InitZipFile('INSTALL.DAT') ;

   IF ArchiveStatus <> 0 THEN BEGIN
      textcolor(7) ;
      textbackground(0) ;
      clrscr ;
      WRITELN('ERROR: ',StatusStr(ArchiveStatus)) ;
      OnCursor ;
      Halt(99) ;
   END ;

   BuildZipFileList(ZFL,FML) ;

   b := ZFL.count ;
   f := (b * 1000) div 40 ;


{
   clrscr ;
   writeln('b = ',b) ;
   writeln('f = ',f) ;
   halt ;
}
   SetExtractSuccessFunc(ExtractSuccess) ;
   ShowProgressWindow ;

   arOptionsOn(arCreateDirs) ;
   ExtractFileMaskList(FML) ;
   writelast ;
   DoneZipFile ;
   DoneFileMaskList(FML) ;
   RmWin ;
   delay(2000) ;
   RmWin ;


   GrowMkWin(27,11,53,13,15,1,7) ;
   WriteBetween(27,53,12,14,1,'Installation Complete.') ;
   delaykey(5000) ;
   RmWin ;

   if exist('DEFAULT.$$$') then
   begin
      n := copyfile('DEFAULT.$$$','DEFAULT.BRD') ;
      assign(ff,'DEFAULT.$$$') ;
      erase(ff) ;
   end ;

   Press_a_key ;
   RmWin ;
   OnCursor ;
   textcolor(7) ;
   textbackground(0) ;
   ClrScr ;
   WRITELN('Installation process completed...') ;
   WRITELN ;
   WRITELN('If you haven''t yet read EA.NEW, *PLEASE* do so before continuing.  Otherwise,') ;
   WRITELN('please read the EA.DOC file section on Installation and Configuration.') ;
   WRITELN ;
END.
